/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.bean.VchCfRowInfo;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.util.VchCfWrapper;

public class VchCfRowWrapper
extends VchCfWrapper {
    private static String ACCT_SEL = String.join((CharSequence)",", "id", "isleaf", "number", "longnumber", "dc", "pltype", "iscash", "isbank", "iscashequivalent", "acnotice", "accheck", "accounttable");
    private static String ITEM_SEL = String.join((CharSequence)",", "id", "isleaf", "number", "isdealactivity", "masterid", "direction");
    private Row row;

    public VchCfRowWrapper(Row row) {
        this.row = row;
        this.initValue();
    }

    public VchCfRowWrapper(VchCfRowInfo rowInfo) {
        this.maincfAmt = rowInfo.getMaincfAmt();
        this.suppcfAmt = rowInfo.getSuppcfAmt();
        this.debitlocal = rowInfo.getDebitlocal();
        this.creditlocal = rowInfo.getCreditlocal();
        this.accountId = rowInfo.getAccountId();
        this.maincfItemId = rowInfo.getMaincfItemId();
        this.suppcfItemId = rowInfo.getSuppcfItemId();
        if (this.maincfItemId != 0L) {
            this.maincfItem = this.loadCfItem(this.maincfItemId);
        }
        if (this.suppcfItemId != 0L) {
            this.suppcfItem = this.loadCfItem(this.suppcfItemId);
        }
        this.account = this.loadAcount(this.accountId);
    }

    private void initValue() {
        this.maincfAmt = this.getRow().getBigDecimal("entries.maincfamount");
        this.suppcfAmt = this.getRow().getBigDecimal("entries.suppcfamount");
        this.debitlocal = this.getRow().getBigDecimal("entries.debitlocal");
        this.creditlocal = this.getRow().getBigDecimal("entries.creditlocal");
        this.accountId = this.getRow().getLong("masterid");
        this.maincfItemId = this.getRow().getLong("entries.maincfitem");
        this.suppcfItemId = this.getRow().getLong("entries.suppcfitem");
        this.maincfItem = this.loadCfItem(this.maincfItemId);
        this.suppcfItem = this.loadCfItem(this.suppcfItemId);
        this.account = this.loadAcount(this.accountId);
    }

    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    private DynamicObject loadAcount(long acctId) {
        return (DynamicObject)ThreadCache.get((Object)(CacheKeyPrefix.ACCOUNT_INFO.name() + "_" + acctId), () -> BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview", (String)ACCT_SEL));
    }

    private DynamicObject loadCfItem(long itemId) {
        return (DynamicObject)ThreadCache.get((Object)(CacheKeyPrefix.CFMAINITEM_INFO.name() + "_" + itemId), () -> BusinessDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"gl_cashflowitem", (String)ITEM_SEL));
    }
}

