/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.finalprocess.constant.VoucherAmortConstant;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.finalprocessing.info.AmortGenVchInfo;
import kd.fi.gl.finalprocessing.info.AmortRowKey;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class VoucherAmortSchemeUtils {
    private static final String beginDate = "begindate";
    private static final String endDate = "enddate";
    private static final BigDecimal HUNDRED = new BigDecimal("100");

    public static BigDecimal queryCurPeriodAmortPeriod(Long orgId, Long bookTypeId, Date dateBegin, Date dateEnd, BigDecimal planPeriod) {
        return VoucherAmortSchemeUtils.queryCurPeriodAmortPeriod(orgId, bookTypeId, dateBegin, dateEnd, planPeriod, 0L);
    }

    public static BigDecimal queryCurPeriodAmortPeriod(Long orgId, Long bookTypeId, Date dateBegin, Date dateEnd, BigDecimal planPeriod, Long specifiedPeriodId) {
        Long endPeriodId;
        BigDecimal curAmortPercent = BigDecimal.ZERO;
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(orgId, (long)bookTypeId);
        if (dateBegin == null || dateEnd == null || bookInfo == null) {
            return curAmortPercent;
        }
        DynamicObject startPeriod = GLUtil.getPeriodByDate(dateBegin, bookInfo.getPeriodTypeId());
        DynamicObject endPeriod = GLUtil.getPeriodByDate(dateEnd, bookInfo.getPeriodTypeId());
        if (startPeriod == null || endPeriod == null) {
            return curAmortPercent;
        }
        Long curPeriodId = bookInfo.getCurPeriodId(specifiedPeriodId);
        Long startPeriodId = startPeriod.getLong("id");
        List<Long> periodIds = VoucherAmortSchemeUtils.getPeriodIds(startPeriodId, endPeriodId = Long.valueOf(endPeriod.getLong("id")));
        if (!periodIds.contains(curPeriodId)) {
            return curAmortPercent;
        }
        return VoucherAmortSchemeUtils.getCurPeriodAmortPeriod(startPeriod, curPeriodId, endPeriodId, planPeriod, dateBegin, dateEnd);
    }

    public static BigDecimal getCurPeriodAmortPeriod(DynamicObject startPeriod, Long curPeriodId, Long endPeriodId, BigDecimal planPeriod, Date dateBegin, Date dateEnd) {
        BigDecimal curAmortPeriod = null;
        Long startPeriodId = startPeriod.getLong("id");
        if (startPeriodId.equals(curPeriodId)) {
            long beginTotalDays = VoucherAmortSchemeUtils.diffDays(startPeriod.getDate(beginDate), startPeriod.getDate(endDate));
            Date dateEndReal = dateEnd.before(startPeriod.getDate(endDate)) ? dateEnd : startPeriod.getDate(endDate);
            long beginRangeDays = VoucherAmortSchemeUtils.diffDays(dateBegin, dateEndReal);
            curAmortPeriod = beginTotalDays == 0L ? BigDecimal.ZERO : new BigDecimal(beginRangeDays).divide(new BigDecimal(beginTotalDays), 2, RoundingMode.HALF_UP);
        } else {
            curAmortPeriod = endPeriodId.equals(curPeriodId) ? planPeriod : BigDecimal.ONE;
        }
        return curAmortPeriod;
    }

    public static List<Long> getPeriodIds(Long begin, Long end) {
        if (end == 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            return ids;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(end / GLUtil.TYPE_PERIOD_L));
        QFilter beginFilter = new QFilter("id", ">=", (Object)begin);
        QFilter endFilter = new QFilter("id", "<=", (Object)end);
        QFilter adjustFilter = new QFilter("isadjustperiod", "=", (Object)"0");
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, beginFilter, endFilter, adjustFilter}, null);){
            for (Row r : rs) {
                result.add(r.getLong(0));
            }
        }
        return result;
    }

    public static long getMaxPeriodIdByCount(long startPeriodId, int count, String includeAdjust) {
        long maxPeriodId = 0L;
        if (startPeriodId == 0L) {
            return maxPeriodId;
        }
        QFBuilder builder = new QFBuilder("periodtype", "=", startPeriodId / GLUtil.TYPE_PERIOD_L);
        builder.add("id", ">=", startPeriodId);
        if (!"1".equals(includeAdjust)) {
            builder.add("isadjustperiod", "=", includeAdjust);
        }
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])builder.toArray(), (String)"id asc", (int)count);){
            for (Row r : rs) {
                long id = r.getLong("id");
                if (maxPeriodId >= id) continue;
                maxPeriodId = id;
            }
            long l = maxPeriodId;
            return l;
        }
    }

    public static int getPeriodIdCount(long startPeriodId, String includeAdjust) {
        int count = 0;
        if (startPeriodId == 0L) {
            return count;
        }
        QFBuilder builder = new QFBuilder("periodtype", "=", startPeriodId / GLUtil.TYPE_PERIOD_L);
        builder.add("id", ">=", startPeriodId);
        if (!"1".equals(includeAdjust)) {
            builder.add("isadjustperiod", "=", includeAdjust);
        }
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])builder.toArray(), (String)"id asc");){
            for (Row r : rs) {
                ++count;
            }
            int n = count;
            return n;
        }
    }

    private static long diffDays(Date dtBegin, Date dtEnd) {
        long totalDays = (dtEnd.getTime() - dtBegin.getTime()) / 1000L / 3600L / 24L + 1L;
        return totalDays;
    }

    public static DynamicObjectCollection getPeriods(long period, int count) {
        QFBuilder qfBuilder = new QFBuilder().add("periodtype", "=", period / GLUtil.TYPE_PERIOD_L).add("id", ">=", period).add("isadjustperiod", "=", "0");
        return QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])qfBuilder.toArray(), (String)"id", (int)count);
    }

    public static Set<Long> getAssgrpIdByRowId(String rowId) {
        QFilter qFilter = new QFilter("assgrprow", "=", (Object)rowId);
        DynamicObject assgrpDyn = (DynamicObject)BusinessDataServiceHelper.loadFromCache((String)"gl_finalprocess_assgrp", (QFilter[])new QFilter[]{qFilter}).values().iterator().next();
        return FinalProcessAssgrp.create(assgrpDyn.getDynamicObjectCollection("entryentity")).getHgIds();
    }

    public static void getLeafAccountIds(Collection<String> acctNumbers, Collection<Long> leafs, QFilter orgFilter, AccountBookInfo accountBookInfo, long curPeriodId) {
        QFilter parentFilter = new QFilter("parent.number", "in", acctNumbers);
        QFBuilder acctFilterBuilder = AccountUtils.getAccountFilerOnBookAndPeriod(accountBookInfo, curPeriodId, parentFilter.and(orgFilter), false);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.finalprocessing.operateservice.AmortGenVchOperateService.getLeafAccountIds", (String)"bd_accountview", (String)"id,number,isleaf", (QFilter[])acctFilterBuilder.toArray(), null);){
            HashSet<String> unLeafAcctNumbers = new HashSet<String>(16);
            for (Row row : ds) {
                long acctId = row.getLong("id");
                String acctNumber = row.getString("number");
                if (row.getBoolean("isleaf").booleanValue()) {
                    leafs.add(acctId);
                    continue;
                }
                unLeafAcctNumbers.add(acctNumber);
            }
            if (!unLeafAcctNumbers.isEmpty()) {
                VoucherAmortSchemeUtils.getLeafAccountIds(unLeafAcctNumbers, leafs, orgFilter, accountBookInfo, curPeriodId);
            }
        }
    }

    public static Set<Long> getLeafAccountIds(DynamicObject row, AmortGenVchInfo amortInfo) {
        QFilter baseDataF = kd.fi.bd.util.AccountUtils.getAccountDataFilter((long)amortInfo.getOrgId(), (long)amortInfo.getAccountTableId());
        String numberProp = row.getDynamicObjectType().getName().replace("accounts", "account.number");
        String idProp = numberProp.replace(".number", "_id");
        Long acctId = row.getLong(idProp);
        String acctNumber = row.getString(numberProp);
        Set<Long> acctIds = Stream.of(acctId).collect(Collectors.toSet());
        Set<String> acctNumbers = Stream.of(acctNumber).collect(Collectors.toSet());
        VoucherAmortSchemeUtils.getLeafAccountIds(acctNumbers, acctIds, baseDataF, amortInfo.getAccountBookInfo(), amortInfo.getCurPeriodId());
        if (acctIds.size() > 1) {
            acctIds.remove(acctId);
        }
        return acctIds;
    }

    public static Map<String, Set<Long>> batchLoadRowId2Assgrp(Set<String> rowIds) {
        Set nonAssgrp = Stream.of(Long.valueOf(0L)).collect(Collectors.toSet());
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(4);
        QFilter rowIdFilter = new QFilter("assgrprow", "in", rowIds);
        BusinessDataServiceHelper.loadFromCache((String)"gl_finalprocess_assgrp", (QFilter[])new QFilter[]{rowIdFilter}).values().forEach(dyn -> {
            FinalProcessAssgrp value = FinalProcessAssgrp.create(dyn.getDynamicObjectCollection("entryentity"));
            if (value != null) {
                result.put(dyn.getString("assgrprow"), value.getHgIds().isEmpty() ? nonAssgrp : value.getHgIds());
            }
        });
        rowIds.forEach(rowId -> result.putIfAbsent((String)rowId, nonAssgrp));
        return result;
    }

    public static String getPeriodDetail(DynamicObject scheme) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("inittable", "true");
        Map<AmortRowKey, Tuple<BigDecimal, BigDecimal>> detail = new AmortGenVchInfo(scheme, operateOption).getTargetDetailInfoTable();
        return SerializationUtils.serializeToBase64(detail);
    }

    public static int getOriScale(DynamicObject row) {
        String currencyPropName = row.getDynamicObjectType().getName().replaceAll("accounts|entry", "currency");
        return row.getInt(String.join((CharSequence)".", currencyPropName, "amtprecision"));
    }

    public static int getLocScale(DynamicObject scheme) {
        return scheme.getInt(String.join((CharSequence)".", "currency", "amtprecision"));
    }

    public static boolean isNewVersion(DynamicObject scheme, Action action) {
        DynamicObjectCollection detailEntry = scheme.getDynamicObjectCollection("detailentry");
        switch (action) {
            case Save: {
                String amortStatus = scheme.getString("status");
                if (!amortStatus.equals("2") || !detailEntry.isEmpty()) break;
                return false;
            }
            case GenVch: {
                if (!detailEntry.isEmpty() && !scheme.getString("description").startsWith("old")) break;
                return false;
            }
        }
        return BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.amort.genvch.new", (boolean)true);
    }

    public static void negateAllDetailEntry(DynamicObjectCollection detailEntry) {
        detailEntry.forEach(detailRow -> {
            detailRow.set("detailoritotal", (Object)detailRow.getBigDecimal("detailoritotal").negate());
            detailRow.set("detailloctotal", (Object)detailRow.getBigDecimal("detailloctotal").negate());
        });
    }

    public static DynamicObjectCollection mergeDetailEntry(DynamicObjectCollection detailEntry) {
        return detailEntry.stream().collect(Collector.of(() -> new DynamicObjectCollection(detailEntry.getDynamicObjectType(), detailEntry.getParent()), (entry, row) -> {
            boolean isMerged = false;
            for (DynamicObject existRow : entry) {
                List detailAssistKeyList = existRow.getDataEntityType().getProperties().stream().map(IMetadata::getName).filter(name -> name.startsWith("detailcomassist")).collect(Collectors.toList());
                boolean sameComAssist = true;
                for (String detailAssistKey : detailAssistKeyList) {
                    if (existRow.getLong(detailAssistKey) == row.getLong(detailAssistKey)) continue;
                    sameComAssist = false;
                    break;
                }
                if (existRow.getLong("detailaccount") != row.getLong("detailaccount") || existRow.getLong("detailassgrp") != row.getLong("detailassgrp") || !sameComAssist) continue;
                existRow.set("detailoritotal", (Object)existRow.getBigDecimal("detailoritotal").add(row.getBigDecimal("detailoritotal")));
                existRow.set("detailloctotal", (Object)existRow.getBigDecimal("detailloctotal").add(row.getBigDecimal("detailloctotal")));
                isMerged = true;
                break;
            }
            if (!isMerged) {
                entry.add(row);
            }
        }, (entry1, entry2) -> {
            entry1.addAll((Collection)entry2);
            return entry1;
        }, new Collector.Characteristics[0]));
    }

    public static boolean checkLegalByRatio(DynamicObject scheme) {
        return scheme.getDynamicObjectCollection("destaccounts").stream().map(destRow -> destRow.getBigDecimal("destratio")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).compareTo(new BigDecimal("100")) == 0;
    }

    public static boolean checkLegalByAmount(DynamicObject scheme) {
        BigDecimal cof = ((DynamicObject)scheme.getDynamicObjectCollection("targetaccounts").get(0)).getBigDecimal("plandirection").multiply(((DynamicObject)scheme.getDynamicObjectCollection("destaccounts").get(0)).getBigDecimal("destdirection")).negate();
        BigDecimal destTotalAmount = scheme.getDynamicObjectCollection("destaccounts").stream().map(destRow -> destRow.getBigDecimal("destlocal")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        return destTotalAmount.multiply(cof).compareTo(scheme.getBigDecimal("periodamortamount")) == 0;
    }

    public static List<List<Object>> getCartesianProduct(List<Object> ... lists) {
        ArrayList<List<Object>> resultLists = new ArrayList<List<Object>>(8);
        for (List<Object> list : lists) {
            ArrayList tempLists = new ArrayList(8);
            if (CollectionUtils.isEmpty(resultLists)) {
                for (Object object : list) {
                    tempLists.add(Stream.of(object).collect(Collectors.toList()));
                }
            } else if (CollectionUtils.isNotEmpty(list)) {
                for (Object object : list) {
                    for (List list2 : resultLists) {
                        tempLists.add(Stream.concat(list2.stream(), Stream.of(object)).collect(Collectors.toList()));
                    }
                }
            } else {
                for (List list3 : resultLists) {
                    tempLists.add(Stream.concat(list3.stream(), Stream.of(Integer.valueOf(0))).collect(Collectors.toList()));
                }
            }
            resultLists = tempLists;
        }
        return resultLists;
    }

    public static enum Action {
        Save,
        GenVch;

    }

    public static class DestAmountCalculator {
        private BigDecimal destRowOriAmountSum = BigDecimal.ZERO;
        private BigDecimal destRowLocAmountSum = BigDecimal.ZERO;
        BigDecimal oriAmountForNow;
        BigDecimal locAmountForNow;
        AmortGenVchInfo amortInfo;

        public DestAmountCalculator(AmortGenVchInfo amortInfo) {
            this.amortInfo = amortInfo;
            BigDecimal coefficient = new BigDecimal(amortInfo.getDestDc()).multiply(new BigDecimal(amortInfo.getTargetDc())).negate();
            this.oriAmountForNow = amortInfo.getAmountForNow().getOriAmount().multiply(coefficient);
            this.locAmountForNow = amortInfo.getAmountForNow().getLocAmount().multiply(coefficient);
        }

        public AmountInfo calculate(DynamicObject destRow) {
            if (this.amortInfo.getDestEntry().indexOf((Object)destRow) == this.amortInfo.getDestEntry().size() - 1) {
                return new AmountInfo.Builder().oriAmount(this.oriAmountForNow.subtract(this.destRowOriAmountSum)).locAmount(this.locAmountForNow.subtract(this.destRowLocAmountSum)).build();
            }
            if (VoucherAmortConstant.DestType.AMOUNT.getValue().equals(destRow.get("desttype"))) {
                this.destRowOriAmountSum = this.destRowOriAmountSum.add(destRow.getBigDecimal("destamount"));
                this.destRowLocAmountSum = this.destRowLocAmountSum.add(destRow.getBigDecimal("destlocal"));
                return new AmountInfo.Builder().oriAmount(destRow.getBigDecimal("destamount")).locAmount(destRow.getBigDecimal("destlocal")).build();
            }
            BigDecimal curRowLoc = this.locAmountForNow.multiply(destRow.getBigDecimal("destratio")).divide(HUNDRED, VoucherAmortSchemeUtils.getLocScale(this.amortInfo.getDataEntity()), RoundingMode.HALF_UP);
            BigDecimal curRowOri = this.oriAmountForNow.multiply(destRow.getBigDecimal("destratio")).divide(HUNDRED, VoucherAmortSchemeUtils.getOriScale(destRow), RoundingMode.HALF_UP);
            this.destRowOriAmountSum = this.destRowOriAmountSum.add(curRowOri);
            this.destRowLocAmountSum = this.destRowLocAmountSum.add(curRowLoc);
            return new AmountInfo.Builder().oriAmount(curRowOri).locAmount(curRowLoc).build();
        }
    }
}

