/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.iter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SplitIterator<E>
implements Iterator<List<E>> {
    private final Iterator<E> iterator;
    private final int splitSize;

    public SplitIterator(Iterator<E> iterator, int splitSize) {
        if (splitSize <= 0) {
            throw new IllegalArgumentException("Size need larger than 0");
        }
        this.iterator = iterator;
        this.splitSize = splitSize;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<E> next() {
        ArrayList<E> split = new ArrayList<E>(this.splitSize);
        while (this.iterator.hasNext() && split.size() < this.splitSize) {
            split.add(this.iterator.next());
        }
        return split;
    }
}

