/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.count;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.voucher.count.VoucherCount;

public class VoucherCountHelper {
    private static final String Insert_VoucherCount_Log = "insert into T_GL_VOUCHERCOUNT_LOG (fid,fvoucherid,forgid,fbooktypeid,fperiodid,fbookeddate,fbillstatus,fischeck,fispost,fsourcetype,fmainstatus,fsuppstatus,foperation,fcount,fcalculated) Values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
    private static final String ENTRIES_PREFIX = "entries.";
    private static final String E_PREFIX = "e";
    private static final int Insert_Batch_Size = 999;

    public static void createChangeLog(DynamicObject[] dataEntities, String operation, boolean isOld) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        List<Long> voucherIds = Arrays.stream(dataEntities).map(x -> (Long)x.getPkValue()).collect(Collectors.toList());
        VoucherCountHelper.createChangeLog(voucherIds, operation, isOld);
    }

    public static void createChangeLog(Collection<Long> voucherIds, String operation, boolean isOld) {
        if (voucherIds == null || voucherIds.size() == 0) {
            return;
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select a.fid, a.forgid ,a.fperiodid,a.fbooktypeid,a.fbookeddate,a.fbillstatus ,a.fsourcetype, a.fischeck, a.fispost, a.fmainstatus, a.fsuppstatus, count(b.fentryid) entrycount  from t_gl_voucher a left join t_gl_voucherentry b on a.fid = b.fid where ", new Object[0]);
        builder.appendIn("a.fid", voucherIds.toArray());
        builder.append("and", new Object[0]);
        builder.appendIn("b.fid", voucherIds.toArray());
        builder.append(" group by a.fid, a.forgid ,a.fperiodid,a.fbooktypeid,a.fbookeddate,a.fbillstatus ,a.fsourcetype, a.fischeck, a.fispost, a.fmainstatus, a.fsuppstatus", new Object[0]);
        try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, voucherIds)}).prepareShardingIndex();
             DataSet dataSet = DB.queryDataSet((String)"kd.fi.gl.voucher.count.VoucherCountHelper", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)builder);){
            ArrayList<Object[]> dbParams = new ArrayList<Object[]>(999);
            List ids = Arrays.stream(DB.genLongIds((String)"t_gl_vouchercount_log", (int)voucherIds.size())).boxed().collect(Collectors.toList());
            for (Row row : dataSet) {
                dbParams.add(new Object[]{ids.remove(0), row.getLong("fid"), row.getLong("forgid"), row.getLong("fbooktypeid"), row.getLong("fperiodid"), row.getDate("fbookeddate"), row.getString("fbillstatus"), row.getString("fischeck"), row.getBoolean("fispost"), row.getString("fsourcetype"), row.getString("fmainstatus"), row.getString("fsuppstatus"), operation, isOld ? Integer.valueOf(row.getInteger("entrycount") * -1) : row.getInteger("entrycount"), Character.valueOf('0')});
                if (dbParams.size() <= 999) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)Insert_VoucherCount_Log, dbParams);
                dbParams.clear();
            }
            if (dbParams.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)Insert_VoucherCount_Log, dbParams);
            }
        }
    }

    public static boolean checkFilterOptEnable(QFilter[] filters) {
        if (!GLBillParamEnum.VOUCHER_QUERY_COUNT_ENHANCE_ENABLE.getBooleanValue()) {
            return false;
        }
        if (ArrayUtils.isNotEmpty((Object[])filters)) {
            ArrayList<String> propertyList = new ArrayList<String>(filters.length);
            for (QFilter filter : filters) {
                List nests = filter.getNests(true);
                if (!CollectionUtils.isEmpty((Collection)nests)) {
                    propertyList.addAll(nests.stream().map(x -> x.getFilter().getProperty()).collect(Collectors.toList()));
                }
                propertyList.add(filter.getProperty());
            }
            return propertyList.stream().allMatch(p -> p.equalsIgnoreCase("org") || p.equalsIgnoreCase("booktype") || p.equalsIgnoreCase("period") || p.equalsIgnoreCase("bookeddate") || p.equalsIgnoreCase("billstatus") || p.equalsIgnoreCase("sourcetype") || p.equalsIgnoreCase("mainstatus") || p.equalsIgnoreCase("suppstatus") || p.equalsIgnoreCase("entries.eorg") || p.equalsIgnoreCase("entries.eperiod") || p.equalsIgnoreCase("org.id") || p.equalsIgnoreCase("booktype.id") || p.equalsIgnoreCase("period.id") || p.equalsIgnoreCase("entries.eorg.id") || p.equalsIgnoreCase("entries.eperiod.id"));
        }
        return false;
    }

    public static List<QFilter> optimizeVoucherFilters(QFilter[] filters) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(filters.length);
        for (QFilter filter : filters) {
            String p = filter.getProperty();
            if (p.equalsIgnoreCase("org") || p.equalsIgnoreCase("booktype") || p.equalsIgnoreCase("period") || p.equalsIgnoreCase("bookeddate") || p.equalsIgnoreCase("billstatus") || p.equalsIgnoreCase("mainstatus") || p.equalsIgnoreCase("suppstatus") || p.equalsIgnoreCase("sourcetype")) {
                qFilterList.add(filter.copy());
                continue;
            }
            if (!p.equalsIgnoreCase("org.id") && !p.equalsIgnoreCase("booktype.id") && !p.equalsIgnoreCase("period.id")) continue;
            QFilter copy = filter.copy();
            copy.__setProperty(copy.getProperty().replace(".id", ""));
            qFilterList.add(copy);
        }
        return qFilterList;
    }

    public static int queryVoucherCount(List<QFilter> qFilterList) {
        int voucherCount = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.voucher.count.VoucherCountHelper", (String)"gl_vouchercount", (String)"vouchercount,entrycount", (QFilter[])qFilterList.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                voucherCount += row.getInteger("vouchercount").intValue();
            }
        }
        qFilterList.add(new QFilter("calculated", "=", (Object)false));
        var3_3 = null;
        try (DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.voucher.count.VoucherCountHelper", (String)"gl_vouchercount_log", (String)"voucher,count", (QFilter[])qFilterList.toArray(new QFilter[0]), null);){
            for (Row row : logDataSet) {
                int count = row.getInteger("count");
                if (count > 0) {
                    ++voucherCount;
                    continue;
                }
                if (count >= 0) continue;
                --voucherCount;
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        return voucherCount;
    }

    public static int queryEntryCount(List<QFilter> qFilterList) {
        int enytryCount = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.voucher.count.VoucherCountHelper", (String)"gl_vouchercount", (String)"vouchercount,entrycount", (QFilter[])qFilterList.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                enytryCount += row.getInteger("entrycount").intValue();
            }
        }
        qFilterList.add(new QFilter("calculated", "=", (Object)false));
        var3_3 = null;
        try (DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.voucher.count.VoucherCountHelper", (String)"gl_vouchercount_log", (String)"count", (QFilter[])qFilterList.toArray(new QFilter[0]), null);){
            for (Row row : logDataSet) {
                enytryCount += row.getInteger("count").intValue();
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        return enytryCount;
    }

    public static Map<VoucherCount, Tuple<Integer, Integer>> queryVoucherForCount(long org, long booktype, long period) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select a.forgid ,a.fperiodid,a.fbooktypeid,a.fbookeddate ,a.fbillstatus ,a.fsourcetype, a.fischeck, a.fispost, a.fmainstatus, a.fsuppstatus, count(b.fentryid) entrycount ", new Object[0]);
        builder.append("from t_gl_voucher a inner join t_gl_voucherentry b on a.fid = b.fid ", new Object[0]);
        builder.append("where ", new Object[0]);
        builder.append("a.forgid = " + org, new Object[0]).append(" and a.fbooktypeid = " + booktype, new Object[0]).append(" and a.fperiodid = " + period, new Object[0]);
        builder.append(" group by a.fid,a.forgid ,a.fperiodid,a.fbooktypeid,a.fbookeddate ,a.fbillstatus ,a.fsourcetype, a.fischeck, a.fispost, a.fmainstatus, a.fsuppstatus", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.gl.voucher.count.VoucherCountUpgradeEngine", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)builder);){
            HashMap<VoucherCount, Tuple<Integer, Integer>> map = new HashMap<VoucherCount, Tuple<Integer, Integer>>(1024);
            for (Row row : dataSet) {
                VoucherCount key = new VoucherCount(row.getLong("forgid"), row.getLong("fbooktypeid"), row.getLong("fperiodid"), row.getDate("fbookeddate"), row.getString("fbillstatus"), row.getString("fischeck"), row.getString("fispost"), row.getString("fsourcetype"), row.getString("fmainstatus"), row.getString("fsuppstatus"));
                Tuple tuple = (Tuple)map.get(key);
                if (tuple == null) {
                    map.put(key, new Tuple<Integer, Integer>(1, row.getInteger("entrycount")));
                    continue;
                }
                Tuple tuple2 = tuple;
                Integer.valueOf((Integer)tuple2.item1 + 1);
                tuple2.item1 = tuple2.item1;
                tuple2 = tuple;
                Integer.valueOf((Integer)tuple2.item2 + row.getInteger("entrycount"));
                tuple2.item2 = tuple2.item2;
            }
            HashMap<VoucherCount, Tuple<Integer, Integer>> hashMap = map;
            return hashMap;
        }
    }
}

