/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.dimquery.vdf;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.vo.SimpleFilter;
import kd.fi.gl.voucher.dimquery.vdf.VchDimFilterService;

public class ComAssistVDF
extends VchDimFilterService {
    protected ComAssistVDF(String vchDim) {
        super(vchDim);
        Preconditions.checkArgument((boolean)vchDim.contains("comassist"));
    }

    @Override
    public boolean isExtFilter(List<String> vchQueryDims) {
        return true;
    }

    @Override
    public QFilter getVchDimFilter(VchDimFilterService.VDFContext context, Set<Long> mids) {
        String comAssistKey = this.getVchDim().split("\\.")[1];
        String comAssistEntity = ComAssistTable.get((Long)context.getAcctTableID()).getCommonAssist((String)comAssistKey).get().valueSource;
        Set ids = BusinessDataServiceHelper.loadFromCache((String)comAssistEntity, (String)"id", (QFilter[])new QFilter("masterid", "in", mids).toArray()).keySet();
        return new QFilter(this.getVchDim(), "in", ids);
    }

    @Override
    public Optional<QFilter> getBalDimFilter(VchDimFilterService.VDFContext context, SimpleFilter oriVchFilter) {
        Preconditions.checkArgument((boolean)oriVchFilter.getProperty().equals(this.getVchDim()));
        String comAssistKey = this.getVchDim().split("\\.")[1];
        String comAssistEntity = ComAssistTable.get((Long)context.getAcctTableID()).getCommonAssist((String)comAssistKey).get().valueSource;
        Set mids = BusinessDataServiceHelper.loadFromCache((String)comAssistEntity, (String)"masterid", (QFilter[])new QFilter("id", oriVchFilter.getCP(), oriVchFilter.getValue()).toArray()).values().stream().map(dyo -> dyo.getLong("masterid")).collect(Collectors.toSet());
        return Optional.of(new QFilter(comAssistKey, "in", mids));
    }
}

