/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.dimquery.vdf;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.vo.SimpleFilter;
import kd.fi.gl.voucher.dimquery.vdf.VDFFactory;
import org.apache.commons.collections4.list.UnmodifiableList;

public abstract class VchDimFilterService {
    private final String vchDim;

    public VchDimFilterService(String vchDim) {
        this.vchDim = vchDim;
    }

    public abstract boolean isExtFilter(List<String> var1);

    public abstract Optional<QFilter> getBalDimFilter(VDFContext var1, SimpleFilter var2);

    public QFilter getVchDimFilter(VDFContext context, Set<Long> values) {
        return new QFilter(this.vchDim, "in", values);
    }

    public String getVchDim() {
        return this.vchDim;
    }

    public static class VDFContext {
        private final Long acctTableID;
        private final List<String> vchQueryDims;
        private final List<String> balQueryDims;

        private VDFContext(Long acctTableID, List<String> vchQueryDims, List<String> balQueryDims) {
            this.acctTableID = acctTableID;
            this.vchQueryDims = new UnmodifiableList(vchQueryDims);
            this.balQueryDims = new UnmodifiableList(balQueryDims);
        }

        public static VDFContext createByVch(Long acctTableID, List<String> vchQueryDims) {
            List<String> balQueryDims = vchQueryDims.stream().map(VDFFactory::getBalDim).collect(Collectors.toList());
            return new VDFContext(acctTableID, vchQueryDims, balQueryDims);
        }

        public Long getAcctTableID() {
            return this.acctTableID;
        }

        public List<String> getVchQueryDims() {
            return this.vchQueryDims;
        }

        public List<String> getBalQueryDims() {
            return this.balQueryDims;
        }
    }

    public static class RedundancyVDF
    extends VchDimFilterService {
        public RedundancyVDF(String vchDim) {
            super(vchDim);
        }

        @Override
        public boolean isExtFilter(List<String> vchQueryDims) {
            return false;
        }

        @Override
        public Optional<QFilter> getBalDimFilter(VDFContext context, SimpleFilter oriVchFilter) {
            return Optional.empty();
        }
    }
}

