/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.gl.voucher.IVoucherEntryPK;

public class VoucherEntryMap<K extends IVoucherEntryPK, V>
implements Map<K, V> {
    private static final int DEF_SIZE = 16;
    private final Map<K, V> originalMap;
    private final Map<Long, K> entryIdKeyMap;
    private final Map<Integer, K> entrySeqKeyMap;

    public VoucherEntryMap() {
        this(0);
    }

    public VoucherEntryMap(int entriesSize) {
        int size = entriesSize > 0 ? entriesSize : 16;
        this.originalMap = new HashMap(size);
        this.entryIdKeyMap = new HashMap<Long, K>(size);
        this.entrySeqKeyMap = new HashMap<Integer, K>(size);
    }

    public VoucherEntryMap(Map<K, V> originalMap) {
        this.originalMap = originalMap;
        this.entryIdKeyMap = originalMap.keySet().stream().filter(x -> this.legalEntryId(x.getEntryId())).collect(Collectors.toMap(IVoucherEntryPK::getEntryId, x -> x, (o, n) -> n));
        this.entrySeqKeyMap = originalMap.keySet().stream().filter(x -> this.legalSeq(x.getSeq())).collect(Collectors.toMap(IVoucherEntryPK::getSeq, x -> x, (o, n) -> n));
    }

    @Override
    public int size() {
        return this.originalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.originalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean containsKey = this.originalMap.containsKey(key);
        if (!containsKey && key instanceof IVoucherEntryPK) {
            IVoucherEntryPK entry = (IVoucherEntryPK)key;
            return this.containsEntryId(entry) || this.containsEntrySeq(entry);
        }
        return containsKey;
    }

    public boolean containsEntryId(IVoucherEntryPK entry) {
        if (entry == null) {
            return false;
        }
        return this.legalEntryId(entry.getEntryId()) && this.originalMap.containsKey(this.entryIdKeyMap.get(entry.getEntryId()));
    }

    public boolean containsEntrySeq(IVoucherEntryPK entry) {
        if (entry == null) {
            return false;
        }
        return this.legalSeq(entry.getSeq()) && this.originalMap.containsKey(this.entrySeqKeyMap.get(entry.getSeq()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.originalMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (this.originalMap.containsKey(key)) {
            return this.originalMap.get(key);
        }
        if (key instanceof IVoucherEntryPK) {
            IVoucherEntryPK entry = (IVoucherEntryPK)key;
            if (this.containsEntryId(entry)) {
                return this.originalMap.get(this.entryIdKeyMap.get(entry.getEntryId()));
            }
            if (this.containsEntrySeq(entry)) {
                return this.originalMap.get(this.entrySeqKeyMap.get(entry.getSeq()));
            }
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key != null) {
            if (this.legalSeq(key.getSeq())) {
                this.entrySeqKeyMap.put(key.getSeq(), (Integer)key);
            }
            if (this.legalEntryId(key.getEntryId())) {
                this.entryIdKeyMap.put(key.getEntryId(), (Long)key);
            }
        }
        return this.originalMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.originalMap.containsKey(key)) {
            if (key instanceof IVoucherEntryPK) {
                IVoucherEntryPK entry = (IVoucherEntryPK)key;
                if (this.legalEntryId(entry.getEntryId())) {
                    this.entryIdKeyMap.remove(entry.getEntryId(), key);
                }
                if (this.legalSeq(entry.getSeq())) {
                    this.entrySeqKeyMap.remove(entry.getSeq(), key);
                }
            }
            return this.originalMap.remove(key);
        }
        if (key instanceof IVoucherEntryPK) {
            IVoucherEntryPK entry = (IVoucherEntryPK)key;
            if (this.containsEntryId(entry)) {
                return this.remove(this.entryIdKeyMap.get(entry.getEntryId()));
            }
            if (this.containsEntrySeq(entry)) {
                return this.remove(this.entrySeqKeyMap.get(entry.getSeq()));
            }
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> all) {
        if (all == null || all.isEmpty()) {
            return;
        }
        this.entryIdKeyMap.putAll(all.keySet().stream().filter(x -> this.legalEntryId(x.getEntryId())).collect(Collectors.toMap(IVoucherEntryPK::getEntryId, x -> x, (o, n) -> n)));
        this.entrySeqKeyMap.putAll(all.keySet().stream().filter(x -> this.legalSeq(x.getSeq())).collect(Collectors.toMap(IVoucherEntryPK::getSeq, x -> x, (o, n) -> n)));
        this.originalMap.putAll(all);
    }

    @Override
    public void clear() {
        this.originalMap.clear();
        this.entryIdKeyMap.clear();
        this.entrySeqKeyMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.originalMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.originalMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.originalMap.entrySet();
    }

    private boolean legalSeq(Integer seq) {
        return seq != null && seq > 0;
    }

    private boolean legalEntryId(Long entryId) {
        return entryId != null && entryId > 0L;
    }
}

