/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.writeoff;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.fi.gl.business.service.voucher.writeoff.WriteOffService;
import kd.fi.gl.enums.WriteOffTypeEnum;
import kd.fi.gl.voucher.IVoucherEntryPK;
import kd.fi.gl.voucher.map.IEntryMapping;
import kd.fi.gl.voucher.map.VoucherEntryMap;
import kd.fi.gl.voucher.vo.DynamicVoucher;
import kd.fi.gl.voucher.vo.VoucherEntryPK;
import kd.fi.gl.voucher.vo.VoucherPK;
import kd.fi.gl.voucher.writeoff.WriteOffVoucher;

public class DynamicWriteOffVoucher
extends WriteOffVoucher {
    private final DynamicObject voucher;
    private final DynamicObjectCollection entries;
    private VoucherEntryMap<IVoucherEntryPK, DynamicObject> sourceEntriesMap;
    private VoucherEntryMap<IVoucherEntryPK, DynamicObject> mappingEntriesMap;

    public DynamicWriteOffVoucher(DynamicObject voucher, DynamicVoucher sourceVoucher) {
        this.voucher = voucher;
        this.setId(voucher.getLong("id"));
        this.setSourceVoucher(sourceVoucher);
        this.entries = voucher.getDynamicObjectCollection("entries");
        this.setWriteOffType(WriteOffTypeEnum.get(voucher.getString("againsttype")));
        this.setEntryMapping(WriteOffService.buildEntryMapping(this));
    }

    public DynamicWriteOffVoucher(DynamicObject voucher) {
        this.voucher = voucher;
        this.setId(voucher.getLong("id"));
        this.setSourceVoucher(new VoucherPK(voucher.getLong("sourcebill")));
        this.entries = voucher.getDynamicObjectCollection("entries");
        this.setWriteOffType(WriteOffTypeEnum.get(voucher.getString("againsttype")));
        this.setEntryMapping(WriteOffService.buildEntryMapping(this));
    }

    public DynamicObject getVoucher() {
        return this.voucher;
    }

    public DynamicObjectCollection getEntries() {
        return this.entries;
    }

    @Override
    public VoucherPK getSourceVoucher() {
        return super.getSourceVoucher();
    }

    @Override
    public void setEntryMapping(IEntryMapping<?, ?> entryMapping) {
        super.setEntryMapping(entryMapping);
        this.sourceEntriesMap = null;
        this.mappingEntriesMap = null;
    }

    private VoucherEntryMap<IVoucherEntryPK, DynamicObject> getSourceEntriesMap() {
        if (this.sourceEntriesMap == null) {
            if (this.getSourceVoucher() instanceof DynamicVoucher) {
                DynamicObjectCollection collection = ((DynamicVoucher)this.getSourceVoucher()).getEntries();
                this.sourceEntriesMap = new VoucherEntryMap(collection.size());
                for (DynamicObject entry : collection) {
                    this.sourceEntriesMap.put(new VoucherEntryPK(entry.getLong("id"), entry.getInt("seq")), entry);
                }
            } else {
                throw new KDBizException("Source voucher not has entries. ");
            }
        }
        return this.sourceEntriesMap;
    }

    private VoucherEntryMap<IVoucherEntryPK, DynamicObject> getMappingEntriesMap() {
        if (this.mappingEntriesMap == null) {
            DynamicObjectCollection collection = this.getEntries();
            this.mappingEntriesMap = new VoucherEntryMap(collection.size());
            for (DynamicObject entry : collection) {
                this.mappingEntriesMap.put(new VoucherEntryPK(entry.getLong("id"), entry.getInt("seq")), entry);
            }
        }
        return this.mappingEntriesMap;
    }

    public Optional<DynamicObject> findSourceEntry(DynamicObject mappingEntry) {
        return Optional.ofNullable(this.getSourceEntriesMap().get(this.getEntryMapping().getSourceEntry(new VoucherEntryPK(mappingEntry.getLong("id"), mappingEntry.getInt("seq")))));
    }

    public Optional<DynamicObject> findMappingEntry(DynamicObject sourceEntry) {
        return Optional.ofNullable(this.getMappingEntriesMap().get(this.getEntryMapping().getMappingEntry(new VoucherEntryPK(sourceEntry.getLong("id"), sourceEntry.getInt("seq")))));
    }
}

