/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.writeoff;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.fi.gl.business.vo.voucher.Amount;
import kd.fi.gl.business.vo.voucher.AmountField;

public class WriteOffEntry {
    private String dc = "-1";
    private Map<AmountField, Amount> amountMap = new HashMap<AmountField, Amount>(4);
    private BigDecimal quantity = BigDecimal.ZERO;

    public String getDc() {
        return this.dc;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public Map<AmountField, Amount> getAmountMap() {
        return this.amountMap;
    }

    public void setAmountMap(Map<AmountField, Amount> amountMap) {
        this.amountMap = amountMap;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public void reset() {
        this.dc = "-1";
        this.getAmountMap().values().forEach(x -> {
            x.setDebit(BigDecimal.ZERO);
            x.setCredit(BigDecimal.ZERO);
        });
        this.quantity = BigDecimal.ZERO;
    }

    public void resetAmount(AmountField field, BigDecimal debit, BigDecimal credit) {
        Amount amount = this.getAmountMap().computeIfAbsent(field, k -> new Amount());
        amount.setDebit(debit);
        amount.setCredit(credit);
    }

    public void resetQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }
}

