/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.acccurrentfloat.constant.AcccurrentFloatParam;
import kd.fi.gl.acccurrentfloat.constant.AcccurrentFormula;
import kd.fi.gl.acccurrentfloat.constant.BCMAcccurrentFloatContext;
import kd.fi.gl.acct.action.AcctBalParseAction;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.ReClassUtils;

public class AcccurrentFloatParseAction {
    private static final String BD_ACCOUNTBOOKSTYPE = "bd_accountbookstype";
    private static final Log log = LogFactory.getLog(AcctBalParseAction.class);

    public Map<String, Map<String, Object>> parseParam(AcccurrentFloatParam floatParam) {
        try {
            this.printLog(floatParam);
            BCMAcccurrentFloatContext context = this.getContext(floatParam);
            Map<String, Object> paramMap = floatParam.getAcctFormulaMap();
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                try {
                    this.addFormulaToContext(entry, context);
                }
                catch (Exception e) {
                    log.info("\u91cd\u5206\u7c7b\u53d6\u6570\u516c\u5f0f\u5f02\u5e38\u4fe1\u606f\uff1a" + GLUtil.printError((Throwable)e));
                }
            }
            return context.complie();
        }
        catch (Exception e) {
            log.info("\u91cd\u5206\u7c7b\u53d6\u6570\u5f02\u5e38\u4fe1\u606f\uff1a" + GLUtil.printError((Throwable)e));
            throw new BOSException((Throwable)e);
        }
    }

    private BCMAcccurrentFloatContext getContext(AcccurrentFloatParam floatParam) {
        String defaultOrgNumber = floatParam.getComOrgNumber();
        Map<String, Long> mainBookTypeMap = this.getMainBookType();
        String mainBookTypeNumber = "";
        if (!mainBookTypeMap.isEmpty()) {
            mainBookTypeNumber = mainBookTypeMap.keySet().iterator().next();
        }
        if (StringUtils.isBlank((CharSequence)mainBookTypeNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u7684\u7ec4\u7ec7\u53d6\u4e0d\u5230\u4e3b\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"AcccurrentParseAction_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        Map<String, Object> commMap = floatParam.getCommParamMap();
        if (commMap == null || commMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u4e3a\u7a7a", (String)"AcccurrentParseAction_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        String defaultCurNumber = (String)commMap.get("currency");
        BCMAcccurrentFloatContext context = new BCMAcccurrentFloatContext();
        context.setDefaultOrgNumber(defaultOrgNumber);
        context.setDefaultBookTypeNumber(mainBookTypeNumber);
        context.setDefaultCurNumber(defaultCurNumber);
        context.setDefaultFy(floatParam.getComYear());
        context.setDefaultPeriod(floatParam.getComPeriod());
        context.setRefParamMap(floatParam.getRefParamMap());
        return context;
    }

    private void addFormulaToContext(Map.Entry<String, Object> entry, BCMAcccurrentFloatContext context) {
        String tmpBookTypeNumber;
        List paramFields = (List)entry.getValue();
        String tmpOrgNumber = (String)paramFields.get(0);
        if (StringUtils.isEmpty((CharSequence)tmpOrgNumber)) {
            tmpOrgNumber = context.getDefaultOrgNumber();
        }
        if (StringUtils.isEmpty((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
            tmpBookTypeNumber = context.getDefaultBookTypeNumber();
        }
        Date bookedDate = null;
        try {
            Object strDate = paramFields.get(8);
            if (!StringUtils.isBlank(strDate)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                bookedDate = simpleDateFormat.parse((String)strDate);
            }
            AcccurrentFormula formula = new AcccurrentFormula(entry);
            context.addFormula(tmpOrgNumber, tmpBookTypeNumber, bookedDate, formula);
        }
        catch (ParseException e) {
            context.addErrorRst(entry.getKey(), GLUtil.printError((Throwable)e));
        }
    }

    private Map<String, Long> getMainBookType() {
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        QFilter ftype = new QFilter("accounttype", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ftype);
        DataSet bookTypeSet = ReClassUtils.queryDataSet(BD_ACCOUNTBOOKSTYPE, "id,number", filters);
        for (Row row : bookTypeSet) {
            long bookTypeId = row.getLong("id");
            String bookTypeNumber = row.getString("number");
            numberToIdMap.put(bookTypeNumber, bookTypeId);
        }
        return numberToIdMap;
    }

    private void printLog(AcccurrentFloatParam floatParam) {
        this.logInfo(ResManager.loadKDString((String)"\u62a5\u8868\u53c2\u6570\uff1a%1$s,\u7ec4\u7ec7\u7f16\u7801\uff1a%2$s,\u671f\u95f4\uff1a%3$s", (String)"AcccurrentParseAction_2", (String)"fi-gl-mservice", (Object[])new Object[]{floatParam.getComAcctReClass(), floatParam.getComOrgNumber(), floatParam.getComPeriod()}));
        Map<String, Object> paramMap = floatParam.getAcctFormulaMap();
        int logIndex = 1;
        int logCount = 1;
        StringBuilder logBuilder = new StringBuilder();
        if (paramMap.size() > 1000) {
            this.logInfo(paramMap.toString());
            return;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (logCount > 100) {
                logBuilder.append(entry);
                this.logInfo(logIndex + "\uff1a" + logBuilder);
                logBuilder = new StringBuilder();
                ++logIndex;
                logCount = 0;
                continue;
            }
            logBuilder.append(entry);
            ++logCount;
        }
        if (logIndex == 1) {
            this.logInfo(logBuilder.toString());
        } else {
            this.logInfo(logIndex + "\uff1a" + logBuilder);
        }
    }

    private void logInfo(String msg) {
        log.info("ACCTAGE\u6d6e\u52a8\u516c\u5f0f\uff1a" + msg);
    }
}

