/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat.formater;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.acccurrentfloat.constant.AcccurrentFormula;
import kd.fi.gl.acct.handle.MakeBaseDateDetailHelper;
import kd.fi.gl.util.ReClassUtils;

public class AccountNumIDParam {
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private static final String FLEXFIELD = "flexfield";
    private static final String VALUETYPE = "valuetype";
    private Map<String, String> errorInfoMap = new HashMap<String, String>(32);
    private Set<String> acctNumberSet = new HashSet<String>(64);
    private Set<String> acctRangeNumberSet = new HashSet<String>(32);
    private Map<String, Set<String>> assistToValNumbersMap = new HashMap<String, Set<String>>(64);
    private Map<String, Set<String>> assistToValRangeNumbersMap = new HashMap<String, Set<String>>(64);
    private Map<String, Map<String, Set<Object>>> floatFlexValsMap = new HashMap<String, Map<String, Set<Object>>>(8);
    private Map<String, Long> acctNumberToIdsMap = new HashMap<String, Long>(64);
    private Map<String, Set<Long>> acctRangeKeyToIdsMap = new HashMap<String, Set<Long>>(32);
    private Map<Long, Set<Long>> acctToAllLeafMap = new HashMap<Long, Set<Long>>(64);
    private Set<Long> allLeafMasterIds = new HashSet<Long>();
    private Map<String, String> assistToFlexMap = new HashMap<String, String>(8);
    private Map<String, Set<Object>> assistValNumberToObjMap = new HashMap<String, Set<Object>>(1024);
    private Map<String, Set<Object>> assistValRangeNumberToObjsMap = new HashMap<String, Set<Object>>(8);
    private Set<String> assistNumberAllVal = new HashSet<String>(8);
    private Set<String> floatAssistNumberList = new HashSet<String>(8);
    private Set<String> flexAllVal = new HashSet<String>(8);
    private Map<String, Long> standardMap = new HashMap<String, Long>(8);
    private Map<String, DataSet> groupMap = new HashMap<String, DataSet>(8);
    private static final String FLOAT_SIGN = "@";
    private Long orgId;
    private Long bookTypeId;
    private Long acctTableId;
    private Date bookedDate;

    public Map<String, Map<String, Set<Object>>> getFloatFlexValsMap() {
        return this.floatFlexValsMap;
    }

    public AccountNumIDParam(Long orgId, Long bookTypeId, Long acctTableId, List<AcccurrentFormula> formulas, Date bookedDate, Map<String, Object> refParamMap) {
        this.orgId = orgId;
        this.bookTypeId = bookTypeId;
        this.acctTableId = acctTableId;
        this.bookedDate = bookedDate;
        this.parseAcctFormula(formulas, refParamMap);
    }

    private void parseAcctFormula(List<AcccurrentFormula> formulas, Map<String, Object> refParamMap) {
        for (AcccurrentFormula formula : formulas) {
            String acctToAssistStr = formula.getAcctAssistListStr();
            this.getBatchAcctAndAssist(acctToAssistStr, formula, refParamMap);
        }
        QFilter facctBaseData = new QFilter("startdate", "<=", (Object)this.bookedDate);
        facctBaseData = facctBaseData.and(new QFilter("enddate", ">=", (Object)this.bookedDate));
        this.queryAcctId(facctBaseData.copy());
        this.queryDLAndALAcct(facctBaseData.copy());
        this.queryAssistId(refParamMap);
    }

    private void queryDLAndALAcct(QFilter facctBaseData) {
        HashSet<Long> acctIds = new HashSet<Long>();
        acctIds.addAll(this.acctNumberToIdsMap.values());
        for (Collection collection : this.acctRangeKeyToIdsMap.values()) {
            acctIds.addAll(collection);
        }
        this.queryAcctAllLeaf(facctBaseData.copy());
        Iterator<Set<Long>> iterator = acctIds.iterator();
        while (iterator.hasNext()) {
            long l = (Long)((Object)iterator.next());
            Set<Long> allLeafAcctIds = this.acctToAllLeafMap.get(l);
            if (Objects.isNull(allLeafAcctIds)) {
                allLeafAcctIds = new HashSet<Long>(8);
                allLeafAcctIds.add(l);
                this.acctToAllLeafMap.put(l, allLeafAcctIds);
                continue;
            }
            if (!allLeafAcctIds.isEmpty()) continue;
            this.acctToAllLeafMap.remove(l);
        }
    }

    private void queryAcctAllLeaf(QFilter baseFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(baseFilter);
        filters.add(new QFilter("isleaf", "=", (Object)"1"));
        DataSet leafAcctSet = AccountUtils.queryAccountDataSet((long)this.orgId, (long)this.acctTableId, (String)"id, masterid, number, longnumber, checkitementry.enaccheck enaccheck", filters, null);
        for (Row row : leafAcctSet) {
            String longNumber = row.getString("longnumber");
            String[] split = longNumber.split("_");
            boolean enAcCheck = row.getBoolean("enaccheck");
            for (String number : split) {
                if (this.acctNumberToIdsMap.get(number) == null) continue;
                long acctId = this.acctNumberToIdsMap.get(number);
                Set leafSet = this.acctToAllLeafMap.computeIfAbsent(acctId, x -> new HashSet());
                if (!enAcCheck) continue;
                leafSet.add(row.getLong("masterid"));
                this.allLeafMasterIds.add(row.getLong("masterid"));
            }
        }
    }

    private void queryAssistId(Map<String, Object> refParamMap) {
        HashSet<String> asstactTypeNumbers = new HashSet<String>();
        asstactTypeNumbers.addAll(this.floatAssistNumberList);
        asstactTypeNumbers.addAll(this.assistNumberAllVal);
        if (!this.assistToValNumbersMap.keySet().isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValNumbersMap.keySet());
        }
        if (!this.assistToValRangeNumbersMap.keySet().isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValRangeNumbersMap.keySet());
        }
        HashMap<String, Long> numberToDetailGroupMap = new HashMap<String, Long>();
        HashMap<String, String> assistNnumberToEntityMap = new HashMap<String, String>();
        this.getFlexToAssistTypeMap(assistNnumberToEntityMap, numberToDetailGroupMap, asstactTypeNumbers);
        this.queryMulAssistIds(assistNnumberToEntityMap, numberToDetailGroupMap, this.assistToValNumbersMap, false);
        HashMap<String, Set<String>> floatAssistNumberMap = new HashMap<String, Set<String>>(8);
        for (String floatAssistNumber : this.floatAssistNumberList) {
            Object floatAssistValues = refParamMap.get(floatAssistNumber);
            if (Objects.isNull(floatAssistValues) || !(floatAssistValues instanceof List)) continue;
            List valNumberList = (List)floatAssistValues;
            HashSet valNumberSet = new HashSet(valNumberList);
            floatAssistNumberMap.put(floatAssistNumber, valNumberSet);
        }
        this.queryMulAssistIds(assistNnumberToEntityMap, numberToDetailGroupMap, floatAssistNumberMap, true);
        this.queryRangeAssistId(assistNnumberToEntityMap, numberToDetailGroupMap);
        for (String assistNumber : this.assistNumberAllVal) {
            String flex = this.assistToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            this.flexAllVal.add(flex);
        }
    }

    private void queryMulAssistIds(Map<String, String> assistNnumberToEntityMap, Map<String, Long> numberToDetailGroupMap, Map<String, Set<String>> assistNumberToValsMap, boolean isFloatFlex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        for (Map.Entry<String, Set<String>> entry : assistNumberToValsMap.entrySet()) {
            QFilter fbasedata;
            String assistNumber = entry.getKey();
            String entityId = assistNnumberToEntityMap.get(assistNumber);
            Set<String> valNumbers = entry.getValue();
            filters.clear();
            if (this.orgId != 0L && entityId != null && (fbasedata = this.dealBasedataFilter(entityId, this.orgId)) != null) {
                filters.add(fbasedata);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long assistGroupId = numberToDetailGroupMap.get(assistNumber);
                QFilter qFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistGroupId, (Long)this.orgId);
                if (qFilter != null) {
                    filters.add(qFilter);
                }
                filters.add(new QFilter("group", "=", (Object)assistGroupId));
            }
            HashMap<String, Set> assistNumberToObjsMap = new HashMap<String, Set>();
            if (entityId == null) {
                for (String string : valNumbers) {
                    HashSet<String> txtSet = new HashSet<String>(2);
                    txtSet.add(string);
                    Set objsVal = assistNumberToObjsMap.computeIfAbsent(string, x -> new HashSet());
                    objsVal.addAll(txtSet);
                }
            } else {
                Map<String, Set<Long>> numberToIdsMap = detailHelper.getDetailAssists(entityId, valNumbers, filters);
                for (Map.Entry<String, Set<Long>> idEntry : numberToIdsMap.entrySet()) {
                    String number = idEntry.getKey();
                    Set<Long> valSet = idEntry.getValue();
                    Set objsVal = assistNumberToObjsMap.computeIfAbsent(number, x -> new HashSet());
                    objsVal.addAll(valSet);
                }
            }
            if (isFloatFlex) {
                this.floatFlexValsMap.put(this.assistToFlexMap.get(assistNumber), assistNumberToObjsMap);
                continue;
            }
            for (Map.Entry entry2 : assistNumberToObjsMap.entrySet()) {
                this.assistValNumberToObjMap.put(assistNumber + "*" + (String)entry2.getKey(), (Set<Object>)entry2.getValue());
            }
        }
    }

    private void queryRangeAssistId(Map<String, String> assistNnumberToEntityMap, Map<String, Long> numberToDetailGroupMap) {
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        for (Map.Entry<String, Set<String>> entry : this.assistToValRangeNumbersMap.entrySet()) {
            String assistNumber = entry.getKey();
            String entityId = assistNnumberToEntityMap.get(assistNumber);
            Set<String> rangeValNumber = entry.getValue();
            filters.clear();
            QFilter fbasedata = null;
            if (this.orgId != 0L && entityId != null) {
                fbasedata = this.dealBasedataFilter(entityId, this.orgId);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long assistGroupId = numberToDetailGroupMap.get(assistNumber);
                QFilter assistantOrgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistGroupId, (Long)this.orgId);
                if (assistantOrgFilter != null) {
                    filters.add(assistantOrgFilter);
                }
                filters.add(new QFilter("group", "=", (Object)assistGroupId));
            }
            Iterator<String> iterator = rangeValNumber.iterator();
            while (iterator.hasNext()) {
                String assistRangeNumber;
                String key = assistRangeNumber = iterator.next();
                HashSet<Object> assistValIds = new HashSet<Object>();
                ArrayList<QFilter> rangFilters = new ArrayList<QFilter>(8);
                rangFilters.addAll(filters);
                boolean isNoCategory = ReClassUtils.isCollectionNumber(assistRangeNumber);
                if (!isNoCategory) {
                    assistRangeNumber = assistRangeNumber.substring(1, assistRangeNumber.length() - 1);
                }
                String[] assisttContinueNumbers = assistRangeNumber.split(",");
                if (entityId == null) {
                    assistValIds.addAll(Arrays.asList(assisttContinueNumbers));
                    this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                    continue;
                }
                DataSet assistSet = null;
                if (!isNoCategory) {
                    if (fbasedata != null) {
                        rangFilters.add(fbasedata.copy());
                    }
                    assistSet = this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), rangFilters, "masterid", entityId);
                } else {
                    assistSet = this.queryAssistValByGroup(assistRangeNumber, entityId);
                }
                if (assistSet == null) continue;
                for (Row row : assistSet) {
                    assistValIds.add(row.getLong("masterid"));
                }
                if (!isNoCategory && detailHelper.hasParent(entityId)) {
                    Set<Object> assistValIds1 = detailHelper.getDetailAssisttContinueNumbers(entityId, assistValIds, filters);
                    assistValIds.addAll(assistValIds1);
                }
                this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
            }
        }
    }

    private QFilter dealBasedataFilter(String entityId, long orgId) {
        QFilter qf = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId);
        return qf;
    }

    private void getFlexToAssistTypeMap(Map<String, String> numberToEntityMap, Map<String, Long> numberToDetailGroupMap, Set<String> asstactTypeNumbers) {
        QFilter fnumber = new QFilter("number", "in", asstactTypeNumbers);
        QFilter flexidFilter = new QFilter("flexid", "in", (Object)2);
        DataSet asstactSet = this.queryDataSet(this.getClass().getName(), ASSIST_TYPE, "number,valuetype,assistanttype,valuesource,flexfield", new QFilter[]{fnumber, flexidFilter});
        for (Row row : asstactSet) {
            long assistGroupId = 0L;
            String valType = row.getString(VALUETYPE);
            String entityId = null;
            switch (valType) {
                case "1": {
                    entityId = row.getString("valuesource");
                    break;
                }
                case "2": {
                    entityId = "bos_assistantdata_detail";
                    assistGroupId = row.getLong("assistanttype");
                    break;
                }
                case "3": {
                    entityId = null;
                }
            }
            String number = row.getString("number");
            String flex = row.getString(FLEXFIELD);
            this.assistToFlexMap.put(number, flex);
            if (assistGroupId != 0L) {
                numberToDetailGroupMap.put(number, assistGroupId);
            }
            numberToEntityMap.put(number, entityId);
        }
    }

    private void getBatchAcctAndAssist(String acctAssistListStr, AcccurrentFormula formula, Map<String, Object> refParamMap) {
        acctAssistListStr = acctAssistListStr.replaceAll("\\|", "\\| ");
        String[] accountValues = acctAssistListStr.split("\\|");
        String acctKeyId = formula.getKey();
        String accountNumberStr = "";
        if (accountValues.length == 1) {
            accountNumberStr = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                this.errorInfoMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u683c\u5f0f\u6709\u8bef\u3002", (String)"AccountNumIDParam_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
                return;
            }
            accountNumberStr = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)accountNumberStr)) {
            this.errorInfoMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"AccountNumIDParam_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return;
        }
        this.collectAccountNumbers(accountNumberStr);
        this.collectAssistNumbers(accountValues, formula, refParamMap);
    }

    private void collectAssistNumbers(String[] accountValues, AcccurrentFormula formula, Map<String, Object> refParamMap) {
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            if (StringUtils.isBlank((CharSequence)assistNumber)) continue;
            HashSet<String> vals = new HashSet<String>();
            String rangeVals = "";
            String valStr = accountValues[i + 1].trim();
            if (!StringUtils.isBlank((CharSequence)valStr)) {
                if (FLOAT_SIGN.equals(valStr)) {
                    boolean existRefParam = refParamMap.containsKey(assistNumber);
                    if (existRefParam) {
                        this.floatAssistNumberList.add(assistNumber);
                        formula.addFloatAssistNumber(assistNumber);
                        continue;
                    }
                    this.errorInfoMap.put(formula.getKey(), String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u6d6e\u52a8\u6838\u7b97\u7ef4\u5ea6%1$s \uff0c\u672a\u627e\u5230\u5bf9\u5e94\u6d6e\u52a8\u8303\u56f4\u3002", (String)"AccountNumIDParam_2", (String)"fi-gl-mservice", (Object[])new Object[0]), assistNumber));
                    continue;
                }
                if (ReClassUtils.isContinueNumber(valStr)) {
                    rangeVals = valStr;
                    HashSet<String> rangeValNumbers = this.assistToValRangeNumbersMap.get(assistNumber) == null ? new HashSet<String>() : this.assistToValRangeNumbersMap.get(assistNumber);
                    rangeValNumbers.add(rangeVals);
                    this.assistToValRangeNumbersMap.put(assistNumber, rangeValNumbers);
                    formula.addNonFloatAssistNumber(assistNumber);
                    continue;
                }
                String[] valList = valStr.split(",");
                vals.addAll(Arrays.asList(valList));
                Set<String> valNumbers = this.assistToValNumbersMap.get(assistNumber);
                if (valNumbers == null) {
                    valNumbers = new HashSet<String>();
                    valNumbers.addAll(vals);
                } else {
                    if (valNumbers.size() == 0) continue;
                    valNumbers.addAll(vals);
                }
                this.assistToValNumbersMap.put(assistNumber, valNumbers);
                formula.addNonFloatAssistNumber(assistNumber);
                continue;
            }
            this.assistNumberAllVal.add(assistNumber);
            formula.addNonFloatAssistNumber(assistNumber);
        }
    }

    private void collectAccountNumbers(String accountNumberStr) {
        boolean isContinueAcct = this.isContinueNumber(accountNumberStr);
        if (!isContinueAcct) {
            String[] accts = accountNumberStr.split(",");
            this.acctNumberSet.addAll(Arrays.asList(accts));
        } else {
            this.acctRangeNumberSet.add(accountNumberStr);
        }
    }

    private boolean isContinueNumber(String numberStr) {
        if (!StringUtils.isBlank((CharSequence)numberStr)) {
            return numberStr.contains("[") && numberStr.contains("]");
        }
        return false;
    }

    private void queryAcctId(QFilter facctBaseData) {
        QFilter fnumbers = new QFilter("number", "in", this.acctNumberSet);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(facctBaseData.copy());
        filters.add(fnumbers);
        DataSet acctSet = AccountUtils.queryAccountDataSet((long)this.orgId, (long)this.acctTableId, (String)"id, number, masterid,dc", filters);
        for (Row row : acctSet) {
            long acctId = row.getLong("id");
            String number = row.getString("number");
            this.acctNumberToIdsMap.put(number, acctId);
        }
        for (String acctRangeNumber : this.acctRangeNumberSet) {
            ArrayList<QFilter> rangFilters = new ArrayList<QFilter>();
            rangFilters.add(facctBaseData.copy());
            String key = acctRangeNumber;
            acctRangeNumber = acctRangeNumber.substring(1, acctRangeNumber.length() - 1);
            String[] acctContinueNumbers = acctRangeNumber.split(",");
            DataSet rangeAcctSet = this.queryContinueNumber(Arrays.asList(acctContinueNumbers), rangFilters, "id,masterid,dc,level,number", "bd_accountview");
            HashSet<Long> acctIds = new HashSet<Long>();
            int level = 0;
            for (Row row : rangeAcctSet) {
                if (level == 0) {
                    level = row.getInteger("level");
                }
                if (level != row.getInteger("level")) continue;
                long acctId = row.getLong("id");
                acctIds.add(acctId);
                this.acctNumberToIdsMap.put(row.getString("number"), acctId);
            }
            this.acctRangeKeyToIdsMap.put(key, acctIds);
        }
    }

    private DataSet queryContinueNumber(List<String> acctNumbers, List<QFilter> filters, String sel, String entityName) {
        if (acctNumbers != null && acctNumbers.size() == 2) {
            String acctNumber0 = acctNumbers.get(0);
            String acctNumber1 = acctNumbers.get(1);
            QFilter filterMin = new QFilter("number", ">=", (Object)acctNumber0);
            QFilter filterMax = new QFilter("number", "<=", (Object)acctNumber1);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.addAll(filters);
            filterList.add(filterMin);
            filterList.add(filterMax);
            DataSet acctSet = QueryServiceHelper.queryDataSet((String)"ReClassUtils.queryDataSet", (String)entityName, (String)sel, (QFilter[])filterList.toArray(new QFilter[0]), (String)"number");
            return acctSet;
        }
        return null;
    }

    private Set<Long> queryLeafCategory(String categoryNumber, String entityId) {
        entityId = entityId + "group";
        String[] assisttContinueNumbers = null;
        String sel = "parent pid, id, isleaf";
        DataSet dataSet = null;
        if (categoryNumber.startsWith("[")) {
            categoryNumber = categoryNumber.substring(1, categoryNumber.length() - 1);
            assisttContinueNumbers = categoryNumber.split(",");
            dataSet = this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), new ArrayList<QFilter>(), sel, entityId);
        } else if (categoryNumber.contains(",")) {
            String[] categroyList = categoryNumber.split(",");
            QFilter fid = new QFilter("number", "in", (Object)categroyList);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        } else {
            QFilter fid = new QFilter("number", "=", (Object)categoryNumber);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        }
        HashSet<Long> allIds = new HashSet<Long>();
        HashSet<Long> noLeafIds = new HashSet<Long>();
        this.getLeafAndNoLeaf(dataSet, noLeafIds, allIds);
        this.getAllLeaf(noLeafIds, entityId, allIds);
        return allIds;
    }

    private DataSet queryAssistValByGroup(String categoryNumber, String entityId) {
        DataSet assistSet;
        String groupKey = entityId.substring(3);
        String[] categoryList = categoryNumber.split("#");
        if (categoryList.length != 2) {
            return null;
        }
        String standardNumber = categoryList[0];
        long standardId = 0L;
        if (this.standardMap.get(entityId + "*" + standardNumber) == null) {
            DataSet standardSet = this.queryDataSet(this.getClass().getName(), entityId + "groupstandard", "id", new QFilter[]{new QFilter("number", "=", (Object)standardNumber)});
            for (Row row : standardSet) {
                standardId = row.getLong("id");
            }
            this.standardMap.put(entityId + "*" + standardNumber, standardId);
        } else {
            standardId = this.standardMap.get(entityId + "*" + standardNumber);
        }
        String groupNumber = categoryList[1];
        if (this.groupMap.get(entityId + "*" + groupNumber) == null) {
            Set<Long> allGroupIds = this.queryLeafCategory(groupNumber, entityId);
            QFilter fgid = new QFilter("group", "in", allGroupIds);
            QFilter fstandard = new QFilter("standard", "=", (Object)standardId);
            String sel = groupKey + " masterid";
            assistSet = this.queryDataSet(this.getClass().getName(), entityId + "groupdetail", sel, new QFilter[]{fgid, fstandard});
            this.groupMap.put(entityId + "*" + groupNumber, assistSet);
        } else {
            assistSet = this.groupMap.get(entityId + "*" + groupNumber);
        }
        return assistSet;
    }

    private DataSet queryDataSet(String algoKey, String entityId, String sel, QFilter[] filters) {
        DataSet assistSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityId, (String)sel, (QFilter[])filters, null);
        return assistSet;
    }

    private void getAllLeaf(Set<Long> noLeafIds, String entityId, Set<Long> leafIds) {
        if (noLeafIds.isEmpty()) {
            return;
        }
        QFilter fid = new QFilter("parent", "in", noLeafIds);
        String sel = "id, isleaf";
        DataSet childSet = this.queryDataSet(this.getClass().getName(), entityId, sel, new QFilter[]{fid});
        noLeafIds.clear();
        this.getLeafAndNoLeaf(childSet, noLeafIds, leafIds);
        this.getAllLeaf(noLeafIds, entityId, leafIds);
    }

    private void getLeafAndNoLeaf(DataSet childSet, Set<Long> noLeafIds, Set<Long> allIds) {
        if (childSet == null) {
            return;
        }
        for (Row row : childSet) {
            long id = row.getLong("id");
            if (row.getBoolean("isleaf").booleanValue()) {
                allIds.add(id);
                continue;
            }
            allIds.add(id);
            noLeafIds.add(id);
        }
    }

    public Map<String, Long> getAcctNumberToIdsMap() {
        return this.acctNumberToIdsMap;
    }

    public long getBookTypeId() {
        return this.bookTypeId;
    }

    public Map<String, Set<Long>> getAcctRangeKeyToIdsMap() {
        return this.acctRangeKeyToIdsMap;
    }

    public Set<Long> getAllLeafAccounts(Long accountId) {
        return Objects.isNull(this.acctToAllLeafMap.get(accountId)) ? Collections.EMPTY_SET : this.acctToAllLeafMap.get(accountId);
    }

    public Set<Long> getAllLeafMasterIds() {
        return this.allLeafMasterIds;
    }

    public Map<String, String> getAssistToFlexMap() {
        return this.assistToFlexMap;
    }

    public Map<String, Set<Object>> getassistValNumberToObjMap() {
        return this.assistValNumberToObjMap;
    }

    public Map<String, Set<Object>> getassistValRangeNumberToObjsMap() {
        return this.assistValRangeNumberToObjsMap;
    }

    public Map<String, String> getErrorInfoMap() {
        return this.errorInfoMap;
    }
}

