/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat.matchdata;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.exception.KDBizException;
import kd.fi.gl.exception.GLErrorCode;

public class RangeBuilder<F> {
    private static final String VOID = "void";
    private Map<Long, Set<F>> _treeMap = new TreeMap<Long, Set<F>>();

    public void feed(List<Long> ids, F identifier) {
        for (Long id : ids) {
            Set<F> value = this._treeMap.get(id);
            if (value == null) {
                value = new HashSet<F>();
                value.add(identifier);
                this._treeMap.put(id, value);
                continue;
            }
            value.add(identifier);
        }
    }

    private RangeMap<Long, Set<F>> build() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        Set<F> lastIdentifier = Collections.EMPTY_SET;
        long rangeStart = -1L;
        long curId = -1L;
        for (Map.Entry<Long, Set<F>> entry : this._treeMap.entrySet()) {
            curId = entry.getKey();
            if (rangeStart == -1L) {
                rangeStart = curId;
                lastIdentifier = entry.getValue();
                continue;
            }
            Set<F> curIdentifier = entry.getValue();
            if (curIdentifier.equals(lastIdentifier)) continue;
            rangeMap.put(Range.closedOpen((Comparable)Long.valueOf(rangeStart), (Comparable)Long.valueOf(curId)), lastIdentifier);
            rangeStart = curId;
            lastIdentifier = curIdentifier;
        }
        if (rangeStart != -1L) {
            rangeMap.put(Range.closed((Comparable)Long.valueOf(rangeStart), (Comparable)Long.valueOf(curId)), (Object)lastIdentifier);
        }
        this._treeMap.clear();
        return rangeMap;
    }

    public Map<F, Set<Range<Long>>> buildReverseRetrivalMap() {
        if (this._treeMap.isEmpty()) {
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        HashMap idToRangeMap = new HashMap(8);
        RangeMap<Long, Set<F>> rangeMap = this.build();
        for (Map.Entry rangeEntry : rangeMap.asMapOfRanges().entrySet()) {
            Range range = (Range)rangeEntry.getKey();
            Set fs = (Set)rangeEntry.getValue();
            for (Object f : fs) {
                idToRangeMap.putIfAbsent(f, new HashSet(8));
                ((Set)idToRangeMap.get(f)).add(range);
            }
        }
        return idToRangeMap;
    }

    public static void main(String[] args) {
        RangeBuilder<String> builder = new RangeBuilder<String>();
        builder.feed(Arrays.asList(1L, 2L, 100L), "f1");
        builder.feed(Arrays.asList(1L, 2L, 5L), "f2");
        RangeMap rangeMap = super.build();
        System.out.println(rangeMap);
        RangeBuilder<String> builder2 = new RangeBuilder<String>();
        builder2.feed(Arrays.asList(1L, 2L, 100L), "f1");
        builder2.feed(Arrays.asList(1L, 2L, 5L), "f2");
        System.out.println(builder2.buildReverseRetrivalMap());
    }
}

