/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.action;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ThreadLocals;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.acct.action.BuildParamMap;
import kd.fi.gl.acct.buildparam.AssistIdCollectionType;
import kd.fi.gl.acct.context.AcctMapContext;
import kd.fi.gl.acct.context.BuildAcctMapContext;
import kd.fi.gl.acct.handle.LoopExcuteAcctMapBalanceQueryHandle;
import kd.fi.gl.acct.param.BCMBalanceIndexParam;
import kd.fi.gl.acct.param.ReClassNumberIDParam;
import kd.fi.gl.acct.param.ReClassParam;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;
import kd.fi.gl.util.ReClassUtils;

public class AcctBalParseAction {
    private static final Log log = LogFactory.getLog(AcctBalParseAction.class);
    private static AtomicLong AllBuildCxtTimes = new AtomicLong(0L);
    public static ThreadLocal<Integer> ThreadBuildCxtTimes = ThreadLocals.create((Object)0);
    private static final String ACCTLOG = "ACCT GETBALANCE WATCH LOG -AcctBalParseAction-: ";

    private void printLog(ReClassParam reClassParam) {
        log.info("ACCT\u91cd\u5206\u7c7b\u53d6\u6570\uff0c\u62a5\u8868\u53c2\u6570\uff1a" + reClassParam.getAcctReClass() + ",\u7ec4\u7ec7\u7f16\u7801\uff1a" + reClassParam.getOrgNumber() + ",\u671f\u95f4\uff1a" + reClassParam.getPeriod());
        Map<String, Object> paramMap = reClassParam.getAcctFormulaMap();
        int logIndex = 1;
        int logCount = 1;
        StringBuilder logBuilder = new StringBuilder();
        if (paramMap.size() > 1000) {
            log.info("ACCT\u91cd\u5206\u7c7b\u516c\u5f0f\uff1a" + logBuilder);
            return;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (logCount > 100) {
                logBuilder.append(entry);
                log.info("ACCT\u91cd\u5206\u7c7b\u516c\u5f0f" + logIndex + "\uff1a" + logBuilder);
                logBuilder = new StringBuilder();
                ++logIndex;
                logCount = 0;
                continue;
            }
            logBuilder.append(entry);
            ++logCount;
        }
        if (logIndex == 1) {
            log.info("ACCT\u91cd\u5206\u7c7b\u516c\u5f0f\uff1a" + logBuilder);
        } else {
            log.info("ACCT\u91cd\u5206\u7c7b\u516c\u5f0f" + logIndex + "\uff1a" + logBuilder);
        }
    }

    public Map<String, Map<String, Object>> parseParam(final ReClassParam reClassParam) {
        try {
            PerformanceWatch watch_Parse = new PerformanceWatch(AcctBalParseAction.class, "parseParam", false);
            watch_Parse.start("ACCT GETBALANCE WATCH LOG -AcctBalParseAction-: parseParam start");
            this.printLog(reClassParam);
            final String comOrgNumber = reClassParam.getOrgNumber();
            Map<String, Long> mainBookTypeMap = this.getMainBookType();
            String mainBookTypeNumber = "";
            if (mainBookTypeMap.size() > 0) {
                mainBookTypeNumber = mainBookTypeMap.keySet().iterator().next();
            }
            if (StringUtils.isBlank((CharSequence)mainBookTypeNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u7684\u7ec4\u7ec7\u53d6\u4e0d\u5230\u4e3b\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"AcctBalParseAction_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
            }
            final int comFy = reClassParam.getFy();
            final int comPeriod = reClassParam.getPeriod();
            final String comAdjustPeriod = reClassParam.getAdjustPeriod();
            final List<String> scopePeriods = reClassParam.getScopePeriods();
            final String comAssistStr = reClassParam.getComAssistStr();
            final AcctUtil acctUtil = new AcctUtil();
            Map<String, Object> paramMap = reClassParam.getAcctFormulaMap();
            final HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(paramMap.size());
            Map<String, Map<String, List<String>>> bookStrToFormulasMap = this.getBookStrSet(paramMap, mainBookTypeNumber, comOrgNumber, scopePeriods, resultMap);
            ArrayList<Future> futures = new ArrayList<Future>(bookStrToFormulasMap.size());
            final HasPermOrgResult permOrgResult = InterfacePermissionService.getAllPermOrgs(PermissionType.ACCT);
            final String permName = InterfacePermissionService.getPermName(PermissionType.ACCT);
            watch_Parse.stop();
            watch_Parse.start("ACCT GETBALANCE WATCH LOG -AcctBalParseAction-: bookStrSet" + bookStrToFormulasMap.keySet() + " GLThreadService.computeAcct");
            final String finalMainBookTypeNumber = mainBookTypeNumber;
            for (Map.Entry<String, Map<String, List<String>>> bookEntry : bookStrToFormulasMap.entrySet()) {
                final String bookStr = bookEntry.getKey();
                final Map<String, List<String>> formulasMap = bookEntry.getValue();
                futures.add(GLThreadService.computeAcct((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        PerformanceWatch watch = new PerformanceWatch(AcctBalParseAction.class, "parseParam", false);
                        watch.start("ACCT GETBALANCE WATCH LOG -AcctBalParseAction-:  bookStr " + bookStr + " ReClassNumberIDParam");
                        ReClassNumberIDParam numberIDParam = new ReClassNumberIDParam(reClassParam, formulasMap, bookStr);
                        AssistIdCollectionType.rebuildIndex();
                        long acctOrgId = numberIDParam.getOrgId();
                        long bookTypeId = numberIDParam.getBookTypeId();
                        long acctTableId = numberIDParam.getAcctTableId();
                        String bookErrorMessage = AcctBalParseAction.this.checkBook(bookStr, acctOrgId, bookTypeId);
                        String orgPermMsg = AcctUtil.checkPermByOrgId(bookStr.split(",")[0], permName, acctOrgId, permOrgResult);
                        BuildAcctMapContext buildAcctMapContext = new BuildAcctMapContext();
                        watch.stop();
                        watch.start("ACCT GETBALANCE WATCH LOG -AcctBalParseAction-: bookStr " + bookStr + " buildAcctMapContext build start");
                        Map<String, Map<String, Object>> errorInfoMap = numberIDParam.getErrorInfoMap();
                        for (Map.Entry entry : formulasMap.entrySet()) {
                            try {
                                Long endPeriodId;
                                Long startPeriodId;
                                String tmpBookTypeNumber;
                                String acctKeyId = (String)entry.getKey();
                                List paramFields = (List)entry.getValue();
                                if (errorInfoMap.containsKey(acctKeyId)) continue;
                                String tmpOrgNumber = (String)paramFields.get(0);
                                if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                                    tmpOrgNumber = comOrgNumber;
                                }
                                if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                                    tmpBookTypeNumber = finalMainBookTypeNumber;
                                }
                                String periodParam = AcctUtil.getPeriodParam((String)paramFields.get(5));
                                String fetchType = (String)paramFields.get(3);
                                if ((StringUtils.isBlank((CharSequence)periodParam) || periodParam.equals("0")) && CollectionUtils.isNotEmpty((Collection)scopePeriods)) {
                                    periodParam = String.valueOf(scopePeriods.get(1));
                                }
                                if (!bookStr.equals(tmpOrgNumber + "," + tmpBookTypeNumber + "," + (String)paramFields.get(4) + "," + periodParam)) continue;
                                if (!AcctUtil.checkPeriodFormat(periodParam)) {
                                    AcctBalParseAction.this.setErrorMessage(resultMap, -1, ResManager.loadKDString((String)"\u516c\u5f0f\u7684\u671f\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AcctBalParseAction_17", (String)"fi-gl-mservice", (Object[])new Object[0]), (String)entry.getKey());
                                    continue;
                                }
                                if (!StringUtils.isEmpty((CharSequence)bookErrorMessage)) {
                                    AcctBalParseAction.this.setErrorMessage(resultMap, -1, bookErrorMessage, (String)entry.getKey());
                                    continue;
                                }
                                if (StringUtils.isNotBlank((CharSequence)orgPermMsg)) {
                                    AcctBalParseAction.this.setErrorMessage(resultMap, -1, orgPermMsg, (String)entry.getKey());
                                    continue;
                                }
                                String acctToAssistList = (String)paramFields.get(2);
                                Map<Long, Map<String, Set<Object>>> assistToAcctMap = acctUtil.parseAcctAssistList(acctToAssistList, numberIDParam, acctKeyId);
                                if (DebugTrace.enable()) {
                                    log.info("acctUtil_assistToAcctMap : " + DebugTraceHelper.toString(assistToAcctMap));
                                }
                                if (assistToAcctMap.isEmpty()) {
                                    HashMap<String, Object> message = new HashMap<String, Object>(8);
                                    message.put("type", -2);
                                    message.put("v", String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u65e0\u6cd5\u89e3\u6790\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u79d1\u76ee\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AcctBalParseAction_5", (String)"fi-gl-mservice", (Object[])new Object[0]), tmpOrgNumber, acctToAssistList));
                                    errorInfoMap.putIfAbsent((String)entry.getKey(), (Map<String, Object>)message);
                                    continue;
                                }
                                if (StringUtils.isBlank((CharSequence)fetchType)) {
                                    AcctBalParseAction.this.setErrorMessage(resultMap, -1, ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AcctBalParseAction_2", (String)"fi-gl-mservice", (Object[])new Object[0]), (String)entry.getKey());
                                    continue;
                                }
                                fetchType = fetchType.toUpperCase();
                                periodParam = AcctUtil.getPeriodParam((String)paramFields.get(5));
                                if ((StringUtils.isBlank((CharSequence)periodParam) || periodParam.equals("0")) && CollectionUtils.isNotEmpty((Collection)scopePeriods)) {
                                    String startPeriodNumber = String.valueOf(scopePeriods.get(0));
                                    String endPeriodNumber = String.valueOf(scopePeriods.get(1));
                                    int formulaYear = StringUtils.isBlank((CharSequence)((CharSequence)paramFields.get(4))) || ((String)paramFields.get(4)).equals("0") ? 0 : Integer.parseInt((String)paramFields.get(4));
                                    int fy = formulaYear > 1000 ? formulaYear : comFy + formulaYear;
                                    startPeriodId = numberIDParam.getSeasonPeriodIdMap().get(fy + "," + startPeriodNumber);
                                    endPeriodId = numberIDParam.getSeasonPeriodIdMap().get(fy + "," + endPeriodNumber);
                                } else {
                                    int fy = -1;
                                    String periodStr = StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(comPeriod);
                                    String yearAndPeriodKey = AcctUtil.dealYearAndPeriod(AcctUtil.getPeriodParam((String)paramFields.get(5)), comPeriod, comAdjustPeriod, (String)paramFields.get(4), comFy, numberIDParam.getPeriodFromYearMap());
                                    String[] yearAndPeriod = yearAndPeriodKey.split("-");
                                    if (yearAndPeriod.length == 2) {
                                        fy = Integer.parseInt(yearAndPeriod[0]);
                                        periodStr = yearAndPeriod[1];
                                    }
                                    if (periodStr.endsWith("T") || fy != -1) {
                                        endPeriodId = startPeriodId = numberIDParam.getPeriodIdsMap().get(fy + "," + periodStr);
                                    } else {
                                        AcctBalParseAction.this.setErrorMessage(resultMap, -1, ResManager.loadKDString((String)"\u671f\u95f4\u8d1f\u6570\u4e0d\u80fd\u8de8\u5ea6\u4e24\u5e74\u3002", (String)"AcctBalParseAction_3", (String)"fi-gl-mservice", (Object[])new Object[0]), (String)entry.getKey());
                                        continue;
                                    }
                                }
                                if (startPeriodId == null || endPeriodId == null) {
                                    AcctBalParseAction.this.setErrorMessage(resultMap, -1, ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"AcctBalParseAction_4", (String)"fi-gl-mservice", (Object[])new Object[0]), (String)entry.getKey());
                                    continue;
                                }
                                if (acctTableId == 0L) {
                                    AcctBalParseAction.this.setErrorMessage(resultMap, -1, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u8d26\u7c3f\u7c7b\u578b\uff1a%2$s\uff0c\u5c1a\u672a\u5efa\u7acb\u8d26\u7c3f\u3002", (String)"AcctBalParseAction_10", (String)"fi-gl-mservice", (Object[])new Object[0]), tmpOrgNumber, tmpBookTypeNumber), (String)entry.getKey());
                                    continue;
                                }
                                String currencyNumber = (String)paramFields.get(6);
                                long currencyId = 0L;
                                if (!StringUtils.isBlank((CharSequence)currencyNumber)) {
                                    currencyId = numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber) == null ? 0L : numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber);
                                }
                                HashMap<Long, Integer> acctToAssistStyleMap = new HashMap<Long, Integer>(64);
                                HashMap<Long, Set<Long>> acctToRCAcctIdsMap = new HashMap<Long, Set<Long>>(64);
                                int acctReClass = reClassParam.getAcctReClass();
                                if (!BCMBalanceIndexParam.getFetchTypeReclass().contains(fetchType)) {
                                    Map<Long, Set<Long>> leafMap = numberIDParam.getAcctToAllLeafMap();
                                    Set<Long> acctIds = assistToAcctMap.keySet();
                                    for (Long acctId : acctIds) {
                                        acctToAssistStyleMap.put(acctId, 2);
                                        acctToRCAcctIdsMap.put(acctId, leafMap.get(acctId));
                                    }
                                } else {
                                    if (paramFields.size() > 7 && StringUtils.isNotBlank((CharSequence)((CharSequence)paramFields.get(7)))) {
                                        acctReClass = Integer.parseInt((String)paramFields.get(7));
                                    }
                                    acctUtil.acctReClassDeal(acctReClass, assistToAcctMap, acctToAssistStyleMap, acctToRCAcctIdsMap, numberIDParam);
                                }
                                String contraAccount = "N";
                                if (paramFields.size() > 8 && StringUtils.isNotBlank((CharSequence)((CharSequence)paramFields.get(8)))) {
                                    contraAccount = (String)paramFields.get(8);
                                }
                                if (acctToAssistStyleMap.isEmpty()) {
                                    String[] accountValues = acctToAssistList.split("\\|");
                                    String acctsStr = accountValues[0];
                                    HashMap<String, Object> message = new HashMap<String, Object>(8);
                                    message.put("type", -2);
                                    message.put("v", String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u6ca1\u6709\u5206\u914d%2$s\u79d1\u76ee\u6743\u9650\u3002", (String)"AcctBalParseAction_15", (String)"fi-gl-mservice", (Object[])new Object[0]), tmpOrgNumber, acctsStr));
                                    errorInfoMap.putIfAbsent((String)entry.getKey(), (Map<String, Object>)message);
                                    continue;
                                }
                                HashMap<String, Set<Long>> comAssistIdMap = new HashMap(8);
                                String tempComAssistStr = comAssistStr;
                                if (paramFields.size() > 9 && StringUtils.isNotBlank((CharSequence)((CharSequence)paramFields.get(9)))) {
                                    tempComAssistStr = (String)paramFields.get(9);
                                }
                                if (StringUtils.isNotBlank((CharSequence)tempComAssistStr)) {
                                    if (AcctUtil.checkComAssistFormat(tempComAssistStr, Boolean.FALSE)) {
                                        comAssistIdMap = AcctBalParseAction.this.getComAssistIdMap(tempComAssistStr, (Table<String, String, Set<Long>>)numberIDParam.getComAssistToValueIdTable(), (Table<String, String, Set<Long>>)numberIDParam.getComAssistToValRangeIdTable());
                                    } else {
                                        AcctBalParseAction.this.setErrorMessage(resultMap, -1, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u53c2\u6570\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"AcctBalParseAction_19", (String)"fi-gl-mservice", (Object[])new Object[0]), (String)entry.getKey());
                                        continue;
                                    }
                                }
                                if (DebugTrace.enable()) {
                                    log.info("formulaKey = " + (String)entry.getKey() + ", comAssistIdMap : " + comAssistIdMap);
                                }
                                new BuildParamMap().buildContext(buildAcctMapContext, assistToAcctMap, acctToAssistStyleMap, acctToRCAcctIdsMap, numberIDParam, fetchType, currencyId, acctOrgId, acctKeyId, bookTypeId, acctTableId, startPeriodId, endPeriodId, acctReClass, contraAccount, comAssistIdMap);
                            }
                            catch (Exception e) {
                                log.info("\u91cd\u5206\u7c7b\u53d6\u6570\u516c\u5f0f\u5f02\u5e38\u4fe1\u606f\uff1a" + GLUtil.printError((Throwable)e));
                                HashMap<String, Object> message = new HashMap<String, Object>(8);
                                message.put("type", -1);
                                message.put("v", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u5f0f\u201c%s\u201d\u5f02\u5e38", (String)"AcctBalParseAction_6", (String)"fi-gl-mservice", (Object[])new Object[0]), entry) + GLUtil.printError((Throwable)e));
                                errorInfoMap.putIfAbsent((String)entry.getKey(), (Map<String, Object>)message);
                            }
                        }
                        watch.stop();
                        watch.start("ACCT GETBALANCE WATCH LOG -AcctBalParseAction-: bookStr " + bookStr + " buildAcctMapContext handle getBalance");
                        if (buildAcctMapContext.getAssistAcctGroupMapContext().getSize() > 0) {
                            for (Map.Entry<Object, Object> entry : buildAcctMapContext.getAssistAcctGroupMapContext().getGroupMap().entrySet()) {
                                AcctMapContext contextValue = (AcctMapContext)entry.getValue();
                                new LoopExcuteAcctMapBalanceQueryHandle();
                                LoopExcuteAcctMapBalanceQueryHandle.handle(buildAcctMapContext, contextValue);
                            }
                            buildAcctMapContext.getAssistAcctGroupMapContext().clear();
                        }
                        AcctBalParseAction.this.setFormulaAmt(buildAcctMapContext, resultMap, numberIDParam);
                        watch.stop();
                        return true;
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
            watch_Parse.stop();
            log.info(watch_Parse.show());
            return resultMap;
        }
        catch (Exception e) {
            log.info(ResManager.loadKDString((String)"\u91cd\u5206\u7c7b\u53d6\u6570\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"AcctBalParseAction_20", (String)"fi-gl-mservice", (Object[])new Object[0]) + GLUtil.printError((Throwable)e));
            throw new BOSException((Throwable)e);
        }
    }

    private Map<String, Set<Long>> getComAssistIdMap(String tempComAssistStr, Table<String, String, Set<Long>> comAssistToValueIdTable, Table<String, String, Set<Long>> comAssistToValRangeIdTable) {
        HashMap<String, Set<Long>> comAssistIdMap = new HashMap<String, Set<Long>>(8);
        Map<String, Set<String>> comAssistKeyToNumMap = AcctUtil.parseComAssistStr(tempComAssistStr);
        for (Map.Entry<String, Set<String>> comAssistKeyToNumEntry : comAssistKeyToNumMap.entrySet()) {
            Set allValueIdSet;
            String comAssistKey = comAssistKeyToNumEntry.getKey();
            Set<String> valueNumberSet = comAssistKeyToNumEntry.getValue();
            if (valueNumberSet != null && valueNumberSet.isEmpty()) {
                comAssistIdMap.put(comAssistKey, new HashSet(8));
                continue;
            }
            if (valueNumberSet == null) continue;
            String tempValueNumber = valueNumberSet.iterator().next();
            if (AcctUtil.isRangeValueNumber(tempValueNumber)) {
                for (String valueNumber : valueNumberSet) {
                    allValueIdSet = comAssistIdMap.computeIfAbsent(comAssistKey, e -> new HashSet(8));
                    String tempValueNum = valueNumber.substring(1, valueNumber.length() - 1);
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)comAssistToValRangeIdTable.get((Object)comAssistKey, (Object)tempValueNum)))) {
                        allValueIdSet.addAll((Collection)comAssistToValRangeIdTable.get((Object)comAssistKey, (Object)tempValueNum));
                        continue;
                    }
                    allValueIdSet.add(-1L);
                }
                continue;
            }
            for (String valueNumber : valueNumberSet) {
                allValueIdSet = comAssistIdMap.computeIfAbsent(comAssistKey, e -> new HashSet(8));
                if (CollectionUtils.isNotEmpty((Collection)((Collection)comAssistToValueIdTable.get((Object)comAssistKey, (Object)valueNumber)))) {
                    allValueIdSet.addAll((Collection)comAssistToValueIdTable.get((Object)comAssistKey, (Object)valueNumber));
                    continue;
                }
                allValueIdSet.add(-1L);
            }
        }
        return comAssistIdMap;
    }

    private void setFormulaAmt(BuildAcctMapContext buildAcctMapContext, Map<String, Map<String, Object>> resultMap, ReClassNumberIDParam numberIDParam) {
        Map<String, Map<String, Object>> builMap = buildAcctMapContext.getResultMap();
        log.info(ResManager.loadKDString((String)"\u91cd\u5206\u7c7b\u5206\u6279\u53d6\u6570\u7ed3\u679c\uff1a", (String)"AcctBalParseAction_18", (String)"fi-gl-mservice", (Object[])new Object[0]) + builMap.toString());
        resultMap.putAll(builMap);
        Map<String, Map<String, Object>> errorInfoMap = numberIDParam.getErrorInfoMap();
        for (Map.Entry<String, Map<String, Object>> entry : errorInfoMap.entrySet()) {
            String acctKeyId = entry.getKey();
            Map acctValMap = resultMap.computeIfAbsent(acctKeyId, e -> new HashMap(128));
            acctValMap.putAll(entry.getValue());
        }
        log.info(ResManager.loadKDString((String)"\u91cd\u5206\u7c7b\u53d6\u6570\u5f02\u5e38\uff1a", (String)"AcctBalParseAction_21", (String)"fi-gl-mservice", (Object[])new Object[0]) + errorInfoMap.toString());
    }

    private void setErrorMessage(Map<String, Map<String, Object>> resultMap, int type, String errorMessage, String key) {
        HashMap<String, Object> map = new HashMap<String, Object>(32);
        map.put("v", ResManager.loadKDString((String)errorMessage, (String)"BCMBalanceParamParseUtils", (String)"AcctBalParseAction_7", (Object[])new Object[0]));
        map.put("type", type);
        resultMap.put(key, map);
    }

    private String checkBook(String bookStr, long acctOrgId, long bookTypeId) {
        String bookErrorMessage = "";
        String[] orgBookTypes = bookStr.split(",");
        String orgNumber = orgBookTypes[0];
        String bookNumber = "";
        if (orgBookTypes.length > 1) {
            bookNumber = orgBookTypes[1];
        }
        if (acctOrgId == 0L) {
            bookErrorMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u672a\u627e\u5230\u76f8\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"AcctBalParseAction_8", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNumber);
        } else if (bookTypeId == 0L) {
            bookErrorMessage = String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u201c%s\u201d\u672a\u627e\u5230\u76f8\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"AcctBalParseAction_9", (String)"fi-gl-mservice", (Object[])new Object[0]), bookNumber);
        }
        return bookErrorMessage;
    }

    private Map<String, Map<String, List<String>>> getBookStrSet(Map<String, Object> paramMap, String comBookTypeNumber, String comOrgNumber, List<String> scopePeriods, Map<String, Map<String, Object>> resultMap) {
        HashMap<String, Map<String, List<String>>> bookStrToFormulasMap = new HashMap<String, Map<String, List<String>>>(8);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String periodParam;
            String tmpBookTypeNumber;
            String key = entry.getKey();
            List paramFields = (List)entry.getValue();
            String tmpOrgNumber = (String)paramFields.get(0);
            if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                if (StringUtils.isBlank((CharSequence)comOrgNumber)) {
                    String tip = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ec4\u7ec7", (String)"AcctBalParseAction_403", (String)"fi-gl-mservice", (Object[])new Object[0]);
                    HashMap<String, String> tipMap = new HashMap<String, String>(64);
                    tipMap.put("v", tip);
                    tipMap.put("type", "-1");
                    resultMap.put(key, tipMap);
                    continue;
                }
                tmpOrgNumber = comOrgNumber;
            }
            if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                if (StringUtils.isBlank((CharSequence)comBookTypeNumber)) {
                    String tip = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8d26\u7c3f\u7c7b\u578b", (String)"AcctBalParseAction_404", (String)"fi-gl-mservice", (Object[])new Object[0]);
                    HashMap<String, String> tipMap = new HashMap<String, String>(64);
                    tipMap.put("v", tip);
                    tipMap.put("type", "-1");
                    resultMap.put(key, tipMap);
                    continue;
                }
                tmpBookTypeNumber = comBookTypeNumber;
            }
            if ((StringUtils.isBlank((CharSequence)(periodParam = AcctUtil.getPeriodParam((String)paramFields.get(5)))) || periodParam.equals("0")) && CollectionUtils.isNotEmpty(scopePeriods)) {
                periodParam = String.valueOf(scopePeriods.get(1));
            }
            String bookStr = tmpOrgNumber + "," + tmpBookTypeNumber + "," + (String)paramFields.get(4) + "," + periodParam;
            Map formulasMap = bookStrToFormulasMap.computeIfAbsent(bookStr, x -> new HashMap(64));
            formulasMap.put(key, paramFields);
        }
        return bookStrToFormulasMap;
    }

    private Map<String, Long> getMainBookType() {
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>(8);
        QFilter ftype = new QFilter("accounttype", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(ftype);
        DataSet bookTypeSet = ReClassUtils.queryDataSet("bd_accountbookstype", "id,number", filters);
        for (Row row : bookTypeSet) {
            long bookTypeId = row.getLong("id");
            String bookTypeNumber = row.getString("number");
            numberToIdMap.put(bookTypeNumber, bookTypeId);
        }
        return numberToIdMap;
    }
}

