/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.action;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.acct.buildparam.AssistIdCollectionType;
import kd.fi.gl.acct.buildparam.AssistWrap;
import kd.fi.gl.acct.combination.AssistCombination;
import kd.fi.gl.acct.combination.IBiz;
import kd.fi.gl.acct.context.AcctKeyObject;
import kd.fi.gl.acct.context.AssistKeyObject;
import kd.fi.gl.acct.param.BCMBalanceIndexParam;
import kd.fi.gl.acct.param.FormulaParam;
import kd.fi.gl.acct.param.ReClassNumberIDParam;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.GLUtil;

public class QueryTask {
    private long bookTypeId;
    private long startPeriodId;
    private long endPeriodId;
    private long accountTableId;
    private ReClassNumberIDParam param;
    private Set<String> allFlexs;
    private boolean isFilterByComAssist = true;
    private Table<AcctKeyObject, AssistKeyObject, Set<FormulaParam>> formulasTable;
    private Set<FormulaParam> allFormulas = new HashSet<FormulaParam>(8);
    private Set<Set<String>> valFlexsSet = new HashSet<Set<String>>(64);
    private Set<Long> orgIds = new HashSet<Long>(8);
    private Set<Long> currencyIds = new HashSet<Long>(8);
    private Set<String> acctNumbers = new HashSet<String>(128);
    private Set<Long> leafAcctIds = new HashSet<Long>(128);
    private Set<String> fetchTypes = new HashSet<String>(64);
    private Map<String, Set<Long>> comAssistIdMap = new HashMap<String, Set<Long>>(8);
    private Set<Map<String, Set<Long>>> allComAssistIdMapSet = new HashSet<Map<String, Set<Long>>>(8);
    private static final Log LOG = LogFactory.getLog(QueryTask.class);
    private static final String ACCTLOG = "ACCT GETBALANCE WATCH LOG -QueryTask-: ";

    public void clear() {
        if (this.formulasTable != null) {
            for (Table.Cell table : this.formulasTable.cellSet()) {
                ((Set)table.getValue()).clear();
            }
            this.formulasTable.clear();
            this.formulasTable = null;
        }
    }

    public QueryTask(long bookTypeId, long startPeriodId, long endPeriodId, long accountTableId, Table<AcctKeyObject, AssistKeyObject, Set<FormulaParam>> formulasTable, ReClassNumberIDParam param, Set<String> allFlexs) {
        this.bookTypeId = bookTypeId;
        this.startPeriodId = startPeriodId;
        this.endPeriodId = endPeriodId;
        this.accountTableId = accountTableId;
        this.formulasTable = formulasTable;
        this.param = param;
        this.allFlexs = allFlexs;
    }

    public long getBookTypeId() {
        return this.bookTypeId;
    }

    public void setBookTypeId(long bookTypeId) {
        this.bookTypeId = bookTypeId;
    }

    public long getStartPeriodId() {
        return this.startPeriodId;
    }

    public void setStartPeriodId(long startPeriodId) {
        this.startPeriodId = startPeriodId;
    }

    public long getEndPeriodId() {
        return this.endPeriodId;
    }

    public void setEndPeriodId(long endPeriodId) {
        this.endPeriodId = endPeriodId;
    }

    public long getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(long accountTableId) {
        this.accountTableId = accountTableId;
    }

    public Table<AcctKeyObject, AssistKeyObject, Set<FormulaParam>> getMap() {
        return this.formulasTable;
    }

    public void setMap(Table<AcctKeyObject, AssistKeyObject, Set<FormulaParam>> table) {
        this.formulasTable = table;
    }

    public void addOrgIds(long orgId) {
        this.orgIds.add(orgId);
    }

    public void addCurrencyIds(long currencyId) {
        this.currencyIds.add(currencyId);
    }

    public void addAcctNumbers(Set<String> acctNumbers) {
        this.acctNumbers.addAll(acctNumbers);
    }

    public void addLeafAcctIds(Set<Long> leafAccts) {
        this.leafAcctIds.addAll(leafAccts);
    }

    public void addFetchTypes(String fetchType) {
        this.fetchTypes.add(fetchType);
    }

    public void addValFlexsSet(Set<Set<String>> valFlexsSet) {
        this.valFlexsSet.addAll(valFlexsSet);
    }

    public void addComAssistIdMap(Map<String, Set<Long>> comAssistIdMap) {
        if (Objects.isNull(comAssistIdMap) || comAssistIdMap.isEmpty()) {
            this.isFilterByComAssist = false;
        } else {
            this.allComAssistIdMapSet.add(comAssistIdMap);
        }
    }

    public void execute() {
        PerformanceWatch watch = new PerformanceWatch(QueryTask.class, "execute", false);
        watch.start("ACCT GETBALANCE WATCH LOG -QueryTask-: orgIds+bookTypeId " + this.orgIds + this.bookTypeId + " execute queryBalance ");
        boolean isBaseCurrency = this.currencyIds == null || this.currencyIds.iterator().next() == 0L;
        boolean isExistCollectionType = AssistIdCollectionType.isExistCollectionType();
        try (DataSet ds = this.queryBalance(isBaseCurrency);){
            if (DebugTrace.enable()) {
                this.printFormulaTable(this.formulasTable);
            }
            watch.stop();
            watch.start("ACCT GETBALANCE WATCH LOG -QueryTask-: orgIds+bookTypeId " + this.orgIds + this.bookTypeId + " execute queryBalance match balance valFlexsSet size " + this.valFlexsSet.size());
            for (Row row : ds) {
                String acctNum = row.getString("account");
                for (Set<String> assistSet : this.valFlexsSet) {
                    HashMap<String, Object> assgrpMap = new HashMap<String, Object>(assistSet.size());
                    for (String flex : assistSet) {
                        assgrpMap.put(flex, row.get(flex));
                    }
                    AcctKeyObject key = this.buildKeyByRow(row, assgrpMap, isBaseCurrency);
                    Map comAssistKeyToFormulaMap = this.formulasTable.row((Object)key);
                    Set<AssistKeyObject> assistKeySet = this.buildComAssistKey(row, acctNum);
                    HashSet legalFormulaSet = new HashSet(8);
                    if (Objects.nonNull(comAssistKeyToFormulaMap)) {
                        for (AssistKeyObject comAssistKey : assistKeySet) {
                            Set ps = (Set)comAssistKeyToFormulaMap.get(comAssistKey);
                            if (!CollectionUtils.isNotEmpty((Collection)ps)) continue;
                            legalFormulaSet.addAll(ps);
                        }
                    }
                    for (FormulaParam formula : legalFormulaSet) {
                        formula.addValue(row);
                    }
                    if (!isExistCollectionType) continue;
                    this.collectTypeSum(assgrpMap, row, isBaseCurrency, assistKeySet);
                }
            }
        }
        watch.stop();
        LOG.info(watch.show());
    }

    private void collectTypeSum(Map<String, Object> assgrpMap, Row row, boolean isBaseCurrency, Set<AssistKeyObject> assistKeySet) {
        HashMap assgrpCollectionTypeMap = new HashMap(assgrpMap.size());
        for (Map.Entry<String, Object> assistTypeIdEntry : assgrpMap.entrySet()) {
            Set<AssistIdCollectionType> collectionTypes;
            String flex = assistTypeIdEntry.getKey();
            Long value = (Long)assistTypeIdEntry.getValue();
            if (value == null || (collectionTypes = AssistIdCollectionType.findByAssistTypeAndId(flex, value)).isEmpty()) break;
            assgrpCollectionTypeMap.put(flex, collectionTypes);
        }
        if (assgrpCollectionTypeMap.size() == assgrpMap.size()) {
            final ArrayList candidates = new ArrayList(1);
            AssistCombination.parts(assgrpCollectionTypeMap, new IBiz(){

                public void deal(Map params) {
                    candidates.add(params);
                }
            });
            for (Map assistMap : candidates) {
                AcctKeyObject assistKey = this.buildKeyByRow(row, assistMap, isBaseCurrency);
                for (AssistKeyObject comAssistKey : assistKeySet) {
                    Set ps = (Set)this.formulasTable.get((Object)assistKey, (Object)comAssistKey);
                    if (CollectionUtils.isEmpty((Collection)ps)) continue;
                    for (FormulaParam p : ps) {
                        p.addValue(row);
                    }
                }
            }
        }
    }

    private Set<AssistKeyObject> buildComAssistKey(Row row, String acctNumber) {
        HashSet<AssistKeyObject> assistKeySet = new HashSet<AssistKeyObject>(8);
        HashSet<Map<String, Object>> comAssistKeySet = new HashSet<Map<String, Object>>(8);
        HashMap<String, Long> comAssistKeyToIdMap = new HashMap<String, Long>(8);
        for (String string : this.comAssistIdMap.keySet()) {
            long comAssistValueId = row.getLong(string);
            comAssistKeyToIdMap.put(string, comAssistValueId);
        }
        for (int i = 0; i <= comAssistKeyToIdMap.size(); ++i) {
            this.combinationSelect(comAssistKeyToIdMap, i, comAssistKeySet);
        }
        for (Map map : comAssistKeySet) {
            AssistKeyObject assistKey = AssistKeyObject.retrievalFromCacheOrBuild(acctNumber, map);
            assistKeySet.add(assistKey);
        }
        return assistKeySet;
    }

    private AcctKeyObject buildKeyByRow(Row row, Map<String, ? extends Object> assgrpMap, boolean isBaseCurrency) {
        AssistWrap assistWrap = AssistWrap.retrievalAssistWrapFromCacheOrBuild(assgrpMap);
        long currencyId = isBaseCurrency ? 0L : row.getLong("currency");
        AcctKeyObject key = AcctKeyObject.retrievalFromCacheOrBuild(currencyId, assistWrap);
        return key;
    }

    private DataSet queryBalance(boolean isBaseCurrency) {
        String fetchField = this.fetchTypes.iterator().next();
        boolean isSubPL = BCMBalanceIndexParam.getSubPlFetchType().contains(fetchField);
        HashSet<String> sumFileds = new HashSet<String>();
        Map<String, List<String>> fetchjtypeFieldMap = BCMBalanceIndexParam.getFetchTypeField();
        if (!isBaseCurrency) {
            fetchjtypeFieldMap = BCMBalanceIndexParam.getFetchTypeForField();
        }
        for (String fetchType : this.fetchTypes) {
            List<String> filedList = fetchjtypeFieldMap.get(fetchType);
            if (filedList == null) continue;
            sumFileds.addAll(filedList);
        }
        QueryParam queryParam = new QueryParam();
        queryParam.setSpecialAccount(false);
        queryParam.setSubstractPL(isSubPL);
        if (this.acctNumbers != null && !this.acctNumbers.isEmpty()) {
            this.dealLeafAcctNumbers();
            queryParam.setOnlyLeafAcctBal(false);
            queryParam.setAccountFilter(new QFilter("number", "in", this.acctNumbers));
        }
        if (!isBaseCurrency) {
            queryParam.setCurrencyIds(this.currencyIds.toArray(new Long[0]));
        }
        this.initAllComAssistValueId();
        if (this.isFilterByComAssist) {
            List<QFilter> comAssistFilterList = this.buildComAssistFilters();
            if (queryParam.getCustomFilter() == null) {
                queryParam.setCustomFilter(comAssistFilterList);
            } else {
                queryParam.getCustomFilter().addAll(comAssistFilterList);
            }
        }
        boolean isReclass = BCMBalanceIndexParam.getFetchTypeReclass().contains(fetchField);
        HashSet<String> balFields = new HashSet<String>();
        balFields.add("org");
        if (!isBaseCurrency) {
            balFields.add("currency");
        }
        balFields.add("account.number account");
        if (isReclass || this.allFlexs.size() > 0) {
            balFields.add("assgrp hg");
        }
        balFields.addAll(sumFileds);
        balFields.addAll(this.comAssistIdMap.keySet());
        String selFields = ((Object)balFields).toString();
        selFields = selFields.substring(1, selFields.length() - 1);
        if (DebugTrace.enable()) {
            LOG.info("QueryTask_queryBalance : selFields = " + selFields);
            LOG.info("QueryTask_queryBalance : queryParam = " + queryParam);
        }
        PerformanceWatch watch = new PerformanceWatch(QueryTask.class, "queryBalance", false);
        watch.start("ACCT GETBALANCE WATCH LOG -QueryTask-: orgIds+bookTypeId " + this.orgIds + this.bookTypeId + " BalanceQueryExecutor.getInstance ");
        DataSet balSet = BalanceQueryExecutor.getInstance().getBalance(selFields, this.orgIds.toArray(new Long[0]), this.bookTypeId, this.accountTableId, this.startPeriodId, this.endPeriodId, queryParam);
        watch.stop();
        watch.start("ACCT GETBALANCE WATCH LOG -QueryTask-: orgIds+bookTypeId " + this.orgIds + this.bookTypeId + " balJoinAssist accountTableId " + this.accountTableId);
        balSet = this.balJoinAssist(balSet, sumFileds, isReclass);
        if (DebugTrace.enable()) {
            LOG.info("ACCT GETBALANCE WATCH LOG -QueryTask-: QueryTask_queryBalance : balSet = " + DataSetHelper.printDataSet((DataSet)balSet));
        }
        watch.stop();
        LOG.info(watch.show());
        return balSet;
    }

    private void dealLeafAcctNumbers() {
        if (!this.allFlexs.isEmpty()) {
            Set<String> allAcctNumbers = this.getAcctMumbersByFlexFields();
            this.acctNumbers.clear();
            this.acctNumbers.addAll(allAcctNumbers);
        }
    }

    private DataSet balJoinAssist(DataSet balSet, Set<String> sumFileds, boolean isReclass) {
        PerformanceWatch watch = new PerformanceWatch(QueryTask.class, "balJoinAssist", false);
        HashSet<String> flexFields = new HashSet<String>();
        for (String flex : this.allFlexs) {
            if (null == this.param.getFlexToIDHgSet().get(flex)) {
                balSet = balSet.filter("1!=1");
                break;
            }
            watch.start("ACCT GETBALANCE WATCH LOG -QueryTask-: orgIds+bookTypeId " + this.orgIds + this.bookTypeId + " balJoinAssist flex " + flex);
            DataSet assistSet = this.param.getFlexToIDHgSet().get(flex).copy();
            List balFields = GLUtil.getDataSetCols((DataSet)balSet);
            flexFields.add(flex);
            List assistList = GLUtil.getDataSetCols((DataSet)assistSet);
            assistList.remove("hg");
            if (DebugTrace.enable()) {
                LOG.info(String.format("%s QueryTask_queryBalance : balSet = %s", ACCTLOG, DataSetHelper.printDataSet((DataSet)balSet)));
                LOG.info(String.format("%s QueryTask_queryBalance : assistSet = %s", ACCTLOG, DataSetHelper.printDataSet((DataSet)assistSet)));
            }
            balSet = balSet.join(assistSet, JoinType.LEFT).on("hg", "hg").select(balFields.toArray(new String[0]), assistList.toArray(new String[0])).finish();
            watch.stop();
        }
        if (isReclass && !flexFields.isEmpty()) {
            watch.start("ACCT GETBALANCE WATCH LOG -QueryTask-: orgIds+bookTypeId " + this.orgIds + this.bookTypeId + " balJoinAssist isReclass groupBy ");
            List balFields = GLUtil.getDataSetCols((DataSet)balSet);
            balFields.removeAll(sumFileds);
            balFields.remove("hg");
            GroupbyDataSet gDataSet = balSet.groupBy(balFields.toArray(new String[0]));
            for (String sumField : sumFileds) {
                gDataSet.sum(sumField);
            }
            balSet = gDataSet.finish();
            watch.stop();
        }
        LOG.info(watch.show());
        return balSet;
    }

    public Set<String> getAcctMumbersByFlexFields() {
        if (this.leafAcctIds.isEmpty()) {
            return new HashSet<String>();
        }
        DynamicObjectCollection acttypeColl = QueryServiceHelper.query((String)"bd_asstacttype", (String)"id,flexfield", (QFilter[])new QFilter("flexfield", "in", this.allFlexs).toArray());
        HashMap<String, Long> typeMap = new HashMap<String, Long>();
        for (DynamicObject acttype : acttypeColl) {
            typeMap.put(acttype.getString("flexfield"), acttype.getLong("id"));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fnumber from T_BD_Account a ");
        StringBuffer where = new StringBuffer();
        where.append(" WHERE a.faccounttableid = ? ");
        ArrayList<Long> sp = new ArrayList<Long>(this.allFlexs.size());
        sp.add(this.accountTableId);
        where.append(" AND a.fid in (");
        for (Long acctId : this.leafAcctIds) {
            where.append("?,");
            sp.add(acctId);
        }
        where = where.deleteCharAt(where.length() - 1);
        where.append(')');
        HashSet<String> acctNumbers = new HashSet<String>(32);
        int i = 1;
        for (String s : this.allFlexs) {
            sql.append(" INNER JOIN T_BD_AccountAsstActItem a").append(i).append(" ON a.fid=a").append(i).append(".fid");
            where.append(" and a").append(i).append(".fasstactitemid = ? ");
            sp.add((Long)typeMap.get(s));
            ++i;
        }
        try (DataSet dataSet = DB.queryDataSet((String)"getAcctMumbersByFlexFields", (DBRoute)DBRoute.of((String)"gl"), (String)sql.append(where).toString(), (Object[])sp.toArray());){
            while (dataSet.hasNext()) {
                acctNumbers.add(dataSet.next().getString("fnumber"));
            }
        }
        return acctNumbers;
    }

    private List<QFilter> buildComAssistFilters() {
        ArrayList<QFilter> comAssistFilterList = new ArrayList<QFilter>(8);
        for (Map.Entry<String, Set<Long>> comAssistIdEntry : this.comAssistIdMap.entrySet()) {
            String comAssistKey = comAssistIdEntry.getKey();
            Set<Long> comAssistIdSet = comAssistIdEntry.getValue();
            if (!CollectionUtils.isNotEmpty(comAssistIdSet)) continue;
            comAssistFilterList.add(new QFilter(comAssistKey, "in", comAssistIdSet));
        }
        return comAssistFilterList;
    }

    private void combinationSelect(Map<String, Long> dataMap, int n, Set<Map<String, Object>> resultMap) {
        String[] comAssistKeys = dataMap.keySet().toArray(new String[0]);
        this.combinationSelect(dataMap, comAssistKeys, n, 0, new HashMap<String, Object>(n), resultMap);
    }

    private void combinationSelect(Map<String, Long> dataMap, String[] keys, int resultLen, int dataIndex, Map<String, Object> tempResultMap, Set<Map<String, Object>> resultMap) {
        int resultCount = tempResultMap.size() + 1;
        if (resultCount > resultLen) {
            resultMap.add(new HashMap<String, Object>(tempResultMap));
            return;
        }
        for (int i = dataIndex; i < keys.length + resultCount - resultLen; ++i) {
            tempResultMap.put(keys[i], dataMap.get(keys[i]));
            this.combinationSelect(dataMap, keys, resultLen, i + 1, tempResultMap, resultMap);
            tempResultMap.remove(keys[i]);
        }
    }

    private void printFormulaTable(Table<AcctKeyObject, AssistKeyObject, Set<FormulaParam>> formulasTable) {
        HashBasedTable formulaLogTable = HashBasedTable.create();
        for (Table.Cell formulasCell : formulasTable.cellSet()) {
            AcctKeyObject rowKey = (AcctKeyObject)formulasCell.getRowKey();
            AssistKeyObject columnKey = (AssistKeyObject)formulasCell.getColumnKey();
            List values = ((Set)formulasCell.getValue()).stream().map(FormulaParam::getKey).collect(Collectors.toList());
            formulaLogTable.put((Object)rowKey, (Object)columnKey, values);
        }
        LOG.info("QueryTask_printFormulaTable formulasTable : " + formulaLogTable);
    }

    private void initAllComAssistValueId() {
        HashSet<String> allComAssistKeySet = new HashSet<String>(8);
        for (Map<String, Set<Long>> comAssistIdMap : this.allComAssistIdMapSet) {
            allComAssistKeySet.addAll(comAssistIdMap.keySet());
        }
        for (Map<String, Set<Long>> comAssistIdMap : this.allComAssistIdMapSet) {
            for (String comAssistKey : allComAssistKeySet) {
                Set<Long> allComAssistValueIdSet = this.comAssistIdMap.get(comAssistKey);
                Set comAssistValueIdSet = comAssistIdMap.getOrDefault(comAssistKey, new HashSet(8));
                if (allComAssistValueIdSet == null) {
                    this.comAssistIdMap.put(comAssistKey, comAssistValueIdSet);
                    continue;
                }
                if (!allComAssistValueIdSet.isEmpty() && !comAssistValueIdSet.isEmpty()) {
                    allComAssistValueIdSet.addAll(comAssistValueIdSet);
                    continue;
                }
                this.comAssistIdMap.put(comAssistKey, Collections.EMPTY_SET);
            }
        }
    }

    public Set<FormulaParam> getAllFormulas() {
        return this.allFormulas;
    }

    public void setAllFormulas(Set<FormulaParam> allFormulas) {
        this.allFormulas = allFormulas;
    }
}

