/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.buildparam;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.acct.buildparam.AssistWrap;
import kd.fi.gl.acct.buildparam.BuildParamMapContext;
import kd.fi.gl.acct.combination.AssistCombination;
import kd.fi.gl.acct.combination.IBiz;
import kd.fi.gl.exception.GLErrorCode;

public class CombinationAssistMap {
    private static final Log log = LogFactory.getLog(CombinationAssistMap.class);

    public static void action(final BuildParamMapContext ctx) {
        Map<String, Set<Object>> assistToAcctMapEntry = ctx.getAssistToAcctMapEntry();
        if (null == assistToAcctMapEntry) {
            return;
        }
        HashMap singleAssistMapSet = new HashMap(assistToAcctMapEntry.size());
        for (Map.Entry<String, Set<Object>> assistEtnry : assistToAcctMapEntry.entrySet()) {
            String flex = assistEtnry.getKey();
            Set singleAssistSet = singleAssistMapSet.computeIfAbsent(flex, p -> new HashSet(10));
            Set<Object> vals = assistEtnry.getValue();
            if (null == vals) {
                throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u7ef4\u5ea6\u503c\u7f16\u7801\u9519\u8bef", (String)"CombinationAssistMap_0", (String)"fi-gl-mservice", (Object[])new Object[0])});
            }
            for (Object object : vals) {
                if (object instanceof Collection) {
                    Collection c = (Collection)object;
                    singleAssistSet.addAll(c);
                    continue;
                }
                singleAssistSet.add(object);
            }
            singleAssistMapSet.put(flex, singleAssistSet);
        }
        if (null == singleAssistMapSet || singleAssistMapSet.size() == 0) {
            return;
        }
        AssistCombination.parts(singleAssistMapSet, new IBiz(){

            public void deal(Map params) {
                ctx.getSingleAssistMapCol().add(AssistWrap.retrievalAssistWrapFromCacheOrBuild(params));
            }
        });
        if (DebugTrace.enable()) {
            log.info("acctdebug CombinationAssistMap.parts from {} generates {} params.", (Object)SerializationUtils.toJsonString(singleAssistMapSet.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> null == e.getValue() ? 0 : ((Set)e.getValue()).size()))), (Object)ctx.getSingleAssistMapCol().size());
        }
    }
}

