/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.param;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.gl.acct.handle.MakeBaseDateDetailHelper;
import kd.fi.gl.util.ReClassUtils;

public class AcctPropertyParam {
    private static final Log log = LogFactory.getLog(AcctPropertyParam.class);
    private Map<String, Set<String>> entityPropertyMap = new HashMap<String, Set<String>>(16);
    private Map<String, Set<String>> assistFieldToNumbersMap = new HashMap<String, Set<String>>(16);
    private Map<String, Set<Long>> assistToValIdMap = new HashMap<String, Set<Long>>(16);
    private Map<String, Set<Long>> assistFieldValToIdMap = new HashMap<String, Set<Long>>(16);
    private Map<String, Set<String>> assistToFiledMap = new HashMap<String, Set<String>>(16);
    private Map<String, Set<String>> assistToFiledGroupMap = new HashMap<String, Set<String>>(8);
    private Map<String, String> assistNnumberToEntityMap = new HashMap<String, String>(16);
    private Map<String, Long> numberToDetailGroupMap = new HashMap<String, Long>(16);
    private Map<String, Set<String>> assistFieldToPropertyValMap = new HashMap<String, Set<String>>(16);
    private Map<String, String> assistFiledToBasDataMap = new HashMap<String, String>(16);
    private Map<String, Map<String, Set<Long>>> entityPropertyValMap = new HashMap<String, Map<String, Set<Long>>>(16);
    private Set<Long> assistDataGroupIdSet = new HashSet<Long>(16);
    private Long orgId = 0L;
    private static final String ASSIST_FIELD_DATA = "bos_assistantdata_detail";
    private Map<String, Object> assistNumToIdsMap = new HashMap<String, Object>(16);
    private Map<String, Set<String>> filedMap = new HashMap<String, Set<String>>(8);
    private Map<String, Boolean> hasParent = new HashMap<String, Boolean>(8);
    private static final List<String> groupEntityList = new ArrayList<String>(){
        {
            this.add("bd_customergroup");
            this.add("bd_suppliergroup");
            this.add("bd_materialgroup");
        }
    };
    private String PRESET_LOG = "Acct_AcctPropertyParam_";
    private String fIdField = "fid";
    private String idField = "id";

    public AcctPropertyParam(Map<String, Set<String>> assistToFiledMap, Map<String, String> assistNnumberToEntityMap, Map<String, Set<String>> assistFieldToPropertyValMap, Long orgId, Map<String, Long> numberToDetailGroupMap) {
        if (DebugTrace.enable()) {
            log.info(this.PRESET_LOG + "assistToFiledMap : " + DebugTraceHelper.toString(assistToFiledMap) + "====== assistFieldToPropertyValMap\uff1a " + DebugTraceHelper.toString(assistFieldToPropertyValMap) + " ##### orgId= " + orgId);
        }
        this.orgId = orgId;
        this.assistToFiledMap = assistToFiledMap;
        this.assistNnumberToEntityMap = assistNnumberToEntityMap;
        this.assistFieldToPropertyValMap = assistFieldToPropertyValMap;
        this.numberToDetailGroupMap = numberToDetailGroupMap;
        this.entityPropertyMap = this.queryRelateBaseDataType();
        this.entityPropertyValMap = this.initEntityPropertyVal();
        this.packageAssistFieldProperty();
    }

    private void packageAssistFieldProperty() {
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, String> assistNnumberToEntity : this.assistNnumberToEntityMap.entrySet()) {
            String assistNumber = assistNnumberToEntity.getKey();
            String valueSource = assistNnumberToEntity.getValue();
            if (ReClassUtils.hasMasteridProp(valueSource)) {
                this.fIdField = "fmasterid";
                this.idField = "masterid";
            } else {
                this.fIdField = "fid";
                this.idField = "id";
            }
            this.dealGroupData(assistNumber, valueSource);
            Set<String> fieldsSet = this.assistToFiledMap.get(assistNumber);
            if (null == fieldsSet || fieldsSet.isEmpty()) continue;
            ArrayList<String> assistFields = new ArrayList<String>(fieldsSet);
            QFilter qFilter = this.getQFilter(valueSource, assistNumber);
            if (DebugTrace.enable()) {
                log.info(this.PRESET_LOG + "AcctPropertyParam_qFilter : " + DebugTraceHelper.toString((Object)qFilter));
            }
            if (assistFields.isEmpty()) continue;
            long startQueryTime = System.currentTimeMillis();
            StringBuilder fieldBuilder = new StringBuilder();
            fieldBuilder.append(this.idField).append(",number");
            for (String assistField : assistFields) {
                fieldBuilder.append(",").append(assistField);
            }
            Map assistValues = new HashMap(8);
            assistValues = qFilter == null ? BusinessDataServiceHelper.loadFromCache((String)valueSource, (String)fieldBuilder.toString(), null) : BusinessDataServiceHelper.loadFromCache((String)valueSource, (String)fieldBuilder.toString(), (QFilter[])new QFilter[]{qFilter});
            if (DebugTrace.enable()) {
                log.info(this.PRESET_LOG + valueSource + " query data takes time : " + (System.currentTimeMillis() - startQueryTime));
                log.info(this.PRESET_LOG + "assistValues\uff1a " + assistValues.size());
            }
            this.tabulateData(assistNumber, assistFields, assistValues);
        }
        if (DebugTrace.enable()) {
            log.info(this.PRESET_LOG + "package_data_takes_time : " + (System.currentTimeMillis() - startTime));
            log.info(this.PRESET_LOG + "assistFieldToPropertyValMap : " + DebugTraceHelper.toString(this.assistFieldToPropertyValMap));
            log.info(this.PRESET_LOG + "assistFieldToNumbersMap : " + DebugTraceHelper.toString(this.assistFieldToNumbersMap));
            log.info(this.PRESET_LOG + "assistFieldValToIdMap : " + DebugTraceHelper.toString(this.assistFieldValToIdMap));
            log.info(this.PRESET_LOG + "assistNumToIdsMap : " + DebugTraceHelper.toString(this.assistNumToIdsMap));
        }
    }

    private void dealGroupData(String assistNumber, String valueSource) {
        Set<String> fieldSet = this.assistToFiledGroupMap.get(assistNumber);
        if (null != fieldSet) {
            ArrayList fileds = new ArrayList(this.assistToFiledGroupMap.get(assistNumber));
            for (String filed : fileds) {
                String baseDataEntityId = this.assistFiledToBasDataMap.get(AcctPropertyParam.buildKey(new Object[]{assistNumber, filed}));
                Map<String, Set<Long>> fieldNumToDetailValMap = this.entityPropertyValMap.get(baseDataEntityId);
                SqlBuilder sqlBuilder = new SqlBuilder();
                String groupTable = "t_" + baseDataEntityId;
                String uTable = "t_" + valueSource + "_u";
                HashSet<Long> groupIds = new HashSet<Long>();
                fieldNumToDetailValMap.values().forEach(x -> groupIds.addAll((Collection<Long>)x));
                if (groupIds.isEmpty()) continue;
                switch (valueSource) {
                    case "bd_customer": {
                        sqlBuilder = this.buildSql(groupIds, uTable, "t_bd_customer", "t_bd_customergroupdetail", "b.fcustomerid");
                        break;
                    }
                    case "bd_supplier": {
                        sqlBuilder = this.buildSql(groupIds, uTable, "t_bd_supplier", "t_bd_suppliergroupdetail", "b.fsupplierid");
                        break;
                    }
                    case "bd_material": {
                        sqlBuilder = this.buildSql(groupIds, uTable, "t_bd_material", "t_bd_materialgroupdetail", "b.fmaterialid");
                    }
                }
                DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);
                for (Row row : dataSet) {
                    for (String field : fileds) {
                        Set<String> propertyValNumSet = this.assistFieldToPropertyValMap.get(AcctPropertyParam.buildKey(new Object[]{assistNumber, field}));
                        for (String propertyValNum : propertyValNumSet) {
                            Set<Long> propertyVals = fieldNumToDetailValMap.get(propertyValNum);
                            if (null == propertyVals || !propertyVals.contains(row.getLong("fgroupid"))) continue;
                            String assistFieldVal = AcctPropertyParam.buildKey(new Object[]{assistNumber, field, propertyValNum});
                            this.assistFieldValToIdMap.computeIfAbsent(assistFieldVal, k -> new HashSet(16)).add(row.getLong(this.fIdField));
                            this.assistFieldToNumbersMap.computeIfAbsent(assistNumber, k -> new HashSet(16)).add(row.getString("number"));
                            this.assistToValIdMap.computeIfAbsent(assistNumber, k -> new HashSet(16)).add(row.getLong(this.fIdField));
                            this.assistNumToIdsMap.put(AcctPropertyParam.buildKey(new Object[]{assistNumber, row.getString("number")}), row.getLong(this.fIdField));
                        }
                    }
                }
            }
        }
    }

    private SqlBuilder buildSql(Set<Long> groupIds, String uTable, String mainTable, String subTable, String joinField) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fnumber as number ,b.fgroupid,", new Object[0]).append(this.fIdField, new Object[0]).append(" from ", new Object[0]).append(mainTable, new Object[0]);
        sqlBuilder.append(" a inner join ", new Object[0]).append(subTable, new Object[0]).append(" b on a.fid = ", new Object[0]).append(joinField, new Object[0]).append(" where ", new Object[0]);
        sqlBuilder.appendIn(" b.fgroupid ", new ArrayList<Long>(groupIds)).append(" and ( a.fid in (", new Object[0]);
        sqlBuilder.append(" select fdataid from ", new Object[0]).append(uTable, new Object[0]).append(" where ", new Object[0]);
        sqlBuilder.append(" fuseorgid = ? ", new Object[]{this.orgId}).append(") or a.fctrlstrategy = '5' and a.fstatus = 'C') ", new Object[0]);
        return sqlBuilder;
    }

    private void tabulateData(String assistNumber, List<String> assistFields, Map<Object, DynamicObject> assistValues) {
        for (Map.Entry<Object, DynamicObject> assistValueEntry : assistValues.entrySet()) {
            DynamicObject assistValue = assistValueEntry.getValue();
            for (String assistField : assistFields) {
                String baseEntityId = this.assistFiledToBasDataMap.get(assistNumber + "*" + assistField);
                Map<String, Set<Long>> detailAssistValMap = this.entityPropertyValMap.get(baseEntityId);
                String assistAndField = AcctPropertyParam.buildKey(new Object[]{assistNumber, assistField});
                Set<String> propertyValNumSet = this.assistFieldToPropertyValMap.get(assistAndField);
                for (String propertyValNum : propertyValNumSet) {
                    if (null == detailAssistValMap || !detailAssistValMap.containsKey(propertyValNum)) continue;
                    Set<Long> propertyVals = detailAssistValMap.get(propertyValNum);
                    if (null == assistValue.get(assistField) && this.checkField(assistValue, assistField).booleanValue()) {
                        String[] entryFields = assistField.replaceAll("\\.", "\\,").split(",");
                        String entity = entryFields[0];
                        DynamicObjectCollection entries = assistValue.getDynamicObjectCollection(entity);
                        for (DynamicObject entry : entries) {
                            DynamicObject fieldDy = entry.getDynamicObject(entryFields[1]);
                            this.tabulateAssist(assistNumber, assistValue, assistField, propertyValNum, propertyVals, fieldDy);
                        }
                        continue;
                    }
                    DynamicObject fieldDy = assistValue.getDynamicObject(assistField);
                    this.tabulateAssist(assistNumber, assistValue, assistField, propertyValNum, propertyVals, fieldDy);
                }
            }
        }
    }

    private Boolean checkField(DynamicObject assistValue, String assistField) {
        DataEntityPropertyCollection queryProperties = assistValue.getDataEntityType().getProperties();
        for (IDataEntityProperty queryProperty : queryProperties) {
            if (!assistField.startsWith(queryProperty.getName()) || !(queryProperty instanceof EntryProp)) continue;
            return true;
        }
        return false;
    }

    private void tabulateAssist(String assistNumber, DynamicObject assistValue, String assistField, String propertyValNum, Set<Long> propertyVals, DynamicObject fieldDy) {
        if (null != fieldDy) {
            String fieldKey = "id";
            if (ReClassUtils.hasMasteridProp(fieldDy.getDataEntityType().getName())) {
                fieldKey = "masterid";
            }
            if (propertyVals.contains(fieldDy.getLong(fieldKey))) {
                log.info(this.PRESET_LOG + "current_assist \uff1a " + fieldDy.getPkValue());
                String assistFieldVal = AcctPropertyParam.buildKey(new Object[]{assistNumber, assistField, propertyValNum});
                this.assistFieldValToIdMap.computeIfAbsent(assistFieldVal, k -> new HashSet(16)).add(assistValue.getLong(this.idField));
                this.assistFieldToNumbersMap.computeIfAbsent(assistNumber, k -> new HashSet(16)).add(assistValue.getString("number"));
                this.assistToValIdMap.computeIfAbsent(assistNumber, k -> new HashSet(16)).add(assistValue.getLong(this.idField));
                this.assistNumToIdsMap.put(AcctPropertyParam.buildKey(new Object[]{assistNumber, assistValue.getString("number")}), assistValue.getLong(this.idField));
            }
        }
    }

    private QFilter getQFilter(String valueSource, String assistNumber) {
        QFilter qFilter = null;
        if (this.assistFiledToBasDataMap.isEmpty() || this.entityPropertyValMap.isEmpty()) {
            return qFilter;
        }
        if (this.orgId != 0L && null != valueSource) {
            qFilter = BaseDataServiceHelper.getBaseDataFilter((String)valueSource, (Long)this.orgId);
        }
        if (ASSIST_FIELD_DATA.equalsIgnoreCase(valueSource)) {
            qFilter = qFilter == null ? new QFilter("group", "=", (Object)this.numberToDetailGroupMap.get(assistNumber)) : qFilter.and("group", "=", (Object)this.numberToDetailGroupMap.get(assistNumber));
        }
        return qFilter;
    }

    private Map<String, Map<String, Set<Long>>> initEntityPropertyVal() {
        HashMap<String, Map<String, Set<Long>>> entityPropertyValMap = new HashMap<String, Map<String, Set<Long>>>(16);
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, Set<String>> entry : this.entityPropertyMap.entrySet()) {
            String baseEntityId = entry.getKey();
            Set<String> properties = entry.getValue();
            filters.clear();
            QFilter fbasedata = null;
            if (this.orgId != 0L && baseEntityId != null && (fbasedata = BaseDataServiceHelper.getBaseDataFilter((String)baseEntityId, (Long)this.orgId)) != null) {
                filters.add(fbasedata);
            }
            if (ASSIST_FIELD_DATA.equalsIgnoreCase(baseEntityId)) {
                filters.add(new QFilter("group", "in", this.assistDataGroupIdSet));
            }
            if (this.hasParent.get(baseEntityId).booleanValue()) {
                Map<String, Set<Long>> detailProperties = detailHelper.getDetailAssists(baseEntityId, properties, filters);
                entityPropertyValMap.put(baseEntityId, detailProperties);
                continue;
            }
            if (null != properties && !properties.isEmpty()) {
                filters.add(new QFilter("number", "in", properties));
            }
            HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
            DataSet querySet = ReClassUtils.queryDataSet(baseEntityId, "number, id", filters);
            for (Row row : querySet) {
                numberToIdMap.put(row.getString("number"), row.getLong("id"));
            }
            HashMap<String, Set> numberToIdsMap = new HashMap<String, Set>(8);
            for (Map.Entry mapEnrty : numberToIdMap.entrySet()) {
                numberToIdsMap.computeIfAbsent((String)mapEnrty.getKey(), v -> new HashSet(8)).add(mapEnrty.getValue());
            }
            entityPropertyValMap.put(baseEntityId, numberToIdsMap);
        }
        if (DebugTrace.enable()) {
            log.info(this.PRESET_LOG + "Query_detailAsstists_takes_time : " + (System.currentTimeMillis() - startTime));
            log.info(this.PRESET_LOG + "entityPropertyValMap :" + DebugTraceHelper.toString(entityPropertyValMap));
        }
        return entityPropertyValMap;
    }

    private Map<String, Set<String>> queryRelateBaseDataType() {
        HashMap<String, Set<String>> entityPropertyMap = new HashMap<String, Set<String>>(16);
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, String> valueEntry : this.assistNnumberToEntityMap.entrySet()) {
            String assistNumber = valueEntry.getKey();
            if (!this.assistToFiledMap.containsKey(assistNumber)) continue;
            String valueSource = valueEntry.getValue();
            MainEntityType assistEntity = EntityMetadataCache.getDataEntityType((String)valueSource);
            Set<String> selectedFieldSet = this.assistToFiledMap.get(assistNumber);
            ArrayList<String> fields = new ArrayList<String>(selectedFieldSet);
            for (int i = 0; i < fields.size(); ++i) {
                String documentField = (String)fields.get(i);
                DynamicProperty property = assistEntity.getProperty(documentField);
                if (null == property) {
                    this.dealRefProperty(entityPropertyMap, assistNumber, valueSource, assistEntity, documentField, property);
                    continue;
                }
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                if (property instanceof BasedataProp) {
                    this.getBaseDataEntity(entityPropertyMap, assistNumber, valueSource, documentField, property, baseEntityId);
                }
                this.hasParent.put(baseEntityId, this.checkHasParent(baseEntityId));
            }
        }
        if (DebugTrace.enable()) {
            log.info(this.PRESET_LOG + "takes_time : " + (System.currentTimeMillis() - startTime));
            log.info(this.PRESET_LOG + "entityPropertyMap :" + DebugTraceHelper.toString(entityPropertyMap));
        }
        return entityPropertyMap;
    }

    private void dealRefProperty(Map<String, Set<String>> entityPropertyMap, String assistNumber, String valueSource, MainEntityType assistEntity, String documentField, DynamicProperty property) {
        List retList = assistEntity.getProperties().getCollectionProperties(true);
        for (IDataEntityProperty refDataEntityProperty : retList) {
            if (!(refDataEntityProperty instanceof EntryProp)) continue;
            DynamicObjectType propertyType = ((EntryProp)refDataEntityProperty).getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection properties = propertyType.getProperties();
            for (IDataEntityProperty refProperty : properties) {
                if (!documentField.equalsIgnoreCase(refProperty.getName())) continue;
                String baseEntityId = ((BasedataProp)refProperty).getBaseEntityId();
                Set<String> fields = this.assistToFiledMap.get(assistNumber);
                if (fields.remove(documentField)) {
                    String entryField = refDataEntityProperty.getName() + "." + refProperty.getName();
                    fields.add(entryField);
                    String buildKey = AcctPropertyParam.buildKey(new Object[]{assistNumber, entryField});
                    this.assistFiledToBasDataMap.put(buildKey, baseEntityId);
                    Set<String> propertyVals = this.assistFieldToPropertyValMap.get(AcctPropertyParam.buildKey(new Object[]{assistNumber, documentField}));
                    this.assistFieldToPropertyValMap.computeIfAbsent(AcctPropertyParam.buildKey(new Object[]{assistNumber, entryField}), k -> new HashSet(8)).addAll(propertyVals);
                    Iterator<String> propertyValSet = propertyVals.iterator();
                    while (propertyValSet.hasNext()) {
                        this.filedMap.computeIfAbsent(buildKey, k -> new HashSet()).add(AcctPropertyParam.buildKey(new Object[]{assistNumber, documentField, propertyValSet.next()}));
                    }
                    this.hasParent.put(baseEntityId, this.checkHasParent(baseEntityId));
                }
                this.getBaseDataEntity(entityPropertyMap, assistNumber, valueSource, documentField, property, baseEntityId);
                return;
            }
        }
    }

    private boolean checkHasParent(String baseEntityId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
        return null != dataEntityType.getProperty("masterid");
    }

    private void getBaseDataEntity(Map<String, Set<String>> entityPropertyMap, String assistNumber, String valueSource, String documentField, DynamicProperty property, String baseEntityId) {
        Set<String> properties = this.assistFieldToPropertyValMap.get(AcctPropertyParam.buildKey(new Object[]{assistNumber, documentField}));
        entityPropertyMap.computeIfAbsent(baseEntityId, k -> new HashSet(16)).addAll(properties);
        this.assistFiledToBasDataMap.put(AcctPropertyParam.buildKey(new Object[]{assistNumber, documentField}), baseEntityId);
        if (ASSIST_FIELD_DATA.equalsIgnoreCase(baseEntityId)) {
            this.assistDataGroupIdSet.add(!documentField.equalsIgnoreCase("parent") ? Long.valueOf(((AssistantProp)property).getAsstTypeId()) : this.numberToDetailGroupMap.get(assistNumber));
        }
        if (groupEntityList.contains(baseEntityId)) {
            this.assistToFiledMap.get(assistNumber).remove(documentField);
            this.assistToFiledGroupMap.computeIfAbsent(assistNumber, k -> new HashSet(8)).add(documentField);
        }
    }

    private static String buildKey(Object[] field) {
        return StringUtils.join((Object[])field, (String)"*");
    }

    public Map<String, Set<Long>> getAssistFieldValToIdMap() {
        return this.assistFieldValToIdMap;
    }

    public Map<String, Set<Long>> getAssistToFiledMap() {
        return this.assistToValIdMap;
    }

    public Map<String, Set<String>> getAssistFieldToNumbersMap() {
        return this.assistFieldToNumbersMap;
    }

    public Map<String, Object> getAssistNumToIdsMap() {
        return this.assistNumToIdsMap;
    }

    public Map<String, Set<String>> getFiledMap() {
        return this.filedMap;
    }
}

