/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acctfloat;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.acct.handle.MakeBaseDateDetailHelper;
import kd.fi.gl.acctfloat.AcctFloatQueryFormula;
import kd.fi.gl.acctfloat.AcctFloatQueryParam;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;
import kd.fi.gl.util.ReClassUtils;
import kd.fi.gl.wrap.DynPropertyWrapper;

public class AcctFloatContext {
    private static final String AUXILIARY_DATA_TYPE = "2";
    private static final String MANUAL_DIMENSION = "3";
    private static final String CTRL_STRATEGY_GLOBAL_SHARE = "5";
    private static final String[] selectFields = new String[]{"id", "org.id", "accounttable.id", "number", "startdate", "enddate", "parent", "longnumber", "level", "isleaf", "dc"};
    private static final String BASE_DATA_TYPE = "1";
    private static final String ASSISTANT_DATA_TYPE = "2";
    private final Log log = LogFactory.getLog((String)"AcctFloatContext");
    private AcctFloatQueryParam acctFloatQueryParam;
    private Map<String, Long> orgNumberToIdMap;
    private Map<String, Long> bookTypeNumberToIdMap;
    private Map<String, DynamicObject> accountBookMap;
    private Map<String, List<DynamicObject>> periodMap;
    private Map<String, Map<String, DynamicObject>> formulaToAccountsMap;
    private Map<String, Long> accountTableIdMap;
    private Map<String, Long> currencyNumberToIdMap;
    private Map<Long, Long> accountIdToMasterIdMap;
    private Map<Long, Set<Long>> directChildAccountMap;
    private Map<Long, Set<Long>> allDetailedAccountMap;
    private Map<String, DynamicObject> assistMap;
    private Map<Long, Set<String>> accountIdToFlexFieldMap;
    private Map<String, String> flexFieldToAssistEntityMap;
    private Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable;
    private Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable;
    private Map<Long, String> accountIdToNumberMap;
    private Map<String, DataSet> flexFieldToHgMap;
    private Table<String, String, Map<Object, Set<String>>> assistValIdToNumTable;
    private Map<String, Long> standardMap;
    private Map<String, DataSet> groupMap;
    private Table<String, String, String> comAssistToValSourceTable;
    private Table<String, String, Map<String, Set<Long>>> comAssistDispersedValIdTable;
    private Table<String, String, Map<String, Set<Long>>> comAssistRangeValIdTable;
    private HasPermOrgResult permOrgResult;
    private String permName;

    public AcctFloatContext(AcctFloatQueryParam acctFloatQueryParam, List<AcctFloatQueryFormula> formulas) {
        this.acctFloatQueryParam = acctFloatQueryParam;
        this.orgNumberToIdMap = ReClassUtils.numbersToIds("bos_org", formulas.stream().map(AcctFloatQueryFormula::getOrgNumber).collect(Collectors.toSet()), null);
        this.bookTypeNumberToIdMap = ReClassUtils.numbersToIds("bd_accountbookstype", formulas.stream().map(AcctFloatQueryFormula::getBookTypeNumber).collect(Collectors.toSet()), null);
        this.currencyNumberToIdMap = ReClassUtils.numbersToIds("bd_currency", formulas.stream().map(AcctFloatQueryFormula::getCurrency).collect(Collectors.toSet()), null);
        this.initBookInfos(formulas);
        this.initPeriodMap(acctFloatQueryParam.getComYear(), acctFloatQueryParam.getComPeriod(), acctFloatQueryParam.getComAdjustPeriod(), acctFloatQueryParam.getScopePeriods(), formulas);
        this.initAccountTable(formulas);
        this.initAccountMap(formulas);
        this.initAssistMap(formulas);
        this.initAssistValueId(formulas);
        this.initHgByFlexField(formulas);
        this.initComAssistKeyToValSource(formulas);
        this.initComAssistValueId(formulas);
        this.permOrgResult = InterfacePermissionService.getAllPermOrgs(PermissionType.ACCT);
        this.permName = InterfacePermissionService.getPermName(PermissionType.ACCT);
    }

    private static SqlBuilder getSqlBuilder(Collection<Long> orgIds, Collection<Long> accountTableIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT c.fid id, u.fuseorgid useorgid, c.faccounttableid accounttableid, c.fctrlstrategy ctrlstrategy FROM T_BD_ACCOUNT AS c LEFT JOIN T_BD_ACCOUNT_U AS u ON u.fdataid = c.fid WHERE", new Object[0]).append("c.fstatus='C'", new Object[0]);
        if (CollectionUtils.isNotEmpty(accountTableIds)) {
            sql.appendIn("AND c.faccounttableid", accountTableIds.toArray());
        }
        sql.append("AND", new Object[0]).appendIn("u.fuseorgid", orgIds.toArray());
        sql.append("UNION ", new Object[0]).append("SELECT c.fid id, 0 as fuseorgid, c.faccounttableid accounttableid, c.fctrlstrategy ctrlstrategy  FROM T_BD_ACCOUNT as c where c.fctrlstrategy = '5'", new Object[0]);
        if (CollectionUtils.isNotEmpty(accountTableIds)) {
            sql.appendIn("AND c.faccounttableid", accountTableIds.toArray());
        }
        return sql;
    }

    private void initBookInfos(List<AcctFloatQueryFormula> formulas) {
        this.accountBookMap = new HashMap<String, DynamicObject>(formulas.size());
        HashSet<Long> orgIdSet = new HashSet<Long>(8);
        HashSet<Long> bookTypeIdSet = new HashSet<Long>(8);
        for (AcctFloatQueryFormula formula : formulas) {
            orgIdSet.add(this.orgNumberToIdMap.get(formula.getOrgNumber()));
            bookTypeIdSet.add(this.bookTypeNumberToIdMap.get(formula.getBookTypeNumber()));
        }
        List accountBookInfoList = BatchProcessUtil.batchProcess(orgIdSet, batchData -> BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"org.number, bookstype.number, bookstype.id, accounttable.id, periodtype_id", (QFilter[])new QFilter[]{new QFilter("org", "in", batchData), new QFilter("bookstype", "in", (Object)bookTypeIdSet)}).values());
        HashSet accountBookInfoSet = new HashSet(8);
        accountBookInfoList.forEach(accountBookInfoSet::addAll);
        HashBasedTable accountBoonInfoTable = HashBasedTable.create();
        for (DynamicObject accountBookInfo : accountBookInfoSet) {
            accountBoonInfoTable.put((Object)accountBookInfo.getString("org.number"), (Object)accountBookInfo.getString("bookstype.number"), (Object)accountBookInfo);
        }
        for (AcctFloatQueryFormula formula : formulas) {
            String orgNumber = formula.getOrgNumber();
            String bookTypeNumber = formula.getBookTypeNumber();
            this.accountBookMap.put(orgNumber + "*" + bookTypeNumber, (DynamicObject)accountBoonInfoTable.get((Object)orgNumber, (Object)bookTypeNumber));
        }
    }

    private void initPeriodMap(int comYear, int comPeriod, String comAdjustPeriod, List<String> scopePeriods, List<AcctFloatQueryFormula> formulas) {
        this.periodMap = new HashMap<String, List<DynamicObject>>(formulas.size());
        HashMap<String, Long> periodTypeIdMap = new HashMap<String, Long>(formulas.size());
        for (AcctFloatQueryFormula formula : formulas) {
            Long periodTypeId = formula.getPeriodTypeId(this.accountBookMap);
            if (periodTypeId == null) continue;
            periodTypeIdMap.put(formula.getFormulaKey(), periodTypeId);
        }
        String selectFields = StringUtils.join((Object[])new String[]{"periodyear", "periodnumber", "id", "begindate", "enddate", "periodtype", "isadjustperiod"}, (String)",");
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("periodtype", "in", periodTypeIdMap.values())});
        HashMap<Long, Table> periodTypeToPeriodMap = new HashMap<Long, Table>(periodTypeIdMap.size());
        for (DynamicObject period : periods) {
            Table periodTable = periodTypeToPeriodMap.computeIfAbsent(period.getLong("periodtype"), key -> HashBasedTable.create());
            int periodYear = period.getInt("periodyear");
            int periodNum = period.getInt("periodnumber");
            if (periodNum >= 13) {
                periodTable.put((Object)periodYear, (Object)String.valueOf(periodNum), (Object)period);
                periodTable.put((Object)periodYear, (Object)(periodNum + "T"), (Object)period);
                continue;
            }
            if (period.getBoolean("isadjustperiod")) {
                periodTable.put((Object)periodYear, (Object)(periodNum + "T"), (Object)period);
                continue;
            }
            periodTable.put((Object)periodYear, (Object)String.valueOf(periodNum), (Object)period);
        }
        HashMap periodTypeToPeriodNumberMap = new HashMap(8);
        for (Map.Entry periodTypeToPeriodEntry : periodTypeToPeriodMap.entrySet()) {
            Long periodTypeId = (Long)periodTypeToPeriodEntry.getKey();
            Table periodTable = (Table)periodTypeToPeriodEntry.getValue();
            Map periodFromYearMap = new HashMap(8);
            if (periodTypeToPeriodNumberMap.containsKey(periodTypeId)) {
                periodFromYearMap = (Map)periodTypeToPeriodNumberMap.get(periodTypeId);
            } else {
                periodTypeToPeriodNumberMap.put(periodTypeId, periodFromYearMap);
            }
            for (Table.Cell periodCell : periodTable.cellSet()) {
                String year = String.valueOf(periodCell.getRowKey());
                String periodNumber = (String)periodCell.getColumnKey();
                if (periodFromYearMap.containsKey(year)) {
                    ((List)periodFromYearMap.get(year)).add(periodNumber);
                    continue;
                }
                ArrayList<String> periodNumberList = new ArrayList<String>(8);
                periodNumberList.add(periodNumber);
                periodFromYearMap.put(year, periodNumberList);
            }
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_initPeriodMap periodTypeToPeriodNumberMap:" + periodTypeToPeriodNumberMap);
        }
        for (AcctFloatQueryFormula formula : formulas) {
            Table periodTable;
            int year = -1;
            Long periodTypeId = (Long)periodTypeIdMap.get(formula.getFormulaKey());
            String periodStr = StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(comPeriod);
            if (!AcctUtil.checkPeriodFormat(periodStr)) continue;
            String formulaPeriod = formula.getPeriod();
            String yearAndPeriodKey = AcctUtil.dealYearAndPeriod(formulaPeriod, comPeriod, comAdjustPeriod, String.valueOf(formula.getYear()), comYear, (Map)periodTypeToPeriodNumberMap.get(periodTypeId));
            String[] yearAndPeriod = yearAndPeriodKey.split("-");
            if (yearAndPeriod.length == 2) {
                year = Integer.parseInt(yearAndPeriod[0]);
                periodStr = yearAndPeriod[1];
            }
            if ((periodTable = (Table)periodTypeToPeriodMap.get(periodTypeId)) == null) continue;
            ArrayList<Object> periodList = new ArrayList<Object>(4);
            if (!CollectionUtils.isEmpty(scopePeriods) && (StringUtils.isBlank((CharSequence)formulaPeriod) || "0".equals(formulaPeriod))) {
                for (int i = 0; i < scopePeriods.size(); ++i) {
                    String scopePeriod = String.valueOf(scopePeriods.get(i));
                    periodList.add(periodTable.get((Object)year, (Object)scopePeriod));
                }
            } else {
                if (scopePeriods != null && scopePeriods.size() > 1 && formulaPeriod.startsWith("-")) {
                    formula.setErrorMsg(ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u53d6\u6570\u65f6\u4e0d\u652f\u6301\u8bbe\u7f6e\u504f\u79fb\u91cf\uff0c\u8bf7\u66f4\u6539\u516c\u5f0f\u914d\u7f6e\u6216\u671f\u95f4\u6210\u5458\u6620\u5c04\u3002", (String)"ReClassNumberIDParam_3", (String)"fi-gl-mservice", (Object[])new Object[0]));
                    continue;
                }
                Collection<DynamicObject> periodDyns = periodTable.row((Object)year).values();
                int maxPeriod = this.getMaxPeriod(periodDyns);
                if (!periodStr.endsWith("T") && Integer.parseInt(periodStr) > -maxPeriod && Integer.parseInt(periodStr) <= 0) {
                    periodStr = String.valueOf(Integer.parseInt(periodStr) + maxPeriod);
                }
                periodList.add(periodTable.get((Object)year, (Object)periodStr));
            }
            this.periodMap.put(formula.getFormulaKey(), periodList);
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_initPeriodMap periodMap:" + this.periodMap);
        }
    }

    private int getMaxPeriod(Collection<DynamicObject> periodDyns) {
        int maxPeriod = 0;
        for (DynamicObject periodDyn : periodDyns) {
            if (periodDyn.getInt("periodnumber") <= maxPeriod) continue;
            maxPeriod = periodDyn.getInt("periodnumber");
        }
        return maxPeriod;
    }

    private void initAccountTable(List<AcctFloatQueryFormula> formulas) {
        this.accountTableIdMap = new HashMap<String, Long>(8);
        for (AcctFloatQueryFormula formula : formulas) {
            DynamicObject bookInfo;
            String orgNumber = formula.getOrgNumber();
            String bookTypeNumber = formula.getBookTypeNumber();
            Long orgId = this.orgNumberToIdMap.getOrDefault(orgNumber, 0L);
            Long bookTypeId = this.bookTypeNumberToIdMap.getOrDefault(bookTypeNumber, 0L);
            DynamicObject period = this.getLastPeriodDyns(formula.getFormulaKey());
            if (period == null || orgId == 0L || bookTypeId == 0L) continue;
            long periodId = period.getLong("id");
            long acctTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
            if (acctTableId == 0L && (bookInfo = this.accountBookMap.get(orgNumber + "*" + bookTypeNumber)) != null) {
                acctTableId = bookInfo.getLong("accounttable.id");
            }
            this.accountTableIdMap.put(formula.getFormulaKey(), acctTableId);
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_initAccountTable accountTableIdMap:" + this.accountTableIdMap);
        }
    }

    private void initAccountMap(List<AcctFloatQueryFormula> formulas) {
        long startTime = System.currentTimeMillis();
        Table<Long, Long, List<DynamicObject>> accountDynTable = this.getAccountDynTable(this.orgNumberToIdMap.values(), this.accountTableIdMap.values(), selectFields);
        this.initAccountIdToNumber(accountDynTable);
        Map<DynamicObject, DynPropertyWrapper> accountPropertyMap = this.getAccountPropertyMap(accountDynTable);
        HashSet<DynamicObject> accountDynSet = new HashSet<DynamicObject>(8);
        this.initCurrentAccount(formulas, accountDynTable, accountDynSet, accountPropertyMap);
        this.initDirectChildAccount(formulas, accountDynTable, accountDynSet, accountPropertyMap);
        this.initDetailedAccount(formulas, accountDynTable, accountDynSet, accountPropertyMap);
        this.dealDetailAccount(accountDynSet);
        this.initAllAcctFlexFields();
        long endTime = System.currentTimeMillis();
        this.log.info("init accounts cost time\uff1a" + (endTime - startTime));
    }

    private void initAssistValueId(List<AcctFloatQueryFormula> formulas) {
        long startTime = System.currentTimeMillis();
        this.assistValueNumberToIdTable = HashBasedTable.create();
        this.assistRangeValToIdTable = HashBasedTable.create();
        HashBasedTable allAssistToValueNumberTable = HashBasedTable.create();
        HashBasedTable allAssistToRangeValueTable = HashBasedTable.create();
        for (AcctFloatQueryFormula formula : formulas) {
            String orgNumber = formula.getOrgNumber();
            Map<String, List<String>> assistToValueNumberMap = formula.getAssistToValueNumberMap();
            for (Map.Entry<String, List<String>> assistToValueNumberEntry : assistToValueNumberMap.entrySet()) {
                Set<String> allValueNumSet;
                String assistNumber = assistToValueNumberEntry.getKey();
                List<String> valueNumberList = assistToValueNumberEntry.getValue();
                if (!CollectionUtils.isNotEmpty(valueNumberList)) continue;
                if (allAssistToValueNumberTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    allValueNumSet = (Set)allAssistToValueNumberTable.get((Object)orgNumber, (Object)assistNumber);
                    allValueNumSet.addAll(valueNumberList);
                    continue;
                }
                allValueNumSet = new HashSet<String>(valueNumberList);
                allAssistToValueNumberTable.put((Object)orgNumber, (Object)assistNumber, allValueNumSet);
            }
            Map<String, List<String>> assistToRangeValueMap = formula.getAssistToRangeValueMap();
            for (Map.Entry<String, List<String>> assistToRangeValueEntry : assistToRangeValueMap.entrySet()) {
                String assistNumber = assistToRangeValueEntry.getKey();
                List<String> rangeValueList = assistToRangeValueEntry.getValue();
                if (!CollectionUtils.isNotEmpty(rangeValueList)) continue;
                if (allAssistToRangeValueTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    Set allValueNumSet = (Set)allAssistToRangeValueTable.get((Object)orgNumber, (Object)assistNumber);
                    allValueNumSet.addAll(rangeValueList);
                    continue;
                }
                HashSet<String> allRangeValueSet = new HashSet<String>(rangeValueList);
                allAssistToRangeValueTable.put((Object)orgNumber, (Object)assistNumber, allRangeValueSet);
            }
        }
        this.queryAssistValueId((Table<String, String, Set<String>>)allAssistToValueNumberTable);
        this.queryAssistRangeValueId((Table<String, String, Set<String>>)allAssistToRangeValueTable);
        long endTime = System.currentTimeMillis();
        this.log.info("init assistValueId cost time\uff1a" + (endTime - startTime));
    }

    private void initAssistMap(List<AcctFloatQueryFormula> formulas) {
        long startTime = System.currentTimeMillis();
        HashSet<String> allAssistNumberSet = new HashSet<String>();
        for (AcctFloatQueryFormula formula : formulas) {
            allAssistNumberSet.addAll(formula.getAssistToValueNumberMap().keySet());
            allAssistNumberSet.addAll(formula.getAssistToRangeValueMap().keySet());
            allAssistNumberSet.addAll(formula.getAllValueAssistNumberSet());
        }
        this.assistMap = new HashMap<String, DynamicObject>(allAssistNumberSet.size());
        QFilter numberQF = new QFilter("number", "in", allAssistNumberSet);
        QFilter flexIdQF = new QFilter("flexid", "=", (Object)2L);
        DynamicObjectCollection assistDyns = QueryServiceHelper.query((String)"bd_asstacttype", (String)"number, valuetype, assistanttype, valuesource, flexfield", (QFilter[])new QFilter[]{numberQF, flexIdQF});
        for (DynamicObject assistDyn : assistDyns) {
            this.assistMap.put(assistDyn.getString("number"), assistDyn);
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_initAssistMap assistMap\uff1a" + this.assistMap);
        }
        long endTime = System.currentTimeMillis();
        this.log.info("init assist cost time\uff1a" + (endTime - startTime));
    }

    private void queryAssistValueId(Table<String, String, Set<String>> allAssistToValueNumberTable) {
        this.assistValIdToNumTable = HashBasedTable.create();
        for (Table.Cell allAssistToValueNumberCell : allAssistToValueNumberTable.cellSet()) {
            QFilter orgFilter;
            String orgNumber = (String)allAssistToValueNumberCell.getRowKey();
            long orgId = this.orgNumberToIdMap.getOrDefault(orgNumber, 0L);
            if (orgId == 0L) continue;
            String assistNumber = (String)allAssistToValueNumberCell.getColumnKey();
            DynamicObject assistDyn = this.assistMap.get(assistNumber);
            Set valueNumberSet = (Set)allAssistToValueNumberCell.getValue();
            if (assistDyn == null) continue;
            if (MANUAL_DIMENSION.equals(assistDyn.getString("valuetype"))) {
                Map<String, HashSet<String>> valueNumToIdMap = new HashMap(valueNumberSet.size());
                if (this.assistValueNumberToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    valueNumToIdMap = (Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber);
                }
                Map<String, HashSet<String>> valueIdToNumsMap = new HashMap(8);
                if (this.assistValIdToNumTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    valueIdToNumsMap = (Map)this.assistValIdToNumTable.get((Object)orgNumber, (Object)assistNumber);
                }
                for (String valueNumber : valueNumberSet) {
                    valueNumToIdMap.put(valueNumber, new HashSet<String>(Collections.singleton(valueNumber)));
                    valueIdToNumsMap.put(valueNumber, new HashSet<String>(Collections.singleton(valueNumber)));
                }
                this.assistValueNumberToIdTable.put((Object)orgNumber, (Object)assistNumber, valueNumToIdMap);
                this.assistValIdToNumTable.put((Object)orgNumber, (Object)assistNumber, valueIdToNumsMap);
                continue;
            }
            String entityId = assistDyn.getString("valuesource");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            if (entityId != null && (orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId)) != null) {
                filters.add(orgFilter);
            }
            if ("2".equals(assistDyn.get("valuetype"))) {
                Long assistantTypeId = assistDyn.getLong("assistanttype");
                QFilter assistantOrgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistantTypeId, (Long)orgId);
                if (assistantOrgFilter != null) {
                    filters.add(assistantOrgFilter);
                }
                QFilter groupFilter = new QFilter("group", "=", (Object)assistantTypeId);
                filters.add(groupFilter);
            }
            MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
            Map<String, Set<Long>> valueNumToIdsMap = detailHelper.getDetailAssists(entityId, valueNumberSet, filters);
            Map valNumToIdMap = new HashMap(8);
            if (this.assistValueNumberToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                valNumToIdMap = (Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber);
            }
            for (Map.Entry<String, Set<Long>> valueNumToIdsEntry : valueNumToIdsMap.entrySet()) {
                valNumToIdMap.put(valueNumToIdsEntry.getKey(), new HashSet(valueNumToIdsEntry.getValue()));
            }
            valNumToIdMap.put("None", new HashSet<Long>(Collections.singleton(0L)));
            this.assistValueNumberToIdTable.put((Object)orgNumber, (Object)assistNumber, valNumToIdMap);
            Map<String, Object> floatValueNumberMap = this.getAcctFloatQueryParam().getRefParamMap();
            List assistValueNumList = (List)floatValueNumberMap.get(assistNumber);
            if (CollectionUtils.isEmpty((Collection)assistValueNumList)) continue;
            Map<Object, Set> valueIdToNumsMap = new HashMap(8);
            if (this.assistValIdToNumTable.contains((Object)orgNumber, (Object)assistNumber)) {
                valueIdToNumsMap = (Map)this.assistValIdToNumTable.get((Object)orgNumber, (Object)assistNumber);
            }
            for (String assistValueNumber : assistValueNumList) {
                Set<Long> valueIdSet = valueNumToIdsMap.get(assistValueNumber);
                if (CollectionUtils.isEmpty(valueIdSet)) continue;
                for (Long valueId : valueIdSet) {
                    Set idToValueNumberSet = valueIdToNumsMap.computeIfAbsent(valueId, key -> new HashSet(8));
                    idToValueNumberSet.add(assistValueNumber);
                }
            }
            valueIdToNumsMap.put(0L, new HashSet<String>(Collections.singleton("None")));
            this.assistValIdToNumTable.put((Object)orgNumber, (Object)assistNumber, valueIdToNumsMap);
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_queryAssistValueId assistValueNumberToIdTable\uff1a" + this.assistValueNumberToIdTable);
            this.log.info("AcctFloatContext_queryAssistValueId assistValIdToNumTable\uff1a" + this.assistValIdToNumTable);
        }
    }

    private void queryAssistRangeValueId(Table<String, String, Set<String>> allAssistToRangeValueTable) {
        this.standardMap = new HashMap<String, Long>(8);
        this.groupMap = new HashMap<String, DataSet>(8);
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        for (Table.Cell allAssistToRangeValueCell : allAssistToRangeValueTable.cellSet()) {
            QFilter orgFilter;
            String orgNumber = (String)allAssistToRangeValueCell.getRowKey();
            long orgId = this.orgNumberToIdMap.getOrDefault(orgNumber, 0L);
            String assistNumber = (String)allAssistToRangeValueCell.getColumnKey();
            DynamicObject assistDyn = this.assistMap.get(assistNumber);
            Set assistRangeValueSet = (Set)allAssistToRangeValueCell.getValue();
            if (assistDyn == null) continue;
            String entityId = assistDyn.getString("valuesource");
            if (StringUtils.isBlank((CharSequence)entityId)) {
                Map<String, Set> rangeValueIdMap = new HashMap(8);
                if (this.assistRangeValToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    rangeValueIdMap = (Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber);
                }
                for (String rangeValueNum : assistRangeValueSet) {
                    String rangeValue = rangeValueNum.substring(1, rangeValueNum.length() - 1);
                    Set rangeValueIdSet = rangeValueIdMap.computeIfAbsent(rangeValueNum, key -> new HashSet());
                    rangeValueIdSet.addAll(Arrays.asList(rangeValue.split(",")));
                }
                this.assistRangeValToIdTable.put((Object)orgNumber, (Object)assistNumber, rangeValueIdMap);
                continue;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            if (orgId != 0L && (orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId)) != null) {
                filters.add(orgFilter);
            }
            if ("2".equals(assistDyn.get("valuetype"))) {
                Long assistantTypeId = assistDyn.getLong("assistanttype");
                QFilter assistantOrgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistantTypeId, (Long)orgId);
                if (assistantOrgFilter != null) {
                    filters.add(assistantOrgFilter);
                }
                QFilter groupFilter = new QFilter("group", "=", (Object)assistantTypeId);
                filters.add(groupFilter);
            }
            Map rangeValNumToIdMap = new HashMap(8);
            if (this.assistRangeValToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                rangeValNumToIdMap = (Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber);
            }
            for (String rangeValueNum : assistRangeValueSet) {
                boolean isClassify = ReClassUtils.isCollectionNumber(rangeValueNum);
                DataSet assistDataSet = null;
                if (isClassify) {
                    assistDataSet = AcctUtil.queryAssistValByGroup(rangeValueNum, entityId, this.standardMap, this.groupMap);
                } else {
                    String rangeValue = rangeValueNum.substring(1, rangeValueNum.length() - 1);
                    String[] continueValNum = rangeValue.split(",");
                    assistDataSet = AcctUtil.queryContinueNumber(Arrays.asList(continueValNum), filters, "masterid", entityId);
                }
                HashSet<Object> rangeValueIdSet = new HashSet<Object>(8);
                if (assistDataSet != null) {
                    for (Row assist : assistDataSet) {
                        rangeValueIdSet.add(assist.getLong("masterid"));
                    }
                }
                HashSet<Object> allRangeValIdSet = new HashSet<Object>(8);
                if (CollectionUtils.isNotEmpty(rangeValueIdSet)) {
                    allRangeValIdSet.addAll(rangeValueIdSet);
                }
                if (detailHelper.hasParent(entityId)) {
                    Set<Object> detailAssistIdSet = detailHelper.getDetailAssisttContinueNumbers(entityId, rangeValueIdSet, filters);
                    allRangeValIdSet.addAll(detailAssistIdSet);
                }
                rangeValNumToIdMap.put(rangeValueNum, allRangeValIdSet);
            }
            this.assistRangeValToIdTable.put((Object)orgNumber, (Object)assistNumber, rangeValNumToIdMap);
        }
    }

    private void dealDetailAccount(Set<DynamicObject> accountDynSet) {
        HashSet allAccountIdSet = new HashSet(8);
        accountDynSet.forEach(accountDyn -> {
            if (accountDyn != null) {
                allAccountIdSet.add(accountDyn.getLong("id"));
            }
        });
        Iterator iterator = allAccountIdSet.iterator();
        while (iterator.hasNext()) {
            Set detailedAccountIdSet;
            long accountId = (Long)iterator.next();
            Set directChildAccountIdSet = this.directChildAccountMap.computeIfAbsent(accountId, key -> new HashSet());
            if (directChildAccountIdSet.isEmpty()) {
                directChildAccountIdSet.add(accountId);
            }
            if (!(detailedAccountIdSet = this.allDetailedAccountMap.computeIfAbsent(accountId, key -> new HashSet())).isEmpty()) continue;
            detailedAccountIdSet.add(accountId);
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_dealDetailAccount directChildAccountMap\uff1a" + this.directChildAccountMap);
            this.log.info("AcctFloatContext_dealDetailAccount allDetailedAccountMap\uff1a" + this.allDetailedAccountMap);
        }
    }

    private void initAllAcctFlexFields() {
        this.accountIdToMasterIdMap = new HashMap<Long, Long>(8);
        this.accountIdToFlexFieldMap = new HashMap<Long, Set<String>>(8);
        this.flexFieldToAssistEntityMap = new HashMap<String, String>(8);
        HashSet<Object> allAccountIdSet = new HashSet<Object>(8);
        for (Map.Entry<String, Map<String, DynamicObject>> entry : this.formulaToAccountsMap.entrySet()) {
            Map<String, DynamicObject> accountMap = entry.getValue();
            Collection<DynamicObject> accounts = accountMap.values();
            for (DynamicObject account : accounts) {
                if (account == null) continue;
                allAccountIdSet.add(account.getLong("id"));
            }
        }
        for (Map.Entry<Object, Object> entry : this.directChildAccountMap.entrySet()) {
            allAccountIdSet.add(entry.getKey());
            allAccountIdSet.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.allDetailedAccountMap.entrySet()) {
            allAccountIdSet.add(entry.getKey());
            allAccountIdSet.addAll((Collection)entry.getValue());
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id, number, masterid, checkitementry.asstactitem.flexfield flexfield, checkitementry.asstactitem.valuetype valuetype", (QFilter[])new QFilter[]{new QFilter("id", "in", allAccountIdSet)}, null);
        for (Row row : dataSet) {
            long accountId = row.getLong("id");
            long masterId = row.getLong("masterid");
            this.accountIdToMasterIdMap.put(accountId, masterId);
            String flexField = row.getString("flexfield");
            Set flexFieldSet = this.accountIdToFlexFieldMap.computeIfAbsent(accountId, key -> new HashSet());
            flexFieldSet.add(flexField);
            String valueType = row.getString("valuetype");
            if (MANUAL_DIMENSION.equals(valueType)) {
                this.flexFieldToAssistEntityMap.put(flexField, "gl_assist_txt");
                continue;
            }
            this.flexFieldToAssistEntityMap.put(flexField, "gl_assist_bd");
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_initAllAcctFlexFields accountIdToMasterIdMap\uff1a" + this.accountIdToMasterIdMap);
            this.log.info("AcctFloatContext_initAllAcctFlexFields accountIdToFlexFieldMap\uff1a" + this.accountIdToFlexFieldMap);
            this.log.info("AcctFloatContext_initAllAcctFlexFields flexFieldToAssistEntityMap\uff1a" + this.flexFieldToAssistEntityMap);
        }
    }

    private Table<Long, Long, List<DynamicObject>> getAccountDynTable(Collection<Long> orgIds, Collection<Long> accountTableIds, String[] selectFields) {
        HashBasedTable accountDynTable = HashBasedTable.create();
        if (CollectionUtils.isNotEmpty(orgIds) && CollectionUtils.isNotEmpty(accountTableIds)) {
            SqlBuilder sqlBuilder = AcctFloatContext.getSqlBuilder(orgIds, accountTableIds);
            HashSet<Long> allAccountIdSet = new HashSet<Long>(8);
            HashBasedTable orgAndAcctTableToAcctIDTable = HashBasedTable.create();
            try (DataSet dataSet = DB.queryDataSet((String)"AcctFloatContext.queryAccounts", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
                for (Row row : dataSet) {
                    Long accountId = row.getLong("id");
                    Long useOrgId = row.getLong("useorgid");
                    Long accountTableId = row.getLong("accounttableid");
                    String ctrlStrategy = row.getString("ctrlstrategy");
                    if (CTRL_STRATEGY_GLOBAL_SHARE.equals(ctrlStrategy)) {
                        for (Long orgId : orgIds) {
                            if (!orgAndAcctTableToAcctIDTable.contains((Object)orgId, (Object)accountTableId)) {
                                orgAndAcctTableToAcctIDTable.put((Object)orgId, (Object)accountTableId, new HashSet(8));
                            }
                            ((Set)orgAndAcctTableToAcctIDTable.get((Object)orgId, (Object)accountTableId)).add(accountId);
                        }
                    } else {
                        if (!orgAndAcctTableToAcctIDTable.contains((Object)useOrgId, (Object)accountTableId)) {
                            orgAndAcctTableToAcctIDTable.put((Object)useOrgId, (Object)accountTableId, new HashSet(8));
                        }
                        ((Set)orgAndAcctTableToAcctIDTable.get((Object)useOrgId, (Object)accountTableId)).add(accountId);
                    }
                    allAccountIdSet.add(accountId);
                }
            }
            String fieldsString = StringUtils.join((Object[])selectFields, (String)",");
            Map accountDynCol = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)fieldsString, (QFilter[])new QFilter[]{new QFilter("id", "in", allAccountIdSet)});
            for (Table.Cell accountIdCell : orgAndAcctTableToAcctIDTable.cellSet()) {
                Set accountIdSet = (Set)accountIdCell.getValue();
                long orgId = (Long)accountIdCell.getRowKey();
                long accountTableId = (Long)accountIdCell.getColumnKey();
                accountDynTable.put((Object)orgId, (Object)accountTableId, accountIdSet.stream().map(x -> (DynamicObject)accountDynCol.get(x)).collect(Collectors.toList()));
            }
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_getAccountDynTable accountDynTable\uff1a" + accountDynTable);
        }
        return accountDynTable;
    }

    private List<DynamicObject> getAccountListFromTable(String orgNumber, String formulaKey, Table<Long, Long, List<DynamicObject>> accountDynTable) {
        Long orgId = this.orgNumberToIdMap.get(orgNumber);
        Long accountTableId = this.accountTableIdMap.get(formulaKey);
        return (List)accountDynTable.get((Object)orgId, (Object)accountTableId);
    }

    private void initAccountIdToNumber(Table<Long, Long, List<DynamicObject>> accountDynTable) {
        this.accountIdToNumberMap = new HashMap<Long, String>(8);
        for (List accDys : accountDynTable.values()) {
            for (DynamicObject acc : accDys) {
                this.accountIdToNumberMap.computeIfAbsent(acc.getLong("id"), key -> acc.getString("number"));
            }
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_initAccountIdToNumber accountIdToNumberMap\uff1a" + this.accountIdToNumberMap);
        }
    }

    private Map<DynamicObject, DynPropertyWrapper> getAccountPropertyMap(Table<Long, Long, List<DynamicObject>> accountDynTable) {
        HashMap<DynamicObject, DynPropertyWrapper> accountPropertyMap = new HashMap<DynamicObject, DynPropertyWrapper>(8);
        for (List accDys : accountDynTable.values()) {
            for (DynamicObject acc : accDys) {
                accountPropertyMap.put(acc, new DynPropertyWrapper(acc));
            }
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_getAccountPropertyMap accountPropertyMap\uff1a" + accountPropertyMap);
        }
        return accountPropertyMap;
    }

    private void initCurrentAccount(List<AcctFloatQueryFormula> formulas, Table<Long, Long, List<DynamicObject>> accountDynTable, Set<DynamicObject> accountDynSet, Map<DynamicObject, DynPropertyWrapper> accountPropertyMap) {
        this.formulaToAccountsMap = new HashMap<String, Map<String, DynamicObject>>(formulas.size());
        for (AcctFloatQueryFormula formula : formulas) {
            Set<String> accountContinueNumberSet;
            DynamicObject periodDyn;
            List<DynamicObject> periodDyns = this.periodMap.get(formula.getFormulaKey());
            if (periodDyns == null || Objects.isNull(periodDyn = periodDyns.get(periodDyns.size() - 1))) continue;
            Date periodEndDate = periodDyn.getDate("enddate");
            List<DynamicObject> accountDynList = this.getAccountListFromTable(formula.getOrgNumber(), formula.getFormulaKey(), accountDynTable);
            Set<String> allAccountNumberSet = formula.getAccountNumberToDynMap().keySet();
            if (!allAccountNumberSet.isEmpty() && CollectionUtils.isNotEmpty(accountDynList)) {
                for (DynamicObject accountDyn : accountDynList) {
                    DynPropertyWrapper dynPropertyWrapper = accountPropertyMap.get(accountDyn);
                    String accountNumber = (String)dynPropertyWrapper.getValueByPropertyName("number");
                    Date accountStartDate = (Date)dynPropertyWrapper.getValueByPropertyName("startdate");
                    Date accountEndDate = (Date)dynPropertyWrapper.getValueByPropertyName("enddate");
                    if (!allAccountNumberSet.contains(accountNumber) || !this.isCurPeriod(accountStartDate, accountEndDate, periodEndDate)) continue;
                    formula.getAccountNumberToDynMap().put(accountNumber, accountDyn);
                    Map accountNumberToDynMap = this.formulaToAccountsMap.computeIfAbsent(formula.getFormulaKey(), key -> new HashMap(8));
                    accountNumberToDynMap.put(accountNumber, accountDyn);
                    accountDynSet.add(accountDyn);
                }
            }
            if ((accountContinueNumberSet = formula.getAccountContinueNumberSet()).isEmpty() || !CollectionUtils.isNotEmpty(accountDynList)) continue;
            for (DynamicObject accountDyn : accountDynList) {
                DynPropertyWrapper dynPropertyWrapper = accountPropertyMap.get(accountDyn);
                String accountNumber = (String)dynPropertyWrapper.getValueByPropertyName("number");
                Date accountStartDate = (Date)dynPropertyWrapper.getValueByPropertyName("startdate");
                Date accountEndDate = (Date)dynPropertyWrapper.getValueByPropertyName("enddate");
                for (String continueNum : accountContinueNumberSet) {
                    if (!this.isRangeAccountNum(accountNumber, continueNum) || !this.isCurPeriod(accountStartDate, accountEndDate, periodEndDate)) continue;
                    formula.getAccountNumberToDynMap().put(accountNumber, accountDyn);
                    Map accountNumberToDynMap = this.formulaToAccountsMap.computeIfAbsent(formula.getFormulaKey(), key -> new HashMap(8));
                    accountNumberToDynMap.put(accountNumber, accountDyn);
                    accountDynSet.add(accountDyn);
                }
            }
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_initCurrentAccount formulaToAccountsMap\uff1a" + this.formulaToAccountsMap);
        }
    }

    private DynamicObject getLastPeriodDyns(String formulaKey) {
        List<DynamicObject> periodDyns = this.periodMap.get(formulaKey);
        return periodDyns == null ? null : periodDyns.get(periodDyns.size() - 1);
    }

    private void initDirectChildAccount(List<AcctFloatQueryFormula> formulas, Table<Long, Long, List<DynamicObject>> accountDynTable, Set<DynamicObject> accountDynSet, Map<DynamicObject, DynPropertyWrapper> accountPropertyMap) {
        this.directChildAccountMap = new HashMap<Long, Set<Long>>(8);
        for (AcctFloatQueryFormula formula : formulas) {
            HashSet<DynamicObject> allCurAccountSet = new HashSet<DynamicObject>(formula.getAccountNumberToDynMap().values());
            DynamicObject periodDyn = this.getLastPeriodDyns(formula.getFormulaKey());
            List<DynamicObject> accountDynList = this.getAccountListFromTable(formula.getOrgNumber(), formula.getFormulaKey(), accountDynTable);
            if (!CollectionUtils.isNotEmpty(allCurAccountSet) || periodDyn == null || !CollectionUtils.isNotEmpty(accountDynList)) continue;
            Date periodEndDate = periodDyn.getDate("enddate");
            block1: for (DynamicObject accountDyn : accountDynList) {
                if (accountDyn == null) continue;
                DynPropertyWrapper dynPropertyWrapper = accountPropertyMap.get(accountDyn);
                Long directChildAccountId = (Long)dynPropertyWrapper.getValueByPropertyName("id");
                Date accountStartDate = (Date)dynPropertyWrapper.getValueByPropertyName("startdate");
                Date accountEndDate = (Date)dynPropertyWrapper.getValueByPropertyName("enddate");
                String longNumber = (String)dynPropertyWrapper.getValueByPropertyName("longnumber");
                int level = (Integer)dynPropertyWrapper.getValueByPropertyName("level");
                for (DynamicObject curAccount : allCurAccountSet) {
                    int curAcctLevel;
                    DynPropertyWrapper curAcctProperty;
                    String curAcctLongNumber;
                    if (curAccount == null || !this.isDirectChildAccount(curAcctLongNumber = (String)(curAcctProperty = accountPropertyMap.get(curAccount)).getValueByPropertyName("longnumber"), longNumber, curAcctLevel = ((Integer)curAcctProperty.getValueByPropertyName("level")).intValue(), level) || !this.isCurPeriod(accountStartDate, accountEndDate, periodEndDate)) continue;
                    Long accountId = (Long)curAcctProperty.getValueByPropertyName("id");
                    Set directChildAccountIdSet = this.directChildAccountMap.computeIfAbsent(accountId, key -> new HashSet());
                    directChildAccountIdSet.add(directChildAccountId);
                    accountDynSet.add(accountDyn);
                    continue block1;
                }
            }
        }
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_initDirectChildAccount directChildAccountMap\uff1a" + this.directChildAccountMap);
        }
    }

    private void initDetailedAccount(List<AcctFloatQueryFormula> formulas, Table<Long, Long, List<DynamicObject>> accountDynTable, Set<DynamicObject> accountDynSet, Map<DynamicObject, DynPropertyWrapper> accountPropertyMap) {
        this.allDetailedAccountMap = new HashMap<Long, Set<Long>>(8);
        HashSet<DynamicObject> accountSet = new HashSet<DynamicObject>(8);
        long startTime = System.currentTimeMillis();
        int count = 0;
        HashMap<Date, List> dateToAccountListMap = new HashMap<Date, List>(8);
        for (AcctFloatQueryFormula formula : formulas) {
            DynamicObject periodDyn = this.getLastPeriodDyns(formula.getFormulaKey());
            if (formula.getAccountNumberToDynMap().isEmpty() || periodDyn == null) continue;
            List list = dateToAccountListMap.computeIfAbsent(periodDyn.getDate("enddate"), k -> new ArrayList(8));
            List<DynamicObject> accountDynList = this.getAccountListFromTable(formula.getOrgNumber(), formula.getFormulaKey(), accountDynTable);
            if (!CollectionUtils.isNotEmpty(accountDynList)) continue;
            list.add(accountDynList);
        }
        HashMap accountDynToLongNumMap = new HashMap(8);
        HashMap accountDynToIdMap = new HashMap(8);
        accountDynSet.forEach(accountDyn -> {
            DynPropertyWrapper dynPropertyWrapper = (DynPropertyWrapper)accountPropertyMap.get(accountDyn);
            accountDynToLongNumMap.put(accountDyn, (String)dynPropertyWrapper.getValueByPropertyName("longnumber"));
            accountDynToIdMap.put(accountDyn, (Long)dynPropertyWrapper.getValueByPropertyName("id"));
        });
        for (Map.Entry entry : dateToAccountListMap.entrySet()) {
            Date periodEndDate = (Date)entry.getKey();
            for (List accountDynList : (List)entry.getValue()) {
                List allLeafAccountDynList = accountDynList.stream().filter(account -> {
                    DynPropertyWrapper dynPropertyWrapper = (DynPropertyWrapper)accountPropertyMap.get(account);
                    return (Boolean)dynPropertyWrapper.getValueByPropertyName("isleaf") != false && this.isCurPeriod((Date)dynPropertyWrapper.getValueByPropertyName("startdate"), (Date)dynPropertyWrapper.getValueByPropertyName("enddate"), periodEndDate);
                }).collect(Collectors.toList());
                for (DynamicObject accountDyn2 : allLeafAccountDynList) {
                    DynPropertyWrapper dynPropertyWrapper = accountPropertyMap.get(accountDyn2);
                    String longNumber = (String)dynPropertyWrapper.getValueByPropertyName("longnumber");
                    long leafAccountId = (Long)dynPropertyWrapper.getValueByPropertyName("id");
                    for (DynamicObject curAccountDyn : accountDynSet) {
                        ++count;
                        if (curAccountDyn == null) continue;
                        String curLongNumber = (String)accountDynToLongNumMap.get(curAccountDyn);
                        Long curAccountId = (Long)accountDynToIdMap.get(curAccountDyn);
                        if (!longNumber.startsWith(curLongNumber)) continue;
                        Set accountIdSet = this.allDetailedAccountMap.computeIfAbsent(curAccountId, key -> new HashSet(8));
                        accountIdSet.add(leafAccountId);
                        accountSet.add(accountDyn2);
                    }
                }
            }
        }
        long endTime = System.currentTimeMillis();
        accountDynSet.addAll(accountSet);
        if (DebugTrace.enable()) {
            this.log.info("AcctFloatContext_initDetailedAccount allDetailedAccountMap\uff1a" + this.allDetailedAccountMap);
            this.log.info("initDetailedAccount execute count\uff1a" + count);
            this.log.info("init detail account cost time\uff1a" + (endTime - startTime));
        }
    }

    private boolean isDirectChildAccount(String curAcctLongNumber, String longNumber, int curAcctLevel, int level) {
        return longNumber.startsWith(curAcctLongNumber) && level == curAcctLevel + 1;
    }

    private boolean isCurPeriod(Date startDate, Date endDate, Date checkDate) {
        return startDate.compareTo(checkDate) <= 0 && endDate.compareTo(checkDate) >= 0;
    }

    private void initHgByFlexField(List<AcctFloatQueryFormula> formulas) {
        long startTime = System.currentTimeMillis();
        this.flexFieldToHgMap = new HashMap<String, DataSet>(8);
        HashMap<String, Set> allFlexFieldToValueMap = new HashMap<String, Set>(8);
        for (AcctFloatQueryFormula acctFloatQueryFormula : formulas) {
            String assistNumber;
            Object assistToRangeValueEntry2;
            String flexField;
            DynamicObject assistDyn;
            String orgNumber = acctFloatQueryFormula.getOrgNumber();
            Map<String, List<String>> assistToValueNumberMap = acctFloatQueryFormula.getAssistToValueNumberMap();
            for (Map.Entry<String, List<String>> entry : assistToValueNumberMap.entrySet()) {
                String assistNumber2 = entry.getKey();
                List<String> valueNumberList = entry.getValue();
                assistDyn = this.assistMap.get(assistNumber2);
                if (assistDyn == null || !CollectionUtils.isNotEmpty(valueNumberList)) continue;
                flexField = assistDyn.getString("flexfield");
                HashSet<Integer> assistValueIdSet = new HashSet<Integer>(valueNumberList.size());
                for (String valueNumber : valueNumberList) {
                    if (this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber2) != null && CollectionUtils.isNotEmpty((Collection)((Collection)((Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber2)).get(valueNumber)))) {
                        assistValueIdSet.addAll((Collection)((Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber2)).get(valueNumber));
                        continue;
                    }
                    assistValueIdSet.add(-1);
                }
                Set allAssistValueSet = (Set)allFlexFieldToValueMap.get(flexField);
                if (!Objects.isNull(allAssistValueSet) && allAssistValueSet.isEmpty()) continue;
                Set allAssistValueIdSet = allFlexFieldToValueMap.computeIfAbsent(flexField, key -> new HashSet());
                allAssistValueIdSet.addAll(assistValueIdSet);
            }
            Map<String, List<String>> assistToRangeValueMap = acctFloatQueryFormula.getAssistToRangeValueMap();
            for (Object assistToRangeValueEntry2 : assistToRangeValueMap.entrySet()) {
                assistNumber = assistToRangeValueEntry2.getKey();
                List rangeValueList = (List)assistToRangeValueEntry2.getValue();
                DynamicObject assistDyn2 = this.assistMap.get(assistNumber);
                if (assistDyn2 == null || !CollectionUtils.isNotEmpty((Collection)rangeValueList)) continue;
                String flexField2 = assistDyn2.getString("flexfield");
                HashSet<Integer> assistValueIdSet = new HashSet<Integer>(rangeValueList.size());
                for (String rangeValue : rangeValueList) {
                    if (Objects.nonNull(this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)) && CollectionUtils.isNotEmpty((Collection)((Collection)((Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue)))) {
                        assistValueIdSet.addAll((Collection)((Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue));
                        continue;
                    }
                    assistValueIdSet.add(-1);
                }
                Set allAssistValueSet = (Set)allFlexFieldToValueMap.get(flexField2);
                if (!Objects.isNull(allAssistValueSet) && allAssistValueSet.isEmpty()) continue;
                Set allAssistValueIdSet = allFlexFieldToValueMap.computeIfAbsent(flexField2, key -> new HashSet());
                allAssistValueIdSet.addAll(assistValueIdSet);
            }
            Set<String> set = acctFloatQueryFormula.getAllValueAssistNumberSet();
            assistToRangeValueEntry2 = set.iterator();
            while (assistToRangeValueEntry2.hasNext()) {
                assistNumber = (String)assistToRangeValueEntry2.next();
                assistDyn = this.assistMap.get(assistNumber);
                if (assistDyn == null) continue;
                flexField = assistDyn.getString("flexfield");
                allFlexFieldToValueMap.put(flexField, new HashSet());
            }
        }
        for (Map.Entry entry : allFlexFieldToValueMap.entrySet()) {
            String flexField = (String)entry.getKey();
            Set allAssistValueIdSet = (Set)entry.getValue();
            String entityId = this.flexFieldToAssistEntityMap.get(flexField);
            if (!StringUtils.isNotEmpty((CharSequence)entityId)) continue;
            ArrayList<QFilter> arrayList = new ArrayList<QFilter>(8);
            arrayList.add(new QFilter("asstype", "=", (Object)flexField));
            if (CollectionUtils.isNotEmpty((Collection)allAssistValueIdSet)) {
                arrayList.add(new QFilter("assval", "in", (Object)allAssistValueIdSet));
            }
            String selectFields = "hg, assval " + flexField;
            DataSet hg = this.queryHgByFlexField(entityId, selectFields, arrayList, null);
            this.flexFieldToHgMap.put(flexField, hg);
        }
        long endTime = System.currentTimeMillis();
        this.log.info("init hg cost time\uff1a" + (endTime - startTime));
    }

    public DataSet queryHgByFlexField(String entityId, String selectFields, List<QFilter> filters, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys);
    }

    private boolean isRangeAccountNum(String accountNum, String rangeNum) {
        String[] rangeNums = rangeNum.substring(1, rangeNum.length() - 1).split(",");
        return rangeNums.length == 2 && accountNum.compareTo(rangeNums[0]) >= 0 && accountNum.compareTo(rangeNums[1]) <= 0 && accountNum.length() == rangeNums[0].length();
    }

    private void initComAssistKeyToValSource(List<AcctFloatQueryFormula> formulas) {
        this.comAssistToValSourceTable = HashBasedTable.create();
        HashSet<Long> accountTableIdSet = new HashSet<Long>(8);
        for (AcctFloatQueryFormula formula : formulas) {
            long accountTableId = this.accountTableIdMap.getOrDefault(formula.getFormulaKey(), 0L);
            if (accountTableId == 0L) continue;
            accountTableIdSet.add(accountTableId);
        }
        DynamicObjectCollection accountTableDyns = QueryServiceHelper.query((String)"bd_accounttable", (String)"id, comassistentry.seq seq, comassistentry.valuesourcetype valuesourcetype, comassistentry.valuesource valuesource, comassistentry.assistantvaluesource.id assistantvaluesource.id", (QFilter[])new QFilter[]{new QFilter("id", "in", accountTableIdSet)});
        HashBasedTable accountTableIdToDynTable = HashBasedTable.create();
        for (DynamicObject accountTableDyn : accountTableDyns) {
            accountTableIdToDynTable.put((Object)accountTableDyn.getLong("id"), (Object)CommonAssistUtil.getComassistField((int)accountTableDyn.getInt("seq")), (Object)accountTableDyn);
        }
        for (AcctFloatQueryFormula formula : formulas) {
            Map comAssistKeyToDynMap;
            String formulaKey = formula.getFormulaKey();
            long accountTableId = this.accountTableIdMap.getOrDefault(formulaKey, 0L);
            if (accountTableId == 0L || (comAssistKeyToDynMap = accountTableIdToDynTable.row((Object)accountTableId)) == null || comAssistKeyToDynMap.isEmpty()) continue;
            for (Map.Entry comAssistKeyToDynEntry : comAssistKeyToDynMap.entrySet()) {
                String comAssistKey = (String)comAssistKeyToDynEntry.getKey();
                DynamicObject accountTableDyn = (DynamicObject)comAssistKeyToDynEntry.getValue();
                if (accountTableDyn == null) continue;
                String valueSourceType = accountTableDyn.getString("valuesourcetype");
                String entityId = "";
                if (BASE_DATA_TYPE.equals(valueSourceType)) {
                    entityId = accountTableDyn.getString("valuesource");
                } else if ("2".equals(valueSourceType)) {
                    entityId = "bos_assistantdata_detail_" + accountTableDyn.getLong("valuesource");
                }
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                this.comAssistToValSourceTable.put((Object)formulaKey, (Object)comAssistKey, (Object)entityId);
            }
        }
    }

    private void initComAssistValueId(List<AcctFloatQueryFormula> formulas) {
        HashBasedTable allComAssistToValueNumTable = HashBasedTable.create();
        HashBasedTable allComAssistToRangeNumTable = HashBasedTable.create();
        for (AcctFloatQueryFormula formula : formulas) {
            String formulaKey = formula.getFormulaKey();
            String orgNumber = formula.getOrgNumber();
            Map<String, Set<String>> comAssistToValNumMap = formula.getComAssistToValNumMap();
            for (Map.Entry<String, Set<String>> comAssistToValNumEntry : comAssistToValNumMap.entrySet()) {
                String comAssistKey = comAssistToValNumEntry.getKey();
                String valueSource = (String)this.comAssistToValSourceTable.get((Object)formulaKey, (Object)comAssistKey);
                if (!StringUtils.isNotBlank((CharSequence)valueSource)) continue;
                for (String comAssistValNum : comAssistToValNumEntry.getValue()) {
                    HashSet<String> allComAssistValueSet;
                    if (AcctUtil.isRangeValueNumber(comAssistValNum)) {
                        if (allComAssistToRangeNumTable.contains((Object)orgNumber, (Object)valueSource) && allComAssistToRangeNumTable.get((Object)orgNumber, (Object)valueSource) != null) {
                            ((Set)allComAssistToRangeNumTable.get((Object)orgNumber, (Object)valueSource)).add(comAssistValNum);
                            continue;
                        }
                        allComAssistValueSet = new HashSet<String>(8);
                        allComAssistValueSet.add(comAssistValNum);
                        allComAssistToRangeNumTable.put((Object)orgNumber, (Object)valueSource, allComAssistValueSet);
                        continue;
                    }
                    if (allComAssistToValueNumTable.contains((Object)orgNumber, (Object)valueSource) && allComAssistToValueNumTable.get((Object)orgNumber, (Object)valueSource) != null) {
                        ((Set)allComAssistToValueNumTable.get((Object)orgNumber, (Object)valueSource)).add(comAssistValNum);
                        continue;
                    }
                    allComAssistValueSet = new HashSet(8);
                    allComAssistValueSet.add(comAssistValNum);
                    allComAssistToValueNumTable.put((Object)orgNumber, (Object)valueSource, allComAssistValueSet);
                }
            }
        }
        this.comAssistDispersedValIdTable = AcctUtil.queryComAssistDispersedValueId((Table<String, String, Set<String>>)allComAssistToValueNumTable, this.orgNumberToIdMap);
        this.comAssistRangeValIdTable = AcctUtil.queryComAssistRangeValueId((Table<String, String, Set<String>>)allComAssistToRangeNumTable, this.orgNumberToIdMap, this.standardMap, this.groupMap);
    }

    public AcctFloatQueryParam getAcctFloatQueryParam() {
        return this.acctFloatQueryParam;
    }

    public void setAcctFloatQueryParam(AcctFloatQueryParam acctFloatQueryParam) {
        this.acctFloatQueryParam = acctFloatQueryParam;
    }

    public Map<String, Long> getOrgNumberToIdMap() {
        return this.orgNumberToIdMap;
    }

    public void setOrgNumberToIdMap(Map<String, Long> orgNumberToIdMap) {
        this.orgNumberToIdMap = orgNumberToIdMap;
    }

    public Map<String, Long> getBookTypeNumberToIdMap() {
        return this.bookTypeNumberToIdMap;
    }

    public void setBookTypeNumberToIdMap(Map<String, Long> bookTypeNumberToIdMap) {
        this.bookTypeNumberToIdMap = bookTypeNumberToIdMap;
    }

    public Map<String, DynamicObject> getAccountBookMap() {
        return this.accountBookMap;
    }

    public void setAccountBookMap(Map<String, DynamicObject> accountBookMap) {
        this.accountBookMap = accountBookMap;
    }

    public Map<String, List<DynamicObject>> getPeriodMap() {
        return this.periodMap;
    }

    public void setPeriodMap(Map<String, List<DynamicObject>> periodMap) {
        this.periodMap = periodMap;
    }

    public Map<String, Map<String, DynamicObject>> getFormulaToAccountsMap() {
        return this.formulaToAccountsMap;
    }

    public void setFormulaToAccountsMap(Map<String, Map<String, DynamicObject>> formulaToAccountsMap) {
        this.formulaToAccountsMap = formulaToAccountsMap;
    }

    public Map<String, Long> getAccountTableIdMap() {
        return this.accountTableIdMap;
    }

    public void setAccountTableIdMap(Map<String, Long> accountTableIdMap) {
        this.accountTableIdMap = accountTableIdMap;
    }

    public Map<String, Long> getCurrencyNumberToIdMap() {
        return this.currencyNumberToIdMap;
    }

    public void setCurrencyNumberToIdMap(Map<String, Long> currencyNumberToIdMap) {
        this.currencyNumberToIdMap = currencyNumberToIdMap;
    }

    public Map<Long, Long> getAccountIdToMasterIdMap() {
        return this.accountIdToMasterIdMap;
    }

    public void setAccountIdToMasterIdMap(Map<Long, Long> accountIdToMasterIdMap) {
        this.accountIdToMasterIdMap = accountIdToMasterIdMap;
    }

    public Map<Long, Set<Long>> getDirectChildAccountMap() {
        return this.directChildAccountMap;
    }

    public void setDirectChildAccountMap(Map<Long, Set<Long>> directChildAccountMap) {
        this.directChildAccountMap = directChildAccountMap;
    }

    public Map<Long, Set<Long>> getAllDetailedAccountMap() {
        return this.allDetailedAccountMap;
    }

    public void setAllDetailedAccountMap(Map<Long, Set<Long>> allDetailedAccountMap) {
        this.allDetailedAccountMap = allDetailedAccountMap;
    }

    public Map<String, DynamicObject> getAssistMap() {
        return this.assistMap;
    }

    public void setAssistMap(Map<String, DynamicObject> assistMap) {
        this.assistMap = assistMap;
    }

    public Map<Long, Set<String>> getAccountIdToFlexFieldMap() {
        return this.accountIdToFlexFieldMap;
    }

    public void setAccountIdToFlexFieldMap(Map<Long, Set<String>> accountIdToFlexFieldMap) {
        this.accountIdToFlexFieldMap = accountIdToFlexFieldMap;
    }

    public Map<String, String> getFlexFieldToAssistEntityMap() {
        return this.flexFieldToAssistEntityMap;
    }

    public void setFlexFieldToAssistEntityMap(Map<String, String> flexFieldToAssistEntityMap) {
        this.flexFieldToAssistEntityMap = flexFieldToAssistEntityMap;
    }

    public Table<String, String, Map<String, Set<Object>>> getAssistValueNumberToIdTable() {
        return this.assistValueNumberToIdTable;
    }

    public void setAssistValueNumberToIdTable(Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable) {
        this.assistValueNumberToIdTable = assistValueNumberToIdTable;
    }

    public Table<String, String, Map<String, Set<Object>>> getAssistRangeValToIdTable() {
        return this.assistRangeValToIdTable;
    }

    public void setAssistRangeValToIdTable(Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable) {
        this.assistRangeValToIdTable = assistRangeValToIdTable;
    }

    public Map<Long, String> getAccountIdToNumberMap() {
        return this.accountIdToNumberMap;
    }

    public void setAccountIdToNumberMap(Map<Long, String> accountIdToNumberMap) {
        this.accountIdToNumberMap = accountIdToNumberMap;
    }

    public Map<String, DataSet> getFlexFieldToHgMap() {
        return this.flexFieldToHgMap;
    }

    public void setFlexFieldToHgMap(Map<String, DataSet> flexFieldToHgMap) {
        this.flexFieldToHgMap = flexFieldToHgMap;
    }

    public Table<String, String, Map<Object, Set<String>>> getAssistValIdToNumTable() {
        return this.assistValIdToNumTable;
    }

    public void setAssistValIdToNumTable(Table<String, String, Map<Object, Set<String>>> assistValIdToNumTable) {
        this.assistValIdToNumTable = assistValIdToNumTable;
    }

    public Table<String, String, String> getComAssistToValSourceTable() {
        return this.comAssistToValSourceTable;
    }

    public void setComAssistToValSourceTable(Table<String, String, String> comAssistToValSourceTable) {
        this.comAssistToValSourceTable = comAssistToValSourceTable;
    }

    public Table<String, String, Map<String, Set<Long>>> getComAssistDispersedValIdTable() {
        return this.comAssistDispersedValIdTable;
    }

    public void setComAssistDispersedValIdTable(Table<String, String, Map<String, Set<Long>>> comAssistDispersedValIdTable) {
        this.comAssistDispersedValIdTable = comAssistDispersedValIdTable;
    }

    public Table<String, String, Map<String, Set<Long>>> getComAssistRangeValIdTable() {
        return this.comAssistRangeValIdTable;
    }

    public void setComAssistRangeValIdTable(Table<String, String, Map<String, Set<Long>>> comAssistRangeValIdTable) {
        this.comAssistRangeValIdTable = comAssistRangeValIdTable;
    }

    public HasPermOrgResult getAllPermOrgIdSet() {
        return this.permOrgResult;
    }

    public String getPermName() {
        return this.permName;
    }
}

