/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.event.AbstractOrgChangeEventServicePlugin;
import kd.bos.org.model.OrgChangeCheckReport;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.gl.acct.action.AcctBalParseAction;
import kd.fi.gl.business.service.orgrootchange.BaseDataServiceHelper;
import kd.fi.gl.business.service.orgrootchange.OrgViewServiceHelper;

public class OrgRootChangeServicePlugin
extends AbstractOrgChangeEventServicePlugin {
    private static final Log log = LogFactory.getLog(AcctBalParseAction.class);
    private static final Long ACCT_VIEW_ID = 10L;

    protected OrgChangeCheckReport handleEventAndReturnCheckReport(KDBizEvent evt) {
        OrgChangeCheckReport orgChangeCheckReport = new OrgChangeCheckReport();
        orgChangeCheckReport.setCheckStatus("P");
        String variableStr = evt.getVariables();
        JSONObject variables = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
        Object subscriptionId = variables.get((Object)"subscription_id");
        if (Objects.nonNull(subscriptionId)) {
            orgChangeCheckReport.setEventId(Long.valueOf(subscriptionId.toString()));
        }
        JSONObject operationParams = variables.getJSONObject("base_orgchange_resetroot");
        String changeRecordId = operationParams.getString("changerecordid");
        orgChangeCheckReport.setChangeRecordId(Long.valueOf(changeRecordId));
        JSONArray synViewArray = operationParams.getJSONArray("synviews");
        if (CollectionUtils.isEmpty((Collection)synViewArray)) {
            orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u901a\u8fc7\u3002", (String)"OrgRootChangeServicePlugin_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return orgChangeCheckReport;
        }
        long oldRootId = 0L;
        long newRootId = 0L;
        for (int i = 0; i < synViewArray.size(); ++i) {
            JSONObject jsonObject = synViewArray.getJSONObject(i);
            if (!Objects.equals(jsonObject.getLong("viewid"), ACCT_VIEW_ID)) continue;
            oldRootId = jsonObject.getLong("oldrootid");
            newRootId = jsonObject.getLong("newrootid");
            break;
        }
        if (oldRootId != 0L && newRootId != 0L) {
            BaseDataServiceHelper baseDataServiceHelper = new BaseDataServiceHelper();
            DynamicObject record = baseDataServiceHelper.saveChangeRecord(oldRootId, newRootId);
            try {
                List checkDetails = baseDataServiceHelper.changeRootOrgBdUp(oldRootId, newRootId);
                OrgViewServiceHelper orgViewServiceHelper = new OrgViewServiceHelper();
                List viewCheckDetails = orgViewServiceHelper.changeRootOrgViewUp(oldRootId, newRootId);
                checkDetails.addAll(viewCheckDetails);
                if (checkDetails.size() > 0) {
                    orgChangeCheckReport.setCheckStatus("W");
                    orgChangeCheckReport.setDetails(checkDetails);
                    record.set("executionstatus", (Object)"2");
                } else {
                    record.set("executionstatus", (Object)"1");
                }
                baseDataServiceHelper.saveChangeResult(record, checkDetails);
            }
            catch (Exception e) {
                log.error("\u603b\u8d26\u91cd\u7f6e\u6839\u7ec4\u7ec7\u5347\u7ea7\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5931\u8d25\u3002", (Throwable)e);
                orgChangeCheckReport.setCheckStatus("W");
                String result = ResManager.loadKDString((String)"\u603b\u8d26\u91cd\u7f6e\u6839\u7ec4\u7ec7\u5347\u7ea7\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"OrgRootChangeServicePlugin_2", (String)"fi-gl-mservice", (Object[])new Object[]{e.getMessage()});
                orgChangeCheckReport.setCheckResult(result);
                record.set("executionstatus", (Object)"2");
                record.set("result", (Object)StringUtils.substring((String)result, (int)0, (int)200));
                baseDataServiceHelper.saveChangeResult(record, null);
            }
        }
        return orgChangeCheckReport;
    }
}

