/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.service.AccountingSysService;

public class AccountingSysServiceImpl
implements AccountingSysService {
    private static final Log LOGGER = LogFactory.getLog(AccountingSysServiceImpl.class);
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"gl");
    private static final int TYPE_SUCCES = 0;
    private static final int TYPE_ORGIDS_IS_NULL = 1;
    private static final int TYPE_ORG_NOT_ACCOUNTING = 2;
    private static final int TYPE_NO_LEGAL_ACCOUNTSYS = 3;
    private static final int TYPE_TWO_LEGAL_ACCOUNTSYS = 4;
    private static final int TYPE_ORG_OVER_LEGAL = 5;
    private static final int TYPE_ORG_NOT_IN_LEGAL = 6;

    public Map<String, Object> checkBizOrgsIsAcrossLegal(List<Long> orgIds) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (orgIds == null || orgIds.isEmpty()) {
            LOGGER.info("AccountingSysServiceImpl_size==0");
            result.put("issucces", false);
            result.put("code", 1);
            result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"AccountingSysServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return result;
        }
        StringBuilder orgIdStr = new StringBuilder();
        orgIdStr.append("AccountingSysServiceImpl_orgids:");
        orgIds.forEach(orgId -> orgIdStr.append(orgId).append(","));
        LOGGER.info(orgIdStr.toString());
        QFilter pkFilter = new QFilter("id", "in", orgIds);
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,enable,fisaccounting", (QFilter[])new QFilter[]{pkFilter});
        ArrayList<Long> acctOrgIds = new ArrayList<Long>(orgIds.size());
        HashMap<Long, DynamicObject> acctOrgMap = new HashMap<Long, DynamicObject>(orgIds.size());
        for (DynamicObject org : orgs) {
            acctOrgIds.add(org.getLong("id"));
            acctOrgMap.put(org.getLong("id"), org);
        }
        orgIds.removeAll(acctOrgIds);
        ArrayList<String> messages = new ArrayList<String>(10);
        StringBuilder message = new StringBuilder();
        if (orgIds.size() > 0) {
            for (Long orgId2 : orgIds) {
                message.append(orgId2);
                message.append(",");
            }
            message.append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u975e\u6838\u7b97\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u786e\u5b9a\u662f\u5426\u8de8\u6cd5\u4eba\u3002", (String)"AccountingSysServiceImpl_2", (String)"fi-gl-mservice", (Object[])new Object[0]));
            messages.add(message.toString());
        }
        for (DynamicObject org : orgs) {
            Long id = org.getLong("id");
            String name = org.getString("name");
            Boolean fisaccounting = org.getBoolean("fisaccounting");
            if (fisaccounting.booleanValue()) continue;
            message.delete(0, message.length());
            message.append(name).append("(").append(id).append(")").append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u975e\u6838\u7b97\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u786e\u5b9a\u662f\u5426\u8de8\u6cd5\u4eba\u3002", (String)"AccountingSysServiceImpl_2", (String)"fi-gl-mservice", (Object[])new Object[0]));
            messages.add(message.toString());
        }
        if (messages.size() > 0) {
            result.put("issucces", false);
            result.put("code", 2);
            result.put("message", String.join((CharSequence)",", messages));
            return result;
        }
        QFilter islegal = new QFilter("islegal", "=", (Object)true);
        DynamicObject[] legalAccountingsyss = BusinessDataServiceHelper.load((String)"bd_accountingsys", (String)"id", (QFilter[])new QFilter[]{islegal});
        if (legalAccountingsyss == null || legalAccountingsyss.length == 0) {
            result.put("issucces", false);
            result.put("code", 3);
            result.put("message", ResManager.loadKDString((String)"\u6cd5\u4eba\u6838\u7b97\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"AccountingSysServiceImpl_3", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return result;
        }
        if (legalAccountingsyss.length > 1) {
            result.put("issucces", false);
            result.put("code", 4);
            result.put("message", ResManager.loadKDString((String)"\u6cd5\u4eba\u6838\u7b97\u4f53\u7cfb\u8d85\u8fc7\u4e24\u4e2a\u3002", (String)"AccountingSysServiceImpl_4", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return result;
        }
        long legalAccountingSysId = legalAccountingsyss[0].getLong("id");
        HashSet<Long> legalAcctOrgIds = new HashSet<Long>(10);
        HashSet<Long> bizAcctOrgIds = new HashSet<Long>(10);
        try (DataSet dt = BatchProcessUtil.batchQueryDataSet(acctOrgIds, batchOrgs -> {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fbizorgid,fbizacctorgid from t_bd_accountingsys_bizorg where fid = ?", new Object[]{legalAccountingSysId});
            sqlBuilder.appendIn("and fbizorgid", acctOrgIds.toArray());
            return DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DB_ROUTE, (SqlBuilder)sqlBuilder);
        });){
            for (Row row : dt) {
                legalAcctOrgIds.add(row.getLong("fbizorgid"));
                bizAcctOrgIds.add(row.getLong("fbizacctorgid"));
            }
        }
        acctOrgIds.removeAll(legalAcctOrgIds);
        if (acctOrgIds.size() > 0) {
            for (Long bizorgid : acctOrgIds) {
                DynamicObject org = (DynamicObject)acctOrgMap.get(bizorgid);
                String name = org.getString("name");
                message.delete(0, message.length());
                message.append(name).append("(").append(bizorgid).append(")").append(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u8de8\u6cd5\u4eba", (String)"AccountingSysServiceImpl_7", (String)"fi-gl-mservice", (Object[])new Object[0]));
                messages.add(message.toString());
            }
            result.put("issucces", false);
            result.put("code", 6);
            result.put("message", String.join((CharSequence)",", messages));
            return result;
        }
        if (bizAcctOrgIds.size() > 1) {
            result.put("issucces", false);
            result.put("code", 5);
            result.put("message", ResManager.loadKDString((String)"\u7ec4\u7ec7\u8de8\u6cd5\u4eba", (String)"AccountingSysServiceImpl_5", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return result;
        }
        result.put("issucces", true);
        result.put("code", 0);
        result.put("message", ResManager.loadKDString((String)"\u6240\u4f20\u7ec4\u7ec7\u4e0d\u8de8\u6cd5\u4eba\u3002", (String)"AccountingSysServiceImpl_6", (String)"fi-gl-mservice", (Object[])new Object[0]));
        return result;
    }
}

