/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.acctcf.AcctCFQueryExecutor;
import kd.fi.gl.cashflow.CashFlowQueryExecutor;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.service.CashflowQueryParam;
import kd.fi.gl.service.CashflowService;
import kd.fi.gl.util.GLServiceUtils;

public class CashflowServiceImpl
implements CashflowService {
    private static final Log LOG = LogFactory.getLog(CashflowServiceImpl.class);
    private static final String CFITEM = "cfitem";
    private static final String CURRENCY = "currency";
    public static final String AMOUNT = "amount";
    public static final String YEARAMOUNT = "yearamount";
    private CashflowQueryParam queryParam;

    public String getCashFlowAmount(String param) {
        try {
            LOG.info("\u603b\u8d26\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u53c2\u6570\uff1a" + param);
            this.queryParam = (CashflowQueryParam)JSONUtils.cast((String)param, CashflowQueryParam.class);
            List<Map<String, Object>> data = null;
            if (this.queryParam.getSelector().contains(AMOUNT)) {
                data = this.getCashFlowAmountData(this.queryParam);
            } else if (this.queryParam.getSelector().contains(YEARAMOUNT)) {
                data = this.getCashFlowYearAmountData(this.queryParam);
            }
            LOG.info("\u603b\u8d26\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u7ed3\u679c\uff1a" + data);
            return JSONUtils.toString(data);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public List<Map<String, Object>> getCashFlowAmount(long orgId, long bookTypeId, long periodId, long[] cfitemIds) {
        return this.getCashFlow(orgId, bookTypeId, periodId, cfitemIds, this.queryParam.getAssgrp());
    }

    public List<Map<String, Object>> getCashFlowYearAmount(long orgId, long bookTypeId, long periodId, long[] cfitemIds) {
        return this.getCashFlow(orgId, bookTypeId, periodId, cfitemIds, this.queryParam.getAssgrp());
    }

    public String getCashFlowAmountFromBCM(String param) {
        return AcctCFQueryExecutor.getInstance().getCashflow(param);
    }

    public List<Map<String, Object>> getCashFlowAmountData(CashflowQueryParam param) {
        this.queryParam = param;
        LOG.info("\u6267\u884c\u672c\u671f\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3");
        return this.getCashFlowAmount(param.getOrgId(), param.getBookTypeId(), param.getPeriodId(), param.getCfitemIds());
    }

    public List<Map<String, Object>> getCashFlowYearAmountData(CashflowQueryParam param) {
        this.queryParam = param;
        LOG.info("\u6267\u884c\u672c\u5e74\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3");
        return this.getCashFlowYearAmount(param.getOrgId(), param.getBookTypeId(), param.getPeriodId(), param.getCfitemIds());
    }

    private List<Map<String, Object>> getCashFlow(long orgId, long bookTypeId, long periodId, long[] cfitemIds, Map<String, Object> assgrpMap) {
        LOG.info("\u603b\u8d26\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u53c2\u6570\uff1aorgid:" + orgId + "bookTypeId:" + bookTypeId + "periodId:" + periodId + "cfitemIds:" + cfitemIds + "assgrpMap:" + assgrpMap);
        HashSet<String> selectors = new HashSet<String>(16);
        HashSet<String> groupByFieldSet = new HashSet<String>(8);
        HashSet<String> amountFieldSet = new HashSet<String>(4);
        this.initQueryFields(selectors, amountFieldSet);
        groupByFieldSet.addAll(this.queryParam.getGroupBy());
        Set<Long> cfitemIdSet = this.getCfitemIds(cfitemIds);
        if (cfitemIdSet.isEmpty()) {
            return null;
        }
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (accountBookInfo.getCashinitPeriodId() == 0L || accountBookInfo.getCashinitPeriodId() > periodId) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8d26\u7c3f\u672a\u8bbe\u7f6e\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u6216\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u5927\u4e8e\u67e5\u8be2\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u8d26\u7c3f\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u662f\u5426\u6b63\u786e\u3002", (String)"CashflowServiceImpl_11", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        HashSet<String> flexEmptyValFields = new HashSet<String>(8);
        HashMap<String, Set<Object>> flexToValsMap = new HashMap<String, Set<Object>>(8);
        GLServiceUtils.getFlexAndVals(assgrpMap, flexEmptyValFields, flexToValsMap);
        HashSet<String> allFlexSet = new HashSet<String>(8);
        allFlexSet.addAll(flexEmptyValFields);
        allFlexSet.addAll(flexToValsMap.keySet());
        selectors.removeAll(allFlexSet);
        for (Map.Entry<String, List<Long>> entry : this.queryParam.getComassit().entrySet()) {
            filters.add(new QFilter(entry.getKey(), "in", entry.getValue()));
        }
        filters.addAll(this.getAssistMetaQfilter(flexEmptyValFields, flexToValsMap));
        filters.add(new QFilter(CFITEM, "in", cfitemIdSet));
        String selectStr = ((Object)selectors).toString().substring(1, ((Object)selectors).toString().length() - 1);
        String flexMetaFieldSet = this.getFlexMetaField(allFlexSet);
        selectStr = selectStr + flexMetaFieldSet;
        MainEntityType cashflowEntity = GLServiceUtils.getCashflowMainEntityType(allFlexSet);
        DataSet cashflowData = CashFlowQueryExecutor.getInstance().getCashFlowEntity(this.getClass().getName(), selectStr, new long[]{orgId}, bookTypeId, periodId, periodId, filters.toArray(new QFilter[0]), cashflowEntity);
        List<Map<String, Object>> resultList = this.getCashflowResultList(cashflowData, groupByFieldSet, amountFieldSet);
        LOG.info("\u603b\u8d26\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u7ed3\u679c\uff1alist:" + resultList.toString());
        return resultList;
    }

    private Set<Long> getCfitemIds(long[] cfitemIds) {
        HashSet<Long> cfitemSet = new HashSet(8);
        if (cfitemIds != null && cfitemIds.length > 0) {
            cfitemSet.addAll(CollectionUtils.arrayToList((Object)cfitemIds));
        } else {
            cfitemSet = this.queryParam.getCfitemAssgrp().keySet();
        }
        return cfitemSet;
    }

    private List<QFilter> getAssistMetaQfilter(Set<String> flexEmptyValFields, Map<String, Set<Object>> flexToValsMap) {
        String assgrpPrefix = "assgrp_";
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>(8);
        for (String string : flexEmptyValFields) {
            customFilters.add(QFilter.join((String)(assgrpPrefix + string), (String)(assgrpPrefix + string + ".hg"), (QFilter)new QFilter(assgrpPrefix + string + ".asstype", "=", (Object)string), (ORMHint.JoinHint)(this.queryParam.isQueryAll() ? ORMHint.JoinHint.LEFT : ORMHint.JoinHint.INNER), (boolean)false));
        }
        for (Map.Entry entry : flexToValsMap.entrySet()) {
            String flex = (String)entry.getKey();
            Set valSet = (Set)entry.getValue();
            QFilter fflex = new QFilter(assgrpPrefix + flex + ".asstype", "=", (Object)flex);
            QFilter fvalue = new QFilter(assgrpPrefix + flex + ".assval", "in", (Object)valSet);
            customFilters.add(fflex);
            customFilters.add(fvalue);
        }
        return customFilters;
    }

    private String getFlexMetaField(Set<String> flexSet) {
        StringBuilder flexBuilder = new StringBuilder();
        for (String flex : flexSet) {
            flexBuilder.append(",");
            flexBuilder.append(" assgrp_");
            flexBuilder.append(flex);
            flexBuilder.append(".assval ");
            flexBuilder.append(flex);
        }
        return flexBuilder.toString();
    }

    private void initQueryFields(Set<String> selectors, Set<String> amountVals) {
        selectors.addAll(this.queryParam.getSelector());
        selectors.addAll(this.queryParam.getGroupBy());
        selectors.add(CFITEM);
        selectors.add(CURRENCY);
        if (selectors.contains(AMOUNT)) {
            amountVals.add(AMOUNT);
        }
        if (selectors.contains(YEARAMOUNT)) {
            amountVals.add(YEARAMOUNT);
        }
        if (amountVals.isEmpty()) {
            amountVals.add(AMOUNT);
            amountVals.add(YEARAMOUNT);
        }
    }

    private List<Map<String, Object>> getCashflowResultList(DataSet cashflowData, Set<String> groupBySet, Set<String> amountSet) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(1024);
        if (cashflowData != null) {
            ArrayList<String> aliasList = new ArrayList<String>(groupBySet.size());
            for (String string : groupBySet) {
                String[] groupBys = string.split(" ");
                String aliasField = groupBys.length == 2 ? groupBys[1] : groupBys[0];
                aliasList.add(aliasField);
            }
            GroupbyDataSet gds = cashflowData.groupBy(aliasList.toArray(new String[0]));
            for (String amountVal : amountSet) {
                gds = gds.sum(amountVal);
            }
            cashflowData = gds.finish();
            List<String> list = GLServiceUtils.getFieldsByDs(cashflowData);
            for (Row row : cashflowData) {
                HashMap<String, Object> map = new HashMap<String, Object>(list.size());
                for (String field : groupBySet) {
                    Object val = row.get(field);
                    map.put(field, val);
                }
                for (String field : amountSet) {
                    map.put(field, row.getBigDecimal(field));
                }
                resultList.add(map);
            }
        }
        return resultList;
    }
}

