/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.util.FdaFormUtil;
import kd.fi.gl.util.TaxReportFormHelper;

public class FdaFinancialKpiGetValueHelp {
    public static Map<String, BigDecimal> getBalanceValue(List<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision, Map<String, BigDecimal> map) {
        List equiteyResultList;
        List resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"balancesheet", (String)"assetentryentity", (int)amtprecision, (boolean)true);
        if (!resultList.isEmpty()) {
            FdaFinancialKpiGetValueHelp.dealBalanceSheetEdit(resultList, map, orgIds, accTableId, bookTypeId, "assetentryentity");
        }
        if (!(equiteyResultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"balancesheet", (String)"equityentryentity", (int)amtprecision, (boolean)true)).isEmpty()) {
            FdaFinancialKpiGetValueHelp.dealBalanceSheetEdit(equiteyResultList, map, orgIds, accTableId, bookTypeId, "equityentryentity");
        }
        return map;
    }

    private static Map<String, BigDecimal> dealBalance(List<List<BigDecimal>> resultList, Map<String, BigDecimal> map, List<Long> orgIds, Long acctTableId, Long acctBookTypeId) {
        Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
        DynamicObjectCollection collection = TaxReportFormHelper.getBalSheets(Collections.singleton(orgId), (long)acctTableId, (QFilter[])new QFilter("booktype", "=", (Object)acctBookTypeId).toArray());
        if (collection.isEmpty()) {
            return map;
        }
        ArrayList<String> itemList1 = new ArrayList<String>();
        ArrayList<String> itemList2 = new ArrayList<String>();
        for (DynamicObject dyn : collection) {
            itemList1.add(dyn.getString("asset"));
            itemList2.add(dyn.getString("equity"));
        }
        for (int i = 0; i < resultList.size(); ++i) {
            map.put((String)itemList1.get(i) + "1", resultList.get(i).get(0));
            map.put((String)itemList1.get(i) + "2", resultList.get(i).get(1));
            map.put((String)itemList2.get(i) + "1", resultList.get(i).get(2));
            map.put((String)itemList2.get(i) + "2", resultList.get(i).get(3));
        }
        return map;
    }

    private static void dealBalanceSheetEdit(List<List<BigDecimal>> resultList, Map<String, BigDecimal> map, List<Long> orgIds, Long acctTableId, Long acctBookTypeId, String entryName) {
        block8: {
            Set glBalanceSheetEntries;
            Long orgId;
            block7: {
                orgId = TaxReportFormHelper.getParentOrg(orgIds);
                MainEntityType balancesheetEdit = EntityMetadataCache.getDataEntityType((String)"gl_balancesheetedit");
                glBalanceSheetEntries = balancesheetEdit.getAllEntities().keySet();
                if (!glBalanceSheetEntries.contains(entryName)) break block7;
                DynamicObjectCollection collection = TaxReportFormHelper.getBalSheetsByEntryName(Collections.singleton(orgId), (long)acctTableId, (QFilter[])new QFilter("booktype", "=", (Object)acctBookTypeId).toArray(), (String)entryName);
                if (collection == null) break block8;
                ArrayList<String> itemList = new ArrayList<String>(collection.size());
                for (DynamicObject dyn : collection) {
                    if ("assetentryentity".equals(entryName)) {
                        itemList.add(dyn.getString("asset"));
                        continue;
                    }
                    itemList.add(dyn.getString("equity"));
                }
                for (int i = 0; i < resultList.size(); ++i) {
                    map.put((String)itemList.get(i) + "1", resultList.get(i).get(0));
                    map.put((String)itemList.get(i) + "2", resultList.get(i).get(1));
                }
                break block8;
            }
            if (glBalanceSheetEntries.contains("entryentity")) {
                DynamicObjectCollection collection = TaxReportFormHelper.getBalSheets(Collections.singleton(orgId), (long)acctTableId, (QFilter[])new QFilter("booktype", "=", (Object)acctBookTypeId).toArray());
                if (collection.isEmpty()) {
                    return;
                }
                ArrayList<String> itemList1 = new ArrayList<String>(collection.size());
                ArrayList<String> itemList2 = new ArrayList<String>(collection.size());
                for (DynamicObject dyn : collection) {
                    itemList1.add(dyn.getString("asset"));
                    itemList2.add(dyn.getString("equity"));
                }
                for (int i = 0; i < resultList.size(); ++i) {
                    map.put((String)itemList1.get(i) + "1", resultList.get(i).get(0));
                    map.put((String)itemList1.get(i) + "2", resultList.get(i).get(1));
                    map.put((String)itemList2.get(i) + "1", resultList.get(i).get(2));
                    map.put((String)itemList2.get(i) + "2", resultList.get(i).get(3));
                }
            }
        }
    }

    public static Map<String, BigDecimal> getIncomeValue(List<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision, Map<String, BigDecimal> map, boolean isNeedPreYear) {
        List resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"income", (int)2, (int)amtprecision);
        Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
        DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdit(Collections.singleton(orgId), (long)accTableId, (String)"income", (QFilter[])new QFilter("booktype", "=", (Object)bookTypeId).toArray());
        if (!resultList.isEmpty()) {
            map = FdaFinancialKpiGetValueHelp.dealShowincome(resultList, map, 1, collection);
            if (isNeedPreYear) {
                DynamicObject preYearPeriodDyn = FdaFormUtil.getSamePeriodOfYear(periodId, 1);
                long preYearPeriodId = preYearPeriodDyn == null ? 0L : preYearPeriodDyn.getLong("id");
                resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)preYearPeriodId, (String)"income", (int)2, (int)amtprecision);
                if (!resultList.isEmpty()) {
                    map = FdaFinancialKpiGetValueHelp.dealShowincome(resultList, map, 3, collection);
                }
            }
        }
        return map;
    }

    private static Map<String, BigDecimal> dealShowincome(List<List<BigDecimal>> list, Map<String, BigDecimal> map, int able, DynamicObjectCollection collection) {
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Integer, Long> indexMap = new HashMap<Integer, Long>();
        for (DynamicObject dyn : collection) {
            ids.add(dyn.getLong("project"));
            indexMap.put(dyn.getInt("balrowid"), dyn.getLong("project"));
        }
        DynamicObjectCollection items = QueryServiceHelper.query((String)"gl_manage_rptitem", (String)"id,number", (QFilter[])new QFilter("id", "in", ids).toArray());
        HashMap<Long, String> itemNumbers = new HashMap<Long, String>();
        for (DynamicObject item : items) {
            itemNumbers.put(item.getLong("id"), item.getString("number"));
        }
        for (int i = 0; i < list.size(); ++i) {
            map.put((String)itemNumbers.get(indexMap.get(i)) + able, list.get(i).get(0));
            map.put((String)itemNumbers.get(indexMap.get(i)) + (able + 1), list.get(i).get(1));
        }
        return map;
    }

    public static Map<String, BigDecimal> getTaxShowValue(List<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision, Map<String, BigDecimal> map) {
        DynamicObject preYearPeriodDyn;
        long preYearPeriodId;
        DynamicObject prePeriodDyn;
        long prePeriodId;
        ArrayList<String> itemlist = new ArrayList<String>();
        Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
        DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdits(Collections.singleton(orgId), (long)accTableId, (String)"taxshow", (QFilter[])new QFilter("booktype", "=", (Object)bookTypeId).toArray());
        for (DynamicObject dyn : collection) {
            itemlist.add(dyn.getString("number"));
        }
        List resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"taxshow", (int)2, (int)amtprecision);
        if (!resultList.isEmpty()) {
            for (int i = 0; i < itemlist.size(); ++i) {
                map.put((String)itemlist.get(i) + "1", (BigDecimal)((List)resultList.get(i)).get(0));
                map.put((String)itemlist.get(i) + "2", (BigDecimal)((List)resultList.get(i)).get(1));
            }
        }
        long l = prePeriodId = (prePeriodDyn = FdaFormUtil.getPreviousPeriod(periodId)) == null ? 0L : prePeriodDyn.getLong("id");
        if (prePeriodDyn != null && !(resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)prePeriodId, (String)"taxshow", (int)2, (int)amtprecision)).isEmpty()) {
            for (int i = 0; i < itemlist.size(); ++i) {
                map.put((String)itemlist.get(i) + "3", (BigDecimal)((List)resultList.get(i)).get(0));
                map.put((String)itemlist.get(i) + "4", (BigDecimal)((List)resultList.get(i)).get(1));
            }
        }
        long l2 = preYearPeriodId = (preYearPeriodDyn = FdaFormUtil.getSamePeriodOfYear(periodId, 1)) == null ? 0L : preYearPeriodDyn.getLong("id");
        if (preYearPeriodDyn != null && !(resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)preYearPeriodId, (String)"taxshow", (int)2, (int)amtprecision)).isEmpty()) {
            for (int i = 0; i < itemlist.size(); ++i) {
                map.put((String)itemlist.get(i) + "5", (BigDecimal)((List)resultList.get(i)).get(0));
                map.put((String)itemlist.get(i) + "6", (BigDecimal)((List)resultList.get(i)).get(1));
            }
        }
        return map;
    }

    public static Map<String, BigDecimal> getCashFlowStatValue(List<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision, Map<String, BigDecimal> map) {
        DynamicObject preYearPeriodDyn;
        long preYearPeriodId;
        List resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"cashflow", (int)2, (int)amtprecision);
        Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
        DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdits(Collections.singleton(orgId), (long)accTableId, (String)"cashflow", (QFilter[])new QFilter("booktype", "=", (Object)bookTypeId).toArray());
        if (!resultList.isEmpty()) {
            map = FdaFinancialKpiGetValueHelp.dealCashFlowStat(resultList, map, collection, 1);
        }
        long l = preYearPeriodId = (preYearPeriodDyn = FdaFormUtil.getSamePeriodOfYear(periodId, 1)) == null ? 0L : preYearPeriodDyn.getLong("id");
        if (preYearPeriodDyn != null && !(resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)preYearPeriodId, (String)"cashflow", (int)2, (int)amtprecision)).isEmpty()) {
            map = FdaFinancialKpiGetValueHelp.dealCashFlowStat(resultList, map, collection, 2);
        }
        return map;
    }

    private static Map<String, BigDecimal> dealCashFlowStat(List<List<BigDecimal>> list, Map<String, BigDecimal> map, DynamicObjectCollection collection, int able) {
        ArrayList<String> itemlist = new ArrayList<String>();
        for (DynamicObject dyn : collection) {
            itemlist.add(dyn.getString("number"));
        }
        for (int i = 0; i < itemlist.size(); ++i) {
            map.put((String)itemlist.get(i) + able, list.get(i).get(0));
        }
        BigDecimal cashIn1 = FdaFinancialKpiGetValueHelp.getSum(list, 2, 4, able);
        map.put("100205" + able, cashIn1);
        BigDecimal cashOut1 = FdaFinancialKpiGetValueHelp.getSum(list, 6, 9, able);
        map.put("100210" + able, cashOut1);
        BigDecimal cashNet1 = cashIn1.subtract(cashOut1);
        map.put("100211" + able, cashNet1);
        BigDecimal cashIn2 = FdaFinancialKpiGetValueHelp.getSum(list, 13, 17, able);
        map.put("100218" + able, cashIn2);
        BigDecimal cashOut2 = FdaFinancialKpiGetValueHelp.getSum(list, 19, 22, able);
        map.put("100223" + able, cashOut2);
        BigDecimal cashNet2 = cashIn2.subtract(cashOut2);
        map.put("100224" + able, cashNet2);
        BigDecimal cashIn3 = FdaFinancialKpiGetValueHelp.getSum(list, 26, 28, able);
        map.put("100229" + able, cashIn3);
        BigDecimal cashOut3 = FdaFinancialKpiGetValueHelp.getSum(list, 30, 32, able);
        map.put("100233" + able, cashOut3);
        BigDecimal cashNet3 = cashIn3.subtract(cashOut3);
        map.put("100234" + able, cashNet3);
        BigDecimal cashNet = cashNet1.add(cashNet2).add(cashNet3).add(list.get(34).get(able - 1));
        map.put("100236" + able, cashNet);
        BigDecimal cashBalance = cashNet.add(list.get(36).get(able - 1));
        map.put("100238" + able, cashBalance);
        BigDecimal suppCashNet = FdaFinancialKpiGetValueHelp.getSum(list, 41, 56, able);
        map.put("100257" + able, suppCashNet);
        BigDecimal suppCashInc = list.get(62).get(able - 1).subtract(list.get(63).get(able - 1)).add(list.get(64).get(able - 1)).subtract(list.get(65).get(able - 1));
        map.put("100267" + able, suppCashInc);
        return map;
    }

    public static String translateDesc(String desp, Long orgId) {
        HashSet<String> desps = new HashSet<String>();
        Pattern p = Pattern.compile("\\d{7}");
        Matcher m = p.matcher(desp);
        while (m.find()) {
            desps.add(m.group());
        }
        Map<String, String> map = FdaFinancialKpiGetValueHelp.dealDesp(desps, orgId);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            desp = desp.replace(key, entry.getValue());
        }
        return desp;
    }

    private static Map<String, String> dealDesp(Set<String> desps, Long orgId) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> codeValueMap = new HashMap<String, String>();
        ArrayList<String> names = new ArrayList<String>();
        for (String item : desps) {
            String key = item.substring(0, 6);
            if (!codeValueMap.containsKey(key)) {
                codeValueMap.put(item.substring(0, 6), item.substring(6));
                names.add(item.substring(0, 6));
                continue;
            }
            codeValueMap.put(item.substring(0, 6), (String)codeValueMap.get(key) + "," + item.substring(6));
        }
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_manage_rptitem", (Long)orgId);
        QFilter numberFilter = new QFilter("number", "in", names);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_manage_rptitem", (String)"name,number,rptunit", (QFilter[])new QFilter[]{orgFilter, numberFilter});
        for (DynamicObject dyn : dyns) {
            String[] suffixs;
            String number = dyn.getString("number");
            String name = dyn.getString("name");
            String rptunit = dyn.getString("rptunit");
            String suffixStr = (String)codeValueMap.get(number);
            for (String suffix : suffixs = suffixStr.split(",")) {
                if ("gl_balancesheet".equals(rptunit)) {
                    if ("1".equals(suffix)) {
                        map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u671f\u521d\u4f59\u989d", (String)"FdaFinancialKpiGetValueHelp_0", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                        continue;
                    }
                    map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u671f\u672b\u4f59\u989d", (String)"FdaFinancialKpiGetValueHelp_1", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                    continue;
                }
                if ("gl_cashflowstat".equals(rptunit)) {
                    if ("1".equals(suffix)) {
                        map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u91d1\u989d", (String)"FdaFinancialKpiGetValueHelp_2", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                        continue;
                    }
                    map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"FdaFinancialKpiGetValueHelp_3", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                    continue;
                }
                if ("gl_showincome".equals(rptunit)) {
                    if ("1".equals(suffix)) {
                        map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u672c\u671f\u91d1\u989d", (String)"FdaFinancialKpiGetValueHelp_4", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                        continue;
                    }
                    if ("2".equals(suffix)) {
                        map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u672c\u671f\u7d2f\u8ba1", (String)"FdaFinancialKpiGetValueHelp_5", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                        continue;
                    }
                    if ("3".equals(suffix)) {
                        map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"FdaFinancialKpiGetValueHelp_3", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                        continue;
                    }
                    map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u7d2f\u8ba1", (String)"FdaFinancialKpiGetValueHelp_6", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                    continue;
                }
                if ("1".equals(suffix)) {
                    map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u672c\u671f\u91d1\u989d", (String)"FdaFinancialKpiGetValueHelp_4", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                    continue;
                }
                if ("2".equals(suffix)) {
                    map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u672c\u671f\u7d2f\u8ba1", (String)"FdaFinancialKpiGetValueHelp_5", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                    continue;
                }
                if ("3".equals(suffix)) {
                    map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u4e0a\u671f\u91d1\u989d", (String)"FdaFinancialKpiGetValueHelp_7", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                    continue;
                }
                if ("4".equals(suffix)) {
                    map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u4e0a\u671f\u7d2f\u8ba1", (String)"FdaFinancialKpiGetValueHelp_8", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                    continue;
                }
                if ("5".equals(suffix)) {
                    map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"FdaFinancialKpiGetValueHelp_3", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
                    continue;
                }
                if (!"6".equals(suffix)) continue;
                map.put(number + suffix, String.format(ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"FdaFinancialKpiGetValueHelp_3", (String)"fi-gl-mservice", (Object[])new Object[0]), name));
            }
        }
        return map;
    }

    private static BigDecimal getSum(List<List<BigDecimal>> list, int begin, int end, int able) {
        BigDecimal result = BigDecimal.ZERO;
        --end;
        for (int i = --begin; i <= end; ++i) {
            result = result.add(list.get(i).get(able - 1));
        }
        return result;
    }
}

