/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.CheckResult;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accountref.bookversion.AccountBookVersion;
import kd.fi.gl.accountref.utils.GLAccountRefUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.service.accountref.IGLAccountRefService;
import kd.fi.gl.util.QFBuilder;

public class GLAccountTableRefServiceImpl
implements IAccountTableRefService {
    private static List<IGLAccountRefService> GL_SERVICE = new ArrayList<IGLAccountRefService>();

    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        if (Objects.isNull(enableDate)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u542f\u7528\u65e5\u671f\u4e0d\u5b58\u5728\u3002", (String)"GLAccountTableRefServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        if (Objects.isNull(accountIdRef)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"GLAccountTableRefServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        List books = null;
        if (accountIdRef.getNewAccountTableId() == accountIdRef.getOldAccountTableId()) {
            books = GLAccountTableRefServiceImpl.getBooks(orgId, accountIdRef.getOldAccountTableId());
        } else {
            GLAccountRefUtil.AccountBookCheckResult enableableAccountBook = GLAccountRefUtil.getEnableableAccountBook((long)orgId, (Date)enableDate, (AccountTableRef)accountIdRef);
            books = enableableAccountBook.getBooks();
        }
        for (AccountBookInfo bookInfo : books) {
            AccountBookVersion accountBookVersion = new AccountBookVersion(bookInfo, enableDate, accountIdRef);
            accountBookVersion.enable();
            for (IGLAccountRefService accountRefService : GL_SERVICE) {
                accountRefService.enable(bookInfo, enableDate, accountIdRef);
            }
        }
    }

    public CheckResult enableCheck(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        if (Objects.isNull(enableDate)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u542f\u7528\u65e5\u671f\u4e0d\u5b58\u5728\u3002", (String)"GLAccountTableRefServiceImpl_0", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        if (Objects.isNull(accountIdRef)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"GLAccountTableRefServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        if (accountIdRef.getOldAccountTableId() == accountIdRef.getNewAccountTableId()) {
            return new CheckResult();
        }
        GLAccountRefUtil.AccountBookCheckResult enableableAccountBook = GLAccountRefUtil.getEnableableAccountBook((long)orgId, (Date)enableDate, (AccountTableRef)accountIdRef);
        return enableableAccountBook.getCheckResult();
    }

    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        if (Objects.isNull(disableDate)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u53cd\u542f\u7528\u65e5\u671f\u4e0d\u5b58\u5728\u3002", (String)"GLAccountTableRefServiceImpl_2", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        if (Objects.isNull(accountIdRef)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"GLAccountTableRefServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        List books = null;
        if (accountIdRef.getNewAccountTableId() == accountIdRef.getOldAccountTableId()) {
            books = GLAccountTableRefServiceImpl.getBooks(orgId, accountIdRef.getOldAccountTableId());
        } else {
            GLAccountRefUtil.AccountBookCheckResult enableableAccountBook = GLAccountRefUtil.getDisableableAccountBook((long)orgId, (Date)disableDate, (AccountTableRef)accountIdRef);
            books = enableableAccountBook.getBooks();
        }
        for (AccountBookInfo bookInfo : books) {
            AccountBookVersion accountBookVersion = new AccountBookVersion(bookInfo, disableDate, accountIdRef);
            accountBookVersion.disable();
            for (IGLAccountRefService accountRefService : GL_SERVICE) {
                accountRefService.disable(bookInfo, disableDate, accountIdRef);
            }
        }
    }

    public CheckResult disableCheck(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        if (Objects.isNull(disableDate)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u53cd\u542f\u7528\u65e5\u671f\u4e0d\u5b58\u5728\u3002", (String)"GLAccountTableRefServiceImpl_2", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        if (Objects.isNull(accountIdRef)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"GLAccountTableRefServiceImpl_1", (String)"fi-gl-mservice", (Object[])new Object[0])});
        }
        if (accountIdRef.getOldAccountTableId() == accountIdRef.getNewAccountTableId()) {
            return new CheckResult();
        }
        GLAccountRefUtil.AccountBookCheckResult enableableAccountBook = GLAccountRefUtil.getDisableableAccountBook((long)orgId, (Date)disableDate, (AccountTableRef)accountIdRef);
        return enableableAccountBook.getCheckResult();
    }

    private static List<AccountBookInfo> getBooks(long orgId, long accountTableId) {
        QFBuilder qfBuilder = new QFBuilder("org", "=", (Object)orgId);
        qfBuilder.add("accounttable", "=", (Object)accountTableId);
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"gl_accountbook", (QFilter[])qfBuilder.toArray(), null, (int)-1);
        ArrayList<AccountBookInfo> result = new ArrayList<AccountBookInfo>(primaryKeys.size());
        for (Object pk : primaryKeys) {
            result.add(new AccountBookInfo(Long.parseLong(pk.toString())));
        }
        return result;
    }
}

