/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.service.CashflowQueryParam;
import kd.fi.gl.service.CashflowServiceImpl;
import kd.fi.gl.service.TaxReportService;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.TaxReportFormHelper;

public class TaxReportServiceImpl
implements TaxReportService {
    public Map<Long, List<BigDecimal>> getTaxReportAmount(long orgId, long orgViewId, long bookTypeId, long accTableId, long periodId, long[] taxProjectIds, String taxTypeFormId) {
        Map<Long, List<BigDecimal>> resultList = new HashMap<Long, List<BigDecimal>>();
        if ("gl_income".equals(taxTypeFormId)) {
            resultList = this.getIncomeProjectAmount(orgId, orgViewId, bookTypeId, accTableId, periodId, taxProjectIds);
        }
        return resultList;
    }

    /*
     * WARNING - void declaration
     */
    public List<Map<String, Object>> getTaxReportAmountByRule(List<Map<String, Object>> taxReportBeans, String taxTypeFormId) throws ParseException {
        long orgId = 0L;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(taxReportBeans.size());
        if (!CollectionUtils.isEmpty(taxReportBeans)) {
            void var8_11;
            String type = "";
            String string = taxTypeFormId;
            int n = -1;
            switch (string.hashCode()) {
                case 1471418653: {
                    if (!string.equals("gl_balancesheet")) break;
                    boolean bl = false;
                    break;
                }
                case -899399040: {
                    if (!string.equals("gl_showincome")) break;
                    boolean bl = true;
                    break;
                }
                case -912027185: {
                    if (!string.equals("gl_cashflowstat")) break;
                    int n2 = 2;
                }
            }
            switch (var8_11) {
                case 0: {
                    type = "balancesheet";
                    break;
                }
                case 1: {
                    type = "income";
                    break;
                }
                case 2: {
                    type = "cashflowstat";
                    break;
                }
            }
            for (Map map : taxReportBeans) {
                if (!map.containsKey("org") || !map.containsKey("periodDate") || !map.containsKey("orgView")) continue;
                orgId = this.getValue(map, "org");
                long bookType = this.getValue(map, "bookType");
                Date periodDate = new SimpleDateFormat("yyyy-MM-dd").parse((String)map.get("periodDate"));
                long orgView = this.getValue(map, "orgView");
                long accTable = this.getValue(map, "accTable");
                long periodType = this.getValue(map, "periodType");
                Map taxProjects = (Map)map.get("taxProjects");
                HashSet<Long> orgParent = new HashSet<Long>();
                orgParent.add(orgId);
                Set childOrgSet = AccSysUtil.getChildOrgId((String)"10", (Long)orgView, orgParent, (boolean)true);
                if (childOrgSet.size() > 1) {
                    if (bookType <= 0L || accTable <= 0L || periodType <= 0L) continue;
                    this.getProjectAmount(resultList, orgId, orgView, bookType, this.getBookTypeNum(bookType), accTable, periodType, periodDate, taxTypeFormId, type, taxProjects);
                    continue;
                }
                if (bookType > 0L) {
                    AccountBookInfo acc = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookType);
                    if (acc == null) continue;
                    this.getProjectAmount(resultList, orgId, orgView, bookType, acc.getBookTypeNum(), acc.getAccountTableId(), acc.getPeriodTypeId(), periodDate, taxTypeFormId, type, taxProjects);
                    continue;
                }
                List accInfo = AccSysUtil.getAllBookInfoFromAccSys((long)orgId);
                for (AccountBookInfo acc : accInfo) {
                    this.getProjectAmount(resultList, orgId, orgView, acc.getBookTypeId(), acc.getBookTypeNum(), acc.getAccountTableId(), acc.getPeriodTypeId(), periodDate, taxTypeFormId, type, taxProjects);
                }
            }
        }
        return resultList;
    }

    private void getProjectAmount(List<Map<String, Object>> resultList, long orgId, long orgViewId, long bookTypeId, String bookTypeNum, long accountTableId, long periodTypeId, Date periodDate, String taxTypeFormId, String type, Map<Long, String> taxProjects) {
        DynamicObjectCollection periods = GLUtil.getPeriodByDate((Date)periodDate, (String)"id", (long)periodTypeId);
        if (periods == null) {
            return;
        }
        for (DynamicObject period : periods) {
            Long periodId = period.getLong("id");
            Map<Long, List<BigDecimal>> resultMap = type.equals("cashflowstat") ? this.getCashFlowData(orgId, bookTypeId, periodId) : this.getProjectAmountByType(orgId, orgViewId, bookTypeId, accountTableId, periodTypeId, periodId, taxTypeFormId, taxProjects, type);
            resultList.add(this.setInfo(orgId, orgViewId, bookTypeId, bookTypeNum, periodId, resultMap));
        }
    }

    private String getBookTypeNum(long bookTypeId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bookTypeId)});
        if (dynamicObject != null) {
            return dynamicObject.getString("number");
        }
        return "";
    }

    private Map<Long, List<BigDecimal>> getCashFlowData(Long org, Long bookType, Long period) {
        CashflowServiceImpl cashflowService = new CashflowServiceImpl();
        HashMap<Long, List<BigDecimal>> result = new HashMap<Long, List<BigDecimal>>(16);
        CashflowQueryParam param = new CashflowQueryParam();
        param.setOrgId(org);
        param.setBookTypeId(bookType);
        param.setPeriodId(period);
        param.addSelector("org");
        param.addSelector("amount");
        param.addSelector("yearamount");
        param.addGroupBy("cfitem");
        Set<Long> masterIsassist = this.getCashMasteridToIsassist(org);
        param.setCfitemIds(ArrayUtils.toPrimitive((Long[])masterIsassist.toArray(new Long[masterIsassist.size()])));
        HashMap cfitemAssgrp = new HashMap();
        masterIsassist.forEach(e -> {
            List cfr_ignored_0 = cfitemAssgrp.put(e, null);
        });
        List<Map<String, Object>> cashFlowAmountData = cashflowService.getCashFlowAmountData(param);
        if (!CollectionUtils.isEmpty(cashFlowAmountData)) {
            for (Map<String, Object> map : cashFlowAmountData) {
                ArrayList<BigDecimal> itemAmount = new ArrayList<BigDecimal>(2);
                itemAmount.add((BigDecimal)map.get("amount"));
                itemAmount.add((BigDecimal)map.get("yearamount"));
                Long itemId = (Long)map.get("cfitem");
                result.put(itemId, itemAmount);
            }
        }
        return result;
    }

    private Set<Long> getCashMasteridToIsassist(Long orgId) {
        HashSet<Long> masterIsassist = new HashSet<Long>(16);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        DynamicObjectCollection cashflowitems = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"masterid,isassist", (QFilter[])new QFilter[]{baseDataFilter});
        if (cashflowitems == null || cashflowitems.size() == 0) {
            return masterIsassist;
        }
        for (DynamicObject dyn : cashflowitems) {
            masterIsassist.add(dyn.getLong("masterid"));
        }
        return masterIsassist;
    }

    private Map<Long, List<BigDecimal>> getIncomeProjectAmount(long orgId, long orgViewId, long bookTypeId, long accTableId, long periodId, long[] taxProjectIds) {
        int i;
        HashMap<Long, List<BigDecimal>> resultMap = new HashMap<Long, List<BigDecimal>>();
        HashSet childOrgSet = new HashSet();
        HashSet<Long> bookTypes = new HashSet<Long>();
        bookTypes.add(bookTypeId);
        TaxReportFormHelper.getBookTypeAndChildLeafOrg((long)orgId, (long)orgViewId, (String)"gl_showincome", bookTypes, childOrgSet);
        long deafaultOrgId = 0L;
        if (!childOrgSet.isEmpty()) {
            deafaultOrgId = (Long)childOrgSet.iterator().next();
        }
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)deafaultOrgId, (long)bookTypeId);
        long basecurrencyId = bookInfo.getBaseCurrencyId();
        long periodTypeId = bookInfo.getPeriodTypeId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "=", (Object)basecurrencyId));
        DataSet periodSet = this.queryDataSet("bd_currency", "amtprecision", filters);
        int amtprecision = ((Row)periodSet.iterator().next()).getInteger("amtprecision");
        List detailAmountList = TaxReportFormHelper.collectBal(Collections.singletonList(orgId), childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"income", (int)2, (int)amtprecision);
        if (detailAmountList == null || detailAmountList.isEmpty()) {
            return resultMap;
        }
        DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdit(childOrgSet, (long)accTableId, (String)"income", (QFilter[])new QFilter("booktype", "=", (Object)bookTypeId).toArray());
        ArrayList<Long> projectList = new ArrayList<Long>();
        if (collection != null && collection.size() > 0) {
            for (DynamicObject row : collection) {
                projectList.add(row.getLong("project"));
            }
        }
        ArrayList<Object> allAmountList = new ArrayList<Object>();
        Map rowToAmountMap = TaxReportFormHelper.getIncomeIndexAmount((List)detailAmountList);
        ArrayList<Integer> indexList = new ArrayList<Integer>(rowToAmountMap.size());
        for (Map.Entry entry : rowToAmountMap.entrySet()) {
            int position = (Integer)entry.getKey();
            indexList.add(position);
        }
        for (i = 0; i < detailAmountList.size(); ++i) {
            if (indexList.contains(i + 1)) {
                allAmountList.add(rowToAmountMap.get(i + 1));
                continue;
            }
            allAmountList.add(detailAmountList.get(i));
        }
        if (taxProjectIds != null && taxProjectIds.length > 0) {
            ArrayList<Long> taxProjectList = new ArrayList<Long>(taxProjectIds.length);
            for (long id : taxProjectIds) {
                taxProjectList.add(id);
            }
            for (Long id : taxProjectList) {
                if (!projectList.contains(id)) continue;
                int rowIndex = projectList.indexOf(id);
                resultMap.put(id, (List<BigDecimal>)allAmountList.get(rowIndex));
            }
        } else {
            for (i = 0; i < projectList.size(); ++i) {
                Long l = (Long)projectList.get(i);
                resultMap.put(l, (List<BigDecimal>)allAmountList.get(i));
            }
        }
        return resultMap;
    }

    private DataSet queryDataSet(String entityName, String sel, List<QFilter> filters) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)sel, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private Map<Long, List<BigDecimal>> getProjectAmountByType(Long orgId, long orgViewId, long bookTypeId, long accTableId, long periodType, long periodId, String taxTypeFormId, Map<Long, String> taxProjects, String type) {
        HashSet childOrgSet = new HashSet(16);
        HashSet<Long> bookTypes = new HashSet<Long>(16);
        bookTypes.add(bookTypeId);
        TaxReportFormHelper.getBookTypeAndChildLeafOrg((long)orgId, (long)orgViewId, (String)taxTypeFormId, bookTypes, childOrgSet);
        long deafaultOrgId = 0L;
        if (!childOrgSet.isEmpty()) {
            deafaultOrgId = (Long)childOrgSet.iterator().next();
        }
        int amtprecision = 2;
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)deafaultOrgId, (long)bookTypeId);
        if (bookInfo != null) {
            long basecurrencyId = bookInfo.getBaseCurrencyId();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
            filters.add(new QFilter("id", "=", (Object)basecurrencyId));
            DataSet periodSet = this.queryDataSet("bd_currency", "amtprecision", filters);
            amtprecision = ((Row)periodSet.iterator().next()).getInteger("amtprecision");
        }
        return TaxReportFormHelper.collectBal(Collections.singletonList(orgId), childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodType, (long)periodId, (String)type, null, (int)amtprecision, (boolean)true, taxProjects);
    }

    private Map<String, Object> setInfo(long orgId, long orgViewId, long bookTypeId, String bookTypeNumber, long period, Map<Long, List<BigDecimal>> amountMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("org", orgId);
        map.put("bookType", bookTypeId);
        map.put("bookTypeNumber", bookTypeNumber);
        map.put("orgView", orgViewId);
        map.put("period", period);
        map.put("projectAmount", amountMap);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"name", (QFilter[])new QFilter("id", "=", (Object)bookTypeId).toArray());
        if (dyn != null) {
            map.put("bookTypeName", dyn.getString("name"));
        }
        return map;
    }

    private long getValue(Map<String, Object> map, String key) {
        if (map.containsKey(key)) {
            return Long.parseLong(map.get(key).toString());
        }
        return 0L;
    }
}

