/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.util.AccountQuickSearchDs;
import kd.fi.gl.util.BCMAcctFiled;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.ReClassNumberIDParam;
import kd.fi.gl.util.ReClassParam;
import kd.fi.gl.util.ReClassUtils;

public class BCMBalanceParamParseUtils {
    private static final List<String> SUBPLFETCHTYPE = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("SY");
            this.add("SL");
            this.add("LSY");
            this.add("LSL");
        }
    };
    private static final List<String> BALFETCHTYPE = new ArrayList<String>(){
        private static final long serialVersionUID = 2L;
        {
            this.add("JFCY");
            this.add("DFCY");
            this.add("JC");
            this.add("DC");
            this.add("JY");
            this.add("DY");
            this.add("LJFCY");
            this.add("LDFCY");
            this.add("LJC");
            this.add("LDC");
            this.add("LJY");
            this.add("LDY");
        }
    };
    private static final Log log = LogFactory.getLog(BCMBalanceParamParseUtils.class);
    private long acctOrgId;
    private long bookTypeId;
    private long acctTableId;

    private void printLog(ReClassParam reClassParam) {
        log.info("ACCT\u91cd\u5206\u7c7b\u53d6\u6570\uff0c\u62a5\u8868\u53c2\u6570\uff1a" + reClassParam.getAcctReClass() + ",\u7ec4\u7ec7\u7f16\u7801\uff1a" + reClassParam.getOrgNumber() + ",\u671f\u95f4\uff1a" + reClassParam.getPeriod());
        Map<String, Object> paramMap = reClassParam.getAcctFormulaMap();
        int logIndex = 1;
        int logCount = 1;
        StringBuilder logBuilder = new StringBuilder();
        if (paramMap.size() > 1000) {
            log.info("ACCT\u91cd\u5206\u7c7b\u516c\u5f0f\uff1a" + logBuilder);
            return;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (logCount > 100) {
                logBuilder.append(entry);
                log.info("ACCT\u91cd\u5206\u7c7b\u516c\u5f0f" + logIndex + "\uff1a" + logBuilder);
                logBuilder = new StringBuilder();
                ++logIndex;
                logCount = 0;
                continue;
            }
            logBuilder.append(entry);
            ++logCount;
        }
        if (logIndex == 1) {
            log.info("ACCT\u91cd\u5206\u7c7b\u516c\u5f0f\uff1a" + logBuilder);
        } else {
            log.info("ACCT\u91cd\u5206\u7c7b\u516c\u5f0f" + logIndex + "\uff1a" + logBuilder);
        }
    }

    public Map<String, Map<String, Object>> parseParam(ReClassParam reClassParam) {
        try {
            Map<String, Object> commMap = reClassParam.getCommParamMap();
            if (commMap == null || commMap.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u4e3a\u7a7a", (String)"BCMBalanceParamParseUtils_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
            }
            this.printLog(reClassParam);
            String comOrgNumber = reClassParam.getOrgNumber();
            Map<String, Long> mainBookTypeMap = this.getMainBookType();
            String mainBookTypeNumber = "";
            if (mainBookTypeMap.size() > 0) {
                mainBookTypeNumber = mainBookTypeMap.keySet().iterator().next();
            }
            if (StringUtils.isBlank((CharSequence)mainBookTypeNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u7684\u7ec4\u7ec7\u53d6\u4e0d\u5230\u4e3b\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"BCMBalanceParamParseUtils_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
            }
            int comFy = reClassParam.getFy();
            int comPeriod = reClassParam.getPeriod();
            int acctReClass = reClassParam.getAcctReClass();
            Map<String, Object> paramMap = reClassParam.getAcctFormulaMap();
            Set<String> bookStrSet = this.getBookStrSet(paramMap, mainBookTypeNumber, comOrgNumber);
            HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(paramMap.size());
            for (String bookStr : bookStrSet) {
                ReClassNumberIDParam numberIDParam = new ReClassNumberIDParam(mainBookTypeNumber, reClassParam, bookStr);
                this.acctOrgId = numberIDParam.getOrgId();
                this.bookTypeId = numberIDParam.getBookTypeId();
                this.acctTableId = numberIDParam.getAcctTableId();
                String bookErrorMessage = this.checkBook(bookStr);
                Map<String, DataSet> keyBalSetMap = this.getBalByReClass(paramMap, comFy, comPeriod, numberIDParam, comOrgNumber, mainBookTypeNumber);
                AccountQuickSearchDs accountQuickSearchInstance = new AccountQuickSearchDs(keyBalSetMap);
                Object object = null;
                try {
                    for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                        try {
                            String tmpBookTypeNumber;
                            String acctKeyId = entry.getKey();
                            List paramFields = (List)entry.getValue();
                            String tmpOrgNumber = (String)paramFields.get(0);
                            if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                                tmpOrgNumber = comOrgNumber;
                            }
                            if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                                tmpBookTypeNumber = mainBookTypeNumber;
                            }
                            if (!bookStr.equals(tmpOrgNumber + "," + tmpBookTypeNumber)) continue;
                            if (!StringUtils.isEmpty((CharSequence)bookErrorMessage)) {
                                this.setErrorMessage(resultMap, bookErrorMessage, entry.getKey());
                                continue;
                            }
                            String acctToAssistList = (String)paramFields.get(2);
                            Tuple2<String, Map<Long, Map<String, Set<Object>>>> tuple = this.parseAcctAssistList(acctToAssistList, numberIDParam, acctKeyId);
                            String fetchType = (String)paramFields.get(3);
                            if (StringUtils.isBlank((CharSequence)fetchType)) {
                                this.setErrorMessage(resultMap, ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BCMBalanceParamParseUtils_2", (String)"fi-gl-mservice", (Object[])new Object[0]), entry.getKey());
                                continue;
                            }
                            boolean isLocal = false;
                            fetchType = fetchType.toUpperCase(Locale.ENGLISH);
                            String fetchTypeField = BCMAcctFiled.getFetchTypeBalance().get(fetchType);
                            if (StringUtils.isBlank((CharSequence)fetchTypeField)) {
                                fetchTypeField = BCMAcctFiled.getFetchTypeAcct().get(fetchType);
                            }
                            if (StringUtils.isBlank((CharSequence)fetchTypeField) && fetchType.startsWith("L")) {
                                fetchType = fetchType.substring(1, fetchType.length());
                                fetchTypeField = BCMAcctFiled.getFetchTypeBalance().get(fetchType);
                                if (StringUtils.isBlank((CharSequence)fetchTypeField)) {
                                    fetchTypeField = BCMAcctFiled.getFetchTypeAcct().get(fetchType);
                                }
                                boolean bl = isLocal = !StringUtils.isBlank((CharSequence)fetchTypeField);
                            }
                            if (StringUtils.isBlank((CharSequence)fetchTypeField)) {
                                this.setErrorMessage(resultMap, ResManager.loadKDString((String)"\u76ee\u524d\u4e0d\u652f\u6301\uff1a %1$s \u53d6\u6570\u7c7b\u578b%2$s\u3002", (String)"BCMBalanceParamParseUtils_3", (String)"fi-gl-mservice", (Object[])new Object[]{fetchType, entry.getKey()}), entry.getKey());
                                continue;
                            }
                            int periodNumber = numberIDParam.dealPeriod((String)paramFields.get(5), comPeriod);
                            int fy = numberIDParam.dealYear((String)paramFields.get(4), comFy, periodNumber);
                            Long periodId = null;
                            if (periodNumber <= -12) {
                                this.setErrorMessage(resultMap, ResManager.loadKDString((String)"\u671f\u95f4\u8d1f\u6570\u4e0d\u80fd\u5c0f\u4e8e-12\u3002", (String)"BCMBalanceParamParseUtils_5", (String)"fi-gl-mservice", (Object[])new Object[0]), entry.getKey());
                                continue;
                            }
                            periodId = numberIDParam.getPeriodIdsMap().get(fy + "," + periodNumber);
                            if (periodId == null) {
                                this.setErrorMessage(resultMap, ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u671f\u95f4\uff0c\u8bf7\u67e5\u770b\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u662f\u5426\u6b63\u786e", (String)"BCMBalanceParamParseUtils_6", (String)"fi-gl-mservice", (Object[])new Object[0]), entry.getKey());
                                continue;
                            }
                            String currencyNumber = (String)paramFields.get(6);
                            long currencyId = 0L;
                            if (!StringUtils.isBlank((CharSequence)currencyNumber)) {
                                currencyId = numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber) == null ? 0L : numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber);
                            }
                            String key = (SUBPLFETCHTYPE.contains(fetchType) ? "true," : "false,") + periodId;
                            if (currencyId != 0L && !isLocal) {
                                fetchTypeField = fetchTypeField.replace("local", "for");
                            }
                            HashMap<Long, Integer> acctToAssistStyleMap = new HashMap<Long, Integer>();
                            HashMap<Long, Set<Long>> acctToRCAcctIdsMap = new HashMap<Long, Set<Long>>();
                            HashSet<Long> thirdStyleAcctIds = new HashSet<Long>();
                            HashMap<Long, Map<String, Set<Object>>> thirdAcctToAssistMap = new HashMap<Long, Map<String, Set<Object>>>();
                            String isAccountSum = "1";
                            if (!BALFETCHTYPE.contains(fetchType)) {
                                Set acctIds = ((Map)tuple.t2).keySet();
                                for (Long acctId : acctIds) {
                                    acctToAssistStyleMap.put(acctId, 2);
                                    HashSet<Long> leafAcctIds = new HashSet<Long>();
                                    leafAcctIds.add(acctId);
                                    acctToRCAcctIdsMap.put(acctId, leafAcctIds);
                                }
                            } else {
                                isAccountSum = this.acctReClass(acctReClass, (Map)tuple.t2, acctToAssistStyleMap, acctToRCAcctIdsMap, thirdAcctToAssistMap, isAccountSum, numberIDParam);
                            }
                            if (acctToAssistStyleMap.isEmpty()) {
                                Map<String, String> errorInfoMap = numberIDParam.getErrorInfoMap();
                                errorInfoMap.put(entry.getKey(), ResManager.loadKDString((String)"\u516c\u5f0f\u7684\u79d1\u76ee\u6ca1\u6709\u5206\u914d\u6743\u9650\u3002", (String)"BCMBalanceParamParseUtils_7", (String)"fi-gl-mservice", (Object[])new Object[0]));
                                numberIDParam.setErrorInfoMap(errorInfoMap);
                                continue;
                            }
                            DataSet bcmBalSet = this.dealBalByReClass((Map)tuple.t2, acctToAssistStyleMap, acctToRCAcctIdsMap, thirdStyleAcctIds, thirdAcctToAssistMap, accountQuickSearchInstance, isAccountSum, numberIDParam, acctReClass, key, currencyId);
                            Map acctValMap = resultMap.computeIfAbsent(acctKeyId, e -> new HashMap());
                            if (Objects.nonNull(bcmBalSet)) {
                                if ("0".equals(isAccountSum)) {
                                    bcmBalSet = bcmBalSet.addField("'" + (String)tuple.t1 + "'", "dc");
                                }
                                bcmBalSet = bcmBalSet.select(fetchTypeField).groupBy().sum(fetchType).finish();
                                for (Row row : bcmBalSet) {
                                    BigDecimal value = row.getBigDecimal(fetchType);
                                    if (value == null) continue;
                                    if (acctValMap.isEmpty()) {
                                        acctValMap.put("v", value);
                                        acctValMap.put("type", 1);
                                        continue;
                                    }
                                    BigDecimal cur = (BigDecimal)acctValMap.get("v");
                                    if (cur == null) continue;
                                    acctValMap.put("v", cur.add(value));
                                }
                                continue;
                            }
                            acctValMap.put("v", 0L);
                            acctValMap.put("type", 1);
                        }
                        catch (Exception e2) {
                            log.error(String.format("\u91cd\u5206\u7c7b\u53d6\u6570\u516c\u5f0f\u5f02\u5e38\u4fe1\u606f\uff1a, \u5f53\u524d\u53c2\u6570: %s, ErrMsg: %s", entry, e2.getMessage()), (Throwable)e2);
                            Map<String, String> errorInfoMap = numberIDParam.getErrorInfoMap();
                            errorInfoMap.put(entry.getKey(), GLUtil.printError((Throwable)e2));
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (accountQuickSearchInstance != null) {
                        if (object != null) {
                            try {
                                accountQuickSearchInstance.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            accountQuickSearchInstance.close();
                        }
                    }
                }
                Map<String, String> errorInfoMap = numberIDParam.getErrorInfoMap();
                for (Map.Entry entry : errorInfoMap.entrySet()) {
                    String acctKeyId = (String)entry.getKey();
                    Map acctValMap = resultMap.computeIfAbsent(acctKeyId, e -> new HashMap());
                    acctValMap.put("v", entry.getValue());
                    acctValMap.put("type", -1);
                }
            }
            return resultMap;
        }
        catch (Exception e3) {
            log.info("\u91cd\u5206\u7c7b\u53d6\u6570\u5f02\u5e38\u4fe1\u606f\uff1a" + GLUtil.printError((Throwable)e3));
            throw new BOSException((Throwable)e3);
        }
    }

    private void setErrorMessage(Map<String, Map<String, Object>> resultMap, String errorMessage, String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("v", ResManager.loadKDString((String)errorMessage, (String)"BCMBalanceParamParseUtils", (String)"BCMBalanceParamParseUtils_8", (Object[])new Object[0]));
        map.put("type", -1);
        resultMap.put(key, map);
    }

    private String checkBook(String bookStr) {
        String bookErrorMessage = "";
        String[] orgBookTypes = bookStr.split(",");
        String orgNumber = orgBookTypes[0];
        String bookTypeNumber = orgBookTypes[1];
        if (this.acctOrgId == 0L) {
            bookErrorMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801:%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f;", (String)"BCMBalanceParamParseUtils_9", (String)"fi-gl-mservice", (Object[])new Object[]{orgNumber});
        } else if (this.bookTypeId == 0L) {
            bookErrorMessage = ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u201c%s\u201d\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"BCMBalanceParamParseUtils_11", (String)"fi-gl-mservice", (Object[])new Object[]{bookTypeNumber});
        } else if (this.acctTableId == 0L) {
            bookErrorMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u548c\u8d26\u7c3f\u7c7b\u578b%2$s\u672a\u5efa\u7acb\u8d26\u7c3f;", (String)"BCMBalanceParamParseUtils_12", (String)"fi-gl-mservice", (Object[])new Object[]{orgNumber, bookTypeNumber});
        }
        return bookErrorMessage;
    }

    private Set<String> getBookStrSet(Map<String, Object> paramMap, String comBookTypeNumber, String comOrgNumber) {
        HashSet<String> bookStrSet = new HashSet<String>(paramMap.size());
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String tmpBookTypeNumber;
            List paramFields = (List)entry.getValue();
            String tmpOrgNumber = (String)paramFields.get(0);
            if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                tmpOrgNumber = comOrgNumber;
            }
            if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                tmpBookTypeNumber = comBookTypeNumber;
            }
            String bookStr = tmpOrgNumber + "," + tmpBookTypeNumber;
            bookStrSet.add(bookStr);
        }
        return bookStrSet;
    }

    private Map<String, Long> getMainBookType() {
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        QFilter ftype = new QFilter("accounttype", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ftype);
        DataSet bookTypeSet = ReClassUtils.queryDataSet("bd_accountbookstype", "id,number", filters);
        for (Row row : bookTypeSet) {
            long bookTypeId = row.getLong("id");
            String bookTypeNumber = row.getString("number");
            numberToIdMap.put(bookTypeNumber, bookTypeId);
        }
        return numberToIdMap;
    }

    private Map<String, Map<String, Set<Long>>> dealBalQueryCondition(Map<String, Object> paramMap, int comFy, int comPeriod, ReClassNumberIDParam numberIDParam, String comOrgNumber, String comBookTypeNumber) {
        HashMap<String, Map<String, Set<Long>>> balMap = new HashMap<String, Map<String, Set<Long>>>(paramMap.size());
        Map<String, Long> periodIdMap = numberIDParam.getPeriodIdsMap();
        Map<String, Long> currencyNumberToIdsMap = numberIDParam.getCurrencyNumberToIdsMap();
        if (numberIDParam.getOrgId() == 0L || numberIDParam.getBookTypeId() == 0L || numberIDParam.getAcctTableId() == 0L) {
            return balMap;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String tmpBookTypeNumber;
            List paramFields = (List)entry.getValue();
            String tmpOrgNumber = (String)paramFields.get(0);
            if (StringUtils.isBlank((CharSequence)tmpOrgNumber)) {
                tmpOrgNumber = comOrgNumber;
            }
            if (StringUtils.isBlank((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
                tmpBookTypeNumber = comBookTypeNumber;
            }
            if (!(numberIDParam.getOrgNumber() + "," + numberIDParam.getBookTypeNumber()).equals(tmpOrgNumber + "," + tmpBookTypeNumber)) continue;
            String acctToAssistList = (String)paramFields.get(2);
            Map acctIdToAssistMap = (Map)this.parseAcctAssistList((String)acctToAssistList, (ReClassNumberIDParam)numberIDParam, (String)entry.getKey()).t2;
            int periodNumber = numberIDParam.dealPeriod((String)paramFields.get(5), comPeriod);
            int fy = numberIDParam.dealYear((String)paramFields.get(4), comFy, periodNumber);
            Long periodId = null;
            if (periodNumber > -12) {
                periodId = periodIdMap.get(fy + "," + periodNumber);
            }
            if (periodId == null) {
                Map<String, String> errorInfoMap = numberIDParam.getErrorInfoMap();
                if (periodNumber < -12) {
                    errorInfoMap.put(entry.getKey(), ResManager.loadKDString((String)"\u671f\u95f4\u8d1f\u6570\u4e0d\u80fd\u5c0f\u4e8e-12\u3002", (String)"BCMBalanceParamParseUtils_5", (String)"fi-gl-mservice", (Object[])new Object[0]));
                } else {
                    errorInfoMap.put(entry.getKey(), ResManager.loadKDString((String)"\u516c\u5f0f\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"BCMBalanceParamParseUtils_15", (String)"fi-gl-mservice", (Object[])new Object[0]));
                }
                numberIDParam.setErrorInfoMap(errorInfoMap);
                continue;
            }
            String currencyNumber = (String)paramFields.get(6);
            long currencyId = currencyNumberToIdsMap.get(currencyNumber) == null ? 0L : currencyNumberToIdsMap.get(currencyNumber);
            String fetchType = (String)paramFields.get(3);
            String key = "false,";
            if (SUBPLFETCHTYPE.contains(fetchType)) {
                key = "true,";
            }
            Map currencyAcctMap = balMap.get(key = key + periodId) == null ? new HashMap() : (Map)balMap.get(key);
            Set<Long> currencyIds = null;
            if (balMap.get(key) != null && currencyAcctMap.get("currencyIds") != null) {
                currencyIds = currencyAcctMap.get("currencyIds") == null ? new HashSet() : (Set)currencyAcctMap.get("currencyIds");
                currencyIds.add(currencyId);
            }
            currencyAcctMap.put("currencyIds", currencyIds);
            Set paramAcctIds = acctIdToAssistMap.keySet();
            Set acctIds = currencyAcctMap.get("acctIds") == null ? new HashSet() : (Set)currencyAcctMap.get("acctIds");
            acctIds.addAll(paramAcctIds);
            currencyAcctMap.put("acctIds", acctIds);
            if (acctIds.isEmpty()) {
                Map<String, String> errorInfoMap = numberIDParam.getErrorInfoMap();
                errorInfoMap.put(entry.getKey(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$sBCMBalanceParamParseUtils_16%2$s\u7684\u4f59\u989d\u53d6\u6570\u627e\u4e0d\u5230\u79d1\u76ee\u3002", (String)"BCMBalanceParamParseUtils_8", (String)"fi-gl-mservice", (Object[])new Object[0]), tmpOrgNumber, tmpBookTypeNumber));
                numberIDParam.setErrorInfoMap(errorInfoMap);
            }
            balMap.put(key, currencyAcctMap);
        }
        return balMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private DataSet dealBalByReClass(Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToRCAcctIdsMap, Set<Long> thirdStyleAcctIds, Map<Long, Map<String, Set<Object>>> thirdAcctToFlexsMap, AccountQuickSearchDs accountQuickSearchInstance, String isAccountSum, ReClassNumberIDParam numberIDParam, int acctReclass, String dataKey, long currencyFilterId) {
        DataSet bcmBalSet = null;
        Iterator<Map.Entry<Long, Map<String, Set<Object>>>> iterator = acctIdToAssistMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Set<Long> masterSet;
            Optional<DataSet> acctBalSetOpt;
            Map.Entry<Long, Map<String, Set<Object>>> entry = iterator.next();
            long acctId = entry.getKey();
            Set<Long> leafAcctIds = acctToRCAcctIdsMap.get(acctId);
            if (leafAcctIds == null || leafAcctIds.isEmpty() || !(acctBalSetOpt = accountQuickSearchInstance.rebuildDatasetByFilter(dataKey, masterSet = this.acctIdsToMasterIds(leafAcctIds, numberIDParam), currencyFilterId)).isPresent()) continue;
            DataSet acctBalSet = acctBalSetOpt.get();
            Set<Long> availableHgIds = accountQuickSearchInstance.getAvailableHgIds(dataKey, masterSet, currencyFilterId);
            ArrayList<String> amountFields = new ArrayList<String>();
            ArrayList<String> noAmountFields = new ArrayList<String>();
            ArrayList<String> balAllFields = new ArrayList<String>();
            this.getSetAmountFields(acctBalSet, amountFields, noAmountFields);
            balAllFields.addAll(amountFields);
            balAllFields.addAll(noAmountFields);
            int assistStyle = acctToAssistStyleMap.get(acctId);
            Set<String> groupByFields = this.getGroupByFields();
            if (1 == assistStyle) {
                acctBalSet = this.balSum(acctBalSet, amountFields, groupByFields);
            } else if (2 == assistStyle) {
                Map<String, Set<Object>> flexToIdsMap = entry.getValue();
                if (flexToIdsMap != null && !flexToIdsMap.isEmpty()) {
                    DataSet assistSet = this.dealAssistSet(flexToIdsMap, numberIDParam, availableHgIds);
                    if (assistSet != null) {
                        List<String> assistFields = this.getFieldsBySet(assistSet);
                        assistFields.removeIf(x -> x.equals("hg"));
                        acctBalSet = acctBalSet.join(assistSet, JoinType.INNER).on("hg", "hg").select(balAllFields.toArray(new String[0]), assistFields.toArray(new String[0])).finish();
                        if (!acctBalSet.hasNext()) {
                            assistSet.close();
                            continue;
                        }
                        if (acctReclass != 4 && acctReclass != 5) {
                            groupByFields.addAll(assistFields);
                        }
                        if ("0".equals(isAccountSum)) {
                            groupByFields.removeIf(x -> x.equals("account"));
                            groupByFields.removeIf(x -> x.equals("dc"));
                        }
                        acctBalSet = this.balSum(acctBalSet, amountFields, groupByFields);
                    } else {
                        acctBalSet.close();
                        continue;
                    }
                }
            } else if (3 == assistStyle) {
                groupByFields.add("hg");
                acctBalSet = this.balSum(acctBalSet, amountFields, groupByFields);
            }
            if (bcmBalSet != null && acctBalSet != null) {
                List<String> acctMoreFields = this.getFieldsBySet(acctBalSet);
                acctMoreFields.removeAll(this.getFieldsBySet(bcmBalSet));
                List<String> bcmMoreFields = this.getFieldsBySet(bcmBalSet);
                bcmMoreFields.removeAll(this.getFieldsBySet(acctBalSet));
                for (String field : acctMoreFields) {
                    if (field.equals("dc")) {
                        bcmBalSet = bcmBalSet.addField("'0'", field);
                        continue;
                    }
                    bcmBalSet = bcmBalSet.addField("0", field);
                }
                for (String field : bcmMoreFields) {
                    if (field.equals("dc")) {
                        acctBalSet = acctBalSet.addField("'0'", field);
                        continue;
                    }
                    acctBalSet = acctBalSet.addField("0", field);
                }
                acctBalSet = acctBalSet.select(this.getFieldsBySet(bcmBalSet).toArray(new String[0]));
            }
            if (acctBalSet == null) continue;
            bcmBalSet = bcmBalSet == null ? acctBalSet : bcmBalSet.union(acctBalSet);
        }
        return bcmBalSet;
    }

    private Set<Long> acctIdsToMasterIds(Set<Long> acctIds, ReClassNumberIDParam numberIDParam) {
        Map<Long, Long> acctToMasterMap = numberIDParam.getAcctIdToMasterIdMap();
        HashSet<Long> masterSet = new HashSet<Long>(acctToMasterMap.size());
        for (Long acctId : acctIds) {
            long masterId = acctToMasterMap.get(acctId);
            masterSet.add(masterId);
        }
        return masterSet;
    }

    private DataSet dealAssistSet(Map<String, Set<Object>> flexToIdsMap, ReClassNumberIDParam numberIDParam, Set<Long> availableHgIds) {
        DataSet resultSet = null;
        Map<String, String> flexToEntityMap = numberIDParam.getFlexToAssistEntityMap();
        ArrayList<String> resultList = new ArrayList<String>(flexToIdsMap.size());
        for (Map.Entry<String, Set<Object>> assistEntry : flexToIdsMap.entrySet()) {
            String flex = assistEntry.getKey();
            if (CollectionUtils.isEmpty(availableHgIds) || availableHgIds.stream().allMatch(x -> Objects.equals(0L, x))) {
                return null;
            }
            ArrayList<String> fileds = new ArrayList<String>(2);
            Set<Object> valObjs = assistEntry.getValue();
            if (Objects.isNull(valObjs)) {
                valObjs = Collections.emptySet();
            }
            if (!CollectionUtils.isEmpty(valObjs) && valObjs.stream().allMatch(x -> Objects.isNull(x))) {
                return null;
            }
            valObjs.removeIf(x -> Objects.isNull(x));
            Optional<DataSet> assistSetOpt = numberIDParam.getAssistQuickSearchInstance().rebuildDatasetByFlex(flexToEntityMap.get(flex), flex, valObjs, availableHgIds);
            if (!assistSetOpt.isPresent()) {
                return null;
            }
            DataSet assistSet = assistSetOpt.get();
            fileds.add("hg");
            fileds.add(flex);
            resultSet = resultSet == null ? assistSet : resultSet.join(assistSet).on("hg", "hg").select(resultList.toArray(new String[0]), fileds.toArray(new String[0])).finish();
            resultList.add(flex);
        }
        return resultSet;
    }

    private Set<String> getGroupByFields() {
        HashSet<String> groupByFields = new HashSet<String>();
        groupByFields.add("org");
        groupByFields.add("booktype");
        groupByFields.add("account");
        groupByFields.add("dc");
        groupByFields.add("measureunit");
        return groupByFields;
    }

    private Map<String, DataSet> getBalByReClass(Map<String, Object> paramMap, int comFy, int comPeriod, ReClassNumberIDParam numberIDParam, String comOrgNumber, String comBookType) {
        Map<String, Map<String, Set<Long>>> balMap = this.dealBalQueryCondition(paramMap, comFy, comPeriod, numberIDParam, comOrgNumber, comBookType);
        HashMap<String, DataSet> keyBalSetMap = new HashMap<String, DataSet>(balMap.size());
        DataSet ds = null;
        String selFields = this.getBalFields();
        for (Map.Entry<String, Map<String, Set<Long>>> balEntry : balMap.entrySet()) {
            Set<Long> acctIds;
            String key = balEntry.getKey();
            String[] balKeys = key.split(",");
            QueryParam queryParam = new QueryParam();
            queryParam.setSpecialAccount(false);
            queryParam.setSubstractPL(Boolean.parseBoolean(balKeys[0]));
            Map<String, Set<Long>> currencyAcctMap = balEntry.getValue();
            Set<Long> currencyIds = currencyAcctMap.get("currencyIds");
            if (currencyIds != null && !currencyIds.isEmpty() && !currencyIds.contains(0L)) {
                queryParam.setCurrencyIds(currencyIds.toArray(new Long[currencyIds.size()]));
            }
            if ((acctIds = currencyAcctMap.get("acctIds")) != null && !acctIds.isEmpty()) {
                queryParam.setAccountFilter(new QFilter("id", "in", acctIds));
            }
            ds = BalanceQueryExecutor.getInstance().getBalance(selFields, new Long[]{this.acctOrgId}, this.bookTypeId, this.acctTableId, Long.parseLong(balKeys[1]), Long.parseLong(balKeys[1]), queryParam);
            keyBalSetMap.put(key, ds);
        }
        return keyBalSetMap;
    }

    private DataSet balSum(DataSet acctBalSet, List<String> amountFields, Set<String> groupByFields) {
        GroupbyDataSet groupAcctBalSet = acctBalSet.groupBy(groupByFields.toArray(new String[groupByFields.size()]));
        for (String amount : amountFields) {
            groupAcctBalSet = groupAcctBalSet.sum(amount);
        }
        acctBalSet = groupAcctBalSet.finish();
        return acctBalSet;
    }

    private void getSetAmountFields(DataSet balanceSet, List<String> amountFields, List<String> noAmountFields) {
        List<String> fieldList = this.getFieldsBySet(balanceSet);
        for (String name : fieldList) {
            if (name.endsWith("local") || name.endsWith("for") || name.endsWith("qty")) {
                amountFields.add(name);
                continue;
            }
            noAmountFields.add(name);
        }
    }

    private List<String> getFieldsBySet(DataSet balanceSet) {
        Field[] fields = balanceSet.getRowMeta().getFields();
        ArrayList<String> fieldList = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            fieldList.add(field.getAlias());
        }
        return fieldList;
    }

    private String acctReClass(int acctReClass, Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToRCAcctIdsMap, Map<Long, Map<String, Set<Object>>> thirdAcctToAssistMap, String isAccountSum, ReClassNumberIDParam numberIDParam) {
        block23: {
            Map<Long, Set<String>> acctToFlexMap;
            Map<Long, Set<Long>> allLeafMap;
            block27: {
                Map<Long, Set<Long>> directLeafMap;
                block26: {
                    block25: {
                        block24: {
                            block22: {
                                directLeafMap = numberIDParam.getAcctToDirectLeafMap();
                                allLeafMap = numberIDParam.getAcctToAllLeafMap();
                                acctToFlexMap = numberIDParam.getAcctToFlexsMap();
                                HashMap<Long, Map<String, Set<Object>>> acctIdToAssistMapFor = new HashMap<Long, Map<String, Set<Object>>>();
                                acctIdToAssistMapFor.putAll(acctIdToAssistMap);
                                if (1 != acctReClass) break block22;
                                for (Map.Entry entry : acctIdToAssistMapFor.entrySet()) {
                                    Set<Long> allLeafIds;
                                    long acctId = (Long)entry.getKey();
                                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                                    if (isSelectAssist) {
                                        allLeafIds = allLeafMap.get(acctId);
                                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                                        acctToAssistStyleMap.put(acctId, 2);
                                        continue;
                                    }
                                    if (!isContainAssist) {
                                        Set<Long> directLeafIds = directLeafMap.get(acctId);
                                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                                        acctToAssistStyleMap.put(acctId, 1);
                                        continue;
                                    }
                                    allLeafIds = allLeafMap.get(acctId);
                                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                                    acctToAssistStyleMap.put(acctId, 3);
                                    for (Long id : allLeafIds) {
                                        thirdAcctToAssistMap.put(id, new HashMap());
                                    }
                                }
                                isAccountSum = "0";
                                break block23;
                            }
                            if (2 != acctReClass) break block24;
                            for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                                Set<Long> allLeafIds;
                                long acctId = entry.getKey();
                                boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                                boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                                if (isSelectAssist) {
                                    allLeafIds = allLeafMap.get(acctId);
                                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                                    acctToAssistStyleMap.put(acctId, 2);
                                    continue;
                                }
                                if (!isContainAssist) {
                                    allLeafIds = allLeafMap.get(acctId);
                                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                                    acctToAssistStyleMap.put(acctId, 3);
                                    for (Long id : allLeafIds) {
                                        thirdAcctToAssistMap.put(id, new HashMap());
                                    }
                                    continue;
                                }
                                allLeafIds = allLeafMap.get(acctId);
                                acctToRCAcctIdsMap.put(acctId, allLeafIds);
                                acctToAssistStyleMap.put(acctId, 3);
                                for (Long id : allLeafIds) {
                                    thirdAcctToAssistMap.put(id, new HashMap());
                                }
                            }
                            break block23;
                        }
                        if (3 != acctReClass) break block25;
                        for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                            long acctId = entry.getKey();
                            boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                            boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                            Set<Long> directLeafIds = directLeafMap.get(acctId);
                            if (isSelectAssist) {
                                acctToRCAcctIdsMap.put(acctId, directLeafIds);
                                acctToAssistStyleMap.put(acctId, 2);
                                continue;
                            }
                            if (!isContainAssist) {
                                acctToRCAcctIdsMap.put(acctId, directLeafIds);
                                acctToAssistStyleMap.put(acctId, 1);
                                continue;
                            }
                            acctToRCAcctIdsMap.put(acctId, directLeafIds);
                            acctToAssistStyleMap.put(acctId, 3);
                        }
                        break block23;
                    }
                    if (4 != acctReClass) break block26;
                    for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                        long acctId = entry.getKey();
                        boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                        boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                        Set<Long> allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        if (isSelectAssist) {
                            Map<String, Set<Object>> flexToIdsMap = acctIdToAssistMap.get(acctId);
                            for (Long id : allLeafIds) {
                                thirdAcctToAssistMap.put(id, flexToIdsMap);
                            }
                            acctToAssistStyleMap.put(acctId, 2);
                            continue;
                        }
                        if (!isContainAssist) {
                            acctToAssistStyleMap.put(acctId, 1);
                            continue;
                        }
                        acctToAssistStyleMap.put(acctId, 1);
                    }
                    break block23;
                }
                if (5 != acctReClass) break block27;
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    Set<Long> directLeafIds = directLeafMap.get(acctId);
                    if (isSelectAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToRCAcctIdsMap.put(acctId, directLeafIds);
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break block23;
            }
            if (6 != acctReClass) break block23;
            for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                HashSet<Long> acctIds;
                long acctId = entry.getKey();
                boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                if (isSelectAssist) {
                    Set<Long> allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    acctToAssistStyleMap.put(acctId, 2);
                    continue;
                }
                if (!isContainAssist) {
                    acctIds = new HashSet<Long>();
                    acctIds.add(acctId);
                    acctToRCAcctIdsMap.put(acctId, acctIds);
                    acctToAssistStyleMap.put(acctId, 1);
                    continue;
                }
                acctIds = new HashSet();
                acctIds.add(acctId);
                acctToRCAcctIdsMap.put(acctId, acctIds);
                acctToAssistStyleMap.put(acctId, 1);
            }
        }
        return isAccountSum;
    }

    private boolean acctIsContainAssistMap(Map<Long, Set<String>> acctToFlexMap, long acctId) {
        boolean isContainAssist = true;
        Set<String> flexs = acctToFlexMap.get(acctId);
        if (flexs == null || flexs.size() == 0) {
            isContainAssist = false;
        }
        return isContainAssist;
    }

    private boolean isSelectAssist(Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, long acctId) {
        Map<String, Set<Object>> assistMap = acctIdToAssistMap.get(acctId);
        boolean isSelectAssist = assistMap != null && !assistMap.isEmpty();
        return isSelectAssist;
    }

    private String getBalFields() {
        String selFields = "org,booktype,account,account.dc dc, currency,assgrp hg,measureunit,beginfor,beginlocal,beginqty,endfor,endlocal,endqty,yeardebitfor,yeardebitlocal,yeardebitqty,yearcreditfor,yearcreditlocal,yearcreditqty,debitfor,debitlocal,debitqty,creditfor,creditlocal,creditqty";
        return selFields;
    }

    private Tuple2<String, Map<Long, Map<String, Set<Object>>>> parseAcctAssistList(String accountListStr, ReClassNumberIDParam numberIDParam, String acctKeyId) {
        Map<String, Long> numberToIdMap = numberIDParam.getAcctNumberToIdsMap();
        Map<String, Set<Long>> rangeNumberToIdsMap = numberIDParam.getAcctRangeKeyToIdsMap();
        if (StringUtils.isEmpty((CharSequence)accountListStr)) {
            Map<String, String> errorMap = numberIDParam.getErrorInfoMap();
            errorMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BCMBalanceParamParseUtils_17", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        String[] accountValues = accountListStr.split("\\|");
        String acctsStr = accountValues[0];
        boolean isContinueAcct = ReClassUtils.isContinueNumber(acctsStr);
        if (StringUtils.isEmpty((CharSequence)acctsStr)) {
            Map<String, String> errorMap = numberIDParam.getErrorInfoMap();
            errorMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BCMBalanceParamParseUtils_17", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        HashMap<Long, HashMap<String, Set<Object>>> acctIdToAssistMap = new HashMap<Long, HashMap<String, Set<Object>>>();
        HashMap<String, Set<Object>> asstMap = new HashMap<String, Set<Object>>();
        Set<Object> acctIds = new HashSet();
        String accountNumber = this.parseAssistStr(accountListStr, asstMap, numberIDParam);
        String dc = null;
        if (isContinueAcct) {
            acctIds = rangeNumberToIdsMap.get(accountNumber);
            dc = numberIDParam.getAcctRangeKeyToDcMap().get(accountNumber);
            Iterator<Object> iterator = acctIds.iterator();
            while (iterator.hasNext()) {
                long acctId = (Long)iterator.next();
                acctIdToAssistMap.put(acctId, asstMap);
            }
        } else {
            String[] accountList;
            for (String acctNumberStr : accountList = acctsStr.split(",")) {
                Long acctId;
                if (dc == null) {
                    dc = numberIDParam.getAcctNumberToDcMap().get(acctNumberStr);
                }
                if ((acctId = numberToIdMap.get(acctNumberStr)) == null) continue;
                acctIds.add(acctId);
                acctIdToAssistMap.put(acctId, asstMap);
            }
        }
        return new Tuple2((Object)dc, acctIdToAssistMap);
    }

    private String parseAssistStr(String accountStr, Map<String, Set<Object>> asstMap, ReClassNumberIDParam numberIDParam) {
        accountStr = accountStr.replaceAll("\\|", "\\| ");
        String[] accountValues = accountStr.split("\\|");
        String accountNumber = "";
        if (accountValues.length == 1) {
            accountNumber = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                return accountNumber;
            }
            accountNumber = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)accountNumber)) {
            return accountNumber;
        }
        Map<String, String> assistNumberToFlexMap = numberIDParam.getAssistToFlexMap();
        Map<String, Object> valNumberToIdsMap = numberIDParam.getassistValNumberToObjMap();
        Map<String, Set<Object>> valRangeNumberToIdsMap = numberIDParam.getassistValRangeNumberToObjsMap();
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            String flex = assistNumberToFlexMap.get(assistNumber);
            Set<Object> valIds = new HashSet();
            if (StringUtils.isNotEmpty((CharSequence)accountValues[i + 1].trim())) {
                String valStr = accountValues[i + 1].trim();
                boolean isContinue = ReClassUtils.isContinueNumber(valStr);
                if (isContinue) {
                    valIds = valRangeNumberToIdsMap.get(assistNumber + "*" + valStr);
                } else {
                    String[] valList;
                    for (String valNumber : valList = valStr.split(",")) {
                        valIds.add(valNumberToIdsMap.get(assistNumber + "*" + valNumber));
                    }
                }
            }
            asstMap.put(flex, valIds);
        }
        return accountNumber;
    }
}

