/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.exception.BOSException;

public class GLServiceUtils {
    public static void getFlexAndVals(Map<String, Object> assgrpMap, Set<String> flexEmptyValFields, Map<String, Set<Object>> flexToValsMap) {
        if (assgrpMap == null) {
            return;
        }
        for (Map.Entry<String, Object> mapEntry : assgrpMap.entrySet()) {
            String flexField = mapEntry.getKey();
            if (!flexEmptyValFields.contains(flexField) && mapEntry.getValue() != null) {
                Set assVals = flexToValsMap.computeIfAbsent(flexField, x -> new HashSet(8));
                assVals.add(mapEntry.getValue());
                continue;
            }
            flexEmptyValFields.add(flexField);
            flexToValsMap.remove(flexField);
        }
    }

    public static List<String> getFieldsByDs(DataSet dataSet) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (dataSet != null) {
            Field[] fields;
            RowMeta rowMeta = dataSet.getRowMeta();
            for (Field field : fields = rowMeta.getFields()) {
                String fieldAlias = field.getAlias();
                fieldNames.add(fieldAlias);
            }
        }
        return fieldNames;
    }

    public static Map<Long, Long> masterToIDMap(Set<Long> ids, String entityId) {
        HashMap<Long, Long> masterToIDMap = new HashMap<Long, Long>();
        QFilter fid = new QFilter("id", "in", ids);
        DataSet acctSet = QueryServiceHelper.queryDataSet((String)"acctIdToMasterIDMap", (String)entityId, (String)"id,masterid", (QFilter[])new QFilter[]{fid}, null);
        for (Row row : acctSet) {
            long masterId = row.getLong("masterid");
            long id = row.getLong("id");
            masterToIDMap.put(masterId, id);
        }
        return masterToIDMap;
    }

    public static MainEntityType getCashflowMainEntityType(Set<String> flexfieldSet) {
        QFilter qFilter = new QFilter("flexfield", "in", flexfieldSet);
        Map assistMap = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"valuesource, flexfield", (QFilter[])new QFilter[]{qFilter}, null);
        Map<String, DynamicObject> flexMap = assistMap.values().stream().collect(Collectors.toMap(x -> x.getString("flexfield"), x -> x));
        try {
            MainEntityType mainEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"gl_cashflow").clone();
            GLServiceUtils.registerProperty(mainEntity, flexMap);
            return mainEntity;
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void registerProperty(MainEntityType mainEntity, Map<String, DynamicObject> assistMap) {
        for (Map.Entry<String, DynamicObject> entry : assistMap.entrySet()) {
            DynamicObject assistDyn = entry.getValue();
            if (assistDyn == null) continue;
            String valueSource = assistDyn.getString("valuesource");
            String flexField = assistDyn.getString("flexfield");
            DynamicObjectType type = GLServiceUtils.getFlexDataType(valueSource);
            BasedataProp prop = new BasedataProp();
            prop.setAlias("fassgrpid");
            prop.setName("assgrp_" + flexField);
            prop.setComplexType((IDataEntityType)type);
            ((LongProp)type.getProperties().get((Object)"id")).setAlias("fid");
            mainEntity.addProperty((DynamicProperty)prop);
        }
    }

    private static DynamicObjectType getFlexDataType(String valueSource) {
        String tableName = StringUtils.isBlank((CharSequence)valueSource) ? "gl_assist_txt" : "gl_assist_bd";
        try {
            return (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)tableName).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

