/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.assistgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.GroupProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.acct.handle.MakeBaseDateDetailHelper;
import kd.fi.gl.util.assistgroup.AbstractAssistGroup;
import kd.fi.gl.util.assistgroup.assistgroupids.AssistGroupIdsProcesserFactory;
import kd.fi.gl.util.findprop.GroupPropFind;

public class ExtAssistGroupImpl
extends AbstractAssistGroup {
    @Override
    public DataSet queryAssistValByGroup(String categoryNumber, String entityId) {
        String[] categoryList = categoryNumber.split("#");
        if (categoryList.length != 2) {
            return null;
        }
        String groupNumber = categoryList[1];
        GroupPropFind propFind = new GroupPropFind(entityId, groupNumber);
        IDataEntityProperty groupProperty = propFind.findDefaultProperty();
        String groupEntity = ((GroupProp)groupProperty).getBaseEntityId();
        if (null == groupProperty) {
            return null;
        }
        DataSet assistSet = (DataSet)this.groupMap.get(entityId + "*" + groupNumber);
        if (assistSet == null) {
            Set<Long> allGroupIds = this.queryLeafCategory(groupNumber, groupEntity);
            if (null == allGroupIds || allGroupIds.size() == 0) {
                this.groupMap.put(entityId + "*" + groupNumber, null);
            } else {
                QFilter fgid = new QFilter(groupProperty.getName(), "in", allGroupIds);
                assistSet = this.queryDataSet(this.getClass().getName(), entityId, "masterid", new QFilter[]{fgid});
                this.groupMap.put(entityId + "*" + groupNumber, assistSet);
            }
        }
        return assistSet;
    }

    private Set<Long> queryLeafCategory(String categoryNumber, String entityId) {
        String[] assisttContinueNumbers = null;
        boolean hasParent = new MakeBaseDateDetailHelper().hasParent(entityId);
        String sel = "id";
        if (hasParent) {
            sel = "parent pid, id, isleaf";
        }
        DataSet dataSet = null;
        if (categoryNumber.startsWith("[")) {
            categoryNumber = categoryNumber.substring(1, categoryNumber.length() - 1);
            assisttContinueNumbers = categoryNumber.split(",");
            dataSet = this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), new ArrayList<QFilter>(), sel, entityId);
        } else if (categoryNumber.contains(",")) {
            String[] categroyList = categoryNumber.split(",");
            QFilter fid = new QFilter("number", "in", (Object)categroyList);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        } else {
            QFilter fid = new QFilter("number", "=", (Object)categoryNumber);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        }
        Set<Long> allIds = AssistGroupIdsProcesserFactory.getProcesser(hasParent).init(dataSet, entityId).getAllIds();
        return allIds;
    }
}

