/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;

public abstract class AbstractApiHelper {
    protected static final String SUCCESS_KEY = "success";
    protected static final String ERROR_KEY = "error";

    protected CustomApiResult<String> buildApiResult(Map<String, List<Object>> resultMap) {
        if (resultMap.containsKey(ERROR_KEY)) {
            List<Object> succObjs = resultMap.get(SUCCESS_KEY);
            List<Object> errorObjs = resultMap.get(ERROR_KEY);
            String succMessage = "";
            if (!CollectionUtils.isEmpty(succObjs)) {
                succMessage = String.format(ResManager.loadResFormat((String)"\u6210\u529f%1$s\u9879\uff1b", (String)"AbstractApiHelper_0", (String)"fi-gl-webapi", (Object[])new Object[0]), succObjs.size());
            }
            String errorMsg = String.format(ResManager.loadResFormat((String)"\u5931\u8d25%1$s\u9879\uff1a%2$s\u3002", (String)"AbstractApiHelper_4", (String)"fi-gl-webapi", (Object[])new Object[0]), errorObjs.size(), errorObjs.toString());
            return CustomApiResult.fail((String)"500", (String)(succMessage + errorMsg));
        }
        return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AbstractApiHelper_1", (String)"fi-gl-webapi", (Object[])new Object[0]));
    }

    protected void buildResult(Map<String, List<Object>> resultMap, List<Object> obj, String key) {
        List<Object> objs = resultMap.get(key);
        if (CollectionUtils.isEmpty(objs)) {
            objs = new ArrayList<Object>();
        }
        objs.addAll(obj);
        resultMap.put(key, objs);
    }

    protected long getOrgId(String orgNum) {
        long orgId;
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNum)});
        long l = orgId = orgDyn == null ? 0L : orgDyn.getLong("id");
        if (orgId == 0L) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u4e3a\u7a7a\u3002", (String)"AbstractApiHelper_2", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        return orgId;
    }

    protected long getBooksTypeId(String booksTypeNum) {
        long booksTypeId;
        DynamicObject booksTypeDyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)booksTypeNum)});
        long l = booksTypeId = booksTypeDyn == null ? 0L : booksTypeDyn.getLong("id");
        if (booksTypeId == 0L) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"AbstractApiHelper_3", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        return booksTypeId;
    }
}

