/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.reciprocal.agingservice.AgingQueryParam;
import kd.fi.gl.reciprocal.agingservice.util.AgingApiUtil;
import kd.fi.gl.util.AsstUtil;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;

@ApiModel
public class AgingApiQueryParam {
    @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="\"org-01\"")
    private @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="\"org-01\"") String orgNumber;
    @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"")
    private @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"") String bookTypeNumber;
    @ApiParam(value="\u79d1\u76ee\u7f16\u7801", required=true, example="\"112301\"")
    private @ApiParam(value="\u79d1\u76ee\u7f16\u7801", required=true, example="\"112301\"") String accountNumber;
    @ApiParam(value="\u5e01\u522b\u7f16\u7801", required=true, example="\"CNY\"", message="\u503c\u4e3a:basecurrency\uff0c\u67e5\u8be2\u7efc\u5408\u672c\u4f4d\u5e01\u8d26\u9f84")
    private @ApiParam(value="\u5e01\u522b\u7f16\u7801", required=true, example="\"CNY\"", message="\u503c\u4e3a:basecurrency\uff0c\u67e5\u8be2\u7efc\u5408\u672c\u4f4d\u5e01\u8d26\u9f84") String currencyNumber;
    @ApiParam(value="\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801", example="\"assgrp\":{\"0002\":[\"JD\"]}")
    private @ApiParam(value="\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801", example="\"assgrp\":{\"0002\":[\"JD\"]}") Map<String, List<String>> assgrp = new HashMap<String, List<String>>();
    @ApiParam(value="\u8bb0\u8d26\u65e5\u671f", required=true, example="2024-04-23 18:54:04")
    private @ApiParam(value="\u8bb0\u8d26\u65e5\u671f", required=true, example="2024-04-23 18:54:04") Date bookedDate;
    @ApiParam(value="\u622a\u6b62\u65e5\u671f", required=true, example="2024-04-23 18:54:04")
    private @ApiParam(value="\u622a\u6b62\u65e5\u671f", required=true, example="2024-04-23 18:54:04") Date expireDate;
    @ApiParam(value="\u8d26\u9f84\u4ece..\u5929", required=true, example="0")
    private @ApiParam(value="\u8d26\u9f84\u4ece..\u5929", required=true, example="0") int agingDayFrom;
    @ApiParam(value="\u5230..\u5929", required=true, example="30")
    private @ApiParam(value="\u5230..\u5929", required=true, example="30") int agingDayTo;
    @ApiParam(value="\u8d26\u9f84\u89c4\u5219", required=true, example="\u8d26\u9f84\u89c4\u5219\uff0c \u6309\u5230\u671f\u65e5\uff1a1\uff0c\u6309\u4e1a\u52a1\u65e5\u671f\uff1a-1")
    private @ApiParam(value="\u8d26\u9f84\u89c4\u5219", required=true, example="\u8d26\u9f84\u89c4\u5219\uff0c \u6309\u5230\u671f\u65e5\uff1a1\uff0c\u6309\u4e1a\u52a1\u65e5\u671f\uff1a-1") Integer caculateRule;
    @ApiParam(value="\u8d26\u9f84\u663e\u793a", required=true, example="\u6309\u4f59\u989d\u663e\u793a\u8d26\u9f84\uff1atrue\uff0c\u6309\u5b9e\u9645\u6838\u9500\u663e\u793a\u8d26\u9f84\uff1afalse")
    private @ApiParam(value="\u8d26\u9f84\u663e\u793a", required=true, example="\u6309\u4f59\u989d\u663e\u793a\u8d26\u9f84\uff1atrue\uff0c\u6309\u5b9e\u9645\u6838\u9500\u663e\u793a\u8d26\u9f84\uff1afalse") boolean showByAmount;
    private Map<String, String> flexToNumberMap = new HashMap<String, String>();

    public String toString() {
        try {
            return JSONUtils.toString((Object)this);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    public AgingQueryParam toAgingQueryParam() {
        long orgId;
        AgingQueryParam param = new AgingQueryParam();
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getOrgNumber())});
        long l = orgId = orgDyn == null ? 0L : orgDyn.getLong("id");
        if (orgId == 0L) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"AgingApiQueryParam_0", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        param.setOrgId(orgId);
        HasPermOrgResult permOrgResult = InterfacePermissionService.getAllPermOrgs((PermissionType)PermissionType.API);
        String permName = InterfacePermissionService.getPermName((PermissionType)PermissionType.API);
        String errorMsg = AcctUtil.checkPermByOrgId((String)this.orgNumber, (String)permName, (long)orgId, (HasPermOrgResult)permOrgResult);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            throw new GLException(GLErrorCode.common, new Object[]{errorMsg});
        }
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getBookTypeNumber())});
        long bookTypeId = bookTypeDyn == null ? 0L : bookTypeDyn.getLong("id");
        param.setBookTypeId(bookTypeId);
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (bookInfo == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"AgingApiQueryParam_1", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        if (!bookInfo.isIsbizunit()) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u865a\u4f53\u7ec4\u7ec7\u3002", (String)"AgingApiQueryParam_8", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        param.setPeriodType(Long.valueOf(bookInfo.getPeriodTypeId()));
        Date bookedDate = this.getBookedDate();
        if (bookedDate == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgingApiQueryParam_4", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        DynamicObject periodDyn = PeriodUtil.getPeriodByDate((Date)bookedDate, (long)bookInfo.getPeriodTypeId());
        if (periodDyn == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"AgingApiQueryParam_11", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        long accountTableId = bookInfo.getAccountTableId();
        param.setAccountTableId(accountTableId);
        long accountMasterId = 0L;
        String acctNumber = this.getAccountNumber();
        if (StringUtils.isNotBlank((CharSequence)acctNumber)) {
            ArrayList<QFilter> accountFilters = new ArrayList<QFilter>(8);
            accountFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
            accountFilters.add(new QFilter("number", "=", (Object)acctNumber));
            accountFilters.add(new QFilter("accheck", "=", (Object)"1"));
            accountFilters.add(new QFilter("isleaf", "=", (Object)"1"));
            QFilter atFilter = new QFilter("startdate", "<=", (Object)periodDyn.getDate("enddate"));
            atFilter.and(new QFilter("enddate", ">=", (Object)periodDyn.getDate("enddate")));
            accountFilters.add(atFilter);
            DynamicObject acctDyn = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"masterid", (QFilter[])accountFilters.toArray(new QFilter[0]));
            if (acctDyn != null) {
                accountMasterId = acctDyn.getLong("masterid");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)acctNumber) && accountMasterId == 0L) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8f93\u5165\u7684\u79d1\u76ee\u7f16\u7801\u6709\u8bef\u3002", (String)"AgingApiQueryParam_2", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        param.setAccountMasterId(accountMasterId);
        long currencyId = 0L;
        String currencyNumber = this.getCurrencyNumber();
        if (!"basecurrency".equalsIgnoreCase(currencyNumber)) {
            DynamicObject currencyDyn = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getCurrencyNumber())});
            if (currencyDyn == null) {
                throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u5e01\u79cd\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"AgingApiQueryParam_3", (String)"fi-gl-webapi", (Object[])new Object[0])});
            }
            currencyId = currencyDyn.getLong("id");
        }
        param.setCurrencyId(currencyId);
        Map<String, List<String>> assgrp = this.getAssgrp();
        Map<String, Map<String, ?>> felxAssgrpMap = AsstUtil.assgrpNumberToID(assgrp);
        Map<String, ?> assgrpIdMap = felxAssgrpMap.get("assgrpIdMap");
        Set<String> flexSet = assgrpIdMap.keySet();
        if (assgrp.size() != flexSet.size()) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801\u6709\u8bef\u3002", (String)"AgingApiQueryParam_7", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        HashMap assgrpMap = new HashMap(16);
        for (Map.Entry<String, ?> entry : assgrpIdMap.entrySet()) {
            HashSet assgrpValues = new HashSet(8);
            if (entry.getValue() != null) {
                assgrpValues.addAll(((Map)entry.getValue()).values());
            }
            assgrpMap.put(entry.getKey(), assgrpValues);
        }
        param.setAssgrp(assgrpMap);
        param.setBookedDate(bookedDate);
        Date expireDate = this.getExpireDate();
        if (expireDate == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgingApiQueryParam_5", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        param.setExpireDate(expireDate);
        int agingDayFrom = this.getAgingDayFrom();
        int agingDayTo = this.getAgingDayTo();
        if (agingDayTo < 0 || agingDayFrom < 0) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8d26\u9f84\u6bb5\u6570\u5b57\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"AgingApiQueryParam_10", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        param.setAgingDayFrom(agingDayFrom);
        param.setAgingDayTo(agingDayTo);
        Integer caculateRule = this.getCaculateRule();
        if (caculateRule == null || caculateRule != -1 && caculateRule != 1) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8d26\u9f84\u89c4\u5219\u6709\u8bef\u3002", (String)"AgingApiQueryParam_6", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        param.setCaculateRule(caculateRule);
        param.setShowByAmount(this.isShowByAmount());
        boolean exists = AgingApiUtil.isEndInit((long)orgId, (long)bookTypeId, (long)accountMasterId);
        if (!exists) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u79d1\u76ee\u672a\u7ed3\u675f\u5f80\u6765\u4f59\u989d\u521d\u59cb\u5316\u3002", (String)"AgingApiQueryParam_9", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        return param;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public String getBookTypeNumber() {
        return this.bookTypeNumber;
    }

    public void setBookTypeNumber(String bookTypeNumber) {
        this.bookTypeNumber = bookTypeNumber;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public Map<String, List<String>> getAssgrp() {
        return this.assgrp;
    }

    public void setAssgrp(Map<String, List<String>> assgrp) {
        this.assgrp = assgrp;
    }

    public Date getBookedDate() {
        return this.bookedDate;
    }

    public void setBookedDate(Date bookedDate) {
        this.bookedDate = bookedDate;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public int getAgingDayFrom() {
        return this.agingDayFrom;
    }

    public void setAgingDayFrom(int agingDayFrom) {
        this.agingDayFrom = agingDayFrom;
    }

    public int getAgingDayTo() {
        return this.agingDayTo;
    }

    public void setAgingDayTo(int agingDayTo) {
        this.agingDayTo = agingDayTo;
    }

    public Integer getCaculateRule() {
        return this.caculateRule;
    }

    public void setCaculateRule(Integer caculateRule) {
        this.caculateRule = caculateRule;
    }

    public boolean isShowByAmount() {
        return this.showByAmount;
    }

    public void setShowByAmount(boolean showByAmount) {
        this.showByAmount = showByAmount;
    }

    public Map<String, String> getFlexToNumberMap() {
        return this.flexToNumberMap;
    }

    public void setFlexToNumberMap(Map<String, String> flexToNumberMap) {
        this.flexToNumberMap = flexToNumberMap;
    }
}

