/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.service.BalanceQueryParam;
import kd.fi.gl.util.AsstUtil;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;

@ApiModel
public class BalanceQueryParamApi {
    @ApiParam(value="\u67e5\u8be2\u5b57\u6bb5", required=true, example="[\"org\",\"endfor\"]")
    private @ApiParam(value="\u67e5\u8be2\u5b57\u6bb5", required=true, example="[\"org\",\"endfor\"]") List<String> selectors = new ArrayList<String>();
    @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="\"org1\"")
    private @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="\"org1\"") String orgNumber;
    private Set<String> orgNumbers;
    @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"")
    private @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"") String bookTypeNumber;
    @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true, example="\"202304\"")
    private @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true, example="\"202304\"") String periodNumber;
    @ApiParam(value="\u5e01\u522b\u7f16\u7801", example="\"CNY\"")
    private @ApiParam(value="\u5e01\u522b\u7f16\u7801", example="\"CNY\"") String currencyNumber;
    @ApiParam(value="\u79d1\u76ee\u8868\u7f16\u7801", example="\"100000\"")
    private @ApiParam(value="\u79d1\u76ee\u8868\u7f16\u7801", example="\"100000\"") String accountTableNumber;
    @ApiParam(value="\u79d1\u76ee\u7f16\u7801\uff1a\u591a\u7ec4\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801", example="{\"1001.01\":[{\"0001\":\"value1\"}]}")
    private @ApiParam(value="\u79d1\u76ee\u7f16\u7801\uff1a\u591a\u7ec4\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801", example="{\"1001.01\":[{\"0001\":\"value1\"}]}") Map<String, List<Map<String, String>>> accountAssgrp = new HashMap<String, List<Map<String, String>>>();
    @ApiParam(value="\u5206\u7ec4\u5b57\u6bb5", example="[\"org\",\"endfor\"]")
    private @ApiParam(value="\u5206\u7ec4\u5b57\u6bb5", example="[\"org\",\"endfor\"]") List<String> groupBys = new ArrayList<String>();
    @ApiParam(value="\u662f\u5426\u6263\u51cf\u635f\u76ca\u7c7b\u91d1\u989d", example="false")
    private @ApiParam(value="\u662f\u5426\u6263\u51cf\u635f\u76ca\u7c7b\u91d1\u989d", example="false") boolean isSubstractPL = false;
    @ApiParam(value="\u6307\u5b9a\u79d1\u76ee\u67e5\u8be2", example="true")
    private @ApiParam(value="\u6307\u5b9a\u79d1\u76ee\u67e5\u8be2", example="true") boolean isSpecialAccount = true;
    @ApiParam(value="\u516c\u5171\u7ef4\u5ea6", example="{\"comassist1\":[\"value1\",\"value2\"]}")
    private @ApiParam(value="\u516c\u5171\u7ef4\u5ea6", example="{\"comassist1\":[\"value1\",\"value2\"]}") Map<String, List<String>> comassist = new HashMap<String, List<String>>(1);
    private Map<String, String> flexToNumberMap = new HashMap<String, String>();
    public HashSet<String> balanceFields = new HashSet<String>(){
        {
            this.add("org");
            this.add("booktype");
            this.add("period");
            this.add("endperiod");
            this.add("accounttable");
            this.add("account");
            this.add("assgrp");
            this.add("currency");
            this.add("measureunit");
            this.add("beginfor");
            this.add("debitfor");
            this.add("creditfor");
            this.add("endfor");
            this.add("beginlocal");
            this.add("debitlocal");
            this.add("creditlocal");
            this.add("endlocal");
            this.add("yeardebitfor");
            this.add("yeardebitlocal");
            this.add("yearcreditfor");
            this.add("yearcreditlocal");
            this.add("beginqty");
            this.add("debitqty");
            this.add("creditqty");
            this.add("endqty");
            this.add("yeardebitqty");
            this.add("yearcreditqty");
            this.add("count");
        }
    };
    public HashSet<String> dcFields = new HashSet<String>(){
        {
            this.add("beginqty");
            this.add("beginfor");
            this.add("beginlocal");
            this.add("endqty");
            this.add("endfor");
            this.add("endlocal");
        }
    };

    public List<String> getSelector() {
        return this.selectors;
    }

    public void addSelector(String selector) {
        this.selectors.add(selector);
    }

    public List<String> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<String> selectors) {
        this.selectors = selectors;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public Set<String> getOrgNumbers() {
        return this.orgNumbers;
    }

    public void setOrgNumbers(Set<String> orgNumbers) {
        this.orgNumbers = orgNumbers;
    }

    public String getBookTypeNumber() {
        return this.bookTypeNumber;
    }

    public void setBookTypeNumber(String bookTypeNumber) {
        this.bookTypeNumber = bookTypeNumber;
    }

    public String getPeriodNumber() {
        return this.periodNumber;
    }

    public void setPeriodNumber(String periodNumber) {
        this.periodNumber = periodNumber;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public String getAccountTableNumber() {
        return this.accountTableNumber;
    }

    public void setAccountTableNumber(String accountTableNumber) {
        this.accountTableNumber = accountTableNumber;
    }

    public Map<String, List<String>> getComassist() {
        return this.comassist;
    }

    public void setComassist(Map<String, List<String>> comassist) {
        this.comassist = comassist;
    }

    public Map<String, List<Map<String, String>>> getAccountAssgrp() {
        return this.accountAssgrp;
    }

    public void setAccountAssgrp(Map<String, List<Map<String, String>>> accountAssgrp) {
        this.accountAssgrp = accountAssgrp;
    }

    public List<String> getGroupBy() {
        return this.groupBys;
    }

    public void addGroupBy(String groupBy) {
        this.groupBys.add(groupBy);
    }

    public List<String> getGroupBys() {
        return this.groupBys;
    }

    public void setGroupBys(List<String> groupBys) {
        this.groupBys = groupBys;
    }

    public Map<String, String> getFlexToNumberMap() {
        return this.flexToNumberMap;
    }

    public void setFlexToNumberMap(Map<String, String> flexToNumberMap) {
        this.flexToNumberMap = flexToNumberMap;
    }

    public HashSet<String> getBalanceFields() {
        return this.balanceFields;
    }

    public void setBalanceFields(HashSet<String> balanceFields) {
        this.balanceFields = balanceFields;
    }

    public HashSet<String> getDcFields() {
        return this.dcFields;
    }

    public void setDcFields(HashSet<String> dcFields) {
        this.dcFields = dcFields;
    }

    public String toString() {
        try {
            return JSONUtils.toString((Object)this);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    protected BalanceQueryParam toBalanceQueryParam() {
        String orgTable = "bos_org";
        String bookTypeTable = "bd_accountbookstype";
        String currencyTable = "bd_currency";
        String accountTableTable = "bd_accounttable";
        BalanceQueryParam param = new BalanceQueryParam();
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)orgTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getOrgNumber())});
        long orgId = orgDyn == null ? 0L : orgDyn.getLong("id");
        param.setOrgId(orgId);
        Set<String> orgNumbers = this.getOrgNumbers();
        if (null != orgNumbers && orgNumbers.size() > 0) {
            DynamicObjectCollection orgDyns = QueryServiceHelper.query((String)orgTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", orgNumbers)});
            for (DynamicObject dyn : orgDyns) {
                param.setOrgId(dyn.getLong("id"));
            }
        }
        if (orgId == 0L) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u4e3a\u7a7a", (String)"BalanceQueryParamApi_2", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        HasPermOrgResult permOrgResult = InterfacePermissionService.getAllPermOrgs((PermissionType)PermissionType.API);
        String permName = InterfacePermissionService.getPermName((PermissionType)PermissionType.API);
        String errorMsg = AcctUtil.checkPermByOrgId((String)this.orgNumber, (String)permName, (long)orgId, (HasPermOrgResult)permOrgResult);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            throw new GLException(GLErrorCode.common, new Object[]{errorMsg});
        }
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)bookTypeTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getBookTypeNumber())});
        long bookTypeId = bookTypeDyn == null ? 0L : bookTypeDyn.getLong("id");
        param.setBookTypeId(bookTypeId);
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (bookInfo == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"BalanceQueryParamApi_1", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        DynamicObject periodDyn = AsstUtil.queryPeriodIdByNumber(bookInfo.getPeriodTypeId(), this.getPeriodNumber());
        if (periodDyn == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u671f\u95f4\u4e3a\u7a7a", (String)"BalanceQueryParamApi_3", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        long periodId = periodDyn.getLong("id");
        param.setPeriodId(periodId);
        long accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
        if (accountTableId == 0L) {
            DynamicObject accountTableDyn = QueryServiceHelper.queryOne((String)accountTableTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getAccountTableNumber())});
            accountTableId = accountTableDyn == null ? bookInfo.getAccountTableId() : accountTableDyn.getLong("id");
        }
        param.setAccountTableId(accountTableId);
        Map<String, Object> flexMap = AsstUtil.acctAssgrpNumberToID(this.getAccountAssgrp(), accountTableId, orgId, periodDyn);
        Map acctAssgrpMap = (Map)flexMap.get("flexToIdMap");
        if (!this.getAccountAssgrp().isEmpty() && acctAssgrpMap.isEmpty()) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u79d1\u76ee\u89e3\u6790\u540e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"BalanceQueryParamApi_4", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        for (Map.Entry acctAssgEntry : acctAssgrpMap.entrySet()) {
            param.setAccountAssgrp((Long)acctAssgEntry.getKey(), (List)acctAssgEntry.getValue());
        }
        DynamicObject currencyDyn = QueryServiceHelper.queryOne((String)currencyTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getCurrencyNumber())});
        param.setCurrencyId(currencyDyn == null ? 0L : currencyDyn.getLong("id"));
        Map numberToFlexMap = (Map)flexMap.get("numberToFlex");
        Set<Object> numberFlexSet = numberToFlexMap == null ? new HashSet() : numberToFlexMap.keySet();
        List<String> selectFields = this.getSelector();
        for (String field : selectFields) {
            if (numberToFlexMap != null && numberFlexSet.contains(field.trim())) {
                String flex = (String)numberToFlexMap.get(field);
                param.addSelector(flex);
                this.flexToNumberMap.put(flex, field);
                continue;
            }
            if (field.startsWith("comassist")) {
                this.flexToNumberMap.put(field, field);
                param.addSelector(field);
                continue;
            }
            param.addSelector(field);
        }
        param.setComassit(AsstUtil.transComassist(accountTableId, this.getComassist()));
        this.initGroupField(param, numberToFlexMap, numberFlexSet);
        Set<String> comAssistFieldSet = this.flexToNumberMap.keySet().stream().filter(key -> key.startsWith("comassist")).collect(Collectors.toSet());
        if (!AsstUtil.checkComAssistFieldIsExist(comAssistFieldSet, accountTableId)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u5b57\u6bb5\u6216\u5206\u7ec4\u5b57\u6bb5\u4e2d\u5b58\u5728\u65e0\u6548\u7684\u516c\u5171\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"BalanceQueryParamApi_5", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        param.setSubstractPL(this.isSubstractPL());
        param.setSpecialAccount(this.isSpecialAccount());
        return param;
    }

    public List<Map<String, Object>> flexToNumberData(List<Map<String, Object>> flexDataList, long accountTableId) {
        if (!this.flexToNumberMap.isEmpty()) {
            HashMap flexToIdsMap = new HashMap();
            HashMap<String, Set<Long>> comAssistToIdsMap = new HashMap<String, Set<Long>>(8);
            Set<String> flexs = this.flexToNumberMap.keySet();
            for (Map<String, Object> map : flexDataList) {
                for (String flex : flexs) {
                    if (flex.startsWith("comassist")) {
                        Set allComAssistIdSet = comAssistToIdsMap.computeIfAbsent(flex, key -> new HashSet());
                        allComAssistIdSet.add((Long)map.get(flex));
                        continue;
                    }
                    long id = map.get(flex) == null ? 0L : (Long)map.get(flex);
                    Set<Long> set = flexToIdsMap.get(flex) == null ? new HashSet() : (Set)flexToIdsMap.get(flex);
                    set.add(id);
                    flexToIdsMap.put(flex, set);
                }
            }
            HashMap<String, String> flexToEntityIdMap = new HashMap<String, String>();
            HashMap<String, String> flexToNumberMap = new HashMap<String, String>();
            QFilter fflexs = new QFilter("flexfield", "in", flexToIdsMap.keySet());
            DataSet assistSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_asstacttype", (String)"flexfield,number,valuesource,valuetype", (QFilter[])fflexs.toArray(), null);
            for (Object row : assistSet) {
                String string = row.getString("valuetype");
                String entityId = null;
                switch (string) {
                    case "1": {
                        entityId = row.getString("valuesource");
                        break;
                    }
                    case "2": {
                        entityId = "bos_assistantdata_detail";
                    }
                }
                String flex = row.getString("flexfield");
                String number = row.getString("number");
                flexToEntityIdMap.put(flex, entityId);
                flexToNumberMap.put(flex, number);
            }
            HashMap flexMap = new HashMap(flexToIdsMap.size());
            for (Map.Entry entry : flexToIdsMap.entrySet()) {
                String flex = (String)entry.getKey();
                Set ids = (Set)entry.getValue();
                DataSet dataSet = AsstUtil.queryEntityId((String)flexToEntityIdMap.get(flex), ids);
                HashMap idToEntityMap = new HashMap();
                for (Row row : dataSet) {
                    String number = row.getString("number");
                    String name = row.getString("name");
                    long id = row.getLong("id");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("number", number);
                    map.put("name", name);
                    idToEntityMap.put(id, map);
                }
                flexMap.put(flex, idToEntityMap);
            }
            Table<String, Long, Map<String, String>> comAssistIdToNumTable = AsstUtil.queryComAssistIdToNum(comAssistToIdsMap, accountTableId);
            for (Map<String, Object> map : flexDataList) {
                HashMap assgrpMap = new HashMap(flexs.size());
                Set comAssistKeySet = comAssistToIdsMap.keySet();
                HashMap<String, Object> comAssistMap = new HashMap<String, Object>(comAssistKeySet.size());
                for (String flex : flexs) {
                    Object value = map.remove(flex);
                    if (!Objects.nonNull(value)) continue;
                    long id = Long.parseLong(value.toString());
                    if (flex.startsWith("comassist")) {
                        comAssistMap.put(flex, comAssistIdToNumTable.get((Object)flex, (Object)id));
                        continue;
                    }
                    Map idToEntityMap = (Map)flexMap.get(flex);
                    Map numberMap = (Map)idToEntityMap.get(id);
                    assgrpMap.put(flexToNumberMap.get(flex), numberMap);
                }
                if (!comAssistKeySet.isEmpty()) {
                    map.put("comassist", comAssistMap);
                }
                map.put("assgrp", assgrpMap);
            }
            return flexDataList;
        }
        return flexDataList;
    }

    public boolean isSubstractPL() {
        return this.isSubstractPL;
    }

    public void setSubstractPL(boolean isSubstractPL) {
        this.isSubstractPL = isSubstractPL;
    }

    public boolean isSpecialAccount() {
        return this.isSpecialAccount;
    }

    public void setSpecialAccount(boolean isSpecialAccount) {
        this.isSpecialAccount = isSpecialAccount;
    }

    private void initGroupField(BalanceQueryParam param, Map<String, String> numberToFlexMap, Set<String> numberFlexSet) {
        List<String> groupFieldList = this.getGroupBy();
        for (String field : groupFieldList) {
            field = field.trim();
            String[] fieldNames = field.split(" ");
            if (numberToFlexMap != null && numberFlexSet.contains(fieldNames[0])) {
                String flex = numberToFlexMap.get(fieldNames[0]);
                if (fieldNames.length == 2) {
                    this.flexToNumberMap.put(flex, fieldNames[1]);
                } else {
                    this.flexToNumberMap.put(flex, fieldNames[0]);
                }
                param.addGroupBy(flex);
                continue;
            }
            if (fieldNames[0].startsWith("comassist")) {
                if (fieldNames.length == 2) {
                    this.flexToNumberMap.put(fieldNames[0], fieldNames[1]);
                } else {
                    this.flexToNumberMap.put(fieldNames[0], fieldNames[0]);
                }
                param.addGroupBy(fieldNames[0]);
                continue;
            }
            param.addGroupBy(field);
        }
    }
}

