/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.api.CashflowQueryParamApi;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.service.CashflowQueryParam;
import kd.fi.gl.service.CashflowServiceImpl;

@ApiController(value="gl", desc="\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3")
public class CashflowServiceApiHelper
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(CashflowServiceApiHelper.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            String param = (String)params.get("data");
            if (param == null || StringUtils.isBlank((String)param)) {
                return null;
            }
            CashflowQueryParamApi queryParamApi = (CashflowQueryParamApi)JSONUtils.cast((String)param, CashflowQueryParamApi.class);
            CashflowServiceImpl impl = new CashflowServiceImpl();
            List<Map<String, Object>> data = null;
            CashflowQueryParam queryParam = queryParamApi.toCashflowQueryParam();
            if (queryParam.getSelector().contains("amount")) {
                data = impl.getCashFlowAmountData(queryParam);
            } else if (queryParam.getSelector().contains("yearamount")) {
                data = impl.getCashFlowYearAmountData(queryParam);
            }
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)queryParam.getOrgId(), (long)queryParam.getBookTypeId());
            data = queryParamApi.flexToNumberData(data, bookInfo.getAccountTableId());
            String strData = JSONUtils.toString(data);
            return ApiResult.success((Object)strData);
        }
        catch (Exception e) {
            GLException glException = new GLException(new ErrorCode(e.getCause() == null ? Arrays.toString(e.getStackTrace()) : e.getCause().getMessage(), e.getMessage()), new Object[0]);
            return ApiResult.ex((Throwable)glException);
        }
    }

    public Map<String, Object> getCashflow(Map<String, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ApiResult result = this.doCustomService(params);
        map.put("getData", result.getData());
        map.put("getSuccess", result.getSuccess());
        map.put("getErrorCode", result.getErrorCode());
        map.put("getMessage", result.getMessage());
        return map;
    }

    @ApiPostMapping(value="/getCashflowApi")
    public CustomApiResult<String> getCashflowApi(@ApiRequestBody CashflowQueryParamApi model) {
        String strData = "";
        try {
            CashflowServiceImpl impl = new CashflowServiceImpl();
            List<Map<String, Object>> data = null;
            CashflowQueryParam queryParam = model.toCashflowQueryParam();
            if (queryParam.getSelector().contains("amount")) {
                data = impl.getCashFlowAmountData(queryParam);
            } else if (queryParam.getSelector().contains("yearamount")) {
                data = impl.getCashFlowYearAmountData(queryParam);
            }
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)queryParam.getOrgId(), (long)queryParam.getBookTypeId());
            data = model.flexToNumberData(data, bookInfo.getAccountTableId());
            strData = JSONUtils.toString(data);
        }
        catch (Exception e) {
            log.error("get cashflow fail \uff1a " + e.getMessage(), (Throwable)e);
            GLException glException = new GLException(e instanceof GLException ? ((GLException)e).getErrorCode() : new ErrorCode("999", "Unknown"), new Object[]{e.getMessage()});
            ApiResult apiResult = ApiResult.ex((Throwable)glException);
            return CustomApiResult.fail((String)apiResult.getErrorCode(), (String)apiResult.getMessage());
        }
        return CustomApiResult.success((Object)strData);
    }
}

