/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.service.DetailBalanceQueryParam;
import kd.fi.gl.util.AsstUtil;

@ApiModel
public class DetailBalanceQueryParamApi {
    @ApiParam(value="\u67e5\u8be2\u5b57\u6bb5", required=true, example="[\"org\",\"endfor\"]")
    private @ApiParam(value="\u67e5\u8be2\u5b57\u6bb5", required=true, example="[\"org\",\"endfor\"]") List<String> selectors = new ArrayList<String>();
    @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="[\"org1\",\"org2\"]")
    private @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="[\"org1\",\"org2\"]") Set<String> orgNumbers;
    @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"")
    private @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"") String bookTypeNumber;
    @ApiParam(value="\u79d1\u76ee\u8868\u7f16\u7801", example="\"100000\"")
    private @ApiParam(value="\u79d1\u76ee\u8868\u7f16\u7801", example="\"100000\"") String accountTableNumber;
    @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true, example="\"202304\"")
    private @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true, example="\"202304\"") String periodNumber;
    @ApiParam(value="\u79d1\u76ee\u7f16\u7801", required=false, example="[\"1001.01\",\"1002.02\"]")
    private @ApiParam(value="\u79d1\u76ee\u7f16\u7801", required=false, example="[\"1001.01\",\"1002.02\"]") Set<String> accountNumbers;
    @ApiParam(value="\u591a\u7ec4\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801", example="{\"0001\":[{\"value1\",\"value2\"}]}")
    private @ApiParam(value="\u591a\u7ec4\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801", example="{\"0001\":[{\"value1\",\"value2\"}]}") Map<String, List<String>> assgrps = new HashMap<String, List<String>>();
    @ApiParam(value="\u516c\u5171\u7ef4\u5ea6", example="{\"comassist1\":[\"value1\",\"value2\"]}")
    private @ApiParam(value="\u516c\u5171\u7ef4\u5ea6", example="{\"comassist1\":[\"value1\",\"value2\"]}") Map<String, List<String>> comassist = new HashMap<String, List<String>>(1);
    @ApiParam(value="\u5e01\u522b\u7f16\u7801", example="\"CNY\"")
    private @ApiParam(value="\u5e01\u522b\u7f16\u7801", example="\"CNY\"") String currencyNumber;
    @ApiParam(value="\u8ba1\u91cf\u5355\u4f4d", example="\"kg\"")
    private @ApiParam(value="\u8ba1\u91cf\u5355\u4f4d", example="\"kg\"") String[] measureUnits;
    @ApiParam(value="\u67e5\u8be2\u9875\u7801", example="\"1\"")
    private @ApiParam(value="\u67e5\u8be2\u9875\u7801", example="\"1\"") Integer pageNo;
    @ApiParam(value="\u5206\u9875\u6761\u6570", example="\"1000\"")
    private @ApiParam(value="\u5206\u9875\u6761\u6570", example="\"1000\"") Integer pageSize;
    @ApiParam(value="\u8bf7\u6c42id,\u53d6\u7f13\u5b58\u4e2d\u7684\u603b\u6761\u6570\uff0c\u6ca1\u6709\u8bf7\u6c42id\uff0c\u8bf7\u6e05\u7a7a\u8be5\u5b57\u6bb5\uff0c\u4e0d\u8981\u5e26\u9ed8\u8ba4\u503c", example="\"3I2ZLP96FJYJ\"")
    private @ApiParam(value="\u8bf7\u6c42id,\u53d6\u7f13\u5b58\u4e2d\u7684\u603b\u6761\u6570\uff0c\u6ca1\u6709\u8bf7\u6c42id\uff0c\u8bf7\u6e05\u7a7a\u8be5\u5b57\u6bb5\uff0c\u4e0d\u8981\u5e26\u9ed8\u8ba4\u503c", example="\"3I2ZLP96FJYJ\"") String requestId;
    private Map<String, String> flexToNumberMap = new HashMap<String, String>();
    public HashSet<String> balanceFields = new HashSet<String>(){
        {
            this.add("org");
            this.add("booktype");
            this.add("period");
            this.add("endperiod");
            this.add("accounttable");
            this.add("account");
            this.add("assgrp");
            this.add("currency");
            this.add("measureunit");
            this.add("beginfor");
            this.add("debitfor");
            this.add("creditfor");
            this.add("endfor");
            this.add("beginlocal");
            this.add("debitlocal");
            this.add("creditlocal");
            this.add("endlocal");
            this.add("yeardebitfor");
            this.add("yeardebitlocal");
            this.add("yearcreditfor");
            this.add("yearcreditlocal");
            this.add("beginqty");
            this.add("debitqty");
            this.add("creditqty");
            this.add("endqty");
            this.add("yeardebitqty");
            this.add("yearcreditqty");
            this.add("count");
        }
    };
    public HashSet<String> dcFields = new HashSet<String>(){
        {
            this.add("beginqty");
            this.add("beginfor");
            this.add("beginlocal");
            this.add("endqty");
            this.add("endfor");
            this.add("endlocal");
        }
    };

    public List<String> getSelector() {
        return this.selectors;
    }

    public void addSelector(String selector) {
        this.selectors.add(selector);
    }

    public List<String> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<String> selectors) {
        this.selectors = selectors;
    }

    public Set<String> getOrgNumbers() {
        return this.orgNumbers;
    }

    public void setOrgNumbers(Set<String> orgNumbers) {
        this.orgNumbers = orgNumbers;
    }

    public String getBookTypeNumber() {
        return this.bookTypeNumber;
    }

    public void setBookTypeNumber(String bookTypeNumber) {
        this.bookTypeNumber = bookTypeNumber;
    }

    public String getPeriodNumber() {
        return this.periodNumber;
    }

    public void setPeriodNumber(String periodNumber) {
        this.periodNumber = periodNumber;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public String getAccountTableNumber() {
        return this.accountTableNumber;
    }

    public void setAccountTableNumber(String accountTableNumber) {
        this.accountTableNumber = accountTableNumber;
    }

    public Map<String, List<String>> getComassist() {
        return this.comassist;
    }

    public void setComassist(Map<String, List<String>> comassist) {
        this.comassist = comassist;
    }

    public Map<String, String> getFlexToNumberMap() {
        return this.flexToNumberMap;
    }

    public void setFlexToNumberMap(Map<String, String> flexToNumberMap) {
        this.flexToNumberMap = flexToNumberMap;
    }

    public HashSet<String> getBalanceFields() {
        return this.balanceFields;
    }

    public void setBalanceFields(HashSet<String> balanceFields) {
        this.balanceFields = balanceFields;
    }

    public HashSet<String> getDcFields() {
        return this.dcFields;
    }

    public void setDcFields(HashSet<String> dcFields) {
        this.dcFields = dcFields;
    }

    public Set<String> getAccountNumbers() {
        return this.accountNumbers;
    }

    public void setAccountNumbers(Set<String> accountNumbers) {
        this.accountNumbers = accountNumbers;
    }

    public Map<String, List<String>> getAssgrps() {
        return this.assgrps;
    }

    public void setAssgrps(Map<String, List<String>> assgrps) {
        this.assgrps = assgrps;
    }

    public String[] getMeasureUnits() {
        return this.measureUnits;
    }

    public void setMeasureUnitIds(String[] measureUnits) {
        this.measureUnits = measureUnits;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String toString() {
        try {
            return JSONUtils.toString((Object)this);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    protected DetailBalanceQueryParam toDetailBalanceQueryParam() {
        String[] measureUnits;
        Map<String, Set<Object>> assgrpsIds;
        QFilter fpn;
        DynamicObject accountTableDyn;
        String orgTable = "bos_org";
        String bookTypeTable = "bd_accountbookstype";
        String periodTable = "bd_period";
        String currencyTable = "bd_currency";
        String accountTableTable = "bd_accounttable";
        DetailBalanceQueryParam param = new DetailBalanceQueryParam();
        Set<String> orgNumbers = this.getOrgNumbers();
        long[] orgIds = null;
        if (null == orgNumbers || orgNumbers.size() == 0) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"DetailBalanceQueryParamApi_1", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        DynamicObjectCollection orgDyns = QueryServiceHelper.query((String)orgTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", orgNumbers)});
        orgIds = new long[orgDyns.size()];
        for (int i = 0; i < orgDyns.size(); ++i) {
            DynamicObject dyn = (DynamicObject)orgDyns.get(i);
            orgIds[i] = dyn.getLong("id");
        }
        param.setOrgIds(orgIds);
        if (orgIds.length == 0) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u4e3a\u7a7a\u3002", (String)"DetailBalanceQueryParamApi_2", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)bookTypeTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getBookTypeNumber())});
        if (bookTypeDyn == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"DetailBalanceQueryParamApi_3", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        long bookTypeId = bookTypeDyn.getLong("id");
        param.setBookTypeId(bookTypeId);
        List bookInfos = AccSysUtil.getBookFromAccSys(Arrays.stream(orgIds).boxed().collect(Collectors.toSet()), (long)bookTypeId);
        if (bookInfos.isEmpty()) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"BalanceQueryParamApi_1", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        long accountTableId = 0L;
        String accountTableNumber = this.getAccountTableNumber();
        if (StringUtils.isNotEmpty((CharSequence)accountTableNumber) && (accountTableDyn = QueryServiceHelper.queryOne((String)accountTableTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accountTableNumber)})) != null) {
            accountTableId = accountTableDyn.getLong("id");
        }
        if (accountTableId == 0L) {
            HashSet<Long> accountTableIds = new HashSet<Long>(10);
            for (AccountBookInfo bookInfo : bookInfos) {
                accountTableIds.add(bookInfo.getAccountTableId());
            }
            if (accountTableIds.size() == 0) {
                throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u901a\u8fc7\u7ec4\u7ec7\u7684\u8d26\u7c3f\u83b7\u53d6\u5230\u7684\u79d1\u76ee\u8868\u4e2a\u6570\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u4ee5\u53ca\u8d26\u7c3f\u3002", (String)"DetailBalanceQueryParamApi_4", (String)"fi-gl-webapi", (Object[])new Object[0])});
            }
            if (accountTableIds.size() > 1) {
                throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u548c\u8d26\u7c3f\uff0c\u786e\u4fdd\u79d1\u76ee\u8868\u6570\u91cf\u4e0d\u8d85\u8fc71\u4e2a\u3002", (String)"DetailBalanceQueryParamApi_5", (String)"fi-gl-webapi", (Object[])new Object[0])});
            }
            accountTableId = (Long)accountTableIds.iterator().next();
        }
        param.setAccountTableId(accountTableId);
        long periodTypeId = 0L;
        HashSet<Long> periodTypeIds = new HashSet<Long>(10);
        for (AccountBookInfo bookInfo : bookInfos) {
            periodTypeIds.add(bookInfo.getPeriodTypeId());
        }
        if (periodTypeIds.size() == 0) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u901a\u8fc7\u7ec4\u7ec7\u7684\u8d26\u7c3f\u83b7\u53d6\u5230\u7684\u671f\u95f4\u7c7b\u578b\u4e2a\u6570\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u4ee5\u53ca\u8d26\u7c3f\u3002", (String)"DetailBalanceQueryParamApi_6", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        if (periodTypeIds.size() > 1) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u901a\u8fc7\u7ec4\u7ec7\u7684\u8d26\u7c3f\u83b7\u53d6\u5230\u7684\u671f\u95f4\u7c7b\u578b\u4e2a\u6570\u8d85\u8fc71\u4e2a\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u4ee5\u53ca\u8d26\u7c3f\u3002", (String)"DetailBalanceQueryParamApi_7", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        periodTypeId = (Long)periodTypeIds.iterator().next();
        String periodNumber = this.getPeriodNumber();
        if (StringUtils.isEmpty((CharSequence)periodNumber)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u671f\u95f4\u7f16\u7801\u3002", (String)"DetailBalanceQueryParamApi_8", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        QFilter fpt = new QFilter("periodtype", "=", (Object)periodTypeId);
        DynamicObject periodDyn = QueryServiceHelper.queryOne((String)periodTable, (String)"id,enddate", (QFilter[])new QFilter[]{fpt, fpn = new QFilter("number", "=", (Object)periodNumber)});
        if (periodDyn == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u901a\u8fc7\u7ec4\u7ec7\u7684\u8d26\u7c3f\u83b7\u53d6\u5230\u7684\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u4ee5\u53ca\u8d26\u7c3f\u3002", (String)"DetailBalanceQueryParamApi_9", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        long periodId = periodDyn.getLong("id");
        param.setPeriodId(periodId);
        long currencyId = 0L;
        String currencyNumber = this.getCurrencyNumber();
        if (StringUtils.isNotEmpty((CharSequence)currencyNumber)) {
            DynamicObject currencyDyn = QueryServiceHelper.queryOne((String)currencyTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyNumber)});
            currencyId = currencyDyn.getLong("id");
        }
        param.setCurrencyId(currencyId);
        List<String> selectFields = this.getSelector();
        for (String field : selectFields) {
            param.addSelector(field);
        }
        param.setComassit(AsstUtil.transComassist(accountTableId, this.getComassist()));
        ArrayList<QFilter> accountFilters = new ArrayList<QFilter>(10);
        Set accountNumbers = this.getAccountNumbers().stream().map(x -> x.trim()).filter(x -> StringUtils.isNotEmpty((CharSequence)x)).collect(Collectors.toSet());
        accountFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        if (null != accountNumbers && accountNumbers.size() > 0) {
            accountFilters.add(new QFilter("number", "in", accountNumbers));
        }
        QFilter atFilter = new QFilter("startdate", "<=", (Object)periodDyn.getDate("enddate"));
        atFilter.and(new QFilter("enddate", ">=", (Object)periodDyn.getDate("enddate")));
        accountFilters.add(atFilter);
        DynamicObjectCollection accountColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number", (QFilter[])accountFilters.toArray(new QFilter[0]));
        ArrayList<Long> accountIds = new ArrayList<Long>(10);
        for (DynamicObject acctDyn : accountColl) {
            accountIds.add(acctDyn.getLong("id"));
        }
        param.setAccountIds(accountIds);
        if (null != accountNumbers && accountNumbers.size() > 0 && accountIds.size() == 0) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8f93\u5165\u7684\u79d1\u76ee\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u7f16\u7801\u3002", (String)"DetailBalanceQueryParamApi_11", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        Map<String, List<String>> assgrps = this.getAssgrps();
        HashMap<String, String> flexfieldMap = new HashMap<String, String>(assgrps.size());
        if (assgrps.size() > 0) {
            DynamicObject[] accTypes;
            ArrayList<String> asstNumberList = new ArrayList<String>(assgrps.size());
            for (Map.Entry<String, List<String>> mapEntry : assgrps.entrySet()) {
                String asstNumber = mapEntry.getKey().trim();
                if (!StringUtils.isNotEmpty((CharSequence)asstNumber)) continue;
                asstNumberList.add(asstNumber);
            }
            QFilter asstNumberFilter = new QFilter("number", "in", asstNumberList);
            QFilter asstFflex = new QFilter("flexid", "=", (Object)2L);
            for (DynamicObject assgrpDyn : accTypes = BusinessDataServiceHelper.load((String)"bd_asstacttype", (String)"number,flexfield,valuesource,valuetype,assistanttype", (QFilter[])new QFilter[]{asstNumberFilter, asstFflex})) {
                flexfieldMap.put(assgrpDyn.getString("flexfield"), assgrpDyn.getString("number"));
            }
            asstNumberList.removeAll(flexfieldMap.values());
            if (asstNumberList.size() > 0) {
                throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801\u3002", (String)"DetailBalanceQueryParamApi_10", (String)"fi-gl-webapi", (Object[])new Object[0])});
            }
        }
        if (!(assgrpsIds = DetailBalanceQueryParamApi.assgrpNumberToID(assgrps)).isEmpty()) {
            for (Map.Entry<String, Set<Object>> entry : assgrpsIds.entrySet()) {
                List<String> assgrpsValues = assgrps.get(flexfieldMap.get(entry.getKey()));
                assgrpsValues = assgrpsValues != null && assgrpsValues.size() > 0 ? assgrpsValues.stream().map(x -> x.trim()).filter(x -> StringUtils.isNotEmpty((CharSequence)x)).collect(Collectors.toList()) : new ArrayList<String>(10);
                Set<Object> value = entry.getValue();
                if (value.size() != 0 || assgrpsValues.size() <= 0) continue;
                throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"DetailBalanceQueryParamApi_13", (String)"fi-gl-webapi", (Object[])new Object[0])});
            }
            param.setAssgrps(assgrpsIds);
        }
        if (assgrpsIds.size() > 0) {
            Set flexActIds = ReportUtils.getAccIdsByFlexFields((long)accountTableId, assgrpsIds.keySet());
            if (accountIds.size() > 0) {
                accountIds.retainAll(flexActIds);
            } else {
                accountIds.addAll(flexActIds);
            }
            if (accountIds.size() == 0) {
                throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u79d1\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u4e0e\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801\u3002", (String)"DetailBalanceQueryParamApi_12", (String)"fi-gl-webapi", (Object[])new Object[0])});
            }
            param.setAccountIds(accountIds);
        }
        if ((measureUnits = this.getMeasureUnits()) != null) {
            QFilter fnumber = new QFilter("number", "in", (Object)measureUnits);
            DataSet unitSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_measureunits", (String)"id", (QFilter[])fnumber.toArray(), null);
            ArrayList<Long> measureUnitIds = new ArrayList<Long>(measureUnits.length);
            for (Row row : unitSet) {
                measureUnitIds.add(row.getLong("id"));
            }
            param.setMeasureUnitIds(measureUnitIds.toArray(new Long[measureUnitIds.size()]));
        }
        param.setPageNo(this.getPageNo() == null ? 0 : this.getPageNo());
        param.setPageSize(this.getPageSize() == null ? 0 : this.getPageSize());
        if (!StringUtils.isEmpty((CharSequence)this.getRequestId())) {
            param.setRequestId(this.getRequestId());
        }
        return param;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, Set<Object>> assgrpNumberToID(Map<String, List<String>> assgrpMap) {
        void var11_13;
        HashMap<String, Set<Object>> assgrps = new HashMap<String, Set<Object>>(16);
        String flexField = "flexfield";
        String sstactType = "bd_asstacttype";
        ArrayList<String> asstNumberList = new ArrayList<String>(assgrpMap.size());
        for (Map.Entry<String, List<String>> mapEntry : assgrpMap.entrySet()) {
            asstNumberList.add(mapEntry.getKey());
        }
        QFilter fnumber = new QFilter("number", "in", asstNumberList);
        QFilter fflex = new QFilter("flexid", "=", (Object)2L);
        DynamicObject[] accTypes = BusinessDataServiceHelper.load((String)sstactType, (String)"number,flexfield,valuesource,valuetype,assistanttype", (QFilter[])new QFilter[]{fnumber, fflex});
        HashMap<String, String> flexfieldMap = new HashMap<String, String>(accTypes.length);
        DynamicObject[] dynamicObjectArray = accTypes;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var11_13 < n) {
            DynamicObject assgrpDyn = dynamicObjectArray[var11_13];
            flexfieldMap.put(assgrpDyn.getString("number"), assgrpDyn.getString("flexfield"));
            ++var11_13;
        }
        HashMap<String, DynamicObject> accTypeMap = new HashMap<String, DynamicObject>(accTypes.length);
        for (DynamicObject accType : accTypes) {
            accTypeMap.put(accType.getString(flexField), accType);
        }
        for (Map.Entry entry : assgrpMap.entrySet()) {
            String flex = (String)flexfieldMap.get(entry.getKey());
            List baseNumberList = (List)entry.getValue();
            DynamicObject accType = (DynamicObject)accTypeMap.get(flex);
            if (accType == null) continue;
            String entityName = "";
            QFilter fbaseNumber = new QFilter("number", "in", (Object)baseNumberList);
            DynamicObjectCollection baseColl = null;
            String midField = "masterid";
            if ("1".equals(accType.getString("valuetype"))) {
                entityName = accType.getDynamicObject("valuesource").getString("number");
                if (EntityMetadataCache.getDataEntityType((String)entityName).getProperty("masterid") == null) {
                    midField = "id";
                }
                baseColl = QueryServiceHelper.query((String)entityName, (String)(midField + ",number"), (QFilter[])new QFilter[]{fbaseNumber});
            } else if ("2".equals(accType.getString("valuetype")) && accType.getDynamicObject("assistanttype") != null) {
                entityName = accType.getDynamicObject("assistanttype").getString("number");
                QFilter filterGroup = new QFilter("number", "=", (Object)entityName);
                DynamicObject groupDyn = QueryServiceHelper.queryOne((String)"bos_assistantdatagroup", (String)"id", (QFilter[])new QFilter[]{filterGroup});
                QFilter fDetail = new QFilter("group.id", "=", groupDyn.get("id"));
                baseColl = QueryServiceHelper.query((String)"bos_assistantdata_detail", (String)"id,masterid,number", (QFilter[])new QFilter[]{fDetail, fbaseNumber});
            }
            if (baseNumberList == null || baseNumberList.isEmpty()) continue;
            if (baseColl != null) {
                for (DynamicObject baseDyn : baseColl) {
                    assgrps.computeIfAbsent(flex, k -> new HashSet()).add(baseDyn.getLong(midField));
                }
            }
            assgrps.putIfAbsent(flex, new HashSet());
        }
        return assgrps;
    }
}

