/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.ErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.api.AbstractApiHelper;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

@ApiController(value="gl", desc="\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316")
public class InitCashflowApiHelper
extends AbstractApiHelper {
    @ApiPostMapping(value="/queryInitCashflow")
    public CustomApiResult<String> queryInitCashflow(@ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="\"110220101\"", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="\"110220101\"", required=true) String orgNum, @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"2000001\"", required=true) @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"2000001\"", required=true) String booksTypeNum) {
        long orgId = this.getOrgId(orgNum);
        long bookTypeId = this.getBooksTypeId(booksTypeNum);
        if (!GLUtil.hasPermission((String)PermissonType.VIEW.getPermId(), (Long)orgId, (String)"gl_initcashflowitem")) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u201d\u7684\u201c\u67e5\u8be2\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitCashflowApiHelper_5", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        ArrayList resultMap = new ArrayList();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter booksTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter tabdeleteFilter = new QFilter("tabdelete", "=", (Object)false);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl_initcashflow", (String)"org.number, booktype.number, cfitem.number,currency.number,comassist1.number,comassist2.number,assgrp,yearamount", (QFilter[])new QFilter[]{orgFilter, booksTypeFilter, tabdeleteFilter});
        for (DynamicObject dyn : collection) {
            HashMap<String, Object> map = new HashMap<String, Object>(6);
            map.put("org.number", dyn.getString("org.number"));
            map.put("booktype.number", dyn.getString("booktype.number"));
            map.put("cfitem.number", dyn.getString("cfitem.number"));
            map.put("currency.number", dyn.getString("currency.number"));
            map.put("comassist1.number", dyn.getString("comassist1.number"));
            map.put("comassist2.number", dyn.getString("comassist2.number"));
            map.put("assgrp", GLUtil.assgrpId2String((Long)dyn.getLong("assgrp")));
            map.put("yearamount", dyn.getBigDecimal("yearamount"));
            resultMap.add(map);
        }
        try {
            String strData = JSONUtils.toString(resultMap);
            return CustomApiResult.success((Object)strData);
        }
        catch (Exception e) {
            GLException glException = new GLException(new ErrorCode(e.getCause() == null ? Arrays.toString(e.getStackTrace()) : e.getCause().getMessage(), e.getMessage()), new Object[0]);
            return CustomApiResult.fail((String)"500", (String)glException.toString());
        }
    }

    @ApiPostMapping(value="/deleteInitCashflow")
    public CustomApiResult<String> deleteInitCashflow(@ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="\"110220101\"", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="\"110220101\"", required=true) String orgNum, @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"2000001\"", required=true) @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"2000001\"", required=true) String booksTypeNum, @ApiParam(value="\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801", example="[\"1001\",\"1002\"]", required=true) @ApiParam(value="\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801", example="[\"1001\",\"1002\"]", required=true) List<String> cfItemNums) {
        HashMap<String, List<Object>> resultMap = new HashMap<String, List<Object>>(8);
        long orgId = this.getOrgId(orgNum);
        long booksTypeId = this.getBooksTypeId(booksTypeNum);
        if (!GLUtil.hasPermission((String)"4715e1f1000000ac", (Long)orgId, (String)"gl_initcashflowitem")) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u201d\u7684\u201c\u5220\u9664\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitCashflowApiHelper_3", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", cfItemNums), baseFilter});
        HashMap<String, Long> cfItems = new HashMap<String, Long>(collection.size());
        for (DynamicObject dyn : collection) {
            cfItemNums.remove(dyn.getString("number"));
            cfItems.put(dyn.getString("number"), dyn.getLong("id"));
        }
        for (String number : cfItemNums) {
            this.buildResult(resultMap, Collections.singletonList(String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff1a%1$s\u4e0d\u5b58\u5728\u3002", (String)"InitCashflowApiHelper_0", (String)"fi-gl-webapi", (Object[])new Object[0]), number)), "error");
        }
        if (cfItems.size() == 0) {
            return this.buildApiResult(resultMap);
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter booksTypeFilter = new QFilter("bookstype", "=", (Object)booksTypeId);
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"isendinitcashflow", (QFilter[])new QFilter[]{orgFilter, booksTypeFilter});
        if (bookTypeDyn.getBoolean("isendinitcashflow")) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u5220\u9664\u6570\u636e\u3002", (String)"InitCashflowApiHelper_4", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_gl_initcashflow set ftabdelete = '1' where ", new Object[0]);
        sqlBuilder.append("forgid = ?", new Object[]{orgId});
        sqlBuilder.append("and fbooktypeid = ? ", new Object[]{booksTypeId});
        sqlBuilder.appendIn("and fcfitemid ", cfItems.values().toArray());
        boolean result = DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        if (result) {
            this.buildResult(resultMap, Arrays.asList(cfItems.values().toArray()), "success");
        } else {
            this.buildResult(resultMap, Collections.singletonList(ResManager.loadKDString((String)"\u5220\u9664\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25\u3002", (String)"InitCashflowApiHelper_2", (String)"fi-gl-webapi", (Object[])new Object[0])), "error");
        }
        return this.buildApiResult(resultMap);
    }
}

