/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api.controller.closeperiod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.gl.api.response.closeperiod.ClosingJobResultResponse;
import kd.fi.gl.business.dao.closeperiod.ClosePeriodDAO;
import kd.fi.gl.business.dao.org.OrgDAO;
import kd.fi.gl.business.dao.period.PeriodDAO;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodJobInfo;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodJobServiceHelper;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodJobType;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodSubJobInfo;
import kd.fi.gl.util.GLApp;

@ApiController(value="gl", desc="\u671f\u672b\u7ed3\u8d26")
public class ClosePeriodController {
    private ClosePeriodJobType getJobType() {
        return ClosePeriodJobType.GL_API;
    }

    @ApiPostMapping(value="/closing_job", desc="\u63d0\u4ea4\u7ed3\u8d26\u4efb\u52a1")
    public CustomApiResult<@ApiResponseBody(value="\u7ed3\u8d26\u4efb\u52a1ID") String> closingJob(@ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="[\"org-001\",\"org-002\"]", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="[\"org-001\",\"org-002\"]", required=true) List<String> orgNumbers, @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="100001", required=true) @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="100001", required=true) String bookTypeNumber, @ApiParam(value="\u671f\u95f4\u7c7b\u578b\u7f16\u7801", example="001", required=true) @ApiParam(value="\u671f\u95f4\u7c7b\u578b\u7f16\u7801", example="001", required=true) String periodTypeNumber, @ApiParam(value="\u7ed3\u8d26\u81f3\u671f\u95f4\u7f16\u7801", example="202308", required=true) @ApiParam(value="\u7ed3\u8d26\u81f3\u671f\u95f4\u7f16\u7801", example="202308", required=true) String awaitPeriodNumber) {
        Optional periodTypeIdByNumber = PeriodDAO.getPeriodTypeIdByNumber((String)periodTypeNumber);
        if (!periodTypeIdByNumber.isPresent()) {
            return CustomApiResult.fail((String)"500", (String)ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801=%1$s\u7684\u671f\u95f4\u7c7b\u578b\uff0c\u8bf7\u524d\u5f80\u4f1a\u8ba1\u671f\u95f4\u521b\u5efa\u3002", (String)"ClosePeriodController_0", (String)GLApp.instance.webapiModule(), (Object[])new Object[]{periodTypeNumber}));
        }
        Long periodTypeId = (Long)periodTypeIdByNumber.get();
        Optional periodIdByNumber = PeriodDAO.getPeriodIdByNumber((long)periodTypeId, (String)awaitPeriodNumber);
        if (!periodIdByNumber.isPresent()) {
            return CustomApiResult.fail((String)"500", (String)ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u671f\u95f4\u7c7b\u578b\u7f16\u7801=%1$s,\u671f\u95f4\u7f16\u7801=%2$s\u7684\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u524d\u5f80\u4f1a\u8ba1\u671f\u95f4\u521b\u5efa\u3002", (String)"ClosePeriodController_1", (String)GLApp.instance.webapiModule(), (Object[])new Object[]{periodTypeNumber, awaitPeriodNumber}));
        }
        Map books = ClosePeriodDAO.queryClosePeriodBooks(orgNumbers, (String)bookTypeNumber, (Long)periodTypeId);
        if (books.isEmpty()) {
            return CustomApiResult.fail((String)"500", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u4e8e\u7ed3\u8d26\u7684\u8d26\u7c3f\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5bf9\u5e94\u7684\u8d26\u7c3f\u6570\u636e\u662f\u5426\u521b\u5efa\u6216\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"ClosePeriodController_2", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]));
        }
        String noBooksOrgNumbers = orgNumbers.stream().filter(x -> !books.containsKey(x)).collect(Collectors.joining("\u3001"));
        if (StringUtils.isNotEmpty((String)noBooksOrgNumbers)) {
            return CustomApiResult.fail((String)"500", (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\uff1a%1$s\u6ca1\u6709\u53ef\u7528\u4e8e\u7ed3\u8d26\u7684\u8d26\u7c3f\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5bf9\u5e94\u7684\u8d26\u7c3f\u6570\u636e\u662f\u5426\u521b\u5efa\u6216\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"ClosePeriodController_3", (String)GLApp.instance.webapiModule(), (Object[])new Object[]{noBooksOrgNumbers}));
        }
        return CustomApiResult.success((Object)ClosePeriodJobServiceHelper.asyncCommit((ClosePeriodJobType)this.getJobType(), (String)RequestContext.get().getRequestId(), (String)"gl", (Object[])new Object[]{new ArrayList(books.values()), periodIdByNumber.get()}));
    }

    @ApiGetMapping(value="/closing_job/result", desc="\u83b7\u53d6\u7ed3\u8d26\u4efb\u52a1\u6267\u884c\u7ed3\u679c")
    public CustomApiResult<@ApiResponseBody(value="\u7ed3\u8d26\u4efb\u52a1\u6267\u884c\u7ed3\u679c") ClosingJobResultResponse> closingJobResult(@ApiParam(value="\u7ed3\u8d26\u4efb\u52a1ID", example="job_00001", required=true) @ApiParam(value="\u7ed3\u8d26\u4efb\u52a1ID", example="job_00001", required=true) String jobId) {
        return CustomApiResult.success((Object)this.buildResponse(ClosePeriodJobServiceHelper.getJobInfo((ClosePeriodJobType)this.getJobType(), (String)jobId)));
    }

    private ClosingJobResultResponse buildResponse(ClosePeriodJobInfo jobInfo) {
        ClosingJobResultResponse response = new ClosingJobResultResponse();
        response.setFinish(jobInfo.isFinish());
        List subJobInfos = jobInfo.getSubJobInfos();
        if (CollectionUtils.isNotEmpty((Collection)subJobInfos)) {
            ArrayList<ClosingJobResultResponse.SubJobResult> subJobResults = new ArrayList<ClosingJobResultResponse.SubJobResult>(subJobInfos.size());
            List orgIds = subJobInfos.stream().map(x -> Long.valueOf(x.getSubJobId())).collect(Collectors.toList());
            Map numberById = OrgDAO.getNumberById(orgIds);
            for (ClosePeriodSubJobInfo subJobInfo : subJobInfos) {
                String subJobId = subJobInfo.getSubJobId();
                ClosingJobResultResponse.SubJobResult subJobResult = new ClosingJobResultResponse.SubJobResult();
                subJobResult.setOrgNumber(numberById.getOrDefault(Long.valueOf(subJobId), subJobId));
                subJobResult.setState(subJobInfo.getState());
                List itemResults = subJobInfo.getItemResults();
                if (CollectionUtils.isNotEmpty((Collection)itemResults)) {
                    ArrayList<ClosingJobResultResponse.SubJobItemResult> items = new ArrayList<ClosingJobResultResponse.SubJobItemResult>(itemResults.size());
                    for (CloseCheckItemResult itemResult : itemResults) {
                        ClosingJobResultResponse.SubJobItemResult item = new ClosingJobResultResponse.SubJobItemResult();
                        item.setItem(itemResult.getCheckItem());
                        item.setState(itemResult.getCheckState());
                        item.setResult(itemResult.getMessage());
                        items.add(item);
                    }
                    subJobResult.setItemResults(items);
                }
                subJobResults.add(subJobResult);
            }
            response.setResults(subJobResults);
        }
        return response;
    }
}

