/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class AssgrpFilterList
extends AbstractListPlugin {
    private static final String K = "gl_assgrpfilter";
    private DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.accSys);
    private static final String formId = "gl_assistfilter";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field.startsWith("org.")) {
            List pkSet = AccSysUtil.getAcctOrgPkList((String)K, (boolean)false, (PermissonType)PermissonType.VIEW);
            args.getQfilters().clear();
            args.addCustomQFilter(new QFilter("id", "in", (Object)pkSet));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Long newOrgid = GLUtil.getCustomFilterId((IFormView)this.getView(), (String)"org.id");
        IPageCache cache = this.getPageCache();
        String orgid = cache.get("orgid");
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : commonFilterColumns) {
            FormShowParameter showParameter;
            String orgId;
            if (!column.getFieldName().startsWith("org.")) continue;
            CommonFilterColumn commFilter = (CommonFilterColumn)column;
            List comboItems = AccSysUtil.getAcctOrgComboItem((String)K, (boolean)false, (PermissonType)PermissonType.VIEW);
            commFilter.setComboItems(comboItems);
            long defaultOrgId = AccSysUtil.getDefaultOrgId((String)K, (boolean)false, (PermissonType)PermissonType.VIEW);
            if (!comboItems.isEmpty() && !AccSysUtil.getAcctOrgPkList2((String)K, (boolean)false, (PermissonType)PermissonType.VIEW).contains(defaultOrgId)) {
                defaultOrgId = Long.parseLong(((ComboItem)comboItems.get(0)).getValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)(orgId = (String)(showParameter = this.getView().getFormShowParameter()).getCustomParam("imicdimension_bos_org")))) {
                defaultOrgId = Long.parseLong(orgId);
            }
            commFilter.setDefaultValue(defaultOrgId + "");
            if (newOrgid != null && newOrgid > 0L) {
                cache.put("orgid", newOrgid.toString());
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)orgid)) continue;
            cache.put("orgid", String.valueOf(defaultOrgId));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IPageCache cache;
        String orgid;
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        IFormView view = this.getView();
        if ("new".equals(key) && StringUtils.isBlank((CharSequence)(orgid = (cache = this.getPageCache()).get("orgid")))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AssgrpFilterList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        IPageCache cache = this.getPageCache();
        if ("importdata".equals(key)) {
            String cacheKey = RequestContext.getOrCreate().getUserId() + formId;
            this.distributeCache.put(cacheKey, cache.get("orgid"));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String cacheKey = RequestContext.getOrCreate().getUserId() + formId;
        this.distributeCache.remove(cacheKey);
    }
}

