/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.fi.gl.util.GLUtil;

public class AssgrpRelationEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String[] CREATEORGENABLE = new String[]{"targetassgrp", "assgrp", "propdesc"};

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        boolean isRef = BaseDataRefrenceHelper.isRefrenced((String)"gl_assgrprelation", (Object)this.getModel().getDataEntity().getPkValue());
        IFormView view = this.getView();
        Object createOrg = this.getView().getFormShowParameter().getCustomParam("createOrg");
        Object modelCreateOrg = this.getModel().getValue("createorg_id");
        Object object = modelCreateOrg = modelCreateOrg == null ? null : modelCreateOrg.toString();
        if (createOrg != null && !createOrg.equals(modelCreateOrg)) {
            view.setEnable(Boolean.FALSE, CREATEORGENABLE);
        } else {
            view.setEnable(Boolean.valueOf(!isRef), CREATEORGENABLE);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object createOrg = this.getView().getFormShowParameter().getCustomParam("createOrg");
        this.getModel().setValue("createorg", createOrg);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"propdesc"});
        IDataModel model = this.getModel();
        Long org = (Long)model.getValue("createorg_id");
        List assists = GLUtil.getAssistPKByOrg((Long)org);
        final QFilter filter = new QFilter("id", "in", (Object)assists).and(new QFilter("valuetype", "in", (Object)new String[]{"1", "2"}));
        BasedataEdit assgrpEdit = (BasedataEdit)this.getControl("assgrp");
        assgrpEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
                list.setCustomParam("isCustom", (Object)Boolean.TRUE);
                List qFilters = list.getListFilterParameter().getQFilters();
                qFilters.clear();
                qFilters.add(filter);
            }
        });
        BasedataEdit targeassgrpEdit = (BasedataEdit)this.getControl("targetassgrp");
        targeassgrpEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
                list.setCustomParam("isCustom", (Object)Boolean.TRUE);
                List qFilters = list.getListFilterParameter().getQFilters();
                qFilters.clear();
                qFilters.add(filter);
            }
        });
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("propdesc".equals(key)) {
            this.showAssistPropTree();
        }
    }

    private void showAssistPropTree() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject fromAssgrp = (DynamicObject)model.getValue("assgrp");
        if (fromAssgrp == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u539f\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AssgrpRelationEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject toAssgrp = (DynamicObject)model.getValue("targetassgrp");
        if (toAssgrp == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AssgrpRelationEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (fromAssgrp.equals(toAssgrp)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u539f\u7ef4\u5ea6\u4e0d\u80fd\u4e0e\u76ee\u6807\u6838\u7b97\u7ef4\u5ea6\u76f8\u540c\u3002", (String)"AssgrpRelationEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> customParam = new HashMap<String, String>();
        customParam.put("type", toAssgrp.getString("name"));
        String valuetype = fromAssgrp.getString("valuetype");
        if ("1".equals(valuetype)) {
            DynamicObject valuesource = fromAssgrp.getDynamicObject("valuesource");
            String dtName = valuesource.getString("number");
            customParam.put("dtName", dtName);
            customParam.put("name", fromAssgrp.getString("name"));
        } else if ("2".equals(valuetype)) {
            customParam.put("dtName", "bos_assistantdata_detail");
            customParam.put("name", fromAssgrp.getString("name"));
        }
        String toValueType = toAssgrp.getString("valuetype");
        if ("1".equals(toValueType)) {
            DynamicObject valuesource = toAssgrp.getDynamicObject("valuesource");
            String basedataType = valuesource.getString("number");
            customParam.put("basedataType", basedataType);
        } else if ("2".equals(toValueType)) {
            DynamicObject assistanttype = toAssgrp.getDynamicObject("assistanttype");
            customParam.put("assistantType", String.valueOf(assistanttype.getPkValue()));
        }
        FormShowParameter form = new FormShowParameter();
        form.setFormId("gl_assistproptree");
        form.setCustomParams(customParam);
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gl_assistproptree"));
        view.showForm(form);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        if ("assgrp".equals(name) || "targetassgrp".equals(name)) {
            model.setValue("propdesc", (Object)"");
            model.setValue("propvalue", (Object)"");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("gl_assistproptree".equals(actionId) && (returnData = (Map)closedCallBackEvent.getReturnData()) != null) {
            IDataModel model = this.getModel();
            model.setValue("propdesc", returnData.get("desc"));
            model.setValue("propvalue", returnData.get("value"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate abstractOperate = (AbstractOperate)args.getSource();
        if ("save".equals(abstractOperate.getOperateKey())) {
            IDataModel model = this.getModel();
            DynamicObject fromAssgrp = (DynamicObject)model.getValue("assgrp");
            DynamicObject toAssgrp = (DynamicObject)model.getValue("targetassgrp");
            if (fromAssgrp != null && toAssgrp != null) {
                String fromtype = fromAssgrp.getString("ctrlstrategy");
                String totype = toAssgrp.getString("ctrlstrategy");
                if ("6".equals(fromtype) || "6".equals(totype)) {
                    model.setValue("ctrlstrategy", (Object)"6");
                } else {
                    model.setValue("ctrlstrategy", (Object)"5");
                }
                Long orgid = (Long)model.getValue("createorg_id");
                if (orgid > 0L) {
                    Object pkValue = model.getDataEntity().getPkValue();
                    List<Object> assgrRelaPKByOrg = this.getAssgrpRelaPKByOrg(orgid);
                    QFilter filter = new QFilter("id", "in", assgrRelaPKByOrg).and(new QFilter("assgrp", "=", fromAssgrp.getPkValue())).and(new QFilter("targetassgrp", "=", toAssgrp.getPkValue())).and(new QFilter("id", "!=", pkValue));
                    if (QueryServiceHelper.exists((String)"gl_assgrprelation", (QFilter[])filter.toArray())) {
                        IFormView view = this.getView();
                        view.showTipNotification(ResManager.loadKDString((String)"\u539f\u7ef4\u5ea6\u4e0e\u76ee\u6807\u6838\u7b97\u7ef4\u5ea6\u7ec4\u5408\u5df2\u5b58\u5728\u3002", (String)"AssgrpRelationEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                }
            }
        }
    }

    private List<Object> getAssgrpRelaPKByOrg(long orgId) {
        List superOrg = GLUtil.getAllSuperiorOrgIdsOrderByLevel((long)orgId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter allCtrl = new QFilter("ctrlstrategy", "=", (Object)"5");
        if (superOrg != null && !superOrg.isEmpty()) {
            QFilter orgFilter = new QFilter("createorg.id", "in", (Object)superOrg).and(new QFilter("ctrlstrategy", "=", (Object)"6"));
            filters.add(allCtrl.or(orgFilter));
        } else {
            filters.add(allCtrl);
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"gl_assgrprelation", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
    }
}

