/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;

public class AssistPropTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final int firstLevel = 1;
    private static final int lastLevel = 3;
    private static final String typeOk = "1";
    private static final String typeNo = "0";

    public void initialize() {
        this.addClickListeners(new String[]{"btnreturndata"});
        TreeView tree = (TreeView)this.getControl("proptree");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        super.initialize();
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnreturndata".equalsIgnoreCase(btn.getKey())) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        IFormView view = this.getView();
        String dtName = (String)view.getFormShowParameter().getCustomParam("dtName");
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(dtName), TreeNode.class);
        TreeView tree = (TreeView)this.getControl("proptree");
        Map map = tree.getTreeState().getFocusNode();
        if (map == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"AssistPropTreePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        } else {
            TreeNode focusNode = root.getTreeNode((String)map.get("id"), 3);
            if (typeOk.equals(focusNode.getType())) {
                HashMap<String, String> returnData = new HashMap<String, String>();
                returnData.put("desc", focusNode.getLongNumber());
                returnData.put("value", focusNode.getId());
                view.returnDataToParent(returnData);
                view.close();
            } else {
                String format = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u5c5e\u6027\u7684\u5b57\u6bb5\u3002", (String)"AssistPropTreePlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                String propName = (String)view.getFormShowParameter().getCustomParam("type");
                view.showTipNotification(String.format(format, propName));
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.initTree();
    }

    private void initTree() {
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        String dtName = (String)customParams.get("dtName");
        TreeNode root = new TreeNode();
        String name = (String)customParams.get("name");
        root.setText(name);
        root.setId(typeNo);
        root.setLongNumber(name);
        String assistantType = customParams.get("assistantType") == null ? null : (String)customParams.get("assistantType");
        String basedataType = customParams.get("basedataType") == null ? null : (String)customParams.get("basedataType");
        this.getChildNodeInfos(Lang.get().toString(), root, dtName, 1, null, basedataType, assistantType);
        this.getPageCache().put(dtName, SerializationUtils.toJsonString((Object)root));
        root.setIsOpened(true);
        TreeView tree = (TreeView)this.getControl("proptree");
        tree.addNode(root);
    }

    private boolean checkType(String basedataType, String baseEntityId) {
        if ("bos_org".equals(basedataType) || "bos_adminorg".equals(basedataType)) {
            return "bos_org".equals(baseEntityId) || "bos_adminorg".equals(baseEntityId);
        }
        return baseEntityId.equals(basedataType);
    }

    private void getChildNodeInfos(String lang, TreeNode parent, String dtName, int level, EntryProp parentProp, String basedataType, String assistantType) {
        if (level > 3) {
            return;
        }
        List<DynamicProperty> properties = this.getPropItems(parentProp, dtName);
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        for (DynamicProperty dynamicProperty : properties) {
            String baseEntityId;
            String displayName = (String)dynamicProperty.getDisplayName().get((Object)lang);
            if (StringUtils.isBlank((CharSequence)displayName)) continue;
            TreeNode node = new TreeNode();
            node.setText(displayName);
            String name = dynamicProperty.getName();
            String preID = typeNo.equals(parent.getId()) ? "" : parent.getId() + ".";
            node.setId(preID + name);
            node.setLongNumber(parent.getLongNumber() + "." + displayName);
            node.setType(typeNo);
            if (dynamicProperty instanceof BasedataProp) {
                AssistantProp assistProp;
                String asstTypeId;
                BasedataProp prop = (BasedataProp)dynamicProperty;
                baseEntityId = prop.getBaseEntityId();
                if (StringUtils.isNotBlank((CharSequence)baseEntityId)) {
                    if (this.checkType(basedataType, baseEntityId)) {
                        node.setType(typeOk);
                    }
                    this.getChildNodeInfos(lang, node, baseEntityId, ++level, null, basedataType, assistantType);
                    --level;
                }
                if (dynamicProperty instanceof AssistantProp && StringUtils.isNotBlank((CharSequence)(asstTypeId = (assistProp = (AssistantProp)dynamicProperty).getAsstTypeId())) && asstTypeId.equals(assistantType)) {
                    node.setType(typeOk);
                }
            } else if (dynamicProperty instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)dynamicProperty;
                if (entryProp != null) {
                    this.getChildNodeInfos(lang, node, null, ++level, entryProp, basedataType, assistantType);
                    --level;
                }
            } else if (dynamicProperty instanceof MulBasedataProp) {
                node.setId(node.getId() + ".fbasedataid");
                MulBasedataProp mulBasedataProp = (MulBasedataProp)dynamicProperty;
                baseEntityId = mulBasedataProp.getBaseEntityId();
                if (StringUtils.isNotBlank((CharSequence)baseEntityId)) {
                    if (this.checkType(basedataType, baseEntityId)) {
                        node.setType(typeOk);
                    }
                    this.getChildNodeInfos(lang, node, baseEntityId, ++level, null, basedataType, assistantType);
                    --level;
                }
            }
            List temp = node.getChildren();
            if ((level >= 3 || temp == null || temp.isEmpty()) && !typeOk.equals(node.getType())) continue;
            node.setParentid(parent.getId());
            children.add(node);
        }
        if (!children.isEmpty()) {
            parent.setChildren(children);
        }
    }

    private List<DynamicProperty> getPropItems(EntryProp parentProp, String dtName) {
        ArrayList<DynamicProperty> propList = new ArrayList<DynamicProperty>();
        DataEntityPropertyCollection properties = parentProp != null ? parentProp.getDynamicCollectionItemPropertyType().getProperties() : EntityMetadataCache.getDataEntityType((String)dtName).getProperties();
        for (IDataEntityProperty iDataEntityProperty : properties) {
            MulBasedataProp mulBasedataProp;
            String alias;
            if (iDataEntityProperty instanceof BasedataProp) {
                String alias2 = iDataEntityProperty.getAlias();
                if (!StringUtils.isNotBlank((CharSequence)alias2)) continue;
                propList.add((DynamicProperty)iDataEntityProperty);
                continue;
            }
            if (iDataEntityProperty instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)iDataEntityProperty;
                alias = entryProp.getDynamicCollectionItemPropertyType().getAlias();
                if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                propList.add((DynamicProperty)iDataEntityProperty);
                continue;
            }
            if (!(iDataEntityProperty instanceof MulBasedataProp) || !StringUtils.isNotBlank((CharSequence)(alias = (mulBasedataProp = (MulBasedataProp)iDataEntityProperty).getDynamicCollectionItemPropertyType().getAlias()))) continue;
            propList.add((DynamicProperty)iDataEntityProperty);
        }
        return propList;
    }
}

