/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountBookInfo;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.enums.AutoTransAmtTypeEnum;
import kd.fi.gl.enums.AutoTransQtyTypeEnum;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.finalprocess.info.ExpressionInfo;
import kd.fi.gl.formplugin.AbstractFinalProcessList;
import kd.fi.gl.reciprocal.AssistTypeValue;
import kd.fi.gl.util.BcmRptHelper;
import kd.fi.gl.util.FinalProcessUtil;
import kd.fi.gl.util.QFBuilder;

public class AutoTransCreateVoucherList
extends AbstractFinalProcessList {
    private static final String AUTOROWID = "autorowid";
    private static final String FILTER_GEN_VCH = "1";
    private static final String FILTER_NOT_GEN_VCH = "2";
    private Map<String, Map<Long, String>> assgrpNumberMap = new HashMap<String, Map<Long, String>>(16);

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        boolean haveGenVchFilter = false;
        String genVch = "";
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            String property = qFilter.getProperty();
            if (!"genvch".equals(property)) continue;
            haveGenVchFilter = true;
            genVch = String.valueOf(qFilter.getValue());
            iterator.remove();
            break;
        }
        if (haveGenVchFilter && FILTER_GEN_VCH.equals(genVch)) {
            qFilters.add(QFilter.joinSQL((String)"gl_autotrans", (String)"inner join t_bd_accountbooks tba on tba.forgid = gl_autotrans.forgid and tba.fbookstypeid = gl_autotrans.fbookid inner join t_gl_voucherrelation gvr ON tba.fcurperiodid = gvr.fperiod AND gl_autotrans.fid = gvr.fsrcentityid ", null));
        } else if (haveGenVchFilter && FILTER_NOT_GEN_VCH.equals(genVch)) {
            qFilters.add(QFilter.joinSQL((String)"gl_autotrans", (String)"inner join t_bd_accountbooks tba on tba.forgid = gl_autotrans.forgid and tba.fbookstypeid = gl_autotrans.fbookid and not exists(select 1 from t_gl_voucherrelation gvr where gvr.fperiod = tba.fcurperiodid and gvr.fsrcentityid = gl_autotrans.fid)", null));
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] queryVals = e.getQueryValues();
        boolean isExportQty = queryVals.length > 0 && queryVals[0].containsProperty("qtyFrom");
        int size = queryVals.length * 2;
        ArrayList<String> rowIdList = new ArrayList<String>(size);
        HashMap<AccountBookInfo, List<String>> bookToRowExpIdList = new HashMap<AccountBookInfo, List<String>>(queryVals.length);
        for (DynamicObject queryVal : queryVals) {
            AccountBookInfo bookInfo = new AccountBookInfo(queryVal.getLong("org_id"), queryVal.getLong("bookstype_id"));
            DynamicObjectCollection entryEntity = queryVal.getDynamicObjectCollection("autotransentry");
            List rowExpIdList = bookToRowExpIdList.getOrDefault(bookInfo, new ArrayList(entryEntity.size()));
            for (DynamicObject entryRow : entryEntity) {
                String dataSourceType = entryRow.getString("datasourcetype");
                if (entryRow.getDataEntityType().getProperties().get((Object)"bcmformulajson") != null && !"12".equals(dataSourceType) && !"13".equals(dataSourceType)) {
                    entryRow.set("bcmformulajson", (Object)"");
                }
                rowIdList.add(entryRow.getString(AUTOROWID));
                if (!"5".equals(dataSourceType) && !"6".equals(dataSourceType)) continue;
                rowExpIdList.add(entryRow.getString(AUTOROWID));
            }
            bookToRowExpIdList.put(bookInfo, rowExpIdList);
        }
        Map<String, String> assgrpMap = this.getAssgrpMap(rowIdList);
        Map<String, String> expMap = this.getExpMap(bookToRowExpIdList);
        for (DynamicObject queryVal : queryVals) {
            DynamicObjectCollection entryEntity = queryVal.getDynamicObjectCollection("autotransentry");
            for (DynamicObject entryRow : entryEntity) {
                String autorowid = entryRow.getString(AUTOROWID);
                entryRow.set("assgrp", (Object)assgrpMap.get(autorowid));
                String datasourcetype = entryRow.getString("datasourcetype");
                if (!"5".equals(datasourcetype) && !"6".equals(datasourcetype)) continue;
                entryRow.set(AUTOROWID, (Object)expMap.get(autorowid));
            }
        }
        LinkedList rptSetups = new LinkedList();
        Arrays.stream(queryVals).map(dyo -> dyo.getDynamicObjectCollection("autotransentry")).forEach(entrys -> entrys.forEach(entry -> {
            String qtyfrom;
            AutoTransQtyTypeEnum qtyType;
            String datasourcetype = entry.getString("datasourcetype");
            AutoTransAmtTypeEnum amtType = AutoTransAmtTypeEnum.valueOfHash((String)datasourcetype);
            if (AutoTransAmtTypeEnum.TRANS_OUT_RPT_VALUE == amtType || AutoTransAmtTypeEnum.TRANS_IN_RPT_VALUE == amtType) {
                rptSetups.add(entry.getString("rptexp"));
            } else {
                entry.set("rptexp", (Object)"");
            }
            if (isExportQty && AutoTransQtyTypeEnum.report == (qtyType = AutoTransQtyTypeEnum.valueOfHash((String)(qtyfrom = entry.getString("qtyfrom"))))) {
                rptSetups.add(entry.getString("qtyformula"));
            }
        }));
        HashSet<Long> modelIDs = new HashSet<Long>();
        HashSet<Long> templateIDs = new HashSet<Long>();
        HashSet<Long> scenarioIDs = new HashSet<Long>();
        rptSetups.stream().map(SerializationUtils::deSerializeFromBase64).map(Map.class::cast).forEach(rptSetup -> {
            templateIDs.add(Long.parseLong(rptSetup.get("templateid").toString()));
            modelIDs.add(Long.parseLong(rptSetup.get("modelid").toString()));
            scenarioIDs.add(Long.parseLong(rptSetup.get("scenarioid").toString()));
        });
        Map<Long, String> modelNumberMap = BcmRptHelper.findModelNumberByID(modelIDs);
        Map<Long, String> templateNumberMap = BcmRptHelper.findTemplateNumberByID(templateIDs);
        Map<Long, String> scenarioNumberMap = BcmRptHelper.findScenarioNumberByID(scenarioIDs);
        Arrays.stream(queryVals).map(dyo -> dyo.getDynamicObjectCollection("autotransentry")).forEach(entrys -> entrys.forEach(entry -> {
            String qtyfrom;
            AutoTransQtyTypeEnum qtyType;
            String datasourcetype = entry.getString("datasourcetype");
            AutoTransAmtTypeEnum amtType = AutoTransAmtTypeEnum.valueOfHash((String)datasourcetype);
            if (AutoTransAmtTypeEnum.TRANS_OUT_RPT_VALUE == amtType || AutoTransAmtTypeEnum.TRANS_IN_RPT_VALUE == amtType) {
                Map rptexp = (Map)SerializationUtils.deSerializeFromBase64((String)entry.getString("rptexp"));
                String setupStr = String.format("model:%s;scene:%s;template:%s;position:%s;", modelNumberMap.get(Long.parseLong((String)rptexp.get("modelid"))), scenarioNumberMap.get(Long.parseLong((String)rptexp.get("scenarioid"))), templateNumberMap.get(Long.parseLong((String)rptexp.get("templateid"))), rptexp.get("position"));
                entry.set("rptexp", (Object)setupStr);
            }
            if (isExportQty && AutoTransQtyTypeEnum.report == (qtyType = AutoTransQtyTypeEnum.valueOfHash((String)(qtyfrom = entry.getString("qtyfrom"))))) {
                Map rptexp = (Map)SerializationUtils.deSerializeFromBase64((String)entry.getString("qtyformula"));
                String setupStr = String.format("model:%s;scene:%s;template:%s;position:%s;", modelNumberMap.get(Long.parseLong((String)rptexp.get("modelid"))), scenarioNumberMap.get(Long.parseLong((String)rptexp.get("scenarioid"))), templateNumberMap.get(Long.parseLong((String)rptexp.get("templateid"))), rptexp.get("position"));
                entry.set("qtyformula", (Object)setupStr);
            }
        }));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("glmergevoucher".equalsIgnoreCase(op.getOperateKey())) {
            Object[] pkValues = args.getListSelectedData().getPrimaryKeyValues();
            QFBuilder qfBuilder = new QFBuilder("id", "in", (Object)pkValues);
            Map schemes = BusinessDataServiceHelper.loadFromCache((String)"gl_autotrans", (String)"org,bookstype,transfertype,vouchertypeid,voucherdatetype,billstatus,billno", (QFilter[])qfBuilder.toArray());
            String orgAndBookType = "";
            String transfertype = "";
            String voucherDateType = "";
            long voucherTypeId = 0L;
            for (Map.Entry entry : schemes.entrySet()) {
                DynamicObject dyn = (DynamicObject)entry.getValue();
                String billStatus = dyn.getString("billstatus");
                String billNo = dyn.getString("billno");
                String orgNo = dyn.getDynamicObject("org").getString("number");
                String bookNo = dyn.getDynamicObject("bookstype").getString("number");
                if ("D".equals(billStatus)) {
                    this.getView().showTipNotification(FinalProcessUtil.formatMessage((String)orgNo, (String)bookNo, (String)billNo, (String)ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u5408\u5e76\u751f\u6210\u51ed\u8bc1\u5931\u8d25\u3002", (String)"AutoTransCreateVoucherList_05", (String)"fi-gl-formplugin", (Object[])new Object[0])));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    break;
                }
                String entryStr = dyn.getString("org_id") + dyn.getString("bookstype_id");
                if (StringUtils.isEmpty((CharSequence)orgAndBookType)) {
                    orgAndBookType = entryStr;
                } else if (!orgAndBookType.equals(entryStr)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u591a\u4e2a\u65b9\u6848\u5c5e\u4e8e\u4e0d\u540c\u7ec4\u7ec7\u548c\u8d26\u7c3f\uff0c\u65e0\u6cd5\u5408\u5e76\u751f\u6210\u51ed\u8bc1\u3002\u8bf7\u5355\u72ec\u9009\u62e9\u65b9\u6848\u4ee5\u751f\u6210\u51ed\u8bc1\u3002", (String)"AutoTransCreateVoucherList_01", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    break;
                }
                String entryType = dyn.getString("transfertype");
                if (StringUtils.isEmpty((CharSequence)transfertype)) {
                    transfertype = entryType;
                } else if (!transfertype.equals(entryType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u591a\u4e2a\u65b9\u6848\u8f6c\u8d26\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5408\u5e76\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AutoTransCreateVoucherList_02", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    break;
                }
                long entryVoucherTypeId = dyn.getLong("vouchertypeid_id");
                if (voucherTypeId == 0L) {
                    voucherTypeId = entryVoucherTypeId;
                } else if (entryVoucherTypeId != voucherTypeId) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u591a\u4e2a\u65b9\u6848\u51ed\u8bc1\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5408\u5e76\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AutoTransCreateVoucherList_03", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    break;
                }
                String entryVoucherDateType = dyn.getString("voucherdatetype");
                if (StringUtils.isEmpty((CharSequence)voucherDateType)) {
                    voucherDateType = entryVoucherDateType;
                    continue;
                }
                if (voucherDateType.equals(entryVoucherDateType)) continue;
                QFilter qOrg = new QFilter("org.id", "=", (Object)dyn.getLong("org_id"));
                QFilter qBookType = new QFilter("bookstype.id", "=", (Object)dyn.getLong("bookstype_id"));
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)"curperiod", (QFilter[])new QFilter[]{qOrg, qBookType});
                Date endDate = obj.getDate("curperiod.enddate");
                if (fmt.format(endDate).equals(fmt.format(new Date()))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u591a\u4e2a\u65b9\u6848\u51ed\u8bc1\u65e5\u671f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5408\u5e76\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AutoTransCreateVoucherList_04", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                break;
            }
        }
    }

    private Map<String, String> getExpMap(Map<AccountBookInfo, List<String>> bookToRowExpIdList) {
        List rowExpIdList = bookToRowExpIdList.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Map dyns = BusinessDataServiceHelper.loadFromCache((String)"gl_autotransexpression", (QFilter[])new QFilter(AUTOROWID, "in", rowExpIdList).toArray());
        HashSet<Long> assgrpIdSet = new HashSet<Long>(dyns.size());
        HashMap<String, DynamicObject> rowToDyn = new HashMap<String, DynamicObject>(dyns.size());
        for (DynamicObject dyn : dyns.values()) {
            assgrpIdSet.add(dyn.getLong("assgrp_id"));
            rowToDyn.put(dyn.getString(AUTOROWID), dyn);
        }
        Map<Long, String> assistNameMap = AutoTransCreateVoucherList.analyzeAssgrpNameById(assgrpIdSet);
        HashMap<String, String> map = new HashMap<String, String>(dyns.size());
        for (Map.Entry<AccountBookInfo, List<String>> entry : bookToRowExpIdList.entrySet()) {
            AccountBookInfo bookInfo = entry.getKey();
            long curPeriodAccountTableId = AccSysUtil.getCurPeriodAccountTableId((long)bookInfo.getOrgId(), (long)bookInfo.getBookTypeId(), (long)bookInfo.getCurPeriodId());
            List commonAssists = ComAssistTable.get((Long)curPeriodAccountTableId).getCommonAssists();
            List<String> rowIds = entry.getValue();
            List<Map<Long, String>> collectedComAssistVal = this.collectComAssistVal(commonAssists, rowIds, rowToDyn);
            rowIds.forEach(rowId -> map.put((String)rowId, new ExpressionInfo((DynamicObject)rowToDyn.get(rowId), assistNameMap, commonAssists, collectedComAssistVal).toString()));
        }
        return map;
    }

    private List<Map<Long, String>> collectComAssistVal(List<CommonAssist> commonAssists, List<String> rowIds, Map<String, DynamicObject> rowToDyn) {
        ArrayList<Map<Long, String>> res = new ArrayList<Map<Long, String>>(commonAssists.size());
        for (int i = 0; i < commonAssists.size(); ++i) {
            ArrayList comAssistVal = new ArrayList();
            String comAssistKey = "comassist" + (i + 1);
            rowIds.forEach(row -> comAssistVal.addAll(((DynamicObject)rowToDyn.get(row)).getDynamicObjectCollection(comAssistKey).stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList())));
            HashMap<Long, String> comAssistIdToNum = new HashMap<Long, String>();
            try (DataSet comAssist1Ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.formplugin.AutoTransCreateVoucherList.collectComAssistVal", (String)commonAssists.get(i).getValueSource(), (String)"id,number", (QFilter[])new QFilter("id", "in", comAssistVal).toArray(), null);){
                for (Row row2 : comAssist1Ds) {
                    comAssistIdToNum.put(row2.getLong("id"), row2.getString("number"));
                }
            }
            res.add(comAssistIdToNum);
        }
        return res;
    }

    private Map<String, String> getAssgrpMap(List<String> rowIdList) {
        HashMap<String, String> map = new HashMap<String, String>(rowIdList.size());
        Map results = BusinessDataServiceHelper.loadFromCache((String)"gl_finalprocess_assgrp", (QFilter[])new QFilter("assgrprow", "in", rowIdList).toArray());
        for (Map.Entry result : results.entrySet()) {
            DynamicObject dyn = (DynamicObject)result.getValue();
            String assgrprow = dyn.getString("assgrprow");
            StringBuilder desc = new StringBuilder();
            DynamicObjectCollection entrys = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                DynamicObjectCollection values;
                String name = entry.getDynamicObject("fieldname").getString("name");
                String valueType = entry.getDynamicObject("fieldname").getString("valuetype");
                if (AssistValueType.isManualTxt((String)valueType)) {
                    desc.append(name).append(":").append(entry.getString("txtval").replaceAll(";", ",")).append(";");
                    continue;
                }
                DynamicObject valuesource = entry.getDynamicObject("fieldname").getDynamicObject("valuesource");
                if (valuesource == null) continue;
                String fieldnumber = valuesource.getString("number");
                if (!this.assgrpNumberMap.containsKey(fieldnumber)) {
                    this.assgrpNumberMap = this.getAssgrpNumberMap(this.assgrpNumberMap, fieldnumber);
                }
                if ((values = entry.getDynamicObjectCollection("value")).isEmpty()) continue;
                desc.append(name).append(':');
                for (int i = 0; i < values.size(); ++i) {
                    DynamicObject value = (DynamicObject)values.get(i);
                    String number = this.assgrpNumberMap.get(fieldnumber).get(value.getLong("fbasedataid_id"));
                    desc.append(number).append(',');
                }
                desc.deleteCharAt(desc.length() - 1);
                desc.append(';');
            }
            if (StringUtils.isEmpty((CharSequence)desc)) continue;
            map.put(assgrprow, desc.toString().substring(0, desc.length() - 1));
        }
        return map;
    }

    private Map<String, Map<Long, String>> getAssgrpNumberMap(Map<String, Map<Long, String>> assgrpNumberMap, String fieldnumber) {
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)fieldnumber, (String)"id,number", null);
        HashMap<Long, String> map = new HashMap<Long, String>(dyns.size());
        for (DynamicObject dyn : dyns) {
            map.put(dyn.getLong("id"), dyn.getString("number"));
        }
        assgrpNumberMap.put(fieldnumber, map);
        return assgrpNumberMap;
    }

    private static Map<Long, String> analyzeAssgrpNameById(Set<Long> assgrpIdSet) {
        Object atv3;
        Long assgrpId;
        if (assgrpIdSet == null || assgrpIdSet.size() == 0) {
            return null;
        }
        HashMap assistTypeValueMap = new HashMap();
        HashMap entityQFilterMap = new HashMap();
        DataSet resultDs = AutoTransCreateVoucherList.queryResultDs(assgrpIdSet);
        Object object = null;
        try {
            if (resultDs != null) {
                for (Row row : resultDs) {
                    assgrpId = row.getLong("hg");
                    String assEntity = row.getString("valuesource");
                    Long assval = row.getLong("assval");
                    if (assEntity == null) continue;
                    String string = assEntity = "bos_assistantdatagroup".equals(assEntity) ? "bos_assistantdata_detail" : assEntity;
                    if (entityQFilterMap.containsKey(assEntity)) {
                        ((Set)entityQFilterMap.get(assEntity)).add(assval);
                    } else {
                        HashSet<Long> assvalSet = new HashSet<Long>();
                        assvalSet.add(assval);
                        entityQFilterMap.put(assEntity, assvalSet);
                    }
                    String asstypeName = row.getString("name");
                    AssistTypeValue atv2 = new AssistTypeValue(assEntity, assval, asstypeName);
                    if (assistTypeValueMap.containsKey(assgrpId)) {
                        ((List)assistTypeValueMap.get(assgrpId)).add(atv2);
                        continue;
                    }
                    ArrayList<AssistTypeValue> atvList = new ArrayList<AssistTypeValue>();
                    atvList.add(atv2);
                    assistTypeValueMap.put(assgrpId, atvList);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (resultDs != null) {
                if (object != null) {
                    try {
                        resultDs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    resultDs.close();
                }
            }
        }
        resultDs = AutoTransCreateVoucherList.queryResultDsTxt(assgrpIdSet);
        object = null;
        try {
            if (resultDs != null) {
                for (Row row : resultDs) {
                    assgrpId = row.getLong("hg");
                    String assval = row.getString("assval");
                    String asstypeName = row.getString("name");
                    atv3 = new AssistTypeValue(assval, null, asstypeName);
                    if (assistTypeValueMap.containsKey(assgrpId)) {
                        ((List)assistTypeValueMap.get(assgrpId)).add(atv3);
                        continue;
                    }
                    ArrayList<AssistTypeValue> atvList = new ArrayList<AssistTypeValue>();
                    atvList.add((AssistTypeValue)atv3);
                    assistTypeValueMap.put(assgrpId, atvList);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (resultDs != null) {
                if (object != null) {
                    try {
                        resultDs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    resultDs.close();
                }
            }
        }
        HashMap resultMap = new HashMap(entityQFilterMap.size());
        for (Map.Entry entry : entityQFilterMap.entrySet()) {
            Set assvalSet = (Set)entry.getValue();
            HashMap<Long, String> entityResult = new HashMap<Long, String>();
            QFilter idFilter = new QFilter("id", "in", (Object)assvalSet);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"ReciprocalInitUtil.analyzeAssgrpNameById", (String)((String)entry.getKey()), (String)"id,number", (QFilter[])idFilter.toArray(), null);
            atv3 = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        entityResult.put(row.getLong("id"), row.getString("number"));
                    }
                }
            }
            catch (Throwable atvList) {
                atv3 = atvList;
                throw atvList;
            }
            finally {
                if (ds != null) {
                    if (atv3 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable atvList) {
                            ((Throwable)atv3).addSuppressed(atvList);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            resultMap.put(entry.getKey(), entityResult);
        }
        HashMap<Long, String> assistNameMap = new HashMap<Long, String>();
        for (Long assgrpId2 : assgrpIdSet) {
            List atvList = (List)assistTypeValueMap.get(assgrpId2);
            if (atvList == null || atvList.size() == 0) {
                if (assgrpId2 != 0L) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"ID\u4e3a\u201c%s\u201d\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"AutoTransCreateVoucherList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), assgrpId2));
                }
                assistNameMap.put(assgrpId2, null);
                continue;
            }
            ArrayList<String> assValNameList = new ArrayList<String>();
            for (AssistTypeValue atv : atvList) {
                if (resultMap.get(atv.getAssEntity()) != null) {
                    String assvalName = (String)((Map)resultMap.get(atv.getAssEntity())).get(atv.getAssval());
                    atv.setAssvalName(assvalName);
                    if (atv.getAssvalName() == null) continue;
                    assValNameList.add(atv.toString());
                    continue;
                }
                assValNameList.add(atv.getAsstypeName() + ":" + atv.getAssEntity());
            }
            assistNameMap.put(assgrpId2, String.join((CharSequence)"|", assValNameList));
        }
        return assistNameMap;
    }

    private static DataSet queryResultDs(Set<Long> assgrpIdSet) {
        String selectFields = "hg, asstype, assval";
        QFilter idFilter = new QFilter("hg", "in", assgrpIdSet);
        DataSet glAssistDs = QueryServiceHelper.queryDataSet((String)(AutoTransCreateVoucherList.class.getName() + "queryResultDs_gl"), (String)"gl_assist_bd", (String)selectFields, (QFilter[])idFilter.toArray(), null);
        String asstacttypeSelectFields = "flexfield, name, valuesource";
        DataSet asstypeDs = QueryServiceHelper.queryDataSet((String)(AutoTransCreateVoucherList.class.getName() + "queryResultDs_bd"), (String)"bd_asstacttype", (String)asstacttypeSelectFields, null, null);
        DataSet resultDs = glAssistDs.join(asstypeDs, JoinType.LEFT).on("asstype", "flexfield").select(new String[]{"hg", "asstype", "assval"}, new String[]{"name", "valuesource"}).finish();
        return resultDs;
    }

    private static DataSet queryResultDsTxt(Set<Long> assgrpIdSet) {
        String selectFields = "hg, asstype, assval";
        QFilter idFilter = new QFilter("hg", "in", assgrpIdSet);
        DataSet glAssistDs = QueryServiceHelper.queryDataSet((String)(AutoTransCreateVoucherList.class.getName() + "queryResultDs_gl"), (String)"gl_assist_txt", (String)selectFields, (QFilter[])idFilter.toArray(), null);
        String asstacttypeSelectFields = "flexfield, name, valuesource";
        DataSet asstypeDs = QueryServiceHelper.queryDataSet((String)(AutoTransCreateVoucherList.class.getName() + "queryResultDs_bd"), (String)"bd_asstacttype", (String)asstacttypeSelectFields, null, null);
        DataSet resultDs = glAssistDs.join(asstypeDs, JoinType.LEFT).on("asstype", "flexfield").select(new String[]{"hg", "asstype", "assval"}, new String[]{"name", "valuesource"}).finish();
        return resultDs;
    }
}

