/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.ManageItemUtils;
import kd.fi.gl.util.ReportClearUtil;
import kd.fi.gl.util.TaxReportFormHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BalanceSheetEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String COLUMNKEY = "columnkey";
    private static final String PRETOTALROWCELL = "preTotalRowCell";
    private static final String RPTITEM = "rptitem";
    private static final String ISTOTALROW = "istotalrow";
    private static final String org = "org";
    private static final String orgView = "orgview";
    private static final String bookType = "booktype";
    private static final String accTable = "accounttable";
    private static final String save = "save";
    private static final String entryKey = "entryentity";
    private static final String assetEntryKey = "assetentryentity";
    private static final String equityEntryKey = "equityentryentity";
    private static final String asset = "asset";
    private static final String equity = "equity";
    private static final String balrowId = "balrowid";
    private static final String seq = "seq";
    private static final String rowid = "browid";
    private static final String assetBegin = "assetbegin";
    private static final String assetClose = "assetclose";
    private static final String assetRowId = "assetrowid";
    private static final String equityBegin = "equitybegin";
    private static final String equityClose = "equityclose";
    private static final String equityRowId = "equityrowid";
    private static final String expressionFormId = "gl_balancesheetexpression";
    private static final String project = "project";
    private static final String commonColor = "#ffffff";
    private static final String focusColor = "#FEF3D1";
    private static final String[] assetColumn = new String[]{"assetbegin", "assetclose"};
    private static final String[] equityColumn = new String[]{"equitybegin", "equityclose"};
    private static Map<String, String> amountColAndItemNameMap = new HashMap<String, String>();
    private static final List<Pair<String, String>> lstPair;

    public void initialize() {
        super.initialize();
        TextEdit assetB = (TextEdit)this.getControl(assetBegin);
        assetB.addButtonClickListener((ClickListener)this);
        TextEdit assetC = (TextEdit)this.getControl(assetClose);
        assetC.addButtonClickListener((ClickListener)this);
        TextEdit equityB = (TextEdit)this.getControl(equityBegin);
        equityB.addButtonClickListener((ClickListener)this);
        TextEdit equityC = (TextEdit)this.getControl(equityClose);
        equityC.addButtonClickListener((ClickListener)this);
        EntryGrid assetEntryGrid = (EntryGrid)this.getControl(assetEntryKey);
        assetEntryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid equityEntryGrid = (EntryGrid)this.getControl(equityEntryKey);
        equityEntryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{save});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit assetEdit = (BasedataEdit)this.getControl(asset);
        assetEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String taxType = (String)formShowParameter.getCustomParam("type");
            Long orgId = (Long)this.getModel().getValue("org_id");
            TaxReportFormHelper.filterTaxProject((long)orgId, (ListShowParameter)param, (String)taxType);
        });
        BasedataEdit equityEdit = (BasedataEdit)this.getControl(equity);
        equityEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String taxType = (String)formShowParameter.getCustomParam("type");
            Long orgId = (Long)this.getModel().getValue("org_id");
            TaxReportFormHelper.filterTaxProject((long)orgId, (ListShowParameter)param, (String)taxType);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        ChangeData data = e.getChangeSet()[0];
        Object oldVal = data.getOldValue();
        Object newVal = data.getNewValue();
        int rowIdx = data.getRowIndex();
        String entityType = data.getDataEntity().getDataEntityType().getName();
        String rowidField = assetEntryKey.equals(entityType) ? assetRowId : equityRowId;
        String rowId = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(entityType).get(rowIdx)).getString(rowidField);
        Integer balrowIdValue = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(entityType).get(rowIdx)).getInt(seq);
        if (e.getProperty().getName() != null && "".equals(data.getNewValue())) {
            new ReportClearUtil(this.getModel().getDataEntityType().getName()).doCacheClear(rowIdx, this.getCellKey(entityType, rowId, e.getProperty().getName()), (AbstractFormPlugin)this, rowid);
        }
        switch (propertyName = e.getProperty().getName()) {
            case "asset": {
                this.updateExpressionInfo(oldVal, newVal, rowIdx, balrowIdValue, rowId, assetEntryKey);
                break;
            }
            case "equity": {
                this.updateExpressionInfo(oldVal, newVal, rowIdx, balrowIdValue, rowId, equityEntryKey);
                break;
            }
        }
    }

    private void updateExpressionInfo(Object oldVal, Object newVal, int rowIdx, Integer balrowIdValue, String rowTag, String entryKey) {
        DynamicObject oldItem = (DynamicObject)oldVal;
        DynamicObject newItem = (DynamicObject)newVal;
        Boolean isChanged = Boolean.FALSE;
        if (newItem == null) {
            isChanged = Boolean.TRUE;
        } else {
            Boolean oldTotalRow = oldItem == null ? Boolean.FALSE.booleanValue() : oldItem.getBoolean(ISTOTALROW);
            Boolean newTotalRow = newItem.getBoolean(ISTOTALROW);
            if (oldTotalRow.booleanValue() && !newTotalRow.booleanValue() || !oldTotalRow.booleanValue() && newTotalRow.booleanValue()) {
                isChanged = Boolean.TRUE;
            }
        }
        if (isChanged.booleanValue()) {
            Long orgId = (Long)this.getModel().getValue("org_id");
            Long acctTableId = (Long)this.getModel().getValue("accounttable_id");
            Boolean isTotalRow = newItem == null ? Boolean.FALSE.booleanValue() : newItem.getBoolean(ISTOTALROW);
            String beginType = assetEntryKey.equals(entryKey) ? assetBegin : equityBegin;
            String closeType = assetEntryKey.equals(entryKey) ? assetClose : equityClose;
            int columnKey = assetEntryKey.equals(entryKey) ? 1 : 3;
            this.getModel().setValue(beginType, null, rowIdx);
            DynamicObject nullExpObj = this.newNullExpDyn(orgId, acctTableId, balrowIdValue, columnKey, rowTag, isTotalRow);
            this.getPageCache().put(this.getCellKey(entryKey, rowTag, beginType), GlFormUtil.toDynamicObjectJson(nullExpObj));
            this.removeTotalRowDetailItemId(rowTag, closeType, entryKey);
            this.getModel().setValue(beginType, null, rowIdx);
            nullExpObj = this.newNullExpDyn(orgId, acctTableId, balrowIdValue, ++columnKey, rowTag, isTotalRow);
            this.getPageCache().put(this.getCellKey(entryKey, rowTag, closeType), GlFormUtil.toDynamicObjectJson(nullExpObj));
            this.removeTotalRowDetailItemId(rowTag, closeType, entryKey);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        Long orgId = 0L;
        if (formShowParameter.getCustomParam("orgId") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceSheetEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        orgId = Long.valueOf(formShowParameter.getCustomParam("orgId").toString());
        model.setValue(org, (Object)orgId);
        Long orgViewId = 0L;
        if (formShowParameter.getCustomParam("orgViewId") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceSheetEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        orgViewId = Long.valueOf(formShowParameter.getCustomParam("orgViewId").toString());
        model.setValue(orgView, (Object)orgViewId);
        Long bookTypeId = 0L;
        if (formShowParameter.getCustomParam("bookTypeId") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BalanceSheetEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        bookTypeId = Long.valueOf(formShowParameter.getCustomParam("bookTypeId").toString());
        model.setValue(bookType, (Object)bookTypeId);
        Long accTableId = 0L;
        if (formShowParameter.getCustomParam("accTableId") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceSheetEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        accTableId = Long.valueOf(formShowParameter.getCustomParam("accTableId").toString());
        model.setValue(accTable, (Object)accTableId);
        String assetSelectFields = "assetentryentity.seq seq,assetentryentity.assetrowid browid, assetentryentity.asset entryentity, assetentryentity.asset.istotalrow istotalrow, 1 as type";
        String equitySelectFields = "equityentryentity.seq seq,equityentryentity.equityrowid browid, equityentryentity.equity entryentity,equityentryentity.equity.istotalrow istotalrow, 2 as type";
        QFilter forg = new QFilter(org, "=", (Object)orgId);
        QFilter faccTable = new QFilter(accTable, "=", (Object)accTableId);
        QFilter bookTypeFilter = new QFilter(bookType, "=", (Object)bookTypeId);
        QFilter[] filters = new QFilter[]{forg, faccTable, bookTypeFilter};
        String formId = this.getView().getFormShowParameter().getFormId();
        try (DataSet assetDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)formId, (String)assetSelectFields, (QFilter[])filters, (String)"assetentryentity.seq asc");
             DataSet equityDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)formId, (String)equitySelectFields, (QFilter[])filters, (String)"equityentryentity.seq asc");
             DataSet dataSet = assetDataSet.union(equityDataSet);){
            String expSelectField = "org,booktype,accounttable,balrowid, columnkey,rowtag, entryentity.project, entryentity.sign, entryentity.fetchrule, entryentity.rptitem, istotalrow";
            DynamicObject[] expCollection = BusinessDataServiceHelper.load((String)expressionFormId, (String)expSelectField, (QFilter[])filters);
            this.batchSetValue(dataSet, expCollection);
            this.presetTotalExpression(orgId, bookTypeId, accTableId, dataSet, assetEntryKey);
            this.presetTotalExpression(orgId, bookTypeId, accTableId, dataSet, equityEntryKey);
        }
    }

    private void batchSetValue(DataSet dataSet, DynamicObject[] expCollection) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter assetVs = new TableValueSetter(new String[0]);
        TableValueSetter equityVs = new TableValueSetter(new String[0]);
        if (dataSet != null && !dataSet.isEmpty()) {
            assetVs.addField(asset, new Object[0]);
            assetVs.addField(seq, new Object[0]);
            assetVs.addField(assetRowId, new Object[0]);
            equityVs.addField(equity, new Object[0]);
            equityVs.addField(seq, new Object[0]);
            equityVs.addField(equityRowId, new Object[0]);
            dataSet.print(true);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long entryEntity = row.getLong(entryKey);
                int seq = row.getInteger(seq);
                String type = row.getString("type");
                String rowId = row.getString(rowid);
                String entityType = "";
                if (entryEntity != null && entryEntity > 0L) {
                    if ("1".equals(type)) {
                        assetVs.addRow(new Object[]{entryEntity, seq, rowId});
                        entityType = assetEntryKey;
                    } else {
                        equityVs.addRow(new Object[]{entryEntity, seq, rowId});
                        entityType = equityEntryKey;
                    }
                }
                String assetBeginExp = "";
                String assetCloseExp = "";
                String equityBeginExp = "";
                String equityCloseExp = "";
                if (expCollection == null || expCollection.length <= 0) continue;
                for (DynamicObject expDyn : expCollection) {
                    if (!rowId.equals(expDyn.get("rowtag"))) continue;
                    Boolean isTotalRow = expDyn.getBoolean(ISTOTALROW);
                    String itemFieldName = isTotalRow != false ? RPTITEM : project;
                    DynamicObjectCollection expDynColl = expDyn.getDynamicObjectCollection(entryKey);
                    for (DynamicObject expRowDyn : expDynColl) {
                        String name = expRowDyn.getString(itemFieldName + ".name");
                        String number = expRowDyn.getString(itemFieldName + ".number");
                        String sign = (String)expRowDyn.get("sign");
                        String fetchName = this.getNameByVal(expRowDyn, "fetchrule");
                        if ("1".equals(type) && "1".equals(expDyn.get(COLUMNKEY))) {
                            assetBeginExp = this.setRowExpression(assetBeginExp, isTotalRow, name, number, sign, fetchName);
                            this.getPageCache().put(this.getCellKey(entityType, rowId, assetBegin), GlFormUtil.toDynamicObjectJson(expDyn));
                            continue;
                        }
                        if ("1".equals(type) && "2".equals(expDyn.get(COLUMNKEY))) {
                            assetCloseExp = this.setRowExpression(assetCloseExp, isTotalRow, name, number, sign, fetchName);
                            this.getPageCache().put(this.getCellKey(entityType, rowId, assetClose), GlFormUtil.toDynamicObjectJson(expDyn));
                            continue;
                        }
                        if ("2".equals(type) && "3".equals(expDyn.get(COLUMNKEY))) {
                            equityBeginExp = this.setRowExpression(equityBeginExp, isTotalRow, name, number, sign, fetchName);
                            this.getPageCache().put(this.getCellKey(entityType, rowId, equityBegin), GlFormUtil.toDynamicObjectJson(expDyn));
                            continue;
                        }
                        if (!"2".equals(type) || !"4".equals(expDyn.get(COLUMNKEY))) continue;
                        equityCloseExp = this.setRowExpression(equityCloseExp, isTotalRow, name, number, sign, fetchName);
                        this.getPageCache().put(this.getCellKey(entityType, rowId, equityClose), GlFormUtil.toDynamicObjectJson(expDyn));
                    }
                }
                if ("1".equals(type)) {
                    assetVs.addField(assetBegin, new Object[]{this.subLastChart(assetBeginExp)});
                    assetVs.addField(assetClose, new Object[]{this.subLastChart(assetCloseExp)});
                    continue;
                }
                equityVs.addField(equityBegin, new Object[]{this.subLastChart(equityBeginExp)});
                equityVs.addField(equityClose, new Object[]{this.subLastChart(equityCloseExp)});
            }
        } else {
            ArrayList<Long> projects_asset = new ArrayList<Long>();
            int indexRow = 1;
            for (long i = 100001L; i <= 100039L; ++i) {
                assetVs.addField(seq, new Object[]{indexRow});
                ++indexRow;
                projects_asset.add(i);
            }
            for (Long id : projects_asset) {
                assetVs.addField(asset, new Object[]{id});
                assetVs.addField(assetRowId, new Object[]{this.getRowId()});
            }
            indexRow = 1;
            ArrayList<Long> projects_equity = new ArrayList<Long>();
            for (long i = 100040L; i <= 100078L; ++i) {
                equityVs.addField(seq, new Object[]{indexRow});
                ++indexRow;
                projects_equity.add(i);
            }
            for (Long id : projects_equity) {
                equityVs.addField(equity, new Object[]{id});
                equityVs.addField(equityRowId, new Object[]{this.getRowId()});
            }
        }
        model.batchCreateNewEntryRow(assetEntryKey, assetVs);
        model.batchCreateNewEntryRow(equityEntryKey, equityVs);
        model.endInit();
        this.getView().updateView(assetEntryKey);
        this.getView().updateView(equityEntryKey);
    }

    private void presetTotalExpression(Long orgId, Long bookTypeId, Long accTableId, DataSet dataSet, String entryKey) {
        if (dataSet.isEmpty()) {
            Map totalRowExpMap = ManageItemUtils.getBalanceSheetPresetExpressions();
            DynamicObjectCollection entryCollection = this.getModel().getEntryEntity(entryKey);
            MainEntityType expressionType = EntityMetadataCache.getDataEntityType((String)expressionFormId);
            Map itemIdAndNameMap = BusinessDataServiceHelper.loadFromCache((String)"gl_manage_rptitem", (String)"name", (QFilter[])new QFilter[]{new QFilter("rptunit", "=", (Object)"gl_balancesheet")});
            int idx = 0;
            for (DynamicObject entry : entryCollection) {
                String rowId = entry.getString(assetEntryKey.equals(entryKey) ? assetRowId : equityRowId);
                int rowSeq = entry.getInt(seq);
                String item = assetEntryKey.equals(entryKey) ? asset : equity;
                String[] column = assetEntryKey.equals(entryKey) ? assetColumn : equityColumn;
                Long itemId = entry.getLong(item + "_id");
                this.batchLoadExpObjsToCache(orgId, bookTypeId, accTableId, totalRowExpMap, itemIdAndNameMap, (DynamicObjectType)expressionType, itemId, rowId, column, rowSeq, idx, entryKey);
                ++idx;
            }
        }
    }

    private void batchLoadExpObjsToCache(Long orgId, Long bookTypeId, Long accTableId, Map<Long, List<String>> totalRowExpMap, Map<Object, DynamicObject> itemIdAndNameMap, DynamicObjectType expressionType, Long itemId, String rowId, String[] column, Integer rowSeq, int idx, String entryKey) {
        List<String> expressions = totalRowExpMap.get(itemId);
        if (expressions != null && !expressions.isEmpty()) {
            for (int colKey = 0; colKey < column.length; ++colKey) {
                int columnKey = assetEntryKey.equals(entryKey) ? colKey + 1 : colKey + 3;
                DynamicObject expObject = this.createExpObject(orgId, bookTypeId, accTableId, expressionType, rowSeq, columnKey, rowId, expressions, itemIdAndNameMap, idx, column[colKey], entryKey);
                this.getPageCache().put(this.getCellKey(entryKey, rowId, column[colKey]), GlFormUtil.toDynamicObjectJson(expObject));
            }
        }
    }

    private DynamicObject createExpObject(Long orgId, Long bookTypeId, Long accTableId, DynamicObjectType expressionType, Integer rowSeq, Integer colKey, String balRowId, List<String> expressions, Map<Object, DynamicObject> itemIdAndNameMap, int idx, String itemFieldName, String entryKey) {
        DynamicObject expObject = new DynamicObject(expressionType);
        expObject.set(org, (Object)orgId);
        expObject.set("accounttable_id", (Object)accTableId);
        expObject.set("booktype_id", (Object)bookTypeId);
        expObject.set(balrowId, (Object)rowSeq);
        expObject.set("rowtag", (Object)balRowId);
        expObject.set(COLUMNKEY, (Object)colKey);
        expObject.set(ISTOTALROW, (Object)Boolean.TRUE);
        DynamicObjectCollection entries = expObject.getDynamicObjectCollection(entryKey);
        String cellExpression = "";
        HashSet<Long> itemIds = new HashSet<Long>(expressions.size());
        for (String expression : expressions) {
            DynamicObject expEntryObject = new DynamicObject(entries.getDynamicObjectType());
            String[] split = expression.split(",");
            if (split.length != 2) continue;
            Long itemId = Long.valueOf(split[0]);
            itemIds.add(itemId);
            String sign = split[1];
            expEntryObject.set("rptitem_id", (Object)itemId);
            expEntryObject.set("sign", (Object)sign);
            entries.add((Object)expEntryObject);
            DynamicObject item = itemIdAndNameMap.get(itemId);
            if (item == null) continue;
            cellExpression = TaxReportFormHelper.parseExpTotalRow((String)cellExpression, (String)item.getString("name"), (String)sign);
        }
        if (!StringUtils.isEmpty((CharSequence)itemFieldName)) {
            this.getModel().setValue(itemFieldName, (Object)cellExpression, idx);
        }
        this.cacheTotalRowDetailItemIds(balRowId, itemFieldName, itemIds, entryKey);
        return expObject;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        RowDataEntity currow = e.getRowDataEntities()[0];
        IDataModel model = this.getModel();
        int curIndex = currow.getRowIndex();
        String rowIdField = assetEntryKey.equals(entryName) ? assetRowId : equityRowId;
        model.setValue(rowIdField, (Object)this.getRowId(), curIndex);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entity = e.getEntryProp().getName();
        int rowIndex = e.getRowIndexs()[0];
        String rowId = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(entity).get(rowIndex)).getString(assetEntryKey.equals(entity) ? assetRowId : equityRowId);
        this.getPageCache().remove(this.getCellKey(entity, rowId, assetEntryKey.equals(entity) ? assetBegin : equityBegin));
        this.getPageCache().remove(this.getCellKey(entity, rowId, assetEntryKey.equals(entity) ? assetClose : equityClose));
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int rowIdx = evt.getRow();
        String entryEntity = ((EntryGrid)evt.getSource()).getEntryKey();
        this.setCellBGColor(rowIdx, entryEntity);
    }

    public void setCellBGColor(int rowIdx, String entryEntity) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryEntity);
        String key = entryGrid.getEntryState().getFocusField();
        int colIdx = 0;
        if (assetBegin.equals(key)) {
            colIdx = 1;
        } else if (assetClose.equals(key)) {
            colIdx = 2;
        } else if (equityBegin.equals(key)) {
            colIdx = 3;
        } else if (equityClose.equals(key)) {
            colIdx = 4;
        }
        String itemFieldName = amountColAndItemNameMap.get(key);
        if (StringUtils.isEmpty((CharSequence)itemFieldName)) {
            return;
        }
        DynamicObject item = (DynamicObject)this.getModel().getValue(itemFieldName, rowIdx);
        int balRowIndex = (Integer)this.getModel().getValue(entryEntity + "." + seq, rowIdx);
        Boolean isTotalRow = item == null ? Boolean.FALSE.booleanValue() : item.getBoolean(ISTOTALROW);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        this.setPreTotalRowCellColor(cellStyles, entryEntity);
        if (isTotalRow.booleanValue()) {
            // empty if block
        }
        if (!cellStyles.isEmpty()) {
            entryGrid.setCellStyle(cellStyles);
        }
    }

    private void setTotalRowCellColor(String rowId, String key, int colIdx, String itemFieldName, List<CellStyle> cellStyles, String entryEntity) {
        String cell = this.getCellKey(entryEntity, rowId, key);
        Set<Long> itemIds = this.getTotalRowItems(rowId, colIdx, cell, entryEntity);
        this.addCellStyle(key, itemFieldName, itemIds, cellStyles, focusColor, entryEntity);
        this.getPageCache().put(PRETOTALROWCELL, cell);
    }

    private String getCellKey(String entryEntity, String rowId, String key) {
        return entryEntity + "&" + rowId + "&" + key;
    }

    private void setPreTotalRowCellColor(List<CellStyle> cellStyles, String entryEntity) {
        String preCell = this.getPageCache().get(PRETOTALROWCELL);
        String preItemString = this.getPageCache().get(preCell);
        if (!StringUtils.isEmpty((CharSequence)preCell) && !StringUtils.isEmpty((CharSequence)preItemString)) {
            Set preItemIds = (Set)SerializationUtils.deSerializeFromBase64((String)preItemString);
            String[] split = preCell.split("&");
            if (preItemIds != null && split.length == 2) {
                String preKey = split[1];
                String preItemFieldName = amountColAndItemNameMap.get(preKey);
                this.addCellStyle(preKey, preItemFieldName, preItemIds, cellStyles, commonColor, entryEntity);
            }
        }
        this.getPageCache().remove(PRETOTALROWCELL);
    }

    private void addCellStyle(String key, String itemFieldName, Set<Long> preItemIds, List<CellStyle> cellStyles, String commonColor, String entryEntity) {
        int rowCount = this.getModel().getEntryRowCount(entryEntity);
        for (int i = 0; i < rowCount; ++i) {
            Long itemId = (Long)this.getModel().getValue(itemFieldName + "_id", i);
            if (!preItemIds.contains(itemId)) continue;
            this.addRowCellStyle(i, key, commonColor, cellStyles);
        }
    }

    private CellStyle addRowCellStyle(int row, String colKey, String color, List<CellStyle> cellStyles) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setBackColor(color);
        cellStyle.setRow(row);
        cellStyle.setFieldKey(colKey);
        cellStyles.add(cellStyle);
        return cellStyle;
    }

    private Set<Long> getTotalRowItems(String rowId, int colIdx, String cell, String entryEntity) {
        Set<Long> itemIds = this.loadDetailItemIdsFromCache(cell);
        if (itemIds == null || itemIds.isEmpty()) {
            itemIds = this.queryTotalRowItems(rowId, colIdx, entryEntity);
            this.cacheTotalRowDetailItemIds(cell, itemIds);
        }
        return itemIds;
    }

    private Set<Long> queryTotalRowItems(String rowId, int colIdx, String entryEntity) {
        QFilter forg = new QFilter(org, "=", this.getModel().getValue("org_id"));
        QFilter fbookType = new QFilter(bookType, "=", this.getModel().getValue("booktype_id"));
        QFilter facctTable = new QFilter(accTable, "=", this.getModel().getValue("accounttable_id"));
        QFilter fbalRowId = new QFilter(entryEntity + "." + seq, "=", (Object)rowId);
        QFilter fcolumnKey = new QFilter("columnKey", "=", (Object)(colIdx + ""));
        QFilter[] filters = new QFilter[]{forg, fbookType, facctTable, fbalRowId, fcolumnKey};
        String selectFields = "entryentity.rptitem rptitem";
        HashSet<Long> rptItems = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryTotalRowItems"), (String)expressionFormId, (String)selectFields, (QFilter[])filters, null);){
            for (Row row : dSet) {
                rptItems.add(row.getLong(RPTITEM));
            }
        }
        return rptItems;
    }

    private String setRowExpression(String expression, Boolean isTotalRow, String name, String number, String sign, String fetchName) {
        expression = isTotalRow != false ? TaxReportFormHelper.parseExpTotalRow((String)expression, (String)name, (String)sign) : TaxReportFormHelper.parseExpRow((String)expression, (String)number, (String)name, (String)fetchName, (String)sign);
        return expression;
    }

    public String subLastChart(String str) {
        String strs = "";
        if (StringUtils.isNotBlank((CharSequence)str)) {
            strs = str.substring(0, str.length() - 1);
        }
        return strs;
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (save.equals(key)) {
            this.saveBalancesheet();
        } else if ("refresh".equals(key)) {
            ReportClearUtil.clearAllExpressionCache(this.getPageCache());
        }
    }

    private void saveBalancesheet() {
        String formId = this.getView().getFormShowParameter().getFormId();
        QFilter forg = new QFilter(org, "=", this.getModel().getValue("org_id"));
        QFilter faccountTable = new QFilter(accTable, "=", this.getModel().getValue("accounttable_id"));
        QFilter bookTypeFilter = new QFilter(bookType, "=", this.getModel().getValue(GLField.id_((String)bookType)));
        QFilter[] filters = new QFilter[]{forg, faccountTable, bookTypeFilter};
        try (TXHandle h = TX.requiresNew((String)"fi_balancesheet_sav");){
            try {
                DeleteServiceHelper.delete((String)formId, (QFilter[])filters);
                Object[] results = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                if (results.length > 0) {
                    if (this.saveExpre(assetEntryKey) && this.saveExpre(equityEntryKey)) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"BalanceSheetEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        this.getView().close();
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BalanceSheetEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01", (String)"BalanceSheetEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    private boolean saveExpre(String entryKey) {
        int count = this.getModel().getEntryRowCount(entryKey);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)expressionFormId);
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>();
        IDataModel model = this.getModel();
        String[] cellKeys = assetEntryKey.equals(entryKey) ? assetColumn : equityColumn;
        String rowIdFiledName = assetEntryKey.equals(entryKey) ? assetRowId : equityRowId;
        for (int i = 0; i < count; ++i) {
            String rowId = ((DynamicObject)((DynamicObjectCollection)model.getValue(entryKey)).get(i)).getString(rowIdFiledName);
            for (int j = 0; j < cellKeys.length; ++j) {
                String expre = this.getPageCache().get(this.getCellKey(entryKey, rowId, cellKeys[j]));
                if (!StringUtils.isNotEmpty((CharSequence)expre)) continue;
                DynamicObject dyn = GlFormUtil.fromDynamicString(expre, entityType);
                dyn.set(balrowId, (Object)(i + 1));
                dataEntities.add(dyn);
            }
        }
        ArrayList<DynamicObject> listDyn = new ArrayList<DynamicObject>();
        if (dataEntities != null && dataEntities.size() > 0) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject dynamicObject : dynamicObjects = dataEntities.toArray(new DynamicObject[0])) {
                DynamicObject newExpDyn = this.newExpDyn(dynamicObject);
                if (newExpDyn != null) {
                    listDyn.add(newExpDyn);
                }
                QFilter forgId = new QFilter(org, "=", dynamicObject.get(org));
                QFilter facountTable = new QFilter(accTable, "=", (Object)dynamicObject.getLong("accounttable_id"));
                QFilter fbookType = new QFilter(bookType, "=", (Object)dynamicObject.getLong(GLField.id_((String)bookType)));
                QFilter findex = new QFilter("rowtag", "=", dynamicObject.get("rowtag"));
                QFilter fcolumnKey = new QFilter(COLUMNKEY, "=", dynamicObject.get(COLUMNKEY));
                QFilter[] filters = new QFilter[]{forgId, facountTable, findex, fcolumnKey, fbookType};
                DeleteServiceHelper.delete((String)expressionFormId, (QFilter[])filters);
            }
            if (listDyn.isEmpty()) {
                return true;
            }
            Object[] objects = SaveServiceHelper.save((IDataEntityType)entityType, (Object[])listDyn.toArray(new DynamicObject[0]));
            if (objects.length == 0) {
                return false;
            }
        }
        return true;
    }

    private DynamicObject newNullExpDyn(Long orgId, Long acctTableId, Integer balRowId, int columnKey, String rowTag, Boolean isTotalRow) {
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)expressionFormId);
        newExpDyn.set(org, (Object)orgId);
        newExpDyn.set(balrowId, (Object)balRowId);
        newExpDyn.set(COLUMNKEY, (Object)columnKey);
        newExpDyn.set("rowtag", (Object)rowTag);
        newExpDyn.set("accounttable_id", (Object)acctTableId);
        newExpDyn.set(ISTOTALROW, (Object)isTotalRow);
        return newExpDyn;
    }

    private DynamicObject newExpDyn(DynamicObject expDyn) {
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)expressionFormId);
        newExpDyn.set(org, (Object)expDyn.getLong(org));
        newExpDyn.set(bookType, (Object)expDyn.getLong(GLField.id_((String)bookType)));
        newExpDyn.set(balrowId, (Object)expDyn.getString(balrowId));
        newExpDyn.set(COLUMNKEY, (Object)expDyn.getString(COLUMNKEY));
        newExpDyn.set("rowtag", (Object)expDyn.getString("rowtag"));
        newExpDyn.set(accTable, (Object)expDyn.getLong("accounttable_id"));
        newExpDyn.set(ISTOTALROW, expDyn.get(ISTOTALROW));
        DynamicObjectCollection newColl = newExpDyn.getDynamicObjectCollection(entryKey);
        DynamicObjectCollection coll = expDyn.getDynamicObjectCollection(entryKey);
        newColl.clear();
        if (coll.isEmpty()) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            DynamicObject newRow = new DynamicObject(coll.getDynamicObjectType());
            newRow.set(project, row.get("project_id"));
            newRow.set("sign", row.get("sign"));
            newRow.set("fetchrule", row.get("fetchrule"));
            newRow.set(RPTITEM, row.get("rptitem_id"));
            newColl.add((Object)newRow);
        }
        return newExpDyn;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (assetBegin.equals(key) || assetClose.equals(key) || equityBegin.equals(key) || equityClose.equals(key)) {
            this.showExpressionEdit(key);
        }
    }

    public List<String> getTotalIndex() {
        ArrayList<String> list = new ArrayList<String>(26);
        list.add("0assetbegin");
        list.add("0assetclose");
        list.add("0equitybegin");
        list.add("0equitybegin");
        list.add("13assetbegin");
        list.add("13assetclose");
        list.add("14assetbegin");
        list.add("14assetclose");
        list.add("14equitybegin");
        list.add("14equitybegin");
        list.add("15equitybegin");
        list.add("15equitybegin");
        list.add("24equitybegin");
        list.add("24equitybegin");
        list.add("25equitybegin");
        list.add("25equitybegin");
        list.add("26equitybegin");
        list.add("26equitybegin");
        list.add("32assetbegin");
        list.add("32assetclose");
        list.add("33equitybegin");
        list.add("33equitybegin");
        list.add("34assetbegin");
        list.add("34assetclose");
        list.add("34equitybegin");
        list.add("34equitybegin");
        return list;
    }

    private void showExpressionEdit(String style) {
        DynamicObject rptItem;
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", expressionFormId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String rptItemField = "";
        HashMap<String, Object> value = new HashMap<String, Object>();
        String entryEntity = "";
        if (assetBegin.equals(style)) {
            value.put("periodType", "1");
            rptItemField = asset;
            entryEntity = assetEntryKey;
        } else if (assetClose.equals(style)) {
            value.put("periodType", "2");
            rptItemField = asset;
            entryEntity = assetEntryKey;
        } else if (equityBegin.equals(style)) {
            value.put("periodType", "3");
            rptItemField = equity;
            entryEntity = equityEntryKey;
        } else if (equityClose.equals(style)) {
            value.put("periodType", "4");
            rptItemField = equity;
            entryEntity = equityEntryKey;
        }
        value.put("entryEntity", entryEntity);
        AbstractGrid entryGrid = (AbstractGrid)this.getView().getControl(entryEntity);
        int entrySelRow = entryGrid.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        String rowSeq = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection(entryEntity).get(entrySelRow)).getString(seq);
        value.put(balrowId, rowSeq);
        String rowId = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection(entryEntity).get(entrySelRow)).getString(assetEntryKey.equals(entryEntity) ? assetRowId : equityRowId);
        value.put("rowtag", rowId);
        Boolean isTotalRow = Boolean.FALSE;
        if (!StringUtils.isEmpty((CharSequence)rptItemField) && (rptItem = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(entryEntity).get(entrySelRow)).getDynamicObject(rptItemField)) != null) {
            isTotalRow = rptItem.getBoolean(ISTOTALROW);
            value.put(project, rptItem.get("id"));
        }
        value.put(ISTOTALROW, isTotalRow);
        long orgId = (Long)model.getValue("org_id");
        long accTableId = (Long)model.getValue("accounttable_id");
        long bookTypeId = (Long)model.getValue(GLField.id_((String)bookType));
        value.put("orgId", orgId);
        value.put("accTableId", accTableId);
        value.put(bookType, bookTypeId);
        value.put("value", this.getPageCache().get(this.getCellKey(entryEntity, rowId, style)));
        showParameter.setCustomParams(value);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, style + "&" + entrySelRow));
        this.getView().showForm(showParameter);
    }

    public String getNameByVal(DynamicObject dyn, String fieldKey) {
        String fetchrule = dyn.get(fieldKey).toString();
        ComboProp fetchCombo = (ComboProp)dyn.getDataEntityType().getProperties().get((Object)fieldKey);
        String fetchName = fetchCombo.getItemByName(fetchrule);
        return fetchName;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() != null) {
            String[] strs = evt.getActionId().split("&");
            Integer rowIdx = Integer.valueOf(strs[1]);
            String colName = strs[0];
            Map resultMap = (Map)evt.getReturnData();
            String value = (String)resultMap.get("value");
            String entryEntity = (String)resultMap.get("entryEntity");
            this.analysisExp(rowIdx, colName, value, entryEntity);
            if (assetBegin.equals(colName) || assetClose.equals(colName) || equityBegin.equals(colName) || equityClose.equals(colName)) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)expressionFormId);
                DynamicObject dynamicObject = GlFormUtil.fromDynamicString(value, entityType);
                DynamicObjectCollection entryCollection = (DynamicObjectCollection)dynamicObject.get(entryKey);
                if (assetBegin.equals(colName)) {
                    dynamicObject.set(COLUMNKEY, (Object)"2");
                    entryCollection.forEach(dyObj -> dyObj.set("fetchrule", (Object)lstPair.stream().filter(v -> ((String)v.getLeft()).equals(dyObj.get("fetchrule"))).map(Pair::getRight).findFirst().orElse("")));
                    colName = assetClose;
                } else if (equityBegin.equals(colName)) {
                    dynamicObject.set(COLUMNKEY, (Object)"4");
                    entryCollection.forEach(dyObj -> dyObj.set("fetchrule", (Object)lstPair.stream().filter(v -> ((String)v.getLeft()).equals(dyObj.get("fetchrule"))).map(Pair::getRight).findFirst().orElse("")));
                    colName = equityClose;
                }
                value = GlFormUtil.toDynamicObjectJson(dynamicObject);
                this.analysisExp(rowIdx, colName, value, entryEntity);
            }
        }
    }

    private void analysisExp(int rowIdx, String colName, String strObj, String entryEntity) {
        String expression = "";
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)expressionFormId);
        DynamicObject dynamicObject = GlFormUtil.fromDynamicString(strObj, entityType);
        Boolean isTotalRow = dynamicObject.getBoolean(ISTOTALROW);
        DynamicObjectCollection entryCollection = (DynamicObjectCollection)dynamicObject.get(entryKey);
        HashSet<Long> itemIds = new HashSet<Long>();
        for (int i = 0; i < entryCollection.size(); ++i) {
            String sign = (String)((DynamicObject)entryCollection.get(i)).get("sign");
            String itemFieldName = isTotalRow != false ? RPTITEM : project;
            DynamicObject item = (DynamicObject)((DynamicObject)entryCollection.get(i)).get(itemFieldName);
            if (item == null) continue;
            itemIds.add(item.getLong("id"));
            String number = item.getString("number");
            String name = item.getString("name");
            String fetchName = isTotalRow != false ? "" : this.getNameByVal((DynamicObject)entryCollection.get(i), "fetchrule");
            expression = this.setRowExpression(expression, isTotalRow, name, number, sign, fetchName);
        }
        IDataModel model = this.getModel();
        model.setValue(colName, (Object)expression, rowIdx);
        String rowIdValue = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection(entryEntity).get(rowIdx)).getString(assetEntryKey.equals(entryEntity) ? assetRowId : equityRowId);
        if (isTotalRow.booleanValue()) {
            this.cacheTotalRowDetailItemIds(rowIdValue, colName, itemIds, entryEntity);
            this.setCellBGColor(rowIdx, entryEntity);
        }
        this.getPageCache().remove(this.getCellKey(entryEntity, rowIdValue, colName));
        this.getPageCache().put(this.getCellKey(entryEntity, rowIdValue, colName), strObj);
    }

    private void cacheTotalRowDetailItemIds(String cell, Set<Long> itemIds) {
        this.getPageCache().put(cell, SerializationUtils.serializeToBase64(itemIds));
    }

    private void cacheTotalRowDetailItemIds(String rowId, String colField, Set<Long> itemIds, String entryEntity) {
        String cell = this.getCellKey(entryEntity, rowId, colField);
        this.getPageCache().put(cell, SerializationUtils.serializeToBase64(itemIds));
    }

    private void removeTotalRowDetailItemId(String rowId, String colField, String entryEntity) {
        String cell = this.getCellKey(entryEntity, rowId, colField);
        this.getPageCache().remove(cell);
    }

    private Set<Long> loadDetailItemIdsFromCache(String cell) {
        String cacheString = this.getPageCache().get(cell);
        if (StringUtils.isEmpty((CharSequence)cacheString)) {
            return null;
        }
        return (Set)SerializationUtils.deSerializeFromBase64((String)cacheString);
    }

    private String getRowId() {
        return UUID.randomUUID().toString();
    }

    static {
        amountColAndItemNameMap.put(assetBegin, asset);
        amountColAndItemNameMap.put(assetClose, asset);
        amountColAndItemNameMap.put(equityBegin, equity);
        amountColAndItemNameMap.put(equityClose, equity);
        lstPair = new ArrayList<Pair<String, String>>();
        lstPair.add((Pair<String, String>)Pair.of((Object)"1", (Object)"2"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"2", (Object)"1"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"7", (Object)"2"));
    }
}

