/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;

public class BalancesheetPrintPlugin
extends AbstractPrintServicePlugin {
    private static final String ASSETBEGIN = "assetbegin";
    private static final String ASSETCLOSE = "assetclose";
    private static final String EQUITYBEGIN = "equitybegin";
    private static final String EQUITYCLOSE = "equityclose";
    private static final String CURRENTPERIOD = "currentperiod";
    private static final String YEARCOUNT = "yearcount";

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>();
        String pageId = e.getPageId();
        IDataModel model = this.getModel(pageId);
        if (model == null) {
            return;
        }
        Object currency = model.getValue("basecurrency");
        int accuracy = -1;
        if (currency != null) {
            accuracy = ((DynamicObject)currency).getInt("amtprecision");
        }
        if (e.isMainDs()) {
            DynamicObjectType customDt = null;
            customDt = new DynamicObjectType("head");
            customDt.registerProperty("org", String.class, (Object)"", false);
            customDt.registerProperty("period", String.class, (Object)"", false);
            customDt.registerProperty("booktype", String.class, (Object)"", false);
            customDt.registerProperty("orgview", String.class, (Object)"", false);
            customDt.registerProperty("accounttable", String.class, (Object)"", false);
            customDt.registerProperty("periodtype", String.class, (Object)"", false);
            customDt.registerProperty("basecurrency", String.class, (Object)"", false);
            DynamicObject customD = new DynamicObject(customDt);
            String orgName = "";
            DynamicObjectCollection dyOrgs = (DynamicObjectCollection)model.getValue("orgs");
            if (dyOrgs == null || dyOrgs.isEmpty()) {
                return;
            }
            if (dyOrgs.size() == 1) {
                DynamicObject dyOrg = ((DynamicObject)dyOrgs.get(0)).getDynamicObject("fbasedataid");
                orgName = dyOrg.getString("name");
            } else {
                ArrayList<Long> orgIds = new ArrayList<Long>(dyOrgs.size());
                for (DynamicObject dyOrg : dyOrgs) {
                    DynamicObject org = dyOrg.getDynamicObject("fbasedataid");
                    orgIds.add(org.getLong("id"));
                }
                Long parentOrg = AccSysUtil.getParentOrgByChildre(orgIds);
                DynamicObject dyParentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)parentOrg, (String)"bos_org");
                orgName = dyParentOrg != null ? dyParentOrg.getString("name") : "";
            }
            DynamicObject period = (DynamicObject)model.getValue("period");
            DynamicObject orgview = (DynamicObject)model.getValue("orgview");
            DynamicObject accounttable = (DynamicObject)model.getValue("accounttable");
            DynamicObject periodtype = (DynamicObject)model.getValue("periodtype");
            DynamicObject basecurrency = (DynamicObject)model.getValue("basecurrency");
            DynamicObject booktype = (DynamicObject)model.getValue("booktype");
            if (period == null || booktype == null || accounttable == null || periodtype == null) {
                return;
            }
            Date date = period.getDate("enddate");
            SimpleDateFormat format = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"BalancesheetPrintPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            String dateformat = date != null ? format.format(date) : "";
            customD.set("booktype", (Object)booktype.getString("name"));
            customD.set("org", (Object)orgName);
            customD.set("period", (Object)dateformat);
            customD.set("orgview", (Object)(orgview == null ? "" : orgview.getString("name")));
            customD.set("accounttable", (Object)accounttable.getString("name"));
            customD.set("periodtype", (Object)periodtype.getString("name"));
            customD.set("basecurrency", (Object)basecurrency.getString("name"));
            objectList.add(customD);
        } else {
            DynamicObjectType dt = e.getDynamicObjectType();
            if (dt != null) {
                DataEntityPropertyCollection properties = dt.getProperties();
                String dataSourceName = model.getDataEntityType().getName();
                if (dataSourceName.equals("gl_balancesheet")) {
                    DynamicObjectCollection assetColl = model.getEntryEntity("assetentryentity");
                    DynamicObjectCollection equityColl = model.getEntryEntity("equityentryentity");
                    DynamicObjectCollection maxColl = assetColl.size() > equityColl.size() ? assetColl : equityColl;
                    DynamicObjectCollection minColl = assetColl.size() > equityColl.size() ? equityColl : assetColl;
                    HashMap<Integer, DynamicObject[]> map = new HashMap<Integer, DynamicObject[]>(maxColl.size());
                    for (int i = 0; i < maxColl.size(); ++i) {
                        DynamicObject maxDyn = (DynamicObject)maxColl.get(i);
                        DynamicObject minDyn = i > minColl.size() - 1 ? null : (DynamicObject)minColl.get(i);
                        map.put(i, new DynamicObject[]{maxDyn, minDyn});
                    }
                    this.setObjs(map, dt, properties, accuracy, objectList);
                } else {
                    DynamicObjectCollection coll = model.getEntryEntity("entryentity");
                    this.setObjsIncome(coll, dt, properties, accuracy, objectList);
                }
            }
        }
        e.setDataEntities(objectList);
    }

    private void setObjs(Map<Integer, DynamicObject[]> map, DynamicObjectType dt, DataEntityPropertyCollection properties, int accuracy, List<DynamicObject> objectList) {
        for (Map.Entry<Integer, DynamicObject[]> entry : map.entrySet()) {
            DynamicObject[] value = entry.getValue();
            DynamicObject maxDyn = value[0];
            DynamicObject minDyn = value[1];
            DynamicObject obj = new DynamicObject(dt);
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if (property.getName().equals("org")) continue;
                if (name.equals("asset") || name.equals("equity") || name.equals("project")) {
                    if (!(maxDyn.containsProperty(name) && maxDyn.getDynamicObject(name) != null || minDyn != null && minDyn.containsProperty(name) && minDyn.getDynamicObject(name) != null)) {
                        obj.set(property, (Object)"");
                        continue;
                    }
                    obj.set(property, maxDyn.containsProperty(name) ? maxDyn.getDynamicObject(name).get("name") : (minDyn != null ? minDyn.getDynamicObject(name).get("name") : ""));
                    continue;
                }
                if (name.equals(ASSETBEGIN) || name.equals(ASSETCLOSE) || name.equals(EQUITYBEGIN) || name.equals(EQUITYCLOSE) || name.equals(CURRENTPERIOD) || name.equals(YEARCOUNT)) {
                    BigDecimal amount;
                    BigDecimal bigDecimal = maxDyn.containsProperty(name) ? maxDyn.getBigDecimal(name) : (amount = minDyn != null && minDyn.containsProperty(name) ? minDyn.getBigDecimal(name) : BigDecimal.ZERO);
                    if (amount.compareTo(BigDecimal.ZERO) == 0) {
                        obj.set(property, (Object)" ");
                        continue;
                    }
                    if (accuracy != -1) {
                        obj.set(property, (Object)amount.setScale(accuracy, RoundingMode.HALF_UP));
                        continue;
                    }
                }
                obj.set(property, maxDyn.get(property.getName()));
            }
            objectList.add(obj);
        }
    }

    private void setObjsIncome(DynamicObjectCollection coll, DynamicObjectType dt, DataEntityPropertyCollection properties, int accuracy, List<DynamicObject> objectList) {
        for (DynamicObject row : coll) {
            DynamicObject obj = new DynamicObject(dt);
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if (property.getName().equals("org")) continue;
                if (name.equals("assetrow") || name.equals("equityrow") || name.equals("balrowid")) {
                    Object assetrow = row.get(name);
                    if (assetrow.toString().trim().length() == 0) {
                        obj.set(property, (Object)" ");
                        continue;
                    }
                    obj.set(property, (Object)Integer.parseInt(assetrow.toString()));
                    continue;
                }
                if (name.equals("asset") || name.equals("equity") || name.equals("project")) {
                    if (row.getDynamicObject(name) == null) {
                        obj.set(property, (Object)"");
                        continue;
                    }
                    obj.set(property, row.getDynamicObject(name).get("name"));
                    continue;
                }
                if (name.equals(ASSETBEGIN) || name.equals(ASSETCLOSE) || name.equals(EQUITYBEGIN) || name.equals(EQUITYCLOSE) || name.equals(CURRENTPERIOD) || name.equals(YEARCOUNT)) {
                    BigDecimal amount = row.getBigDecimal(name);
                    if (amount.compareTo(BigDecimal.ZERO) == 0) {
                        obj.set(property, (Object)" ");
                        continue;
                    }
                    if (accuracy != -1) {
                        obj.set(property, (Object)amount.setScale(accuracy));
                        continue;
                    }
                }
                obj.set(property, row.get(property.getName()));
            }
            objectList.add(obj);
        }
    }

    private IDataModel getModel(String pageId) {
        FormView view = (FormView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        IDataModel model = view.getModel();
        return model;
    }
}

