/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;

public class CardHomePlugin
extends AbstractFormPlugin {
    public static final String ACCOUNT_BOOK = "accountbookinfo";

    public AccountBookInfo getAccountBook() {
        DynamicObject bookType;
        DynamicObject org;
        String str = this.getPageCache().get(ACCOUNT_BOOK);
        if (str != null) {
            return (AccountBookInfo)GLUtil.fromSerializedString((String)str);
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        if (!parentView.getModel().getDataEntityType().getAllFields().containsKey("orgid") || !parentView.getModel().getDataEntityType().getAllFields().containsKey("booktype")) {
            String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
            HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)appId, (String)parentView.getEntityId(), (String)PermissonType.VIEW.getPermId(), (boolean)true);
            long defaultOrgId = RequestContext.get().getOrgId();
            if (!permOrgRs.getHasPermOrgs().contains(RequestContext.get().getOrgId()) || defaultOrgId == 0L) {
                return null;
            }
            org = BusinessDataServiceHelper.loadSingleFromCache((Object)defaultOrgId, (String)"bos_org");
            bookType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (QFilter[])new QFilter("accounttype", "=", (Object)AccountBooksType.MAIN_BOOK.getValue()).toArray());
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("org", "=", (Object)defaultOrgId));
            qfBuilder.add(new QFilter("bookstype", "=", bookType.getPkValue()));
            qfBuilder.add("isbizunit", "=", (Object)Boolean.TRUE);
            if (!QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])qfBuilder.toArray())) {
                return null;
            }
        } else {
            org = (DynamicObject)parentView.getModel().getValue("orgid");
            bookType = (DynamicObject)parentView.getModel().getValue("booktype");
        }
        if (org == null || bookType == null) {
            return null;
        }
        AccountBookInfo accountBook = null;
        try {
            accountBook = AccSysUtil.getBookFromAccSys((long)org.getLong("id"), (long)bookType.getLong("id"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (accountBook == null) {
            return null;
        }
        this.getPageCache().put(ACCOUNT_BOOK, GLUtil.toSerializedString((Object)accountBook));
        return accountBook;
    }

    @Deprecated
    public String getUserId() {
        return RequestContext.get().getUserId();
    }
}

