/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.formplugin.CardHomePlugin;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.voucher.count.VoucherCountHelper;

public class CardPercentagePlugin
extends CardHomePlugin {
    private static final String PERSONAL_AUTOMATION_RATE = "personalautomationrate";
    private static final String PERSONAL_AUTOMATION_RATE_PRO = "personalautomationratepro";
    private static final String COMPANY_AUTOMATION_RATE_PRO = "companyautomationratepro";
    private static final String MANUAL_VOUCHER_CNT = "manualvouchercnt";
    private static final String MECHANISM_VOUCHER_CNT = "mechanismvouchercnt";
    private static final String[] fields = new String[]{"sourcetype", "creator"};

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(PERSONAL_AUTOMATION_RATE, (Object)ContextUtil.getUserId());
        if (this.getAccountBook() == null) {
            return;
        }
        this.initValue();
    }

    public DataSet getCurPeriodVoucher() {
        AccountBookInfo accountBook = super.getAccountBook();
        long bookTypeId = accountBook.getBookTypeId();
        long periodId = accountBook.getCurPeriodId();
        long orgId = accountBook.getOrgId();
        return Voucher.getDataSet((String)((Object)((Object)this)).getClass().getName(), (String)String.join((CharSequence)",", fields), (long[])new long[]{orgId}, (long)bookTypeId, (long)periodId, null, null);
    }

    private void initValue() {
        DataSet curPeriodVoucher = this.getCurPeriodVoucher().groupBy(fields).count().finish();
        int manual = 0;
        int mechanism = 0;
        int curUserMechanism = 0;
        for (Row row : curPeriodVoucher) {
            Integer count = row.getInteger("count");
            String sys_t = row.getString("sourcetype");
            String creator = row.getString("creator");
            if ("0".equals(sys_t)) {
                manual += count.intValue();
                continue;
            }
            mechanism += count.intValue();
            if (!String.valueOf(ContextUtil.getUserId()).equals(creator)) continue;
            curUserMechanism += count.intValue();
        }
        this.initCnt(MANUAL_VOUCHER_CNT, manual);
        this.initCnt(MECHANISM_VOUCHER_CNT, mechanism);
        int total = manual + mechanism;
        this.initPro(total, curUserMechanism, PERSONAL_AUTOMATION_RATE_PRO);
        this.initPro(total, mechanism, COMPANY_AUTOMATION_RATE_PRO);
    }

    private void initPro(int total, int mechanism, String key) {
        if (total != 0) {
            int percent = new BigDecimal(mechanism).divide(new BigDecimal(total), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).intValue();
            ((ProgressBar)this.getControl(key)).setPercent(Integer.parseInt(String.valueOf(percent)));
        }
    }

    private void initCnt(String labelKey, int count) {
        Label label = (Label)this.getView().getControl(labelKey);
        label.setText(String.valueOf(count));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (this.getAccountBook() == null) {
            return;
        }
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "manualvouchercnt": {
                this.showVoucherFormWithFilter(MANUAL_VOUCHER_CNT);
                break;
            }
            case "mechanismvouchercnt": {
                this.showVoucherFormWithFilter(MECHANISM_VOUCHER_CNT);
                break;
            }
        }
    }

    private void showVoucherFormWithFilter(String key) {
        AccountBookInfo accountBook = super.getAccountBook();
        Long curPeriod = accountBook.getCurPeriodId();
        long orgId = accountBook.getOrgId();
        long bookTypeId = accountBook.getBookTypeId();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("gl_voucher");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter periodFilter = new QFilter("period", "=", (Object)curPeriod);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        switch (key) {
            case "manualvouchercnt": {
                QFilter sourcetypeFilter3 = new QFilter("sourcetype", "=", (Object)"0");
                orgFilter = orgFilter.and(periodFilter).and(bookTypeFilter).and(sourcetypeFilter3);
                break;
            }
            case "mechanismvouchercnt": {
                QFilter sourcetypeFilter4 = new QFilter("sourcetype", "!=", (Object)"0");
                orgFilter = orgFilter.and(periodFilter).and(bookTypeFilter).and(sourcetypeFilter4);
                break;
            }
        }
        para.setCustomParam("source", (Object)"GLIndexMulOrgPlugin");
        para.setCustomParam("org", (Object)String.valueOf(orgId));
        para.setCustomParam("booktype", (Object)String.valueOf(bookTypeId));
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)curPeriod, (String)"bd_period");
        if (loadSingle != null) {
            Object[] dates = new Object[]{loadSingle.getDate("begindate"), loadSingle.getDate("enddate")};
            para.setCustomParam("bookeddate", (Object)dates);
        }
        para.setCustomParam("filter", (Object)orgFilter.toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MANUAL_VOUCHER_CNT, MECHANISM_VOUCHER_CNT});
    }

    private int getVoucherCount(long orgId, long bookTypeId, long periodId, QFilter qFilter) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("booktype", "=", (Object)bookTypeId));
        qFilters.add(new QFilter("period", "=", (Object)periodId));
        qFilters.add(qFilter);
        return VoucherCountHelper.queryVoucherCount(qFilters);
    }
}

