/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.formplugin.CardHomePlugin;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.voucher.count.VoucherCountHelper;

public class CardVoucherPlugin
extends CardHomePlugin {
    private static final String TEMP_CNT = "tempcnt";
    private static final String SUBMIT_CNT = "subcnt";
    private static final String AUDIT_CNT = "audcnt";
    private static final String POST_CNT = "postcnt";
    private static final String SUBMIT = "804f6478000000ac";
    private static final String AUDIT = "47162f66000000ac";
    private static final String CHECK = "/KT3DYXQC54Y";
    private static final String POST = "/KT1KPHCT41P";
    private static final String[] ALL_CNT = new String[]{"tempcnt", "subcnt", "audcnt", "postcnt"};
    private static final String[] ALL_PERM = new String[]{"804f6478000000ac", "47162f66000000ac", "/KT3DYXQC54Y", "/KT1KPHCT41P"};

    public void afterCreateNewData(EventObject e) {
        if (this.getAccountBook() == null) {
            return;
        }
        this.setValue();
    }

    private Map<String, Integer> checkPermission() {
        HashMap<String, Integer> perMap = new HashMap<String, Integer>(ALL_PERM.length);
        AccountBookInfo accountBook = super.getAccountBook();
        if (accountBook == null) {
            return perMap;
        }
        long orgId = accountBook.getOrgId();
        HashMap<String, String> map = new HashMap<String, String>(ALL_PERM.length);
        map.put(SUBMIT, TEMP_CNT);
        map.put(AUDIT, SUBMIT_CNT);
        map.put(CHECK, AUDIT_CNT);
        map.put(POST, POST_CNT);
        for (String perm : ALL_PERM) {
            int i = PermissionServiceHelper.checkPermission((long)ContextUtil.getUserId(), (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)"gl_voucher", (String)perm);
            perMap.put((String)map.get(perm), i);
        }
        return perMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        this.showVoucherList(key);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Map<String, Integer> perMap = this.checkPermission();
        for (Map.Entry<String, Integer> entry : perMap.entrySet()) {
            if (entry.getValue() != 1) continue;
            this.addClickListeners(new String[]{entry.getKey()});
        }
    }

    private void setValue() {
        Map<String, Integer> map = this.getVoucherCount();
        Map<String, Integer> perMap = this.checkPermission();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            Label label = (Label)this.getView().getControl(entry.getKey());
            if (perMap.get(entry.getKey()) != 1) continue;
            label.setText(String.valueOf(entry.getValue()));
        }
    }

    private DataSet getVocher(QFilter customFilter) {
        AccountBookInfo accountBook = super.getAccountBook();
        long bookTypeId = accountBook.getBookTypeId();
        long periodId = accountBook.getCurPeriodId();
        long orgId = accountBook.getOrgId();
        QFilter postFilter = new QFilter("ispost", "=", (Object)false);
        String selectField = "billstatus,ischeck";
        DataSet dataSet = Voucher.getDataSet((String)this.getView().getEntityId(), (String)selectField, (long[])new long[]{orgId}, (long)bookTypeId, (long)periodId, (QFilter[])new QFilter[]{postFilter, customFilter}, null);
        return dataSet;
    }

    private Map<String, Integer> getVoucherCount() {
        HashMap<String, Integer> result = new HashMap<String, Integer>(ALL_CNT.length);
        for (String cnt : ALL_CNT) {
            result.put(cnt, 0);
        }
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C"});
        DataSet dataSet = this.getVocher(statusFilter).groupBy(new String[]{"billstatus", "ischeck"}).count().finish();
        int submitCount = 0;
        int auditCount = 0;
        int checkCount = 0;
        int postCount = 0;
        for (Row row : dataSet) {
            Integer count = row.getInteger("count");
            String status = row.getString("billstatus");
            String checkStatus = row.getString("ischeck");
            switch (status) {
                case "A": {
                    submitCount += count.intValue();
                    break;
                }
                case "B": {
                    auditCount += count.intValue();
                    if (!"b".equals(checkStatus)) break;
                    checkCount += count.intValue();
                    break;
                }
                case "C": {
                    if ("b".equals(checkStatus)) {
                        checkCount += count.intValue();
                        break;
                    }
                    postCount += count.intValue();
                }
            }
        }
        result.put(TEMP_CNT, submitCount);
        result.put(SUBMIT_CNT, auditCount);
        result.put(AUDIT_CNT, checkCount);
        result.put(POST_CNT, postCount);
        return result;
    }

    private QFilter checkCashFilter() {
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
        QFilter checkFilter = new QFilter("ischeck", "=", (Object)"b");
        QFilter acctFilter = statusFilter.and(checkFilter);
        return acctFilter;
    }

    private QFilter checkPostFilter() {
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter postFilter = new QFilter("ispost", "=", (Object)false);
        QFilter checkFilter = new QFilter("ischeck", "!=", (Object)"b");
        QFilter acctFilter = statusFilter.and(postFilter).and(checkFilter);
        return acctFilter;
    }

    private void showVoucherList(String key) {
        AccountBookInfo accountBook = super.getAccountBook();
        if (accountBook == null) {
            return;
        }
        Long curPeriod = accountBook.getCurPeriodId();
        long orgId = accountBook.getOrgId();
        long bookTypeId = accountBook.getBookTypeId();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("gl_voucher");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter periodFilter = new QFilter("period", "=", (Object)curPeriod);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter statusFilter = null;
        String[] mulStatus = null;
        String[] mulCheck = null;
        switch (key) {
            case "postcnt": {
                QFilter postFilter = this.checkPostFilter();
                statusFilter = postFilter.and(orgFilter).and(periodFilter).and(bookTypeFilter);
                mulStatus = new String[]{"C"};
                mulCheck = new String[]{"a", "c"};
                para.setCustomParam("addPostColumn", (Object)"0");
                break;
            }
            case "audcnt": {
                QFilter acctFilter = this.checkCashFilter();
                statusFilter = acctFilter.and(orgFilter).and(periodFilter).and(bookTypeFilter);
                mulStatus = new String[]{"B", "C"};
                mulCheck = new String[]{"b"};
                break;
            }
            case "subcnt": {
                statusFilter = new QFilter("billstatus", "=", (Object)"B");
                statusFilter = statusFilter.and(orgFilter).and(periodFilter).and(bookTypeFilter);
                mulStatus = new String[]{"B"};
                break;
            }
            case "tempcnt": {
                statusFilter = new QFilter("billstatus", "=", (Object)"A");
                statusFilter = statusFilter.and(orgFilter).and(periodFilter).and(bookTypeFilter);
                mulStatus = new String[]{"A"};
            }
        }
        para.setCustomParam("source", (Object)"GLIndexMulOrgPlugin");
        para.setCustomParam("org", (Object)String.valueOf(orgId));
        para.setCustomParam("booktype", (Object)(bookTypeId + ""));
        para.setCustomParam("status", (Object)mulStatus);
        para.setCustomParam("addCheckColumn", mulCheck);
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)curPeriod, (String)"bd_period");
        if (loadSingle != null) {
            Object[] dates = new Object[]{loadSingle.getDate("begindate"), loadSingle.getDate("enddate")};
            para.setCustomParam("bookeddate", (Object)dates);
        }
        if (statusFilter != null) {
            para.setCustomParam("filter", (Object)statusFilter.toSerializedString());
        }
        this.getView().showForm((FormShowParameter)para);
    }

    private int getVoucherCount(List<String> billStatus, List<String> isCheck) {
        AccountBookInfo accountBook = super.getAccountBook();
        long bookTypeId = accountBook.getBookTypeId();
        long periodId = accountBook.getCurPeriodId();
        long orgId = accountBook.getOrgId();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("booktype", "=", (Object)bookTypeId));
        qFilters.add(new QFilter("period", "=", (Object)periodId));
        qFilters.add(new QFilter("billstatus", "in", billStatus));
        if (!CollectionUtils.isEmpty(isCheck)) {
            qFilters.add(new QFilter("ischeck", "in", isCheck));
        }
        qFilters.add(new QFilter("ispost", "=", (Object)false));
        return VoucherCountHelper.queryVoucherCount(qFilters);
    }
}

