/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ListExporter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.formplugin.CashFlowDesignate;
import kd.fi.gl.formplugin.DesignateCommonPlugin;
import kd.fi.gl.formplugin.PresetCashFlowDesignate;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.CashFlowItemHelperNew;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MutexRequireHelper;
import kd.fi.gl.util.cashflow.FilterContext;

public class CashFlowDesignatePlugin
extends DesignateCommonPlugin
implements HyperLinkClickListener {
    public static final String PC_ORG = "orgId";
    private static final String ENTRYKEY = "entry";
    private static final String ITEMNAME = "accountname";
    private static final String AMOUNT = "amount";
    private static final String VOUCHERIDS = "voucherid";
    private static final String COUNT = "count";
    private static final String TYPE = "type";
    private static final String LEVEL = "level";
    private static final String OPTIONCOLUMN = "operationcolumn";
    private static final String SUPPCALLBACK = "suppcallback";
    private static final String SUPERIOR = "superior";
    private static final String KEY_CURRENCY = "currency";
    private static final String fold = "cancel";
    private static final String bysubacct = "bysubacct";
    private static final String cancelappendixitem = "cancelappendixitem";
    private static final String byappendixitem = "byappendixitem";
    public static final String TYPE_ACC = "1";
    public static final String TYPE_CF = "2";
    public static final String ACC_SHOW_LEVEL = "acc_show_level";
    public static final int DEFAULT_VOUCHERBATCH_SIZE = 200;
    private Map<String, PresetCashFlowDesignate> map = null;
    private Map<Long, DynamicObject> cfItemMapCache = new HashMap<Long, DynamicObject>(8);
    public static final Log logger = LogFactory.getLog(CashFlowDesignatePlugin.class);
    private static final String selectFields = "id,period, mainstatus, suppstatus, entries.id, entries.debitlocal, entries.creditlocal, entries.account.pltype, entries.account.longnumber,entries.account.number, entries.account.name, entries.account.iscash, entries.account.isbank, entries.account.iscashequivalent, entries.maincfitem.isdealactivity,entries.maincfitem.direction, entries.suppcfitem, entries.maincfamount, entries.suppcfamount,billstatus,entries.account,entries.entrydc,entries.assgrp,entries.account.accounttype.accounttype,entries.maincfitem";

    private static String getDefsuppname() {
        return ResManager.loadKDString((String)"\u672a\u5904\u7406\u73b0\u91d1\u6d41\u91cf", (String)"CashFlowDesignatePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
    }

    private static String getAllacct() {
        return ResManager.loadKDString((String)"\u6240\u6709\u79d1\u76ee", (String)"CashFlowDesignatePlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.optionColumn();
    }

    private void optionColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYKEY);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && OPTIONCOLUMN.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                DynamicObject obj = pkEvent.getRowData();
                String type = obj.getString(TYPE);
                String level = obj.getString(LEVEL);
                int count = obj.getInt(COUNT);
                String itemName = obj.getString(ITEMNAME);
                if (CashFlowDesignatePlugin.getAllacct().equals(itemName) || "".equals(itemName)) {
                    ((OperationColItem)operationColItems.get(0)).setVisible(false);
                    ((OperationColItem)operationColItems.get(3)).setVisible(false);
                }
                if (count == 0) {
                    ((OperationColItem)operationColItems.get(4)).setVisible(false);
                } else {
                    ((OperationColItem)operationColItems.get(4)).setVisible(true);
                }
                if (type != null && !type.equals(TYPE_ACC) && type.equals(TYPE_CF)) {
                    ((OperationColItem)operationColItems.get(2)).setVisible(false);
                }
                if (level == null || level.equals("3")) {
                    // empty if block
                }
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYKEY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "refresh": {
                FilterContext filterContext = this.getFilterContextFromPageCache();
                this.doQuery(filterContext);
                break;
            }
            case "preset": {
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
                HasPermOrgResult hasPermOrg = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)appId, (String)"gl_cashflowdesignate", (String)"0YH1QK63ECUV");
                if (null == hasPermOrg || !hasPermOrg.hasAllOrgPerm() && hasPermOrg.getHasPermOrgs().size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0[\u8865\u5145\u8d44\u6599\u6307\u5b9a]\u7684\u64cd\u4f5c[\u5e94\u7528\u9884\u8bbe]\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CashFlowDesignatePlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showConfirmTipForPreset("preset", ResManager.loadKDString((String)"\u662f\u5426\u8986\u76d6\u5df2\u6307\u5b9a\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff1f", (String)"CashFlowDesignatePlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u8865\u5145\u8d44\u6599\u3002", (String)"CashFlowDesignatePlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void preset(boolean coverDesigned) {
        long accountTableId;
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter filters = filterContext.getqFilter();
        if (!coverDesigned) {
            filters.and(new QFilter("suppstatus", "in", Arrays.asList(TYPE_CF, TYPE_ACC)));
            filters.and(new QFilter("entries.suppcfitem", "=", (Object)0L));
        }
        Map<String, PresetCashFlowDesignate> subAcct = this.getSubAcctForPreset(filters, TYPE_ACC, "");
        ArrayList<PresetCashFlowItemParam> paramList = new ArrayList<PresetCashFlowItemParam>(subAcct.size());
        HashSet<Long> voucherIdSet = new HashSet<Long>(subAcct.size());
        String checkMsg = null;
        checkMsg = this.initPresetParamAndVoucherIds(subAcct, paramList, voucherIdSet);
        if (checkMsg != null) {
            this.getView().showTipNotification(checkMsg, Integer.valueOf(2000));
            return;
        }
        AccountBookInfo book = filterContext.getBook();
        checkMsg = this.checkPeriod(book, voucherIdSet);
        if (checkMsg != null) {
            this.getView().showTipNotification(checkMsg, Integer.valueOf(2000));
            return;
        }
        if (this.checkModifyHisCf(voucherIdSet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u5305\u542b\u5df2\u7ed3\u8d26\u671f\u95f4\u51ed\u8bc1\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"MainDesignateEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        long orgId = book.getOrgId();
        Map presetMap = PresetCashItemUtil.batchGetCashFlowItemIds(paramList, (long)orgId, (long)(accountTableId = book.getAccountTableId()));
        if (CollectionUtils.isEmpty((Map)presetMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u79d1\u76ee\u6620\u5c04\u5173\u7cfb\u3002", (String)"CashFlowDesignatePlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (DebugTrace.enable()) {
            logger.info("\u6620\u5c04\u5173\u7cfb\u6253\u5370\u683c\u5f0f:acctId-acctLongnumber-assgrp-dc-itemType=value,\u6620\u5c04\u5173\u7cfbmap={}", (Object)this.presetMapToString(presetMap));
        }
        boolean isDesignateSuccess = false;
        for (CashFlowDesignate cashFlowDesignate : subAcct.values()) {
            PresetCashFlowDesignate value = (PresetCashFlowDesignate)cashFlowDesignate;
            Long itemId = (Long)presetMap.get(this.buildPresetParam(value));
            if (DebugTrace.enable()) {
                logger.info("\u5206\u5f55={},\u9644\u8868\u9884\u8bbe\u503c={}", (Object)value, (Object)itemId);
            }
            if (itemId == null) continue;
            boolean hasDesignate = this.designateV1(itemId, value.getVchIdEntriesIdMap());
            if (isDesignateSuccess) continue;
            isDesignateSuccess = hasDesignate;
        }
        Object designateV1ParamsCache = ThreadCache.get((Object)"designateV1Params");
        if (null != designateV1ParamsCache) {
            DesignateCommonPlugin.DesignateV1Params designateV1Params = (DesignateCommonPlugin.DesignateV1Params)designateV1ParamsCache;
            boolean hasDesignate = this.designateV1Pack(designateV1Params);
            if (!isDesignateSuccess) {
                isDesignateSuccess = hasDesignate;
            }
            ThreadCache.remove((Object)"designateV1Params");
        }
        if (isDesignateSuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9884\u8bbe\u6210\u529f\u3002", (String)"CashFlowDesignatePlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            this.firstLineDeploy(0);
        }
    }

    private boolean designateV1(Long cfItem, Multimap<Long, Long> vchIdEntriesIdMap) {
        boolean result = false;
        if (vchIdEntriesIdMap.size() >= 999) {
            List<Tuple<Set<Long>, Set<Long>>> batchList = this.transToBatchList(vchIdEntriesIdMap);
            logger.info("[T_preset]designateV1, vchIdEntriesIdMap.size: {}, batchList.size: {} ", (Object)vchIdEntriesIdMap.size(), (Object)batchList.size());
            for (Tuple<Set<Long>, Set<Long>> tuple : batchList) {
                logger.info("[T_preset]designateV1In itemId:{} assgrpId:{}, vchIds.size: {}, veIds.size: {}", new Object[]{cfItem, ((Set)tuple.item1).size(), ((Set)tuple.item2).size()});
                QFilter entryIdFilter = new QFilter("id", "in", tuple.item1).and(new QFilter("entries.id", "in", tuple.item2));
                boolean hasDesignate = this.designate(entryIdFilter, cfItem, (Set)tuple.item1, null);
                if (result) continue;
                result = hasDesignate;
            }
        } else {
            Object designateV1ParamsCache = ThreadCache.get((Object)"designateV1Params");
            DesignateCommonPlugin.DesignateV1Params designateV1Params = null != designateV1ParamsCache ? (DesignateCommonPlugin.DesignateV1Params)designateV1ParamsCache : new DesignateCommonPlugin.DesignateV1Params();
            designateV1Params.add(cfItem, vchIdEntriesIdMap);
            if (designateV1Params.vchIdCount >= 999) {
                result = this.designateV1Pack(designateV1Params);
                ThreadCache.remove((Object)"designateV1Params");
            } else {
                ThreadCache.put((Object)"designateV1Params", (Object)designateV1Params);
            }
        }
        return result;
    }

    private boolean designateV1Pack(DesignateCommonPlugin.DesignateV1Params designateV1Params) {
        boolean result = false;
        List<Tuple<Set<Long>, Set<Long>>> batchList = this.transToBatchList(designateV1Params.vchIdEntriesIdMap);
        logger.info("[T_preset]designateV1Pack, designateV1Params.vchIdEntriesIdMap.size: {}, batchList.size: {} ", (Object)designateV1Params.vchIdEntriesIdMap.size(), (Object)batchList.size());
        for (Tuple<Set<Long>, Set<Long>> tuple : batchList) {
            logger.info("[T_preset]designateV1Pack designateV1Params designateV1Params.entryidItemIdMap.size:{}, vchIds.size: {}, veIds.size: {}", new Object[]{designateV1Params.entryidItemIdMap.size(), ((Set)tuple.item1).size(), ((Set)tuple.item2).size()});
            QFilter entryIdFilter = new QFilter("id", "in", tuple.item1).and(new QFilter("entries.id", "in", tuple.item2));
            boolean hasDesignate = this.designate(entryIdFilter, null, (Set)tuple.item1, designateV1Params.entryidItemIdMap);
            if (result) continue;
            result = hasDesignate;
        }
        return result;
    }

    @Override
    protected void doQuery(FilterContext filterContext) {
        QFilter qFilter = filterContext.getqFilter();
        if (qFilter == null) {
            logger.error("filterContext.getqFilter() return null!");
            return;
        }
        BigDecimal amt = this.getSumAmt(qFilter);
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYKEY);
        if (amt != null) {
            int index = model.createNewEntryRow(ENTRYKEY);
            model.setValue(ITEMNAME, (Object)CashFlowDesignatePlugin.getAllacct(), index);
            model.setValue(AMOUNT, (Object)amt, index);
            model.setValue(LEVEL, (Object)TYPE_ACC, index);
        }
    }

    @Override
    protected void doUpdateView() {
        this.getModel().deleteEntryData(ENTRYKEY);
    }

    private void buildSuppRow(BigDecimal amt, Row row, Map<String, PresetCashFlowDesignate> map, String newL, String superior) {
        String key = row.getString("entries.suppcfitem.number") + "_" + row.getString("entries.suppcfitem.name");
        PresetCashFlowDesignate cf = null;
        if (map.get(key) == null) {
            HashSet<Long> set = new HashSet<Long>(16);
            set.add(row.getLong("id"));
            cf = new PresetCashFlowDesignate();
            map.put(key, cf);
            cf.setAmt(amt);
            if (row.getLong("entries.suppcfitem") == 0L) {
                cf.setName(CashFlowDesignatePlugin.getDefsuppname());
            } else {
                cf.setName(key);
            }
            cf.setVchIds(set);
            cf.setType(TYPE_CF);
            cf.setSuperior(superior);
            cf.setLevel(newL);
        } else {
            cf = map.get(key);
            cf.setAmt(cf.getAmt().add(amt));
            cf.getVchIds().add(row.getLong("id"));
        }
    }

    private void buildAcctRow(BigDecimal amt, Row row, Map<String, PresetCashFlowDesignate> map, String newL, String superior) {
        String name = row.getString("entries.account.number") + "_" + row.getString("entries.account.name");
        String idKey = String.valueOf(row.getLong("entries.account"));
        if (map.get(idKey) == null) {
            HashSet<Long> ids = new HashSet<Long>(16);
            ids.add(row.getLong("id"));
            PresetCashFlowDesignate cf = new PresetCashFlowDesignate();
            map.put(idKey, cf);
            cf.setAmt(amt);
            cf.setName(name);
            cf.setVchIds(ids);
            cf.setType(TYPE_ACC);
            cf.setLevel(newL);
            cf.setSuperior(superior);
            ArrayList<Long> entryIds = new ArrayList<Long>(16);
            entryIds.add(row.getLong("entries.id"));
            cf.setVoucherEntryIds(entryIds);
            cf.setAcctId(row.getLong("entries.account"));
            cf.setAcctLongNumber(row.getString("entries.account.longnumber"));
            cf.setItemType("3");
            cf.setAssgrpId(row.getLong("entries.assgrp"));
            cf.setDc(row.getString("entries.entrydc"));
        } else {
            PresetCashFlowDesignate cf = map.get(idKey);
            cf.setAmt(cf.getAmt().add(amt));
            cf.getVchIds().add(row.getLong("id"));
            cf.getVoucherEntryIds().add(row.getLong("entries.id"));
        }
    }

    private Map<String, PresetCashFlowDesignate> getSubAcct(QFilter filters, String newL, String superior) {
        LinkedHashMap<String, PresetCashFlowDesignate> map = new LinkedHashMap<String, PresetCashFlowDesignate>();
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])filters.toArray(), (String)"entries.account.number", (int)-1);){
            for (Row row : ds) {
                if (this.isBudgetAcct(row)) continue;
                String mainStatus = row.getString("mainstatus");
                String suppstatus = row.getString("suppstatus");
                if (!mainStatus.equals("0") && !mainStatus.equals(TYPE_ACC)) {
                    if (this.isCashAcct(row) || row.getLong("entries.maincfitem") == 0L) continue;
                    if (this.isPLAcct(row) && !this.isDealactivity(row)) {
                        if (row.getString("suppstatus").equals("3")) {
                            if (row.getLong("entries.suppcfitem") == 0L) continue;
                            this.buildAcctRow(row.getBigDecimal("entries.suppcfamount"), row, map, newL, superior);
                            continue;
                        }
                        this.buildAcctRow(row.getBigDecimal("entries.debitlocal").subtract(row.getBigDecimal("entries.creditlocal")), row, map, newL, superior);
                        continue;
                    }
                    if (this.isPLAcct(row) || !this.isDealactivity(row)) continue;
                    if (row.getString("suppstatus").equals("3")) {
                        if (row.getLong("entries.suppcfitem") == 0L) continue;
                        this.buildAcctRow(row.getBigDecimal("entries.suppcfamount"), row, map, newL, superior);
                        continue;
                    }
                    BigDecimal amt = "o".equals(row.getString("entries.maincfitem.direction")) ? row.getBigDecimal("entries.maincfamount").negate() : row.getBigDecimal("entries.maincfamount");
                    this.buildAcctRow(amt, row, map, newL, superior);
                    continue;
                }
                if (!suppstatus.equals(TYPE_ACC) && !suppstatus.equals("3") && !suppstatus.equals(TYPE_CF) || this.isPLAcct(row)) continue;
                if (row.getString("suppstatus").equals("3")) {
                    if (row.getLong("entries.suppcfitem") == 0L) continue;
                    this.buildAcctRow(row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")), row, map, newL, superior);
                    continue;
                }
                this.buildAcctRow(row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")), row, map, newL, superior);
            }
        }
        return map;
    }

    private Map<String, PresetCashFlowDesignate> getSubAcctForPreset(QFilter filters, String newL, String superior) {
        LinkedHashMap<String, PresetCashFlowDesignate> map = new LinkedHashMap<String, PresetCashFlowDesignate>();
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])filters.toArray(), (String)"entries.account.number", (int)-1);){
            for (Row row : ds) {
                if (this.isBudgetAcct(row)) continue;
                String mainStatus = row.getString("mainstatus");
                String suppstatus = row.getString("suppstatus");
                if (!mainStatus.equals("0") && !mainStatus.equals(TYPE_ACC)) {
                    if (this.isCashAcct(row) || row.getLong("entries.maincfitem") == 0L) continue;
                    if (this.isPLAcct(row) && !this.isDealactivity(row)) {
                        if (row.getString("suppstatus").equals("3")) {
                            if (row.getLong("entries.suppcfitem") == 0L) continue;
                            this.buildAcctRowForPreset(row.getBigDecimal("entries.suppcfamount"), row, map, newL, superior);
                            continue;
                        }
                        this.buildAcctRowForPreset(row.getBigDecimal("entries.debitlocal").subtract(row.getBigDecimal("entries.creditlocal")), row, map, newL, superior);
                        continue;
                    }
                    if (this.isPLAcct(row) || !this.isDealactivity(row)) continue;
                    if (row.getString("suppstatus").equals("3")) {
                        if (row.getLong("entries.suppcfitem") == 0L) continue;
                        this.buildAcctRowForPreset(row.getBigDecimal("entries.suppcfamount"), row, map, newL, superior);
                        continue;
                    }
                    BigDecimal amt = "o".equals(row.getString("entries.maincfitem.direction")) ? row.getBigDecimal("entries.maincfamount").negate() : row.getBigDecimal("entries.maincfamount");
                    this.buildAcctRowForPreset(amt, row, map, newL, superior);
                    continue;
                }
                if (!suppstatus.equals(TYPE_ACC) && !suppstatus.equals("3") && !suppstatus.equals(TYPE_CF) || this.isPLAcct(row)) continue;
                if (row.getString("suppstatus").equals("3")) {
                    if (row.getLong("entries.suppcfitem") == 0L) continue;
                    this.buildAcctRowForPreset(row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")), row, map, newL, superior);
                    continue;
                }
                this.buildAcctRowForPreset(row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")), row, map, newL, superior);
            }
        }
        return map;
    }

    private void buildAcctRowForPreset(BigDecimal amt, Row row, Map<String, PresetCashFlowDesignate> map, String newL, String superior) {
        String name = row.getString("entries.account.number") + "_" + row.getString("entries.account.name");
        String idKey = row.getLong("entries.account") + row.getString("entries.entrydc");
        if (map.get(idKey) == null) {
            HashSet<Long> ids = new HashSet<Long>(16);
            ids.add(row.getLong("id"));
            PresetCashFlowDesignate cf = new PresetCashFlowDesignate();
            map.put(idKey, cf);
            cf.setAmt(amt);
            cf.setName(name);
            cf.setVchIds(ids);
            cf.setType(TYPE_ACC);
            cf.setLevel(newL);
            cf.setSuperior(superior);
            ArrayList<Long> entryIds = new ArrayList<Long>(16);
            entryIds.add(row.getLong("entries.id"));
            cf.setVoucherEntryIds(entryIds);
            ArrayListMultimap vchIdEntriesIdMap = ArrayListMultimap.create();
            vchIdEntriesIdMap.put((Object)row.getLong("id"), (Object)row.getLong("entries.id"));
            cf.setVchIdEntriesIdMap((Multimap<Long, Long>)vchIdEntriesIdMap);
            cf.setAcctId(row.getLong("entries.account"));
            cf.setAcctLongNumber(row.getString("entries.account.longnumber"));
            cf.setItemType("3");
            cf.setAssgrpId(row.getLong("entries.assgrp"));
            cf.setDc(row.getString("entries.entrydc"));
        } else {
            PresetCashFlowDesignate cf = map.get(idKey);
            cf.setAmt(cf.getAmt().add(amt));
            cf.getVchIds().add(row.getLong("id"));
            cf.getVoucherEntryIds().add(row.getLong("entries.id"));
            Multimap<Long, Long> vchIdEntriesIdMap = cf.getVchIdEntriesIdMap();
            vchIdEntriesIdMap.put((Object)row.getLong("id"), (Object)row.getLong("entries.id"));
        }
    }

    private Map<String, PresetCashFlowDesignate> setSuperAccount(Map<String, PresetCashFlowDesignate> map) {
        String str = this.getPageCache().get(ACC_SHOW_LEVEL);
        int level = str == null ? 1 : Integer.parseInt(str);
        Map<Object, TreeNode> accIdMap = this.getAccountMap();
        LinkedHashMap<String, PresetCashFlowDesignate> newMap = new LinkedHashMap<String, PresetCashFlowDesignate>();
        for (Map.Entry<String, PresetCashFlowDesignate> entry : map.entrySet()) {
            Long id = Long.valueOf(entry.getKey());
            TreeNode node = accIdMap.get(id);
            if (node == null || (node = this.getNodeByLevel(node, level)) == null) continue;
            PresetCashFlowDesignate value = entry.getValue();
            String name = node.getPropValue("number") + "_" + node.getPropValue("name");
            value.setName(name);
            String idKey = String.valueOf(node.getId());
            newMap.compute(idKey, (k, v) -> {
                if (v == null) {
                    return value;
                }
                Set<Long> entryIds = v.getVchIds();
                entryIds.addAll(value.getVchIds());
                v.setAmt(v.getAmt().add(value.getAmt()));
                return v;
            });
        }
        return newMap;
    }

    private TreeNode getNodeByLevel(TreeNode node, int level) {
        int nodeLevel = (Integer)node.getPropValue(LEVEL);
        if (nodeLevel == level) {
            return node;
        }
        if (nodeLevel > level) {
            return this.getNodeByLevel(node.getParent(), level);
        }
        return null;
    }

    private void foldCurrentRow(IDataModel model, int curIndex) {
        List<Integer> rmvIndexes = this.getRvmRows(model, curIndex);
        int[] ints = rmvIndexes.stream().mapToInt(Integer::intValue).toArray();
        model.deleteEntryRows(ENTRYKEY, ints);
        model.setValue(COUNT, (Object)0, curIndex);
    }

    private List<Integer> getRvmRows(IDataModel model, int curIndex) {
        int count = (Integer)model.getValue(COUNT, curIndex);
        ArrayList<Integer> rmvIndexes = new ArrayList<Integer>();
        this.setRvmIndexes(curIndex, count, rmvIndexes, model);
        return rmvIndexes;
    }

    private void setRvmIndexes(int curIndex, int count, List<Integer> rmvIndexes, IDataModel model) {
        for (int i = 0; i < count; ++i) {
            rmvIndexes.add(++curIndex);
            int cnt = (Integer)model.getValue(COUNT, curIndex);
            this.setRvmIndexes(curIndex, cnt, rmvIndexes, model);
            curIndex += cnt;
        }
    }

    private String getSupAccountNumber() {
        int index = this.getSupAccountIndex();
        if (index != 0) {
            String name = ((String)this.getModel().getValue(ITEMNAME, index)).trim();
            return name.split("_")[0];
        }
        return null;
    }

    private int getSupAccountIndex() {
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(ENTRYKEY);
        return this.getSupAccountIndex(curIndex);
    }

    private int getSupAccountIndex(int curIndex) {
        IDataModel model = this.getModel();
        int curLevel = Integer.parseInt((String)model.getValue(LEVEL, curIndex));
        String curType = (String)model.getValue(TYPE, curIndex);
        if (TYPE_ACC.equals(curType)) {
            return curIndex;
        }
        for (int i = curIndex; i > 0; --i) {
            int level = Integer.parseInt((String)model.getValue(LEVEL, i));
            if (level >= curLevel) continue;
            String type = (String)model.getValue(TYPE, i);
            if (type.equals(TYPE_ACC)) {
                return i;
            }
            if (level == 2) break;
            --curLevel;
        }
        return 0;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String id;
        switch (id = evt.getCallBackId()) {
            case "designate": {
                if (!evt.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.openSuppItemF7Page();
                break;
            }
            case "preset": {
                if (evt.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.preset(true);
                    break;
                }
                if (!evt.getResult().equals((Object)MessageBoxResult.No)) break;
                this.preset(false);
                break;
            }
            case "cancelcf": {
                boolean hasCancel;
                String curIndex;
                if (!evt.getResult().equals((Object)MessageBoxResult.Yes) || !kd.bos.util.StringUtils.isNotEmpty((String)(curIndex = this.getPageCache().get("curindex"))) || !(hasCancel = this.cancelSuppOp(this.getModel(), Integer.parseInt(curIndex)))) break;
                this.treeLoad(true, 0L);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"CashFlowDesignatePlugin_21", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean designItemOp(long itemId) {
        QFilter qfilter;
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(ENTRYKEY);
        String infoKey = (String)model.getValue(VOUCHERIDS, curIndex);
        Set<Long> ids = this.getCacheVoucherIds(infoKey);
        if (curIndex == 0) {
            FilterContext filterContext = this.getFilterContextFromPageCache();
            qfilter = filterContext.getqFilter();
        } else {
            String type = (String)model.getValue(TYPE, curIndex);
            QFilter facctNum = null;
            String itemName = ((String)model.getValue(ITEMNAME, curIndex)).trim();
            String acctNum = itemName.split("_")[0];
            if (type.equals(TYPE_ACC)) {
                facctNum = new QFilter("entries.account.number", "in", this.getSubAccNumber(acctNum));
                int superCashFlowExcludeSelf = this.getSuperCashFlowExcludeSelf(curIndex, model);
                if (superCashFlowExcludeSelf != -1) {
                    String cfName = ((String)model.getValue(ITEMNAME, superCashFlowExcludeSelf)).trim();
                    String cfNumber = cfName.split("_")[0];
                    if (CashFlowDesignatePlugin.getDefsuppname().equals(cfNumber)) {
                        facctNum.and(new QFilter("entries.suppcfitem", "=", (Object)0));
                    } else {
                        facctNum.and(new QFilter("entries.suppcfitem.number", "=", (Object)cfNumber));
                    }
                }
            } else if (type.equals(TYPE_CF)) {
                facctNum = itemName.equals(CashFlowDesignatePlugin.getDefsuppname()) ? new QFilter("entries.suppcfitem", "=", (Object)0) : new QFilter("entries.suppcfitem.number", "=", (Object)acctNum);
                Set<String> subAccts = this.getAcctNum();
                if (!subAccts.isEmpty()) {
                    QFilter facct = new QFilter("entries.account.number", "in", subAccts);
                    facctNum = facctNum.and(facct);
                }
            }
            QFilter fid = new QFilter("id", "in", ids);
            qfilter = fid.and(facctNum);
        }
        boolean hasDesignate = this.designateV1Single(qfilter, itemId, ids);
        if (hasDesignate) {
            this.treeLoad(false, itemId);
        }
        return hasDesignate;
    }

    private boolean designateV1Single(QFilter qfilter, long itemId, Set<Long> vids) {
        boolean result = false;
        HashSet<Long> subVids = new HashSet<Long>(999);
        for (Long vid : vids) {
            subVids.add(vid);
            if (subVids.size() < 999) continue;
            QFilter fidQF = new QFilter("id", "in", subVids);
            fidQF.and(qfilter);
            boolean hasDesignate = this.designate(fidQF, itemId, subVids, null);
            if (!result) {
                result = hasDesignate;
            }
            subVids.clear();
        }
        if (subVids.size() > 0) {
            QFilter fidQF = new QFilter("id", "in", subVids);
            fidQF.and(qfilter);
            boolean hasDesignate = this.designate(fidQF, itemId, subVids, null);
            if (!result) {
                result = hasDesignate;
            }
        }
        return result;
    }

    private Set<String> getAcctNum() {
        String supAccountNumber = this.getSupAccountNumber();
        if (supAccountNumber == null) {
            return new HashSet<String>();
        }
        return this.getSubAccNumber(supAccountNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean designate(QFilter qfilter, Long itemId, Set<Long> voucherIds, Map<Long, Long> entryidItemIdMap) {
        if (null == itemId && null == entryidItemIdMap) {
            throw new KDBizException("itemId & entryidItemIdMap is null");
        }
        HashSet bookIds = new HashSet();
        ArrayList paramList = new ArrayList(voucherIds.size());
        ArrayList vchParams = new ArrayList(voucherIds.size());
        ArrayList entryParams = new ArrayList(voucherIds.size());
        HashSet vchIds = new HashSet(voucherIds.size());
        HashMap dataMap = new HashMap(voucherIds.size());
        HashMap itemMap = new HashMap(voucherIds.size());
        this.checkParam(qfilter);
        boolean hasDesignate = false;
        boolean hasAuditVchs = false;
        long orgId = this.getFilterValue("org.id");
        long bookTypeId = this.getFilterValue("booktype.id");
        String opertion = "designate";
        Set lockIds = MutexRequireHelper.batchRequire((String)"gl_voucher", voucherIds, (String)opertion);
        if (voucherIds.size() != lockIds.size()) {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u51ed\u8bc1\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainDesignateEdit_31", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])qfilter.toArray(), (String)"id", (int)-1);){
            if (ds.hasNext()) {
                HashMap<Long, BigDecimal> amtMap = new HashMap<Long, BigDecimal>();
                HashMap<Long, Long> itemIDMap = new HashMap<Long, Long>(16);
                long voucherId = 0L;
                for (Row row : ds) {
                    if (!GLUtil.isCurrentVoucherAllowModifyCF((long)orgId, (long)bookTypeId, (long)row.getLong("period"), (String)row.getString("billstatus"))) {
                        hasAuditVchs = true;
                        continue;
                    }
                    if (voucherId != 0L && row.getLong("id") != voucherId) {
                        amtMap = new HashMap(16);
                        itemIDMap = new HashMap(16);
                        if (dataMap.size() > 200) {
                            CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, itemMap, (String)TYPE_CF, bookIds, paramList, vchParams, entryParams, vchIds, this.cfItemMapCache, (Long)0L);
                            dataMap.clear();
                            itemMap.clear();
                            hasDesignate = true;
                        }
                    }
                    voucherId = row.getLong("id");
                    dataMap.put(voucherId, amtMap);
                    itemMap.put(voucherId, itemIDMap);
                    Long entryId = row.getLong("entries.id");
                    Long itemIdParam = itemId;
                    if (itemIdParam == null && (itemIdParam = entryidItemIdMap.get(entryId)) == null) {
                        throw new KDBizException("itemId is null, entryId: " + entryId);
                    }
                    itemIDMap.put(entryId, itemIdParam);
                    String suppStatus = row.getString("suppstatus");
                    if (suppStatus.equals("3")) {
                        if (row.getLong("entries.suppcfitem") == 0L) continue;
                        amtMap.put(entryId, row.getBigDecimal("entries.suppcfamount"));
                        continue;
                    }
                    String mainStatus = row.getString("mainstatus");
                    if (!mainStatus.equals("0")) {
                        if (this.isCashAcct(row) || row.getLong("entries.maincfitem") == 0L) continue;
                        if (this.isPLAcct(row) && !this.isDealactivity(row)) {
                            amtMap.put(entryId, row.getBigDecimal("entries.debitlocal").subtract(row.getBigDecimal("entries.creditlocal")));
                            continue;
                        }
                        if (this.isPLAcct(row) || !this.isDealactivity(row)) continue;
                        BigDecimal amt = row.getBigDecimal("entries.maincfamount");
                        if ("o".equals(row.getString("entries.maincfitem.direction"))) {
                            amt = amt.negate();
                        }
                        amtMap.put(entryId, amt);
                        continue;
                    }
                    if (this.isPLAcct(row)) continue;
                    amtMap.put(entryId, row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal")));
                }
                if (dataMap.size() > 0) {
                    CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, itemMap, (String)TYPE_CF, bookIds, paramList, vchParams, entryParams, vchIds, this.cfItemMapCache, (Long)0L);
                    hasDesignate = true;
                }
            }
            CashFlowItemHelperNew.saveData(paramList, vchParams, entryParams, vchIds);
        }
        finally {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            if (!bookIds.isEmpty()) {
                CashFlowItemHelper.calBal(bookIds);
            }
        }
        if (hasAuditVchs) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u8865\u5145\u8d44\u6599\u3002", (String)"CashFlowDesignatePlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        return hasDesignate;
    }

    private void treeLoad(boolean isCancel, long itemId) {
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(ENTRYKEY);
        if (curIndex == 0) {
            this.firstLineDeploy(curIndex);
        } else {
            String type;
            switch (type = (String)model.getValue(TYPE, curIndex)) {
                case "1": {
                    int cfIndex = this.getSuperCashFlowExcludeSelf(curIndex, model);
                    if (cfIndex != -1) {
                        int supAccountIndex = this.getSupAccountIndex(cfIndex);
                        if (supAccountIndex == 0) {
                            if (isCancel) {
                                this.lineLoad(model, curIndex, cfIndex, CashFlowDesignatePlugin.getDefsuppname());
                                break;
                            }
                            DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"number", (QFilter[])new QFilter("id", "=", (Object)itemId).toArray());
                            String number = dyn.getString("number");
                            this.lineLoad(model, curIndex, cfIndex, number);
                            break;
                        }
                        this.callDeploy(model, supAccountIndex, true);
                        break;
                    }
                    this.callDeploy(model, curIndex, true);
                    break;
                }
                case "2": {
                    int cfIndex = this.getSuperCashFlowExcludeSelf(curIndex, model);
                    if (cfIndex != -1) {
                        int supAccountIndex = this.getSupAccountIndex(cfIndex);
                        if (supAccountIndex == 0) {
                            this.firstLineDeploy(0);
                            break;
                        }
                        this.callDeploy(model, supAccountIndex, true);
                        break;
                    }
                    int supAccountIndex = this.getSupAccountIndex();
                    if (supAccountIndex == 0) {
                        this.firstLineDeploy(0);
                        break;
                    }
                    this.callDeploy(model, supAccountIndex, true);
                    break;
                }
                default: {
                    this.callDeploy(model, curIndex, true);
                }
            }
        }
    }

    private void lineLoad(IDataModel model, int curIndex, int cfIndex, String itemName) {
        model.getDataEntity(true);
        DynamicObjectCollection col = model.getEntryEntity(ENTRYKEY);
        String infoKey = (String)model.getValue(VOUCHERIDS, curIndex);
        Set<Long> ids = this.getCacheVoucherIds(infoKey);
        this.supLineDeploy(model, cfIndex);
        if (this.map == null || this.map.size() == 0) {
            model.getDataEntity(true);
            DynamicObjectCollection col1 = model.getEntryEntity(ENTRYKEY);
            infoKey = (String)model.getValue(VOUCHERIDS, cfIndex);
            Map<Long, Set<Long>> key2VoucherIds = this.getCache();
            key2VoucherIds.remove(Long.parseLong(infoKey));
            this.putCache(key2VoucherIds);
            col1.remove(cfIndex);
            col1.remove(cfIndex);
            this.getView().updateView(ENTRYKEY);
        }
        int defSupIndex = 0;
        LinkedHashMap<String, Integer> cashFlowIndexs = new LinkedHashMap<String, Integer>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            if (!TYPE_CF.equals(((DynamicObject)col.get(i)).getString(TYPE))) continue;
            if (((DynamicObject)col.get(i)).getString(ITEMNAME).contains(itemName)) {
                defSupIndex = i;
            }
            cashFlowIndexs.put(((DynamicObject)col.get(i)).getString(ITEMNAME).split("_")[0], i);
        }
        if (defSupIndex > 0) {
            infoKey = (String)model.getValue(VOUCHERIDS, defSupIndex);
            Map<Long, Set<Long>> key2VoucherIds = this.getCache();
            Set<Long> defSupIds = key2VoucherIds.get(Long.valueOf(infoKey));
            defSupIds.addAll(ids);
            this.putCache(key2VoucherIds);
            this.supLineDeploy(model, defSupIndex);
        } else {
            QFilter fid = new QFilter("id", "in", ids);
            Map<String, PresetCashFlowDesignate> nullItemMap = this.getAppendixItem(fid, TYPE_CF, "");
            if (nullItemMap != null && nullItemMap.size() > 0) {
                Map<Long, Set<Long>> infoKey2VoucherIds = this.getCache();
                long[] infoKeys = this.batchGenGlobalIds(nullItemMap.size());
                int keyIndex = 0;
                for (CashFlowDesignate cashFlowDesignate : nullItemMap.values()) {
                    String number = cashFlowDesignate.getName();
                    if (cashFlowIndexs.containsKey(number.split("_")[0])) continue;
                    DynamicObject obj = (DynamicObject)col.getDynamicObjectType().createInstance();
                    obj.set(ITEMNAME, (Object)cashFlowDesignate.getName());
                    obj.set(AMOUNT, (Object)cashFlowDesignate.getAmt());
                    obj.set(TYPE, (Object)cashFlowDesignate.getType());
                    obj.set(LEVEL, (Object)cashFlowDesignate.getLevel());
                    infoKey2VoucherIds.put(infoKeys[keyIndex], cashFlowDesignate.getVchIds());
                    obj.set(VOUCHERIDS, (Object)Long.toString(infoKeys[keyIndex]));
                    obj.set(SUPERIOR, (Object)cashFlowDesignate.getSuperior());
                    int index = this.getInsertCfIndex(cashFlowIndexs, cashFlowDesignate.getName());
                    if (index < 0) {
                        index = col.size();
                    }
                    col.add(index, obj);
                    ++keyIndex;
                }
                this.putCache(infoKey2VoucherIds);
                this.getView().updateView(ENTRYKEY);
            }
        }
    }

    private int getInsertCfIndex(Map<String, Integer> cashFlowIndexs, String itemName) {
        for (Map.Entry<String, Integer> entry : cashFlowIndexs.entrySet()) {
            if (itemName.compareTo(entry.getKey()) >= 0) continue;
            return entry.getValue();
        }
        return -1;
    }

    private void supLineDeploy(IDataModel model, int cfIndex) {
        QFilter fsupp;
        String itemName = ((String)model.getValue(ITEMNAME, cfIndex)).trim();
        String acctNum = itemName.split("_")[0];
        String superior = "";
        int level = Integer.parseInt((String)model.getValue(LEVEL, cfIndex));
        if (level > 2) {
            return;
        }
        if (itemName.equals(CashFlowDesignatePlugin.getDefsuppname())) {
            fsupp = new QFilter("entries.suppcfitem", "=", (Object)0);
            superior = CashFlowDesignatePlugin.getDefsuppname();
        } else {
            fsupp = new QFilter("entries.suppcfitem.number", "=", (Object)acctNum);
            superior = acctNum;
        }
        String supAcctNum = null;
        int index = this.getSupAccountIndex(cfIndex);
        if (index != 0) {
            String name = ((String)this.getModel().getValue(ITEMNAME, index)).trim();
            supAcctNum = name.split("_")[0];
        }
        if (supAcctNum != null) {
            fsupp = fsupp.and(new QFilter("entries.account.number", "in", this.getSubAccNumber(supAcctNum)));
        }
        DataSet ds = this.getDataSetByNumber(supAcctNum);
        level = 1;
        for (Row d : ds) {
            level = d.getInteger("flevel") + 1;
        }
        this.getPageCache().put(ACC_SHOW_LEVEL, String.valueOf(level));
        String infoKey = (String)model.getValue(VOUCHERIDS, cfIndex);
        Set<Long> ids = this.getCacheVoucherIds(infoKey);
        QFilter fid = new QFilter("id", "in", ids);
        this.deploy(fid.and(fsupp), false, 1, cfIndex, superior);
    }

    private int getSuperCashFlowExcludeSelf(int curIndex, IDataModel model) {
        int level = Integer.parseInt((String)model.getValue(LEVEL, curIndex));
        boolean isSupContainCashFlow = false;
        for (int i = curIndex - 1; i > 0; --i) {
            int lv = Integer.parseInt((String)model.getValue(LEVEL, i));
            if (lv >= level) continue;
            String t = (String)model.getValue(TYPE, i);
            if (t.equals(TYPE_CF)) {
                curIndex = i;
                isSupContainCashFlow = true;
            }
            if (lv == 2) break;
        }
        return isSupContainCashFlow ? curIndex : -1;
    }

    private void firstLineDeploy(int curIndex) {
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter filters = filterContext.getqFilter();
        this.deploy(filters, true, 2, curIndex, "");
    }

    private void callDeploy(IDataModel model, int curIndex, boolean isByAccount) {
        String itemName = ((String)model.getValue(ITEMNAME, curIndex)).trim();
        String acctNum = itemName.split("_")[0];
        String infoKey = (String)model.getValue(VOUCHERIDS, curIndex);
        Set<Long> ids = this.getCacheVoucherIds(infoKey);
        QFilter fid = new QFilter("id", "in", ids);
        if (isByAccount) {
            Set<String> accNumbers = this.getSubAccNumber(acctNum);
            QFilter facctNum = new QFilter("entries.account.number", "in", accNumbers);
            this.deploy(fid.and(facctNum), false, 2, curIndex, "");
        } else {
            QFilter facctNum = new QFilter("entries.suppcfitem.number", "=", (Object)acctNum);
            this.deploy(fid.and(facctNum), false, 1, curIndex, "");
        }
    }

    private Set<String> getSubAccNumber(String acctNum) {
        HashSet<String> result = new HashSet<String>();
        DataSet dyn = this.getDataSetByNumber(acctNum);
        this.getLeafAccount(dyn, result, "fnumber");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelSuppOp(IDataModel model, int curIndex) {
        QFilter qfilter;
        String infoKey = (String)model.getValue(VOUCHERIDS, curIndex);
        Set<Long> voucherIds = this.getCacheVoucherIds(infoKey);
        if (curIndex == 0) {
            FilterContext filterContext = this.getFilterContextFromPageCache();
            qfilter = filterContext.getqFilter();
        } else {
            String type = (String)model.getValue(TYPE, curIndex);
            String item = null;
            String itemName = ((String)model.getValue(ITEMNAME, curIndex)).trim();
            String acctNum = itemName.split("_")[0];
            QFilter fid = new QFilter("id", "in", voucherIds);
            QFilter facctNum = null;
            if (type.equals(TYPE_ACC)) {
                item = "entries.account.number";
                Set<String> acctNums = this.getSubAccNumber(acctNum);
                facctNum = new QFilter(item, "in", acctNums);
                String sup = (String)model.getValue(SUPERIOR, curIndex);
                if (kd.bos.util.StringUtils.isNotEmpty((String)sup) && !CashFlowDesignatePlugin.getDefsuppname().equals(sup)) {
                    facctNum = facctNum.and(new QFilter("entries.suppcfitem.number", "=", (Object)sup));
                }
            } else if (type.equals(TYPE_CF)) {
                item = "entries.suppcfitem.number";
                facctNum = new QFilter(item, "in", (Object)acctNum);
                Set<String> subAccts = this.getAcctNum();
                if (!subAccts.isEmpty()) {
                    QFilter facct = new QFilter("entries.account.number", "in", subAccts);
                    facctNum = facctNum.and(facct);
                }
            }
            qfilter = fid.and(facctNum);
        }
        HashSet bookIds = new HashSet();
        HashSet vouIds = new HashSet(16);
        ArrayList paramList = new ArrayList(16);
        ArrayList vchParams = new ArrayList(16);
        ArrayList entryParams = new ArrayList(16);
        HashMap dataMap = new HashMap(16);
        this.checkParam(qfilter);
        boolean hasAuditVchs = false;
        boolean hasCancel = false;
        long orgId = this.getFilterValue("org.id");
        long bookTypeId = this.getFilterValue("booktype.id");
        String opertion = "cancelSuppOp";
        Set lockIds = MutexRequireHelper.batchRequire((String)"gl_voucher", voucherIds, (String)opertion);
        if (voucherIds.size() != lockIds.size()) {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u51ed\u8bc1\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainDesignateEdit_31", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)"id, period,billstatus, entries.id", (QFilter[])qfilter.toArray(), null, (int)-1);){
            ArrayList<Long> entryIds = new ArrayList<Long>();
            long voucherId = 0L;
            for (Row r : ds) {
                if (!GLUtil.isCurrentVoucherAllowModifyCF((long)orgId, (long)bookTypeId, (long)r.getLong("period"), (String)r.getString("billstatus"))) {
                    hasAuditVchs = true;
                    continue;
                }
                if (voucherId != 0L && r.getLong("id") != voucherId) {
                    entryIds = new ArrayList(10);
                    if (dataMap.size() > 200) {
                        CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, (String)TYPE_CF, bookIds, paramList, vchParams, entryParams, vouIds);
                        dataMap.clear();
                        hasCancel = true;
                    }
                }
                voucherId = r.getLong("id");
                dataMap.put(voucherId, entryIds);
                if (r.getLong("entries.id") == 0L) continue;
                entryIds.add(r.getLong("entries.id"));
            }
            if (dataMap.size() > 0) {
                CashFlowItemHelperNew.batchCalVoucherStatus(dataMap, (String)TYPE_CF, bookIds, paramList, vchParams, entryParams, vouIds);
                hasCancel = true;
            }
            CashFlowItemHelperNew.saveData(paramList, vchParams, entryParams, vouIds);
        }
        finally {
            MutexRequireHelper.batchRelease((String)"gl_voucher", (Set)lockIds, (String)opertion);
            if (!bookIds.isEmpty()) {
                CashFlowItemHelper.calBal(bookIds);
            }
        }
        if (hasAuditVchs) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002\u4e0d\u53ef\u4fee\u6539\u5df2\u5ba1\u6838\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u7684\u8865\u5145\u8d44\u6599\u3002", (String)"CashFlowDesignatePlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        return hasCancel;
    }

    private void deploy(QFilter filter, boolean firstLine, int type, int curIndex, String superior) {
        String level = (String)this.getModel().getValue(LEVEL, curIndex);
        String newL = String.valueOf(Integer.parseInt(level) + 1);
        if (type == 1) {
            this.map = this.getSubAcct(filter, newL, superior);
            this.map = this.setSuperAccount(this.map);
        } else if (type == 2) {
            this.map = this.getAppendixItem(filter, newL, superior);
        }
        if (this.map != null && this.map.size() > 0) {
            IDataModel model = this.getModel();
            model.getDataEntity(true);
            DynamicObjectCollection col = model.getEntryEntity(ENTRYKEY);
            Map<Long, Set<Long>> infoKey2VoucherIds = this.getCache();
            long[] infoKey = this.batchGenGlobalIds(this.map.size());
            int keyIndex = 0;
            if (firstLine) {
                int size = col.size();
                for (int i = size - 1; i > 0; --i) {
                    infoKey2VoucherIds.remove(Long.valueOf(((DynamicObject)col.get(i)).getString(VOUCHERIDS)));
                    col.remove(i);
                }
                for (CashFlowDesignate cashFlowDesignate : this.map.values()) {
                    DynamicObject dynamicObject = col.addNew();
                    String tabs = this.getTabs(cashFlowDesignate.getLevel());
                    dynamicObject.set(ITEMNAME, (Object)(tabs + cashFlowDesignate.getName()));
                    dynamicObject.set(AMOUNT, (Object)cashFlowDesignate.getAmt());
                    dynamicObject.set(TYPE, (Object)cashFlowDesignate.getType());
                    dynamicObject.set(LEVEL, (Object)cashFlowDesignate.getLevel());
                    infoKey2VoucherIds.put(infoKey[keyIndex], cashFlowDesignate.getVchIds());
                    dynamicObject.set(VOUCHERIDS, (Object)Long.toString(infoKey[keyIndex]));
                    dynamicObject.set(SUPERIOR, (Object)cashFlowDesignate.getSuperior());
                    ++keyIndex;
                }
            } else {
                List<Integer> rvmRows = this.getRvmRows(model, curIndex);
                rvmRows.sort(Comparator.reverseOrder());
                for (int n : rvmRows) {
                    infoKey2VoucherIds.remove(Long.valueOf(((DynamicObject)col.get(n)).getString(VOUCHERIDS)));
                    col.remove(n);
                }
                int index = curIndex;
                for (CashFlowDesignate cashFlowDesignate : this.map.values()) {
                    DynamicObject obj = new DynamicObject((DynamicObjectType)model.getDataEntityType().getAllEntities().get(ENTRYKEY));
                    col.add(++index, obj);
                    String tabs = this.getTabs(cashFlowDesignate.getLevel());
                    obj.set(ITEMNAME, (Object)(tabs + cashFlowDesignate.getName()));
                    obj.set(AMOUNT, (Object)cashFlowDesignate.getAmt());
                    obj.set(TYPE, (Object)cashFlowDesignate.getType());
                    obj.set(LEVEL, (Object)cashFlowDesignate.getLevel());
                    infoKey2VoucherIds.put(infoKey[keyIndex], cashFlowDesignate.getVchIds());
                    obj.set(VOUCHERIDS, (Object)Long.toString(infoKey[keyIndex]));
                    obj.set(SUPERIOR, (Object)cashFlowDesignate.getSuperior());
                    ++keyIndex;
                }
            }
            this.putCache(infoKey2VoucherIds);
            model.setValue(COUNT, (Object)this.map.size(), curIndex);
            this.getView().updateView(ENTRYKEY);
        }
    }

    private String getTabs(String level) {
        return "";
    }

    private Map<String, PresetCashFlowDesignate> getAppendixItem(QFilter filter, String newL, String superior) {
        LinkedHashMap<String, PresetCashFlowDesignate> map = new LinkedHashMap<String, PresetCashFlowDesignate>();
        String selField = "id,period, mainstatus, suppstatus, entries.id, entries.debitlocal, entries.creditlocal, entries.account.pltype, entries.account.longnumber,entries.account.number, entries.account.name, entries.account.iscash, entries.account.isbank, entries.account.iscashequivalent, entries.maincfitem.isdealactivity,entries.maincfitem.direction, entries.suppcfitem, entries.maincfamount, entries.suppcfamount,billstatus,entries.account,entries.entrydc,entries.assgrp,entries.account.accounttype.accounttype,entries.maincfitem, entries.suppcfitem.number, entries.suppcfitem.name";
        try (DataSet ds = VoucherQueryUtils.queryDataSet((String)selField, (QFilter[])filter.toArray(), (String)"entries.suppcfitem.number", (int)-1);){
            if (ds.hasNext()) {
                for (Row row : ds) {
                    BigDecimal amt = this.getAppendixAmt(row);
                    if (amt.signum() == 0) continue;
                    this.buildSuppRow(amt, row, map, newL, superior);
                }
            }
        }
        return map;
    }

    private BigDecimal getAppendixAmt(Row row) {
        if (this.isBudgetAcct(row)) {
            return BigDecimal.ZERO;
        }
        BigDecimal amt = new BigDecimal("0");
        String mainStatus = row.getString("mainstatus");
        String suppStatus = row.getString("suppstatus");
        if (!mainStatus.equals("0") && !mainStatus.equals(TYPE_ACC)) {
            if (!this.isCashAcct(row) && row.getLong("entries.maincfitem") != 0L) {
                boolean isPL = this.isPLAcct(row);
                boolean isDealactivity = this.isDealactivity(row);
                if (isPL && !isDealactivity) {
                    return row.getBigDecimal("entries.debitlocal").subtract(row.getBigDecimal("entries.creditlocal"));
                }
                if (!isPL && isDealactivity) {
                    amt = row.getBigDecimal("entries.maincfamount");
                    if ("o".equals(row.getString("entries.maincfitem.direction"))) {
                        amt = amt.negate();
                    }
                    return amt;
                }
            }
        } else if (suppStatus.equals(TYPE_ACC) || suppStatus.equals("3") || suppStatus.equals(TYPE_CF)) {
            if (suppStatus.equals("3")) {
                if (row.getLong("entries.suppcfitem") != 0L) {
                    return row.getBigDecimal("entries.suppcfamount");
                }
            } else if (!this.isPLAcct(row)) {
                return row.getBigDecimal("entries.creditlocal").subtract(row.getBigDecimal("entries.debitlocal"));
            }
        }
        return amt;
    }

    private BigDecimal getSumAmt(QFilter filter) {
        try (DataSet dataset = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])filter.toArray(), null, (int)-1);){
            if (dataset.hasNext()) {
                BigDecimal sumAmt = new BigDecimal("0");
                long time = System.currentTimeMillis();
                for (Row row : dataset) {
                    sumAmt = sumAmt.add(this.getAppendixAmt(row));
                }
                logger.info("for each cost : " + (System.currentTimeMillis() - time) + " ms");
                BigDecimal bigDecimal = sumAmt;
                return bigDecimal;
            }
            BigDecimal bigDecimal = null;
            return bigDecimal;
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String id;
        switch (id = evt.getActionId()) {
            case "suppcallback": {
                long itemId;
                boolean result;
                ListSelectedRowCollection col = (ListSelectedRowCollection)evt.getReturnData();
                if (col == null || col.size() <= 0 || !(result = this.designItemOp(itemId = Long.parseLong(col.get(0).getPrimaryKeyValue().toString())))) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u6210\u529f\u3002", (String)"CashFlowDesignatePlugin_20", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                break;
            }
        }
    }

    private String transfterStr(List<Long> entryIds) {
        StringBuilder s = new StringBuilder(16);
        for (long id : entryIds) {
            s.append(id).append(',');
        }
        if (s.length() > 1) {
            s.setLength(s.length() - 1);
        }
        return s.toString();
    }

    private void openSuppItemF7Page() {
        ListShowParameter bsp = ShowFormHelper.createShowListForm((String)"gl_cashflowitem", (boolean)false);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SUPPCALLBACK);
        bsp.setCloseCallBack(callBack);
        FilterContext filterContext = this.getFilterContextFromPageCache();
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)filterContext.getOrgId());
        QFilter filter = new QFilter(TYPE, "=", (Object)"3");
        QFilter filter2 = new QFilter("isleaf", "=", (Object)TYPE_ACC).and(new QFilter("isprefit", "=", (Object)Boolean.FALSE));
        QFilter enableFilter = new QFilter("enable", "=", (Object)TYPE_ACC);
        List qFilters = bsp.getListFilterParameter().getQFilters();
        qFilters.add(filter);
        qFilters.add(filter2);
        qFilters.add(enableFilter);
        qFilters.add(orgFilter);
        this.getView().showForm((FormShowParameter)bsp);
    }

    private boolean isDealactivity(Row row) {
        return row.getBoolean("entries.maincfitem.isdealactivity");
    }

    private boolean isPLAcct(Row row) {
        return !"0".equals(row.getString("entries.account.pltype"));
    }

    private boolean isCashAcct(Row row) {
        return row.getBoolean("entries.account.iscash") != false || row.getBoolean("entries.account.isbank") != false || row.getBoolean("entries.account.iscashequivalent") != false;
    }

    private boolean isBudgetAcct(Row row) {
        return AccountType.isBudgetProp((String)row.getString("entries.account.accounttype.accounttype"));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (fieldName.equals(ITEMNAME)) {
            int index = evt.getRowIndex();
            String type = (String)this.getModel().getValue(TYPE, index);
            if (TYPE_ACC.equals(type)) {
                String infoKey = (String)this.getModel().getValue(VOUCHERIDS, index);
                Set<Long> ids = this.getCacheVoucherIds(infoKey);
                QFilter fid = new QFilter("id", "in", ids);
                this.hyperVoucher(fid);
            } else if (TYPE_CF.equals(type)) {
                String itemName = (String)this.getModel().getValue(ITEMNAME, index);
                String num = itemName.split("_")[0];
                String infoKey = (String)this.getModel().getValue(VOUCHERIDS, index);
                Set<Long> ids = this.getCacheVoucherIds(infoKey);
                if (CashFlowDesignatePlugin.getDefsuppname().equals(itemName)) {
                    this.hyperCashFlowList("", ids, "supp");
                } else {
                    this.hyperCashFlowList(num, ids, "supp");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate eo = (FormOperate)args.getSource();
        String key = eo.getOperateKey();
        IDataModel model = this.getModel();
        int curIndex = this.getModel().getEntryCurrentRowIndex(ENTRYKEY);
        switch (key) {
            case "bysubacct": {
                QFilter fsupp;
                String supAcctNum;
                if (curIndex == 0) {
                    this.getPageCache().put(ACC_SHOW_LEVEL, TYPE_ACC);
                    FilterContext filterContext = this.getFilterContextFromPageCache();
                    QFilter filters = filterContext.getqFilter();
                    this.deploy(filters, true, 1, curIndex, "");
                    break;
                }
                String itemName = ((String)model.getValue(ITEMNAME, curIndex)).trim();
                String acctNum = itemName.split("_")[0];
                String itemType = ((String)model.getValue(TYPE, curIndex)).trim();
                String superior = "";
                if (TYPE_ACC.equals(itemType)) {
                    String sup = (String)model.getValue(SUPERIOR, curIndex);
                    supAcctNum = acctNum;
                    fsupp = new QFilter("entries.account.number", "in", this.getSubAccNumber(acctNum));
                    superior = (String)model.getValue(SUPERIOR, curIndex);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)sup)) {
                        fsupp = sup.equals(CashFlowDesignatePlugin.getDefsuppname()) ? fsupp.and(new QFilter("entries.suppcfitem", "=", (Object)0)) : fsupp.and(new QFilter("entries.suppcfitem.number", "=", (Object)sup));
                    }
                } else {
                    int level = Integer.parseInt((String)model.getValue(LEVEL, curIndex));
                    if (level > 2) break;
                    if (itemName.equals(CashFlowDesignatePlugin.getDefsuppname())) {
                        fsupp = new QFilter("entries.suppcfitem", "=", (Object)0);
                        superior = CashFlowDesignatePlugin.getDefsuppname();
                    } else {
                        fsupp = new QFilter("entries.suppcfitem.number", "=", (Object)acctNum);
                        superior = acctNum;
                    }
                    supAcctNum = this.getSupAccountNumber();
                    if (supAcctNum != null) {
                        fsupp = fsupp.and(new QFilter("entries.account.number", "in", this.getSubAccNumber(supAcctNum)));
                    }
                }
                DataSet ds = this.getDataSetByNumber(supAcctNum);
                int level = 1;
                for (Row d : ds) {
                    level = d.getInteger("flevel") + 1;
                }
                this.getPageCache().put(ACC_SHOW_LEVEL, String.valueOf(level));
                String infoKey = (String)model.getValue(VOUCHERIDS, curIndex);
                Set<Long> ids = this.getCacheVoucherIds(infoKey);
                QFilter fid = new QFilter("id", "in", ids);
                this.deploy(fid.and(fsupp), false, 1, curIndex, superior);
                break;
            }
            case "byappendixitem": {
                int cfIndex = this.getSuperCashFlowExcludeSelf(curIndex, model);
                if (cfIndex != -1) break;
                if (curIndex == 0) {
                    this.firstLineDeploy(curIndex);
                    break;
                }
                this.callDeploy(model, curIndex, true);
                break;
            }
            case "designitem": {
                FilterContext filterContext = this.getFilterContextFromPageCache();
                AccountBookInfo book = filterContext.getBook();
                if ("0".equals(book.getEnable())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"CashFlowDesignatePlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                String cacheId = (String)model.getValue(VOUCHERIDS, model.getEntryCurrentRowIndex(ENTRYKEY));
                Set<Long> voucherIdSet = this.getCacheVoucherIds(cacheId);
                String checkMsg = this.checkPeriod(book, voucherIdSet);
                if (checkMsg != null) {
                    this.getView().showTipNotification(checkMsg, Integer.valueOf(2000));
                    return;
                }
                if (this.checkModifyHisCf(voucherIdSet)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"CashFlowDesignatePlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.showConfirmTip("designate", ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u7528\u9009\u62e9\u7684\u8865\u5145\u8d44\u6599\u9879\u76ee\u66ff\u6362\u5df2\u9009\u884c\u7684\u8865\u5145\u8d44\u6599\u9879\u76ee\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CashFlowDesignatePlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u5df2\u5173\u95ed\uff0c\u5df2\u5ba1\u6838\u51ed\u8bc1\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u4e0d\u5141\u8bb8\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"CashFlowDesignatePlugin_23", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cancelappendixitem": {
                FilterContext filterContext = this.getFilterContextFromPageCache();
                AccountBookInfo book = filterContext.getBook();
                if ("0".equals(book.getEnable())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"CashFlowDesignatePlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                String cacheId2 = (String)model.getValue(VOUCHERIDS, model.getEntryCurrentRowIndex(ENTRYKEY));
                Set<Long> voucherIdSet2 = this.getCacheVoucherIds(cacheId2);
                if (this.checkModifyHisCf(voucherIdSet2)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"CashFlowDesignatePlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.getPageCache().put("curindex", curIndex + "");
                this.showConfirmTip("cancelcf", ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u53d6\u6d88\u5df2\u9009\u884c\u7684\u8865\u5145\u8d44\u6599\u9879\u76ee\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CashFlowDesignatePlugin_22", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u5df2\u5173\u95ed\uff0c\u5df2\u5ba1\u6838\u51ed\u8bc1\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u4e0d\u5141\u8bb8\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"CashFlowDesignatePlugin_23", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cancel": {
                if (curIndex == 0) {
                    int count = model.getEntryRowCount(ENTRYKEY);
                    for (int i = count - 1; i > 0; --i) {
                        model.deleteEntryRow(ENTRYKEY, i);
                    }
                    model.setValue(COUNT, (Object)0, 0);
                    break;
                }
                this.foldCurrentRow(model, curIndex);
                break;
            }
            case "exportexcel": {
                ArrayList<String> columnNames = new ArrayList<String>(2);
                columnNames.add(ITEMNAME);
                columnNames.add(AMOUNT);
                this.exportEntry(columnNames);
            }
        }
    }

    public OperationResult exportEntry(List<String> columnNames) {
        IDataModel model = this.getModel();
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYKEY);
        if (entryRowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"CashFlowDesignatePlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return null;
        }
        DynamicObjectCollection dynColl = model.getEntryEntity(ENTRYKEY);
        EntityType entryType = (EntityType)dynColl.getDynamicObjectType();
        List<KeyValue> captions = this.prepareCaptions(entryType, columnNames);
        ListExporter exporter = new ListExporter(ENTRYKEY, captions);
        int i = 1;
        ArrayList<Object> rowdata = new ArrayList<Object>();
        for (DynamicObject row : dynColl) {
            for (IDataEntityProperty prop : entryType.getFields().values()) {
                if (prop instanceof EntryProp || !columnNames.contains(prop.getName())) continue;
                Object val = row.get(prop);
                if (!StringUtils.isBlank((Object)val)) {
                    if (prop instanceof FlexProp) {
                        List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)row, (FlexProp)((FlexProp)prop), (String)((FlexProp)prop).getBasePropertyKey());
                        ArrayList<String> displayValues = new ArrayList<String>();
                        for (Map item : flexValues) {
                            String alias = (String)item.get("alias");
                            if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                            displayValues.add(alias);
                        }
                        val = String.join((CharSequence)"; ", displayValues);
                    } else if (prop instanceof DecimalProp) {
                        if (prop instanceof AmountProp) {
                            if (val.getClass().isArray() && ((Object[])val).length >= 2) {
                                val = ((Object[])val)[0];
                            }
                            DynamicObject currency = (DynamicObject)model.getValue(KEY_CURRENCY);
                            NumberPrecision number = new NumberPrecision(currency.getInt("amtprecision"), currency.getString("sign"), false, new BigDecimal(val.toString()));
                            val = number;
                        } else {
                            NumberPrecision number = new NumberPrecision(((DecimalProp)prop).getScale(), null, false, new BigDecimal(val.toString()));
                            val = number.toString();
                        }
                        if (!((DecimalProp)prop).isZeroShow() && BigDecimal.ZERO.compareTo(new BigDecimal(val.toString().replace(",", ""))) == 0) {
                            val = null;
                        }
                    }
                }
                rowdata.add(val);
            }
            exporter.writeLine(rowdata, i++);
            rowdata.clear();
        }
        LocalDate now = LocalDate.now();
        String url = exporter.flush(model.getDataEntityType(), ResManager.loadKDString((String)"\u5bfc\u51fa\u8865\u5145\u8d44\u6599\u6307\u5b9a\u5206\u5f55\u6570\u636e_%1$s%2$s", (String)"CashFlowDesignatePlugin_16", (String)"fi-gl-formplugin", (Object[])new Object[]{now.getMonthValue(), now.getDayOfMonth()}));
        this.getView().download(UrlService.getAttachmentFullUrl((String)url));
        return null;
    }

    private List<KeyValue> prepareCaptions(EntityType entryType, List<String> columnNames) {
        ArrayList<KeyValue> captions = new ArrayList<KeyValue>(columnNames.size());
        for (IDataEntityProperty prop : entryType.getFields().values()) {
            if (prop instanceof EntryProp || !columnNames.contains(prop.getName())) continue;
            if (prop instanceof AmountProp) {
                captions.add(new KeyValue(prop.getName(), (Object)prop.getDisplayName().toString(), new Object[]{1, 100, "right"}));
                continue;
            }
            captions.add(new KeyValue(prop.getName(), (Object)new KeyValue(prop.getDisplayName().toString(), new ArrayList())));
        }
        return captions;
    }
}

