/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodJobInfo;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodJobServiceHelper;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodJobType;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodSubJobInfo;
import kd.fi.gl.business.service.closeperiod.job.impl.mq.MQClosePeriodJobHelper;
import kd.fi.gl.constant.closeperiod.ClosePeriodInfo;
import kd.fi.gl.enums.ClosePeriodStateEnum;
import kd.fi.gl.formplugin.card.CardFactory;
import kd.fi.gl.formplugin.card.imp.ClosePeriodCard;
import kd.fi.gl.util.GLUtil;

public class ClosePeriodPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(ClosePeriodPlugin.class);
    private Map<String, Label> labelMap = new HashMap<String, Label>();
    private static final String awaitEntryEntity = "awaitentryentity";
    private static final String finishEntryEntity = "finishentryentity";
    private static final String failedEntryEntity = "failedentryentity";
    private static final String gl_closestate = "gl_closestate";
    private final ButtonAp button = new ButtonAp();

    public void initialize() {
        super.initialize();
        this.labelMap = this.getLabel();
    }

    private String getCloseEventId() {
        return this.getView().getPageId();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"lookparticular", "await", "failed", "lookparticular1"});
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("pauseaccounts".equals(key.trim())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"closeperiod"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pauseaccounts"});
        } else if ("closeperiod".equals(key.trim())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"closeperiod"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pauseaccounts"});
        }
    }

    private void changeButtonColor(String key, String btnTitle, String isUp) {
        String themeColorNum = this.getUserThemeColor(UserServiceHelper.getUserThemeNumAndVer((Long)RequestContext.getOrCreate().getCurrUserId()));
        if ("up".equals(isUp)) {
            this.button.setBackColor(themeColorNum);
            this.button.setForeColor("#ffffff");
        } else if ("down".equals(isUp)) {
            this.button.setBackColor("#ffffff");
            this.button.setForeColor(themeColorNum);
        }
        Style style = new Style();
        Border border = new Border();
        String borderStyle = "1px_solid_#FC8555";
        border.setBottom(borderStyle);
        border.setLeft(borderStyle);
        border.setRight(borderStyle);
        border.setTop(borderStyle);
        style.setBorder(border);
        LocaleString name = new LocaleString(btnTitle);
        this.button.setName(name);
        this.button.setStyle(style);
        this.button.setKey(key);
        this.getView().updateControlMetadata(this.button.getKey(), this.button.createControl());
    }

    private String getUserThemeColor(Map<String, Object> themeMap) {
        return String.valueOf(themeMap.get("color"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctr = (Control)evt.getSource();
        String key = ctr.getKey();
        if ("await".equals(key.trim())) {
            this.changeFlexAndButton("await", "failed", ResManager.loadKDString((String)"\u5f85\u7ed3\u8d26", (String)"ClosePeriodPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5931\u8d25", (String)"ClosePeriodPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            DynamicObjectCollection awaitEntity = this.getModel().getEntryEntity(awaitEntryEntity);
            if (awaitEntity.size() == 0) {
                this.getPageCache().put("faile", String.valueOf(false));
            }
        } else if ("failed".equals(key.trim())) {
            this.changeFlexAndButton("failed", "await", ResManager.loadKDString((String)"\u5931\u8d25", (String)"ClosePeriodPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f85\u7ed3\u8d26", (String)"ClosePeriodPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            DynamicObjectCollection failedEntry = this.getModel().getEntryEntity(failedEntryEntity);
            if (failedEntry.size() == 0) {
                this.getPageCache().put("await", String.valueOf(false));
            }
        } else if ("lookparticular".equals(key)) {
            this.jumpDetail(failedEntryEntity, "faield_id", ClosePeriodStateEnum.FAILED.getCode(), "failed_period", ctr.getKey());
        } else if ("lookparticular1".equals(key)) {
            this.jumpDetail(finishEntryEntity, "finish_id", ClosePeriodStateEnum.SUCCESS.getCode(), "finish_period", ctr.getKey());
        }
    }

    private void jumpDetail(String entryKey, String orgKey, String stateVal, String periodKey, String closeBackKey) {
        int n = this.getModel().getEntryCurrentRowIndex(entryKey);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
        if (entryEntity.size() != 0 && n != -1) {
            DynamicObjectCollection doc;
            AccountBookInfo accountBookInfo;
            ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("closeInfo"), ClosePeriodInfo.class);
            QFilter qf = new QFilter("company", "=", (Object)((DynamicObject)entryEntity.get(n)).getLong(orgKey));
            if ("gl_accountbook".equals(closeInfo.getFormId()) && (accountBookInfo = AccSysUtil.getBookFromAccSys((long)((DynamicObject)entryEntity.get(n)).getLong(orgKey), (long)Long.parseLong((String)closeInfo.getBooktype()))) != null) {
                qf.and(new QFilter("accountbooks", "=", (Object)String.valueOf(accountBookInfo.getId())));
            }
            QFilter state = new QFilter("closestate", "=", (Object)stateVal);
            QFilter formId = new QFilter("subsysformnum", "=", (Object)closeInfo.getFormId());
            long periodId = ((DynamicObject)entryEntity.get(n)).getDynamicObject(periodKey).getLong("id");
            QFilter period = new QFilter("period", "=", (Object)periodId);
            if ("finish_period".equals(periodKey)) {
                DynamicObject previousPeriod = GLUtil.getPreviousPeriod((Object)periodId);
                if (Objects.isNull(previousPeriod)) {
                    return;
                }
                period = new QFilter("period", "=", (Object)previousPeriod.getLong("id"));
            }
            if ((doc = QueryServiceHelper.query((String)gl_closestate, (String)"id", (QFilter[])new QFilter[]{qf, state, period, formId}, (String)"closedate asc")).size() != 0) {
                FormShowParameter showparam = new FormShowParameter();
                showparam.setFormId("gl_periodclosedetails");
                showparam.setCustomParam("accountId", (Object)((DynamicObject)doc.get(0)).getLong("id"));
                showparam.setCustomParam("closeKey", (Object)MQClosePeriodJobHelper.getSubJobItemResultsKey((String)this.getCloseEventId(), (String)qf.getValue().toString()));
                if ("finish_period".equals(periodKey)) {
                    showparam.setCustomParam("curperiod", (Object)periodId);
                }
                showparam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, closeBackKey);
                showparam.setCloseCallBack(ccb);
                this.getView().showForm(showparam);
            } else {
                String str = qf.and(state).and(period).and(formId).toString();
                logger.info("illegal filter on close state for [" + str + "]");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d\u7ed3\u8d26\u72b6\u6001\u4fe1\u606f\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ClosePeriodPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void changeFlex(String key) {
        if ("await".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"failedflex", "awaitfleximage"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"awaitflex"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"awaitflex", "awaitfleximage"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"failedflex"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)customParams.get("closeInfo").toString(), ClosePeriodInfo.class);
        this.setLabelValue(closeInfo.getOrgFieldName());
        this.getPageCache().put("closeInfo", SerializationUtils.toJsonString((Object)closeInfo));
        closeInfo.getOrgs().forEach(this::createAwaitDataEntity);
        this.changeFlex("await");
        this.setNum(this.getNumberMap());
        this.asyncCommit(closeInfo);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.initializeTrue();
    }

    private void initializeTrue() {
        this.getPageCache().put("faile", String.valueOf(true));
        this.getPageCache().put("await", String.valueOf(true));
    }

    private ClosePeriodJobType getJobType() {
        return ClosePeriodJobType.OLD_GL_FORM;
    }

    private void asyncCommit(ClosePeriodInfo closeInfo) {
        ClosePeriodJobServiceHelper.asyncCommit((ClosePeriodJobType)this.getJobType(), (String)this.getCloseEventId(), (String)closeInfo.getBizapp(), (Object[])new Object[]{closeInfo});
    }

    private void getParam() {
        IDataModel model = this.getModel();
        ClosePeriodJobInfo jobInfo = ClosePeriodJobServiceHelper.getJobInfo((ClosePeriodJobType)this.getJobType(), (String)this.getCloseEventId());
        List subJobInfos = jobInfo.getSubJobInfos();
        if (CollectionUtils.isEmpty((Collection)subJobInfos)) {
            return;
        }
        for (ClosePeriodSubJobInfo subJobInfo : subJobInfos) {
            int index;
            String selectField;
            boolean isSuccOrFail;
            String entryentity;
            Long orgId = Long.valueOf(subJobInfo.getSubJobId());
            String state = subJobInfo.getState();
            if (ClosePeriodStateEnum.UNFINISHED.getCode().equals(state) || !this.notCreateEntity(orgId, entryentity = (isSuccOrFail = ClosePeriodStateEnum.SUCCESS.getCode().equals(state)) ? finishEntryEntity : failedEntryEntity, selectField = isSuccOrFail ? "finish_id" : "faield_id").booleanValue() || (index = this.getIndex(orgId, awaitEntryEntity, "company_id")) < 0) continue;
            model.deleteEntryRow(awaitEntryEntity, index);
            this.createDataEntity(orgId, isSuccOrFail ? "1" : "-1", entryentity, subJobInfo);
            this.getView().updateView(entryentity);
            String image = isSuccOrFail ? "imageap" : "failed_image";
            this.setImage(isSuccOrFail, image);
            this.setNum(this.getNumberMap());
        }
    }

    private Map<String, String> getNumberMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        int noaccountnum = this.getModel().getEntryRowCount(awaitEntryEntity);
        int failNum = this.getModel().getEntryRowCount(failedEntryEntity);
        int successNum = this.getModel().getEntryRowCount(finishEntryEntity);
        int awaitNum = noaccountnum + failNum;
        map.put("awaitNum", String.valueOf(awaitNum));
        map.put("successNum", String.valueOf(successNum));
        map.put("noaccountnum", String.valueOf(noaccountnum));
        map.put("failNum", String.valueOf(failNum));
        return map;
    }

    private void setImage(boolean isSuccOrFail, String image) {
        Image mage = (Image)this.getControl(image);
        String str = isSuccOrFail ? "/icons/pc/state/success_28_28.png" : "/icons/pc/state/fail_28_28.png";
        mage.setUrl(str);
    }

    private int getIndex(Long org, String entity, String string) {
        int index = -1;
        DynamicObjectCollection awaitvalue = this.getModel().getEntryEntity(entity);
        for (int i = 0; i < awaitvalue.size(); ++i) {
            if (((DynamicObject)awaitvalue.get(i)).getLong(string) != org.longValue()) continue;
            index = i;
        }
        return index;
    }

    private void createAwaitDataEntity(Long org) {
        this.createDataEntity(org, "0", awaitEntryEntity, null);
    }

    private void createDataEntity(Long org, String cardType, String entryentity, ClosePeriodSubJobInfo subJobInfo) {
        DynamicObject book;
        Object periodId;
        ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("closeInfo"), ClosePeriodInfo.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        QFilter qf = new QFilter("org", "=", (Object)org);
        Object booktype = closeInfo.getBooktype();
        if (StringUtils.isNotBlank((Object)booktype)) {
            qf.and(new QFilter(closeInfo.getTypeFieldName(), "=", (Object)Long.valueOf(booktype.toString())));
        }
        Object object = periodId = subJobInfo == null ? null : (Object)subJobInfo.getCustomInfos().get("openedPeriodId");
        if (null == periodId || StringUtils.isBlank(periodId)) {
            DynamicObject collection = QueryServiceHelper.queryOne((String)closeInfo.getFormId(), (String)"curperiod", (QFilter[])qf.toArray());
            boolean havePeriod = collection == null || collection.getLong("curperiod") == 0L;
            periodId = havePeriod ? closeInfo.getAwaitPeriodId() : Long.valueOf(collection.getLong("curperiod"));
        }
        model.beginInit();
        if ("1".equals(cardType)) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            DynamicObject value = (DynamicObject)parentModel.getValue("periodedit");
            DynamicObject periodNum = QueryServiceHelper.queryOne((String)"bd_period", (String)"number", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(periodId.toString())).toArray());
            if (periodNum.getString("number").equals(value.getString("number"))) {
                String appid = this.getView().getFormShowParameter().getAppId();
                DynamicObject nextPeriod = !"gl".equals(appid) ? GLUtil.getNextPeriod((Object)value.getLong("id"), (boolean)false) : GLUtil.getNextPeriod((Object)value.getLong("id"));
                this.getPageCache().put("nextPeriod", nextPeriod != null ? nextPeriod.getString("id") : value.getString("id"));
            }
        }
        TableValueSetter vs = null == (book = QueryServiceHelper.queryOne((String)closeInfo.getFormId(), (String)"curperiod", (QFilter[])qf.toArray())) ? CardFactory.getInstance().createCardInfo(new ClosePeriodCard(org, periodId, cardType)) : CardFactory.getInstance().createCardInfo(new ClosePeriodCard(org, periodId, book.getLong("curperiod"), cardType));
        if ("1".equals(cardType) && subJobInfo != null) {
            List results = subJobInfo.getItemResults();
            if (CollectionUtils.isNotEmpty((Collection)results)) {
                long count = results.stream().filter(x -> "0".equals(x.getCheckState())).count();
                vs.addField("warninginfo", new Object[]{String.format(ResManager.loadKDString((String)"\u6709%s\u9879\u8b66\u544a\u9879", (String)"ClosePeriodPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), count)});
            } else {
                vs.addField("warninginfo", new Object[]{ResManager.loadKDString((String)"\u67090\u9879\u8b66\u544a\u9879", (String)"ClosePeriodPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0])});
            }
        }
        model.batchCreateNewEntryRow(entryentity, vs);
        model.endInit();
    }

    private Boolean notCreateEntity(Long l, String entryentity, String selectField) {
        DynamicObjectCollection finishvalue = this.getModel().getEntryEntity(entryentity);
        if (finishvalue.size() != 0) {
            for (DynamicObject dynamicObject : finishvalue) {
                if (dynamicObject.getLong(selectField) != l.longValue()) continue;
                return false;
            }
        }
        return true;
    }

    private void setNum(Map<String, String> map) {
        this.labelMap.get("awaitaccount").setText(String.valueOf(map.get("awaitNum")));
        this.labelMap.get("finishaccount").setText(String.valueOf(map.get("successNum")));
        this.labelMap.get("noaccount").setText(String.valueOf(map.get("noaccountnum")));
        this.labelMap.get("failaccount").setText(String.valueOf(map.get("failNum")));
        String str = "";
        if (!Lang.en_US.equals((Object)Lang.get())) {
            str = ResManager.loadKDString((String)"\u5bb6", (String)"ClosePeriodPlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        this.labelMap.get("awaitaccount1").setText(map.get("awaitNum") + str);
        this.labelMap.get("finishaccount2").setText(map.get("successNum") + str);
    }

    private Map<String, Label> getLabel() {
        HashMap<String, Label> map = new HashMap<String, Label>();
        map.put("awaitaccount", (Label)this.getControl("awaitaccountnum1"));
        map.put("awaitaccount1", (Label)this.getControl("awaitaccountnum2"));
        map.put("finishaccount", (Label)this.getControl("finishaccountnum"));
        map.put("finishaccount2", (Label)this.getControl("finishaccountnum1"));
        map.put("failaccount", (Label)this.getControl("failaccountnum"));
        map.put("noaccount", (Label)this.getControl("notaccountnum"));
        return map;
    }

    public void onProgress(ProgressEvent arg0) {
        int value = 60;
        this.getParam();
        this.isAllFinish();
        arg0.setProgress(value);
    }

    private void refreshClose(Long againId) {
        ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("closeInfo"), ClosePeriodInfo.class);
        IDataModel model = this.getModel();
        int isAgain = this.getIndex(againId, failedEntryEntity, "faield_id");
        if (isAgain != -1) {
            model.deleteEntryRow(failedEntryEntity, isAgain);
            this.createAwaitDataEntity(againId);
            this.setNum(this.getNumberMap());
            this.getView().updateView(failedEntryEntity);
            this.getView().updateView(awaitEntryEntity);
            closeInfo.setOrgs(Collections.singletonList(againId));
            this.changeLineStatue(againId);
            this.asyncCommit(closeInfo);
        }
    }

    private void changeLineStatue(Long org) {
        QFilter qf = new QFilter("company", "=", (Object)org);
        QFilter line = new QFilter("linestate", "=", (Object)"2");
        DynamicObjectCollection query = QueryServiceHelper.query((String)gl_closestate, (String)"id", (QFilter[])new QFilter[]{qf, line});
        if (!query.isEmpty()) {
            DynamicObject db = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)query.get(0)).getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)gl_closestate));
            db.set("linestate", (Object)"0");
            this.sqlOperate(db);
        }
    }

    private void isAllFinish() {
        DynamicObjectCollection awaitEntity = this.getModel().getEntryEntity(awaitEntryEntity);
        DynamicObjectCollection failedEntity = this.getModel().getEntryEntity(failedEntryEntity);
        boolean fail = Boolean.parseBoolean(this.getPageCache().get("faile"));
        boolean await = Boolean.parseBoolean(this.getPageCache().get("await"));
        if (awaitEntity.isEmpty() && failedEntity.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"awaitflex", "failedflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"awaitfleximage"});
        } else if (awaitEntity.isEmpty() && fail) {
            this.changeFlexAndButton("failed", "await", ResManager.loadKDString((String)"\u5931\u8d25", (String)"ClosePeriodPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f85\u7ed3\u8d26", (String)"ClosePeriodPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        } else if (!awaitEntity.isEmpty() && failedEntity.isEmpty() && await) {
            this.changeFlexAndButton("await", "failed", ResManager.loadKDString((String)"\u5f85\u7ed3\u8d26", (String)"ClosePeriodPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5931\u8d25", (String)"ClosePeriodPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private void changeFlexAndButton(String name, String otherName, String firststatus, String secondStatus) {
        this.changeButtonColor(name, firststatus, "up");
        this.changeButtonColor(otherName, secondStatus, "down");
        this.changeFlex(name);
    }

    private void sqlOperate(DynamicObject dynamicObject) {
        try (TXHandle h = TX.requiresNew((String)"fi_gl_closeperiod_save_sysstatus");){
            try {
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)gl_closestate), (Object[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.remove();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.stop();
        this.getView().returnDataToParent((Object)this.getPageCache().get("nextPeriod"));
    }

    private void remove() {
        ClosePeriodJobServiceHelper.clearJobInfo((ClosePeriodJobType)this.getJobType(), (String)this.getCloseEventId());
        this.getPageCache().batchRemove(Arrays.asList("faile", "await", "isnotfinish"));
    }

    private void setLabelValue(String value) {
        String formatString = ResManager.loadKDString((String)"\u5df2\u7ed3\u8d26\u7684%s", (String)"ClosePeriodPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String str = String.format(formatString, value);
        List<Label> labels = this.getAwaitLabels();
        for (Label label : labels) {
            label.setText(str);
        }
        formatString = ResManager.loadKDString((String)"\u5f85\u7ed3\u8d26\u7684%s", (String)"ClosePeriodPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        str = String.format(formatString, value);
        labels = this.getFinishLabels();
        for (Label label : labels) {
            label.setText(str);
        }
    }

    private List<Label> getAwaitLabels() {
        ArrayList<Label> labels = new ArrayList<Label>();
        labels.add((Label)this.getControl("finishname"));
        labels.add((Label)this.getControl("finishedname"));
        return labels;
    }

    private List<Label> getFinishLabels() {
        ArrayList<Label> labels = new ArrayList<Label>();
        labels.add((Label)this.getControl("awaitname"));
        labels.add((Label)this.getControl("awaitingname"));
        return labels;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object org = closedCallBackEvent.getReturnData();
        if (org != null) {
            this.refreshClose(Long.parseLong(String.valueOf(org)));
            this.initializeTrue();
        }
    }
}

