/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class CompanyCloseTimePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String COMPANY = "company";
    private static final String SAVE_BTN = "save_btn";

    public void initialize() {
        this.addClickListeners(new String[]{SAVE_BTN});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit be = (BasedataEdit)this.getControl(COMPANY);
        be.addBeforeF7SelectListener(arg -> {
            ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
            QFilter qf = new QFilter("isbizunit", "=", (Object)"1");
            qf.and(this.getPermOrgOfLoginUser("org"));
            DynamicObjectCollection ids = QueryServiceHelper.query((String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{qf});
            Object[] o = new Object[ids.size()];
            int i = 0;
            for (DynamicObject dyo : ids) {
                o[i++] = dyo.get("org");
            }
            param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)o));
        });
    }

    private QFilter getPermOrgOfLoginUser(String orgKey) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"gl_autocloseperiod", (String)"4730fc9f000001ae");
        return rs.hasAllOrgPerm() ? null : new QFilter(orgKey, "in", (Object)rs.getHasPermOrgs());
    }

    public void click(EventObject evt) {
        boolean result;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (SAVE_BTN.equals(key) && (result = this.validate())) {
            this.deleteData();
            this.saveData();
            this.getView().close();
        }
    }

    private boolean validate() {
        IDataModel model = this.getModel();
        int n = model.getEntryRowCount("bookclosetime");
        for (int i = 0; i < n; ++i) {
            DynamicObject entity = model.getEntryRowEntity("bookclosetime", i);
            int closeday = Integer.parseInt(entity.get("closetime").toString());
            if (closeday <= 31) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7ed3\u8d26\u65f6\u95f4\u201d\u4e0d\u80fd\u8d85\u8fc731\u3002", (String)"CompanyCloseTimePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection bookEntity = QueryServiceHelper.query((String)"gl_closebooktimedata", (String)"company,closeday", (QFilter[])new QFilter[]{this.getPermOrgOfLoginUser(COMPANY)});
        for (DynamicObject entry : bookEntity) {
            int rowKey = this.getModel().createNewEntryRow("bookclosetime");
            this.getModel().setValue(COMPANY, entry.get(COMPANY), rowKey);
            this.getModel().setValue("closetime", entry.get("closeday"), rowKey);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String keyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (COMPANY.equals(keyName)) {
            int n = model.getEntryRowCount("bookclosetime");
            int currentRow = changeData.getRowIndex();
            ArrayList<Long> companyIdList = new ArrayList<Long>();
            for (int i = 0; i < n; ++i) {
                DynamicObject entity;
                DynamicObject cp;
                if (i == currentRow || (cp = (DynamicObject)(entity = model.getEntryRowEntity("bookclosetime", i)).get(COMPANY)) == null) continue;
                companyIdList.add(cp.getLong("id"));
            }
            Object companyObj = changeData.getNewValue();
            if (companyObj != null && companyIdList.contains(((DynamicObject)companyObj).getLong("id"))) {
                model.setValue(COMPANY, null, currentRow);
            }
        }
    }

    private void saveData() {
        IDataModel model = this.getModel();
        int n = model.getEntryRowCount("bookclosetime");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (int i = 0; i < n; ++i) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"gl_closebooktimedata");
            DynamicObject dyt = new DynamicObject((DynamicObjectType)type);
            DynamicObject entity = model.getEntryRowEntity("bookclosetime", i);
            if (entity.get(COMPANY) == null || entity.get("closetime") == null) continue;
            dyt.set(COMPANY, entity.get(COMPANY));
            dyt.set("closeday", entity.get("closetime"));
            list.add(dyt);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
    }

    private void deleteData() {
        DeleteServiceHelper.delete((String)"gl_closebooktimedata", (QFilter[])new QFilter[]{this.getPermOrgOfLoginUser(COMPANY)});
    }
}

