/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.TaxReportFetchrule;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.ManageItemUtils;
import kd.fi.gl.util.ReportClearUtil;
import kd.fi.gl.util.TaxReportFormHelper;
import org.apache.commons.lang3.tuple.Pair;

public class IncomeEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String COLUMNKEY = "columnkey";
    private static final String PRETOTALROWCELL = "preTotalRowCell";
    private static final String RPTITEM = "rptitem";
    private static final String ISTOTALROW = "istotalrow";
    private static final String org = "org";
    private static final String orgView = "orgview";
    private static final String bookType = "booktype";
    private static final String accTable = "accounttable";
    private static final String save = "save";
    private static final String type = "type";
    private static final String label = "labelap";
    private static final String add = "add";
    private static final String delete = "delete";
    private static final String entryKey = "entryentity";
    private static final String index = "index";
    private static final String seq = "seq";
    private static final String balrowId = "balrowid";
    private static final String rowid = "rowid";
    private static final String dbRowid = "dbrowid";
    private static final String rowtag = "rowtag";
    private static final String project = "project";
    private static final String currentPeriod = "currentperiod";
    private static final String yearCount = "yearcount";
    private static final String expressionFormId = "gl_incomeexpression";
    private static final String commonColor = "#ffffff";
    private static final String focusColor = "#FEF3D1";
    private static final List<Pair<String, String>> lstPair = new ArrayList<Pair<String, String>>();
    private static final Set<Integer> set = new HashSet<Integer>();

    public void initialize() {
        super.initialize();
        TextEdit currentperiod = (TextEdit)this.getControl(currentPeriod);
        currentperiod.addButtonClickListener((ClickListener)this);
        TextEdit yearcount = (TextEdit)this.getControl(yearCount);
        yearcount.addButtonClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        this.addClickListeners(new String[]{save, add});
        if ("taxshow".equals(this.getView().getFormShowParameter().getCustomParam(type))) {
            HashMap<String, Boolean> operateIconMap = new HashMap<String, Boolean>(1);
            operateIconMap.put("hasOperateIcon", false);
            this.getView().updateControlMetadata(entryKey, operateIconMap);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit equityEdit = (BasedataEdit)this.getControl(project);
        equityEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String taxType = (String)formShowParameter.getCustomParam(type);
            Long orgId = (Long)this.getModel().getValue("org_id");
            TaxReportFormHelper.filterTaxProject((long)orgId, (ListShowParameter)param, (String)taxType);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        new ReportClearUtil(this.getModel().getDataEntityType().getName()).expressionCacheClear(e, (AbstractFormPlugin)this, rowid);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String rptType = (String)formShowParameter.getCustomParam(type);
        if (!"income".equals(rptType)) {
            return;
        }
        ChangeData data = e.getChangeSet()[0];
        Object oldVal = data.getOldValue();
        Object newVal = data.getNewValue();
        int rowIdx = this.getModel().getEntryCurrentRowIndex(entryKey);
        String rowId = (String)this.getModel().getValue(rowid, rowIdx);
        switch (e.getProperty().getName()) {
            case "project": {
                this.updatePeriodExpressionInfo(oldVal, newVal, rowIdx, rowId);
                break;
            }
        }
    }

    private void updatePeriodExpressionInfo(Object oldVal, Object newVal, int rowIdx, String rowId) {
        DynamicObject oldItem = (DynamicObject)oldVal;
        DynamicObject newItem = (DynamicObject)newVal;
        Boolean isChanged = Boolean.FALSE;
        if (newItem == null) {
            isChanged = Boolean.TRUE;
        } else {
            Boolean oldTotalRow = oldItem == null ? Boolean.FALSE.booleanValue() : oldItem.getBoolean(ISTOTALROW);
            Boolean newTotalRow = newItem.getBoolean(ISTOTALROW);
            if (oldTotalRow.booleanValue() && !newTotalRow.booleanValue() || !oldTotalRow.booleanValue() && newTotalRow.booleanValue()) {
                isChanged = Boolean.TRUE;
            }
        }
        if (isChanged.booleanValue()) {
            Long orgId = (Long)this.getModel().getValue("org_id");
            Long acctTableId = (Long)this.getModel().getValue("accounttable_id");
            Boolean isTotalRow = newItem == null ? Boolean.FALSE.booleanValue() : newItem.getBoolean(ISTOTALROW);
            this.getModel().setValue(currentPeriod, null, rowIdx);
            DynamicObject nullExpObj = this.newNullExpDyn(orgId, acctTableId, rowId, 1, isTotalRow);
            this.getPageCache().put(rowId + "&" + 1, GlFormUtil.toDynamicObjectJson(nullExpObj));
            this.removeTotalRowDetailItemId(rowId, currentPeriod);
            this.getModel().setValue(yearCount, null, rowIdx);
            nullExpObj = this.newNullExpDyn(orgId, acctTableId, rowId, 2, isTotalRow);
            this.getPageCache().put(rowId + "&" + 2, GlFormUtil.toDynamicObjectJson(nullExpObj));
            this.removeTotalRowDetailItemId(rowId, yearCount);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String typeValue = (String)formShowParameter.getCustomParam(type);
        if (StringUtils.isBlank((CharSequence)typeValue)) {
            typeValue = "income";
        }
        IDataModel model = this.getModel();
        model.setValue(type, (Object)typeValue);
        this.getPageCache().put(type, typeValue);
        Label labelCotrol = (Label)this.getView().getControl(label);
        String labelName = ResManager.loadKDString((String)"\u5229\u6da6\u8868", (String)"IncomeEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        if (typeValue.equals("taxshow")) {
            labelName = ResManager.loadKDString((String)"\u4f01\u4e1a\u7eb3\u7a0e\u8868", (String)"IncomeEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (typeValue.equals("cashflow")) {
            labelName = ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868", (String)"IncomeEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        labelCotrol.setText(labelName);
        Long orgId = 0L;
        if (formShowParameter.getCustomParam("orgId") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IncomeEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        orgId = Long.valueOf(formShowParameter.getCustomParam("orgId").toString());
        model.setValue(org, (Object)orgId);
        Long orgViewId = 0L;
        if (formShowParameter.getCustomParam("orgViewId") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IncomeEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        orgViewId = Long.valueOf(formShowParameter.getCustomParam("orgViewId").toString());
        model.setValue(orgView, (Object)orgViewId);
        Long bookTypeId = 0L;
        if (formShowParameter.getCustomParam("bookTypeId") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IncomeEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        bookTypeId = Long.valueOf(formShowParameter.getCustomParam("bookTypeId").toString());
        model.setValue(bookType, (Object)bookTypeId);
        Long accTableId = 0L;
        if (formShowParameter.getCustomParam("accTableId") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IncomeEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        accTableId = Long.valueOf(formShowParameter.getCustomParam("accTableId").toString());
        model.setValue(accTable, (Object)accTableId);
        String selectFields = "entryentity.project project, entryentity.balrowid balrowid, entryentity.seq seq, entryentity.project.istotalrow projecttype,entryentity.rowid dbrowid";
        QFilter forg = new QFilter(org, "=", (Object)orgId);
        QFilter faccTable = new QFilter(accTable, "=", (Object)accTableId);
        QFilter bookTypeFilter = new QFilter(bookType, "=", (Object)bookTypeId);
        QFilter ftype = new QFilter(type, "=", (Object)typeValue);
        QFilter[] filters = new QFilter[]{forg, faccTable, bookTypeFilter, ftype};
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])filters, (String)"entryentity.seq asc");
        DynamicObject[] expCollection = null;
        if (collection != null && collection.size() > 0) {
            forg = new QFilter(org, "=", (Object)orgId);
            filters = new QFilter[]{forg, faccTable, bookTypeFilter, ftype};
            String expSelectField = "org,booktype,accounttable,balrowid, columnkey,rowtag, entryentity.project, entryentity.sign, entryentity.fetchrule, entryentity.rptitem, istotalrow,type";
            expCollection = BusinessDataServiceHelper.load((String)expressionFormId, (String)expSelectField, (QFilter[])filters);
        }
        this.batchSetValue(collection, expCollection);
        if ("income".equals(typeValue)) {
            this.presetTotalExpression(orgId, bookTypeId, accTableId, collection);
        }
    }

    private void presetTotalExpression(Long orgId, Long bookTypeId, Long accTableId, DynamicObjectCollection collection) {
        if (collection == null || collection.isEmpty()) {
            Map totalRowExpMap = ManageItemUtils.getIncomePresetExpressions();
            DynamicObjectCollection entryCollection = this.getModel().getEntryEntity(entryKey);
            MainEntityType expressionType = EntityMetadataCache.getDataEntityType((String)expressionFormId);
            Map itemIdAndNameMap = BusinessDataServiceHelper.loadFromCache((String)"gl_manage_rptitem", (QFilter[])new QFilter[]{new QFilter("rptunit", "=", (Object)"gl_showincome")});
            int idx = 0;
            for (DynamicObject entry : entryCollection) {
                String rowId = entry.getString(rowid);
                Long projectId = entry.getLong("project_id");
                this.batchLoadExpObjsToCache(orgId, bookTypeId, accTableId, totalRowExpMap, itemIdAndNameMap, (DynamicObjectType)expressionType, projectId, rowId, 1, 2, idx);
                ++idx;
            }
        }
    }

    private void batchLoadExpObjsToCache(Long orgId, Long bookTypeId, Long accTableId, Map<Long, List<String>> totalRowExpMap, Map<Object, DynamicObject> itemIdAndNameMap, DynamicObjectType expressionType, Long assetId, String rowId, int startCol, int endCol, int idx) {
        List<String> expressions = totalRowExpMap.get(assetId);
        if (expressions != null && !expressions.isEmpty()) {
            for (int colKey = startCol; colKey <= endCol; ++colKey) {
                DynamicObject expObject = this.createExpObject(orgId, bookTypeId, accTableId, expressionType, rowId, colKey, expressions, itemIdAndNameMap, idx);
                this.getPageCache().put(rowId + "&" + colKey, GlFormUtil.toDynamicObjectJson(expObject));
            }
        }
    }

    private DynamicObject createExpObject(Long orgId, Long bookTypeId, Long accTableId, DynamicObjectType expressionType, String rowId, Integer colKey, List<String> expressions, Map<Object, DynamicObject> itemIdAndNameMap, int idx) {
        DynamicObject expObject = new DynamicObject(expressionType);
        expObject.set(org, (Object)orgId);
        expObject.set("booktype_id", (Object)bookTypeId);
        expObject.set("accounttable_id", (Object)accTableId);
        expObject.set(type, (Object)"income");
        expObject.set(rowtag, (Object)rowId);
        expObject.set(COLUMNKEY, (Object)colKey);
        expObject.set(ISTOTALROW, (Object)Boolean.TRUE);
        DynamicObjectCollection entries = expObject.getDynamicObjectCollection(entryKey);
        String cellExpression = "";
        HashSet<Long> itemIds = new HashSet<Long>(expressions.size());
        for (String expression : expressions) {
            DynamicObject expEntryObject = new DynamicObject(entries.getDynamicObjectType());
            String[] split = expression.split(",");
            if (split.length != 2) continue;
            Long itemId = Long.valueOf(split[0]);
            itemIds.add(itemId);
            String sign = split[1];
            expEntryObject.set("rptitem_id", (Object)itemId);
            expEntryObject.set("sign", (Object)sign);
            entries.add((Object)expEntryObject);
            DynamicObject item = itemIdAndNameMap.get(itemId);
            if (item == null) continue;
            cellExpression = TaxReportFormHelper.parseExpTotalRow((String)cellExpression, (String)item.getString("name"), (String)sign);
        }
        String itemFieldName = "";
        if (colKey.equals(1)) {
            itemFieldName = currentPeriod;
        } else if (colKey.equals(2)) {
            itemFieldName = yearCount;
        }
        if (!StringUtils.isEmpty((CharSequence)itemFieldName)) {
            this.getModel().setValue(itemFieldName, (Object)cellExpression, idx);
        }
        this.cacheTotalRowDetailItemIds(rowId, itemFieldName, itemIds);
        return expObject;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity currow = e.getRowDataEntities()[0];
        IDataModel model = this.getModel();
        int curIndex = currow.getRowIndex();
        model.setValue(rowid, (Object)this.getRowId(), curIndex);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int rowIndex = e.getRowIndexs()[0];
        String rowId = (String)this.getModel().getValue(rowid, rowIndex);
        this.getPageCache().remove(this.getCellKey(rowId, "1"));
        this.getPageCache().remove(this.getCellKey(rowId, "2"));
    }

    private String getRowId() {
        return UUID.randomUUID().toString();
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taxType = (String)formShowParameter.getCustomParam(type);
        if ("income".equals(taxType)) {
            int rowIdx = evt.getRow();
            this.setCellBGColor(rowIdx);
        }
    }

    private void setCellBGColor(int rowIdx) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        String key = entryGrid.getEntryState().getFocusField();
        int colIdx = 0;
        if (currentPeriod.equals(key)) {
            colIdx = 1;
        } else if (yearCount.equals(key)) {
            colIdx = 2;
        }
        DynamicObject item = (DynamicObject)this.getModel().getValue(project, rowIdx);
        String rowId = (String)this.getModel().getValue(rowid, rowIdx);
        Boolean isTotalRow = item == null ? Boolean.FALSE.booleanValue() : item.getBoolean(ISTOTALROW);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        this.setPreTotalRowCellColor(cellStyles);
        if (isTotalRow.booleanValue()) {
            this.setTotalRowCellColor(rowId, key, colIdx, cellStyles);
        }
        if (!cellStyles.isEmpty()) {
            entryGrid.setCellStyle(cellStyles);
        }
    }

    private void setTotalRowCellColor(String rowId, String key, int colIdx, List<CellStyle> cellStyles) {
        String cell = this.getCellKey(rowId, key);
        Set<Long> itemIds = this.getTotalRowItems(rowId, colIdx, cell);
        this.addCellStyle(key, itemIds, cellStyles, focusColor);
        this.getPageCache().put(PRETOTALROWCELL, cell);
    }

    private void addCellStyle(String key, Set<Long> preItemIds, List<CellStyle> cellStyles, String commonColor) {
        int rowCount = this.getModel().getEntryRowCount(entryKey);
        for (int i = 0; i < rowCount; ++i) {
            Long itemId = (Long)this.getModel().getValue("project_id", i);
            if (!preItemIds.contains(itemId)) continue;
            this.addRowCellStyle(i, key, commonColor, cellStyles);
        }
    }

    private Set<Long> getTotalRowItems(String rowId, int colIdx, String cell) {
        Set<Long> itemIds = this.loadDetailItemIdsFromCache(cell);
        if (itemIds == null || itemIds.isEmpty()) {
            itemIds = this.queryTotalRowItems(rowId, colIdx);
            this.cacheTotalRowDetailItemIds(cell, itemIds);
        }
        return itemIds;
    }

    private void setPreTotalRowCellColor(List<CellStyle> cellStyles) {
        String preCell = this.getPageCache().get(PRETOTALROWCELL);
        String preItemString = this.getPageCache().get(preCell);
        if (!StringUtils.isEmpty((CharSequence)preCell) && !StringUtils.isEmpty((CharSequence)preItemString)) {
            Set preItemIds = (Set)SerializationUtils.deSerializeFromBase64((String)preItemString);
            String[] split = preCell.split("&");
            if (preItemIds != null && split.length == 2) {
                String preKey = split[1];
                this.addCellStyle(preKey, preItemIds, cellStyles, commonColor);
            }
        }
        this.getPageCache().remove(PRETOTALROWCELL);
    }

    private Set<Long> queryTotalRowItems(String rowId, int colIdx) {
        QFilter forg = new QFilter(org, "=", this.getModel().getValue("org_id"));
        QFilter fbookType = new QFilter(bookType, "=", this.getModel().getValue("booktype_id"));
        QFilter facctTable = new QFilter(accTable, "=", this.getModel().getValue("accounttable_id"));
        QFilter fbalRowId = new QFilter(rowtag, "=", (Object)rowId);
        QFilter fcolumnKey = new QFilter("columnKey", "=", (Object)(colIdx + ""));
        QFilter[] filters = new QFilter[]{forg, fbookType, facctTable, fbalRowId, fcolumnKey};
        String selectFields = "entryentity.rptitem rptitem";
        HashSet<Long> rptItems = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryTotalRowItems"), (String)expressionFormId, (String)selectFields, (QFilter[])filters, null);){
            for (Row row : dSet) {
                rptItems.add(row.getLong(RPTITEM));
            }
        }
        return rptItems;
    }

    private CellStyle addRowCellStyle(int row, String colKey, String color, List<CellStyle> cellStyles) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setBackColor(color);
        cellStyle.setRow(row);
        cellStyle.setFieldKey(colKey);
        cellStyles.add(cellStyle);
        return cellStyle;
    }

    private void batchSetValue(DynamicObjectCollection collection, DynamicObject[] expCollection) {
        int i;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(seq, new Object[0]);
        vs.addField(project, new Object[0]);
        vs.addField(balrowId, new Object[0]);
        vs.addField(rowid, new Object[0]);
        if (collection != null && collection.size() > 0) {
            for (i = 0; i < collection.size(); ++i) {
                DynamicObject rowDyn = (DynamicObject)collection.get(i);
                vs.addRow(new Object[]{rowDyn.get(seq), rowDyn.get(project), rowDyn.get(balrowId), rowDyn.get(dbRowid)});
                String expCurrencyPeriod = "";
                String expYearCount = "";
                if (expCollection == null || expCollection.length <= 0) continue;
                for (DynamicObject expDyn : expCollection) {
                    if (!String.valueOf(rowDyn.get(dbRowid)).equals(expDyn.get(rowtag))) continue;
                    Boolean isTotalRow = expDyn.getBoolean(ISTOTALROW);
                    String itemFieldName = isTotalRow != false ? RPTITEM : project;
                    DynamicObjectCollection expDynColl = expDyn.getDynamicObjectCollection(entryKey);
                    for (DynamicObject expRowDyn : expDynColl) {
                        String name = expRowDyn.get(itemFieldName + ".name") == null ? "" : expRowDyn.get(itemFieldName + ".name").toString();
                        String number = expRowDyn.get(itemFieldName + ".number") == null ? "" : expRowDyn.get(itemFieldName + ".number").toString();
                        String sign = expRowDyn.get("sign") == null ? "" : expRowDyn.get("sign").toString();
                        String fetchVal = (String)expRowDyn.get("fetchrule");
                        String fetchName = TaxReportFetchrule.getName((String)fetchVal);
                        if ("1".equals(expDyn.get(COLUMNKEY))) {
                            expCurrencyPeriod = this.setRowExpression(expCurrencyPeriod, isTotalRow, name, number, sign, fetchName);
                        } else if ("2".equals(expDyn.get(COLUMNKEY))) {
                            expYearCount = this.setRowExpression(expYearCount, isTotalRow, name, number, sign, fetchName);
                        }
                        this.getPageCache().put(rowDyn.get(dbRowid) + "&" + expDyn.get(COLUMNKEY), GlFormUtil.toDynamicObjectJson(expDyn));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)expCurrencyPeriod)) {
                    expCurrencyPeriod = expCurrencyPeriod.substring(0, expCurrencyPeriod.length() - 1);
                }
                if (StringUtils.isNotBlank((CharSequence)expYearCount)) {
                    expYearCount = expYearCount.substring(0, expYearCount.length() - 1);
                }
                vs.addField(currentPeriod, new Object[]{expCurrencyPeriod});
                vs.addField(yearCount, new Object[]{expYearCount});
            }
        } else {
            String type = this.getPageCache().get(type);
            List projects = "income".equals(type) ? TaxReportFormHelper.getProjects((String)"income") : (List)this.getView().getFormShowParameter().getCustomParam("projects");
            for (int i2 = 0; i2 < projects.size(); ++i2) {
                vs.addRow(new Object[]{i2 + 1, projects.get(i2), i2, this.getRowId()});
            }
        }
        for (i = 0; i < vs.getCount(); ++i) {
            vs.addField(index, new Object[]{i + 1});
        }
        model.batchCreateNewEntryRow(entryKey, vs);
        model.endInit();
        this.getView().updateView(entryKey);
    }

    private String setRowExpression(String expression, Boolean isTotalRow, String name, String number, String sign, String fetchName) {
        expression = isTotalRow != false ? TaxReportFormHelper.parseExpTotalRow((String)expression, (String)name, (String)sign) : TaxReportFormHelper.parseExpRow((String)expression, (String)number, (String)name, (String)fetchName, (String)sign);
        return expression;
    }

    public String getNameByVal(DynamicObject dyn, String fieldKey) {
        String fetchrule = dyn.get(fieldKey).toString();
        ComboProp fetchCombo = (ComboProp)dyn.getDataEntityType().getProperties().get((Object)fieldKey);
        String fetchName = fetchCombo.getItemByName(fetchrule);
        return fetchName;
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (save.equals(key)) {
            this.saveIncome();
        } else if (add.equals(key)) {
            int i = this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue(balrowId, (Object)i, i);
            this.freshIndex();
        } else if (delete.equals(key)) {
            this.freshIndex();
        } else if ("refresh".equals(key)) {
            ReportClearUtil.clearAllExpressionCache(this.getPageCache());
        }
    }

    private void saveIncome() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String formId = view.getFormShowParameter().getFormId();
        QFilter forg = new QFilter(org, "=", this.getModel().getValue("org_id"));
        QFilter faccTable = new QFilter(accTable, "=", (Object)((Long)model.getValue("accounttable_id")));
        QFilter bookTypeFilter = new QFilter(bookType, "=", this.getModel().getValue(GLField.id_((String)bookType)));
        QFilter ftype = new QFilter(type, "=", model.getValue(type));
        QFilter[] filters = new QFilter[]{forg, faccTable, bookTypeFilter, ftype};
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)formId, (QFilter[])filters);
                Object[] results = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                if (results.length > 0) {
                    if (this.saveExpre()) {
                        view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"IncomeEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        view.close();
                    } else {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"IncomeEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"IncomeEdit_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private boolean saveExpre() {
        int count = this.getModel().getEntryRowCount(entryKey);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)expressionFormId);
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>();
        IDataModel model = this.getModel();
        for (int i = 0; i < count; ++i) {
            String rowId = (String)model.getValue(rowid, i);
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(rowId + "&1"))) {
                DynamicObject periodDyn = GlFormUtil.fromDynamicString(this.getPageCache().get(rowId + "&1"), entityType);
                periodDyn.getDataEntityState().setBizChanged(true);
                periodDyn.set(balrowId, (Object)(i + 1));
                dataEntities.add(periodDyn);
            }
            if (!StringUtils.isNotBlank((CharSequence)this.getPageCache().get(rowId + "&2"))) continue;
            DynamicObject yearDyn = GlFormUtil.fromDynamicString(this.getPageCache().get(rowId + "&2"), entityType);
            yearDyn.set(balrowId, (Object)(i + 1));
            dataEntities.add(yearDyn);
        }
        ArrayList<DynamicObject> listDyn = new ArrayList<DynamicObject>();
        if (dataEntities != null && dataEntities.size() > 0) {
            DynamicObject dynamicObjects;
            for (DynamicObject dynamicObject : dynamicObjects = dataEntities.toArray(new DynamicObject[0])) {
                DynamicObject newExpDyn = this.newExpDyn(dynamicObject);
                if (newExpDyn != null) {
                    listDyn.add(newExpDyn);
                }
                QFilter forgId = new QFilter(org, "=", dynamicObject.get(org));
                QFilter facountTable = new QFilter(accTable, "=", dynamicObject.get("accounttable_id"));
                QFilter fbookType = new QFilter(bookType, "=", (Object)dynamicObject.getLong(GLField.id_((String)bookType)));
                QFilter forwtag = new QFilter(rowtag, "=", dynamicObject.get(rowtag));
                QFilter fcolumnKey = new QFilter(COLUMNKEY, "=", dynamicObject.get(COLUMNKEY));
                QFilter type = new QFilter(type, "=", dynamicObject.get(type));
                QFilter[] filters = new QFilter[]{forgId, facountTable, fbookType, forwtag, fcolumnKey, type};
                DeleteServiceHelper.delete((String)expressionFormId, (QFilter[])filters);
            }
            if (listDyn.isEmpty()) {
                return true;
            }
            Object[] objects = SaveServiceHelper.save((IDataEntityType)entityType, (Object[])listDyn.toArray(new DynamicObject[0]));
            if (objects.length == 0) {
                return false;
            }
        }
        return true;
    }

    private DynamicObject newNullExpDyn(Long orgId, Long acctTableId, String rowId, int columnKey, Boolean isTotalRow) {
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)expressionFormId);
        newExpDyn.set(org, (Object)orgId);
        newExpDyn.set(rowtag, (Object)rowId);
        newExpDyn.set(COLUMNKEY, (Object)columnKey);
        newExpDyn.set("accounttable_id", (Object)acctTableId);
        newExpDyn.set(type, (Object)"income");
        newExpDyn.set(ISTOTALROW, (Object)isTotalRow);
        return newExpDyn;
    }

    private DynamicObject newExpDyn(DynamicObject expDyn) {
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)expressionFormId);
        newExpDyn.set(org, (Object)expDyn.getLong(org));
        newExpDyn.set(balrowId, (Object)expDyn.getString(balrowId));
        newExpDyn.set(rowtag, (Object)expDyn.getString(rowtag));
        newExpDyn.set(COLUMNKEY, (Object)expDyn.getString(COLUMNKEY));
        newExpDyn.set(accTable, (Object)expDyn.getLong("accounttable_id"));
        newExpDyn.set(bookType, (Object)expDyn.getLong(GLField.id_((String)bookType)));
        newExpDyn.set(ISTOTALROW, expDyn.get(ISTOTALROW));
        newExpDyn.set(type, (Object)expDyn.getString(type));
        DynamicObjectCollection newColl = newExpDyn.getDynamicObjectCollection(entryKey);
        DynamicObjectCollection coll = expDyn.getDynamicObjectCollection(entryKey);
        newColl.clear();
        if (coll.isEmpty()) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            DynamicObject newRow = new DynamicObject(coll.getDynamicObjectType());
            newRow.set(project, row.get("project_id"));
            newRow.set("sign", row.get("sign"));
            newRow.set("fetchrule", row.get("fetchrule"));
            newRow.set(RPTITEM, row.get("rptitem_id"));
            newColl.add((Object)newRow);
        }
        return newExpDyn;
    }

    private void freshIndex() {
        int count = this.getModel().getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue(index, (Object)(i + 1), i);
        }
    }

    public void click(EventObject evt) {
        AbstractGrid entryGrid;
        int entrySelRow;
        String type = this.getPageCache().get(type);
        if ("cashflow".equals(type) && set.contains((entrySelRow = (entryGrid = (AbstractGrid)this.getView().getControl(entryKey)).getEntryState().getFocusRow()) + 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u8ba1\u884c\u4e0d\u5141\u8bb8\u7f16\u8f91\u516c\u5f0f\u3002", (String)"IncomeEdit_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if (currentPeriod.equals(key) || yearCount.equals(key)) {
            this.showExpressionEdit(key);
        }
    }

    private void showExpressionEdit(String style) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        AbstractGrid entryGrid = (AbstractGrid)this.getView().getControl(entryKey);
        int entrySelRow = entryGrid.getEntryState().getFocusRow();
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", expressionFormId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> value = new HashMap<String, Object>();
        if (currentPeriod.equals(style)) {
            value.put("periodType", "1");
        } else if (yearCount.equals(style)) {
            value.put("periodType", "2");
        }
        IDataModel model = this.getModel();
        String balrowIdValue = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection(entryKey).get(entrySelRow)).getString(seq);
        String rowId = (String)model.getValue(rowid, entrySelRow);
        value.put(balrowId, balrowIdValue);
        value.put(rowtag, rowId);
        value.put("orgId", model.getValue("org_id"));
        value.put("accTableId", model.getValue("accounttable_id"));
        value.put(bookType, model.getValue(GLField.id_((String)bookType)));
        String typeValue = (String)formShowParameter.getCustomParam(type);
        value.put(type, typeValue);
        Boolean isTotalRow = Boolean.FALSE;
        DynamicObject rptItem = (DynamicObject)this.getModel().getValue(project, entrySelRow);
        if ("income".equals(typeValue) && rptItem != null) {
            isTotalRow = rptItem.getBoolean(ISTOTALROW);
            value.put(project, rptItem.get("id"));
        }
        value.put(ISTOTALROW, isTotalRow);
        value.put("value", this.getPageCache().get(rowId + "&" + value.get("periodType")));
        showParameter.setCustomParams(value);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, style + "&" + entrySelRow));
        String labelName = ResManager.loadKDString((String)"\u5229\u6da6\u8868\u516c\u5f0f\u7f16\u8f91\u5668", (String)"IncomeEdit_12", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        if (typeValue.equals("taxshow")) {
            labelName = ResManager.loadKDString((String)"\u4f01\u4e1a\u7eb3\u7a0e\u8868\u516c\u5f0f\u7f16\u8f91\u5668", (String)"IncomeEdit_11", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (typeValue.equals("cashflow")) {
            labelName = ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868\u516c\u5f0f\u7f16\u8f91\u5668", (String)"IncomeEdit_10", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        showParameter.setCaption(labelName);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map resultMap;
        String value;
        if (evt.getReturnData() != null && (value = (String)(resultMap = (Map)evt.getReturnData()).get("value")) != null) {
            IDataModel model = this.getModel();
            String[] strs = evt.getActionId().split("&");
            Integer rowIdx = Integer.valueOf(strs[1]);
            String colName = strs[0];
            this.analysisExp(rowIdx, colName, value, null);
            String columnKey = null;
            if (currentPeriod.equals(colName) || yearCount.equals(colName)) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)expressionFormId);
                DynamicObject dynamicObject = GlFormUtil.fromDynamicString(value, entityType);
                DynamicObjectCollection entryCollection = (DynamicObjectCollection)dynamicObject.get(entryKey);
                if (entryCollection.size() < 1) {
                    return;
                }
                if (currentPeriod.equals(colName)) {
                    dynamicObject.set(COLUMNKEY, (Object)"2");
                    colName = yearCount;
                    columnKey = "2";
                    entryCollection.forEach(dyObj -> dyObj.set("fetchrule", (Object)lstPair.stream().filter(v -> ((String)v.getLeft()).equals(dyObj.get("fetchrule"))).map(Pair::getRight).findFirst().orElse("")));
                }
                value = GlFormUtil.toDynamicObjectJson(dynamicObject);
                this.analysisExp(rowIdx, colName, value, columnKey);
            }
        }
    }

    private void analysisExp(int rowIdx, String colName, String strObj, String columnKey) {
        String expression = "";
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)expressionFormId);
        DynamicObject dynamicObject = GlFormUtil.fromDynamicString(strObj, entityType);
        DynamicObjectCollection entryCollection = (DynamicObjectCollection)dynamicObject.get(entryKey);
        Boolean isTotalRow = dynamicObject.getBoolean(ISTOTALROW);
        HashSet<Long> itemIds = new HashSet<Long>();
        for (int i = 0; i < entryCollection.size(); ++i) {
            String sign = (String)((DynamicObject)entryCollection.get(i)).get("sign");
            String itemFieldName = isTotalRow != false ? RPTITEM : project;
            DynamicObject item = (DynamicObject)((DynamicObject)entryCollection.get(i)).get(itemFieldName);
            if (item == null) continue;
            itemIds.add(item.getLong("id"));
            String number = item.getString("number");
            String name = item.getString("name");
            String fetchName = "";
            if (!isTotalRow.booleanValue()) {
                String fetchVal = (String)((DynamicObject)entryCollection.get(i)).get("fetchrule");
                fetchName = TaxReportFetchrule.getName((String)fetchVal);
            }
            expression = this.setRowExpression(expression, isTotalRow, name, number, sign, fetchName);
        }
        IDataModel model = this.getModel();
        model.setValue(colName, (Object)expression, rowIdx);
        String rowId = (String)model.getValue(rowid, rowIdx);
        if (isTotalRow.booleanValue()) {
            this.cacheTotalRowDetailItemIds(rowId, colName, itemIds);
            this.setCellBGColor(rowIdx);
        }
        columnKey = columnKey == null ? dynamicObject.getString(COLUMNKEY) : columnKey;
        this.getPageCache().remove(rowId + "&" + columnKey);
        this.getPageCache().put(rowId + "&" + columnKey, strObj);
    }

    private void cacheTotalRowDetailItemIds(String cell, Set<Long> itemIds) {
        this.getPageCache().put(cell, SerializationUtils.serializeToBase64(itemIds));
    }

    private void cacheTotalRowDetailItemIds(String rowId, String colField, Set<Long> itemIds) {
        String cell = this.getCellKey(rowId, colField);
        this.getPageCache().put(cell, SerializationUtils.serializeToBase64(itemIds));
    }

    private void removeTotalRowDetailItemId(String rowId, String colField) {
        String cell = this.getCellKey(rowId, colField);
        this.getPageCache().remove(cell);
    }

    private Set<Long> loadDetailItemIdsFromCache(String cell) {
        String cacheString = this.getPageCache().get(cell);
        if (StringUtils.isEmpty((CharSequence)cacheString)) {
            return null;
        }
        return (Set)SerializationUtils.deSerializeFromBase64((String)cacheString);
    }

    private String getCellKey(String rowId, String key) {
        return rowId + "&" + key;
    }

    static {
        lstPair.add((Pair<String, String>)Pair.of((Object)"1", (Object)"2"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"2", (Object)"1"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"X", (Object)"2"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"3", (Object)"5"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"5", (Object)"3"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"4", (Object)"6"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"6", (Object)"4"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"7", (Object)"9"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"9", (Object)"7"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"8", (Object)"0"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"0", (Object)"8"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"A", (Object)"5"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"B", (Object)"5"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"C", (Object)"5"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"D", (Object)"5"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"Y", (Object)"5"));
        lstPair.add((Pair<String, String>)Pair.of((Object)"Z", (Object)"5"));
        set.add(1);
        set.add(5);
        set.add(10);
        set.add(11);
        set.add(12);
        set.add(18);
        set.add(23);
        set.add(24);
        set.add(25);
        set.add(29);
        set.add(33);
        set.add(34);
        set.add(36);
        set.add(38);
        set.add(39);
        set.add(40);
        set.add(58);
        set.add(62);
    }
}

