/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.util.AnalysisRptUtils;
import kd.fi.gl.util.FormExportUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.TaxReportFormHelper;

public class IncomeShowPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(IncomeShowPlugin.class);
    private static final String refresh = "refresh";
    private static final String reportEdit = "reportedit";
    private static final String period = "period";
    private static final String orgView = "orgview";
    private static final String bookType = "booktype";
    private static final String accTable = "accounttable";
    private static final String periodType = "periodtype";
    private static final String entryKey = "entryentity";
    private static final String index = "index";
    private static final String project = "project";
    private static final String balrowId = "balrowid";
    private static final String currentPeriod = "currentperiod";
    private static final String yearCount = "yearcount";
    public static final String IS_FINISH = "isFinish";
    public static final String IS_SUCCESS = "isSuccess";
    public static final String QUERY_DATA = "queryData";
    public static final String PROGRESSBARAP = "progressbarap";
    private static int processTime = 1;
    DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid control = (EntryGrid)this.getControl(entryKey);
        control.addHyperClickListener(evt -> this.showAccountBalanceRpt(evt));
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    private void showAccountBalanceRpt(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex() + 1;
        int colIndex = 0;
        switch (evt.getFieldName()) {
            case "currentperiod": {
                colIndex = 1;
                break;
            }
            case "yearcount": {
                colIndex = 2;
                break;
            }
        }
        DynamicObject item = (DynamicObject)this.getModel().getValue(project, evt.getRowIndex());
        AnalysisRptUtils.showAccountBalanceRpt((AbstractFormPlugin)this, (DynamicObject)item, (int)rowIndex, (int)colIndex, (String)"income");
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (reportEdit.equals(key)) {
            this.showIncomeEdit();
        } else if (refresh.equals(key)) {
            String childOrgSetStr = this.getPageCache().get("childOrgSet");
            if (childOrgSetStr == null) {
                return;
            }
            Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
            this.setValue(childOrgSet);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (op.getOperateKey().equals("export")) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            FormExportUtil export = new FormExportUtil();
            List headInfo = AnalysisRptUtils.buildReportHeadInfo((AbstractFormPlugin)this);
            ArrayList<String> fieldList = new ArrayList<String>();
            fieldList.add(index);
            fieldList.add(project);
            fieldList.add(currentPeriod);
            fieldList.add(yearCount);
            String url = export.export((List<String>)headInfo, model.getEntryEntity(entryKey), fieldList, view, (DynamicObject)model.getValue("basecurrency"), op.getPermissionItemId());
            export.openUrl(url, view);
        }
    }

    private void showIncomeEdit() {
        Long orgId;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        List<Long> orgIds = this.getOrgValue();
        long orgViewId = (Long)model.getValue("orgview_id");
        long bookTypeId = (Long)model.getValue("booktype_id");
        long accTableId = (Long)model.getValue("accounttable_id");
        String infoTip = "";
        if (orgIds.isEmpty()) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"IncomeShowPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (orgIds.size() > 1) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u6838\u7b97\u7ec4\u7ec7\u8fdb\u884c\u7f16\u8f91\u3002", (String)"IncomeShowPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (orgViewId == 0L) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"IncomeShowPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (bookTypeId == 0L) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"IncomeShowPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (accTableId == 0L) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"IncomeShowPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else {
            List listId = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.NEW);
            if (!listId.contains(orgId = orgIds.get(0))) {
                infoTip = ResManager.loadKDString((String)"\u65e0\u201c\u5229\u6da6\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IncomeShowPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
        }
        if (!infoTip.isEmpty()) {
            view.showTipNotification(infoTip);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gl_incomeedit");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        orgId = orgIds.get(0);
        showParameter.setCustomParam("orgId", (Object)orgId);
        showParameter.setCustomParam("orgViewId", (Object)orgViewId);
        showParameter.setCustomParam("bookTypeId", (Object)bookTypeId);
        showParameter.setCustomParam("accTableId", (Object)accTableId);
        showParameter.setCustomParam("type", (Object)"income");
        String isLeafOrg = this.getPageCache().get("isLeafOrg");
        showParameter.setCustomParam("isLeafOrg", (Object)isLeafOrg);
        FormShowParameter parent = view.getFormShowParameter();
        showParameter.setParentPageId(parent.getParentPageId());
        view.showForm(showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        String childOrgSetStr = this.getPageCache().get("childOrgSet");
        if (childOrgSetStr == null) {
            return;
        }
        Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
        this.setValue(childOrgSet);
    }

    private void setValue(Set<Long> childOrgSet) {
        List<Long> orgIds = this.getOrgValue();
        if (orgIds.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(entryKey);
        long orgViewId = (Long)this.getModel().getValue("orgview_id");
        long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        long accTableId = (Long)this.getModel().getValue("accounttable_id");
        long periodTypeId = (Long)this.getModel().getValue("periodtype_id");
        long periodId = (Long)this.getModel().getValue("period_id");
        int amtprecision = 2;
        DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (basecurrency != null) {
            basecurrency.getInt("amtprecision");
        }
        if (orgIds.size() > 1) {
            Set<Long> mulSelectedEntityOrg = this.getEntityOrg(orgIds);
            if (mulSelectedEntityOrg.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u9009\u7ec4\u7ec7\u5fc5\u987b\u5305\u542b\u4e00\u4e2a\u5b9e\u4f53\u7ec4\u7ec7\u3002", (String)"IncomeShowPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            long parentOrg = GLRptTemplatePlugin.getParentOrgByChildre(orgIds);
            DynamicObjectCollection parentBalSheet = TaxReportFormHelper.getIncomeEdits(Collections.singleton(parentOrg), (long)accTableId, (String)"income", (QFilter[])new QFilter(bookType, "=", (Object)bookTypeId).toArray());
            if (parentBalSheet == null || parentBalSheet.isEmpty()) {
                DynamicObject pOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)parentOrg, (String)"bos_org");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u5171\u540c\u4e0a\u7ea7%s\u672a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u62a5\u8868\u7f16\u8f91\u516c\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"IncomeShowPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]), pOrg != null ? pOrg.getString("name") : ""));
                return;
            }
        }
        ((ProgressBar)this.getControl(PROGRESSBARAP)).start();
        ThreadService.execute(() -> {
            try {
                List rowAmountList = TaxReportFormHelper.collectBal((List)orgIds, (Set)childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"income", (int)2, (int)amtprecision);
                this.distributeCache.put(this.getPageCacheKey(QUERY_DATA), SerializationUtils.toJsonString((Object)rowAmountList));
                this.distributeCache.put(this.getPageCacheKey(IS_SUCCESS), "true");
            }
            catch (Exception e) {
                this.distributeCache.put(this.getPageCacheKey(IS_SUCCESS), "false");
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.distributeCache.put(this.getPageCacheKey(IS_FINISH), "true");
            }
        }, (TaskType)TaskType.GL_INCOME_COLLECT_BAL);
        processTime = 1;
        this.showLoading();
    }

    private Set<Long> getEntityOrg(List<Long> filterOrg) {
        HashSet<Long> result = new HashSet<Long>(8);
        QFilter orgFiler = new QFilter("org", "in", filterOrg);
        QFilter entityFilter = new QFilter("isbizunit", "=", (Object)true);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{orgFiler, entityFilter}, null);){
            for (Row row : dataSet) {
                result.add(row.getLong("org"));
            }
        }
        return result;
    }

    private void batchSetValue(long orgId, long accTableId, long bookTypeId, String type, List<List<BigDecimal>> resultList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(index, new Object[0]);
        vs.addField(project, new Object[0]);
        vs.addField(balrowId, new Object[0]);
        HashSet<Long> orgSet = new HashSet<Long>();
        orgSet.add(orgId);
        DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdit(orgSet, (long)accTableId, (String)type, (QFilter[])new QFilter(bookType, "=", (Object)bookTypeId).toArray());
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                vs.addRow(new Object[]{i + 1, dynamicObject.get(project), dynamicObject.get(balrowId)});
            }
        } else {
            List projects = TaxReportFormHelper.getProjects((String)type);
            for (int i = 0; i < projects.size(); ++i) {
                vs.addRow(new Object[]{i + 1, projects.get(i), i + 1});
            }
        }
        for (List<BigDecimal> row : resultList) {
            vs.addField(currentPeriod, new Object[]{row.get(0)});
            vs.addField(yearCount, new Object[]{row.get(1)});
        }
        model.batchCreateNewEntryRow(entryKey, vs);
        model.endInit();
    }

    private void setTotalAmount(List<List<BigDecimal>> rowAmountList) {
        IDataModel model = this.getModel();
        Map totalIndexToRowAmountMap = TaxReportFormHelper.getIncomeIndexAmount(rowAmountList);
        for (Map.Entry entry : totalIndexToRowAmountMap.entrySet()) {
            int position = (Integer)entry.getKey();
            List amountList = (List)entry.getValue();
            this.putValue(model, amountList, position);
        }
    }

    private void putValue(IDataModel model, List<BigDecimal> data, int position) {
        model.setValue(currentPeriod, (Object)data.get(0), position - 1);
        model.setValue(yearCount, (Object)data.get(1), position - 1);
    }

    private void setProgressBar(Set<Long> childOrgSet, List<Long> orgIds, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision) {
        HashMap map = new HashMap();
        FormShowParameter para = TaxReportFormHelper.FinMainIndexFormShow((String)"income", childOrgSet, orgIds, (Long)orgViewId, (Long)bookTypeId, (Long)accTableId, (Long)periodTypeId, (Long)periodId, map, (int)amtprecision);
        this.getView().showForm(para);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        Object newObj = args.getChangeSet()[0].getNewValue();
        if (newObj == null) {
            return;
        }
        switch (propertyName) {
            case "orgs": 
            case "orgview": 
            case "booktype": 
            case "accounttable": 
            case "periodtype": 
            case "period": {
                String childOrgSetStr = this.getPageCache().get("childOrgSet");
                if (childOrgSetStr == null) {
                    return;
                }
                Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
                this.setValue(childOrgSet);
            }
        }
    }

    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    public void onProgress(ProgressEvent progressEvent) {
        boolean isFinish = Boolean.parseBoolean(this.distributeCache.get(this.getPageCacheKey(IS_FINISH)));
        boolean isSuccess = Boolean.parseBoolean(this.distributeCache.get(this.getPageCacheKey(IS_SUCCESS)));
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        if (isFinish) {
            bar.stop();
            if (isSuccess) {
                String queryData = this.distributeCache.get(this.getPageCacheKey(QUERY_DATA));
                List rowAmountList = (List)SerializationUtils.fromJsonString((String)queryData, List.class);
                this.distributeCache.remove(this.getPageCacheKey(IS_FINISH));
                this.distributeCache.remove(this.getPageCacheKey(IS_SUCCESS));
                this.distributeCache.remove(this.getPageCacheKey(QUERY_DATA));
                List<Long> orgIds = this.getOrgValue();
                IDataModel model = this.getModel();
                String childOrgSetStr = this.getPageCache().get("childOrgSet");
                Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
                long orgViewId = (Long)model.getValue("orgview_id");
                long bookTypeId = (Long)model.getValue("booktype_id");
                long accTableId = (Long)model.getValue("accounttable_id");
                long periodTypeId = (Long)model.getValue("periodtype_id");
                long periodId = (Long)model.getValue("period_id");
                int amtprecision = 2;
                Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
                this.batchSetValue(orgId, accTableId, bookTypeId, "income", rowAmountList);
                this.getView().updateView(entryKey);
                String formId = this.getView().getFormShowParameter().getFormId();
                if (!"gl_showincome".equals(formId)) {
                    this.setTotalAmount(rowAmountList);
                }
                this.setProgressBar(childOrgSet, orgIds, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision);
            }
            this.getView().hideLoading();
        } else {
            this.showLoading();
        }
    }

    private void showLoading() {
        int percent = processTime * 3 > 99 ? 99 : processTime * 3;
        this.getView().showLoading(new LocaleString(String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u4e2d\uff0c\u8fdb\u5ea6\uff1a%1$s%%\u3002", (String)"IncomeShowPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), percent)));
        ++processTime;
    }

    private String getPageCacheKey(String key) {
        String pageId = this.getView().getPageId();
        return pageId + key;
    }
}

