/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.STConverter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.util.FinancialKpiGetValueHelp;

public class ManageRptitemEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map map = fsp.getCustomParams();
        if (map != null && !map.isEmpty()) {
            this.getModel().setValue("datasource", map.get("datasource"));
            this.getModel().setValue("useorg", map.get("org"));
            if (map.containsKey("addnew")) {
                this.dealRptUnitCom();
            }
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("datasource", (Object)2);
        this.dealRptUnitCom();
    }

    public void afterBindData(EventObject e) {
        OrmLocaleValue name;
        String rptunit;
        Long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"rptunit"});
        }
        if ("gl_taxshow".equals(rptunit = (String)this.getModel().getValue("rptunit")) || "gl_cashflowstat".equals(rptunit)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"istotalrow"});
        }
        Long useOrgId = (Long)this.getModel().getValue("useorg_id");
        Long createOrgId = (Long)this.getModel().getValue("createorg_id");
        long masterid = Long.parseLong(this.getModel().getValue("masterid").toString());
        if (!id.equals(masterid) || !useOrgId.equals(createOrgId)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"istotalrow"});
        }
        if ((name = (OrmLocaleValue)this.getModel().getValue("name")) != null) {
            this.getPageCache().put("oldname", name.getLocaleValue());
        }
    }

    private void dealRptUnitCom() {
        ComboEdit rptunit = (ComboEdit)this.getControl("rptunit");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem balancesheet = new ComboItem();
        balancesheet.setValue("gl_balancesheet");
        balancesheet.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d1f\u503a\u8868", (String)"ManageRptitemEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        items.add(balancesheet);
        ComboItem showincome = new ComboItem();
        showincome.setValue("gl_showincome");
        showincome.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5229\u6da6\u8868", (String)"ManageRptitemEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0])));
        items.add(showincome);
        rptunit.setComboItems(items);
    }

    private boolean checkExistsExpression() {
        Long id = (Long)this.getModel().getDataEntity().getPkValue();
        Boolean isTotalRow = (Boolean)this.getModel().getValue("istotalrow");
        String type = (String)this.getModel().getValue("rptunit");
        if (StringUtils.isEmpty((CharSequence)type) || id == null || id <= 0L) {
            return true;
        }
        if ("gl_balancesheet".equals(type)) {
            QFilter filter = null;
            try (DataSet editSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "checkExistsExpression"), (String)"gl_balancesheetedit", (String)"org, org.name orgname, accounttable, assetentryentity.assetrowid balrowid ,assetentryentity.asset entry,1 as type ", (QFilter[])new QFilter[]{new QFilter("assetentryentity.asset", "=", (Object)id)}, null);
                 DataSet editSet1 = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "checkExistsExpression"), (String)"gl_balancesheetedit", (String)"org, org.name orgname, accounttable, equityentryentity.equityrowid balrowid ,equityentryentity.equity entry ,2 as type", (QFilter[])new QFilter[]{new QFilter("equityentryentity.equity", "=", (Object)id)}, null);){
                DataSet dataSet = editSet.union(editSet1);
                for (Row row : dataSet) {
                    QFilter tmpFilter = new QFilter("org", "=", row.get("org")).and(new QFilter("accounttable", "=", row.get("accounttable"))).and(new QFilter("rowtag", "=", (Object)row.getString("balrowid")));
                    String entryType = row.getString("type");
                    if ("1".equals(entryType) && row.getLong("entry").equals(id)) {
                        tmpFilter = tmpFilter.and(new QFilter("columnkey", "in", (Object)new String[]{"1", "2"}));
                        filter = filter == null ? tmpFilter : filter.or(tmpFilter);
                        continue;
                    }
                    if (!"2".equals(entryType) || !row.getLong("entry").equals(id)) continue;
                    tmpFilter = tmpFilter.and(new QFilter("columnkey", "in", (Object)new String[]{"3", "4"}));
                    filter = filter == null ? tmpFilter : filter.or(tmpFilter);
                }
            }
            if (filter == null) {
                return true;
            }
            var6_8 = null;
            try (DataSet expSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "checkExistsExpression"), (String)"gl_balancesheetexpression", (String)"org, accounttable, balrowid, istotalrow, entryentity.rptitem rptitem, entryentity.project project", (QFilter[])new QFilter[]{filter}, null);){
                while (expSet.hasNext()) {
                    Row row = expSet.next();
                    Long itemId = row.getLong("rptitem");
                    Long projectId = row.getLong("project");
                    if (itemId.equals(0L) && projectId.equals(0L)) continue;
                    Boolean existTotalRow = row.getBoolean("istotalrow");
                    if (existTotalRow.equals(isTotalRow)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5f15\u7528\u7f16\u8f91\u516c\u5f0f\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5408\u8ba1\u884c\u5c5e\u6027\u3002", (String)"ManageRptitemEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Throwable row) {
                var6_8 = row;
                throw row;
            }
        }
        if ("gl_showincome".equals(type)) {
            QFilter filter = null;
            try (DataSet editSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "checkExistsExpression"), (String)"gl_incomeedit", (String)"org, org.name orgname, accounttable, entryentity.rowid rowtag", (QFilter[])new QFilter[]{new QFilter("entryentity.project", "=", (Object)id)}, null);){
                for (Row row : editSet) {
                    QFilter tmpFilter = new QFilter("org", "=", row.get("org")).and(new QFilter("accounttable", "=", row.get("accounttable"))).and(new QFilter("rowtag", "=", (Object)row.getString("rowtag")));
                    filter = filter == null ? tmpFilter : filter.or(tmpFilter);
                }
            }
            if (filter == null) {
                return true;
            }
            var6_9 = null;
            try (DataSet expSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "checkExistsExpression"), (String)"gl_incomeexpression", (String)"org, accounttable, balrowid, istotalrow,  entryentity.rptitem rptitem, entryentity.project project", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"income"), filter}, null);){
                while (expSet.hasNext()) {
                    Iterator row = expSet.next();
                    Long itemId = row.getLong("rptitem");
                    Long projectId = row.getLong("project");
                    if (itemId.equals(0L) && projectId.equals(0L)) continue;
                    Boolean existTotalRow = row.getBoolean("istotalrow");
                    if (existTotalRow.equals(isTotalRow)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5f15\u7528\u7f16\u8f91\u516c\u5f0f\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5408\u8ba1\u884c\u5c5e\u6027\u3002", (String)"ManageRptitemEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                var6_9 = throwable;
                throw throwable;
            }
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate formOp = (FormOperate)args.getSource();
            IDataModel model = this.getModel();
            String operateKey = formOp.getOperateKey();
            model.setValue("status", (Object)"C");
            if ("save".equals(operateKey)) {
                String number = (String)model.getValue("number");
                String name = model.getValue("name").toString();
                Long useorg = (Long)model.getValue("useorg_id");
                String datasource = (String)model.getValue("datasource");
                if (number == null || StringUtils.isEmpty((CharSequence)number)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"ManageRptitemEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (number.trim().length() != 6 || !FinancialKpiGetValueHelp.isDigit(number).booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u987b\u4e3a6\u4f4d\u6570\u5b57\u3002", (String)"ManageRptitemEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                model.setValue("number", (Object)number.trim());
                if (name == null || StringUtils.isEmpty((CharSequence)name)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"ManageRptitemEdit_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (useorg == 0L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ManageRptitemEdit_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (datasource == null || StringUtils.isEmpty((CharSequence)datasource)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6765\u6e90\u3002", (String)"ManageRptitemEdit_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!this.checkExistsExpression()) {
                    args.setCancel(true);
                    return;
                }
                if (this.isUnique()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ManageRptitemEdit_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else if ("close".equals(operateKey)) {
                this.getModel().setDataChanged(false);
            }
        }
    }

    private boolean isUnique() {
        String number = (String)this.getModel().getValue("number");
        Long createorg = (Long)this.getModel().getValue("createorg_id");
        Long id = (Long)this.getModel().getValue("id");
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_manage_rptitem", (Long)createorg);
        return QueryServiceHelper.exists((String)"gl_manage_rptitem", (QFilter[])new QFilter[]{filter, new QFilter("number", "=", (Object)number)}) && id == 0L;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String name = afterDoOperationEventArgs.getOperateKey();
        if (name.equals("save")) {
            String newName = this.getModel().getValue("name") + "";
            String oldName = this.getPageCache().get("oldname");
            String number = this.getModel().getValue("number") + "";
            this.updateAnalskpi(newName, oldName, number);
        }
    }

    private void updateAnalskpi(String newName, String oldName, String number) {
        if (StringUtils.isEmpty((CharSequence)oldName) || StringUtils.isEmpty((CharSequence)newName)) {
            return;
        }
        if (!newName.equals(oldName)) {
            DynamicObject[] dyns;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            Long orgId = Long.parseLong(this.getModel().getValue("useorg_id") + "");
            qFilters.add(new QFilter("desp", "ftlike", (Object)number));
            qFilters.add(new QFilter("createorg", "=", (Object)orgId));
            for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)"gl_business_analskpi", (String)"id,desp,expression,muliexpression", (QFilter[])qFilters.toArray(new QFilter[0]))) {
                String desp = dyn.getString("desp");
                String expression = FinancialKpiGetValueHelp.translateDesc(desp, orgId);
                dyn.set("expression", (Object)expression);
                LocaleString localeString = new LocaleString(expression);
                localeString.setLocaleValue_zh_TW(STConverter.sc2tc((String)expression));
                dyn.set("muliexpression", (Object)localeString);
            }
            SaveServiceHelper.save((DynamicObject[])dyns);
        }
    }
}

