/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLUtil;

public class MyAttentionAccountEdit
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            FormShowParameter param = this.getView().getFormShowParameter();
            Map cps = param.getCustomParams();
            JSONObject jo = (JSONObject)cps.get("param");
            AccountBookInfo bookInfo = (AccountBookInfo)GLUtil.fromSerializedString((String)jo.getString("accountbookinfo"));
            QFilter atF = new QFilter("accounttable", "=", (Object)bookInfo.getAccountTableId());
            QFilter qorg = AccountUtils.getAccountDataFilter((long)bookInfo.getOrgId(), (long)bookInfo.getAccountTableId());
            QFilter endDate = new QFilter("enddate", "=", (Object)GLUtil.getEndDate());
            ListShowParameter paramd = (ListShowParameter)evt.getFormShowParameter();
            List filters = paramd.getListFilterParameter().getQFilters();
            filters.add(qorg);
            filters.add(atF);
            filters.add(endDate);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String userid = RequestContext.get().getUserId();
        DynamicObject[] taskObjs = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(userid))});
        if (taskObjs != null && taskObjs.length > 0) {
            model.setValue("creator", (Object)taskObjs[0].getLong("id"));
        }
        JSONObject param = (JSONObject)this.getView().getFormShowParameter().getCustomParam("param");
        String orgid = (String)param.get((Object)"org");
        boolean isedit = (Boolean)param.get((Object)"isedit");
        DynamicObject[] orgObjs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(orgid))});
        if (orgObjs != null && orgObjs.length > 0) {
            model.setValue("org", (Object)orgObjs[0].getLong("id"));
        }
        model.setValue("createtime", (Object)new Date());
        if (isedit) {
            String editDataStr = (String)param.get((Object)"editData");
            HashMap editData = (HashMap)SerializationUtils.fromJsonString((String)editDataStr, Map.class);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"account"});
            DynamicObjectCollection coll = new DynamicObjectCollection();
            for (Map.Entry editSinleData : editData.entrySet()) {
                String accountType = (String)editSinleData.getKey();
                ArrayList accountValue = (ArrayList)editSinleData.getValue();
                DynamicObject db1 = this.getAttentionData(Long.valueOf(userid), Long.valueOf(orgid), accountType);
                DynamicObject db = BusinessDataServiceHelper.loadSingle((Object)db1.getLong("id"), (String)"gl_myattention");
                DynamicObjectCollection accountCol = db.getDynamicObjectCollection("account");
                for (DynamicObject accountSingleCol : accountCol) {
                    long basedataId = accountSingleCol.getLong("fbasedataid_id");
                    if (!accountValue.contains(String.valueOf(basedataId))) continue;
                    coll.add((Object)accountSingleCol);
                }
            }
            model.setValue("account", (Object)coll);
            if (editData.size() == 1) {
                model.setValue("type", editData.keySet());
            } else {
                model.setValue("type", (Object)"");
            }
        }
    }

    public void click(EventObject e) {
        String key;
        Control ctl = (Control)e.getSource();
        switch (key = ctl.getKey()) {
            case "save": {
                this.saveAttention();
                break;
            }
        }
    }

    private void saveAttention() {
        if (this.validate()) {
            DynamicObject dynObject = this.getView().getModel().getDataEntity(true);
            JSONObject param = (JSONObject)this.getView().getFormShowParameter().getCustomParam("param");
            String orgid = (String)param.get((Object)"org");
            boolean isedit = (Boolean)param.get((Object)"isedit");
            long userid = ContextUtil.getUserId();
            DynamicObjectCollection coll = new DynamicObjectCollection();
            if (isedit) {
                String editDataStr = (String)param.get((Object)"editData");
                HashMap editData = (HashMap)SerializationUtils.fromJsonString((String)editDataStr, Map.class);
                for (Map.Entry editSinleData : editData.entrySet()) {
                    String accountType = (String)editSinleData.getKey();
                    ArrayList accountValue = (ArrayList)editSinleData.getValue();
                    DynamicObject db1 = this.getAttentionData(userid, Long.valueOf(orgid), accountType);
                    Long primaryKey = db1.getLong("id");
                    DynamicObject db = BusinessDataServiceHelper.loadSingle((Object)db1.getLong("id"), (String)"gl_myattention");
                    DynamicObjectCollection accountCol = db.getDynamicObjectCollection("account");
                    Iterator iter = accountCol.iterator();
                    while (iter.hasNext()) {
                        DynamicObject removeDynamic = (DynamicObject)iter.next();
                        long basedataId = removeDynamic.getLong("fbasedataid_id");
                        if (!accountValue.contains(String.valueOf(basedataId))) continue;
                        coll.add((Object)removeDynamic);
                        iter.remove();
                    }
                    if (accountCol.size() == 0) {
                        DeleteServiceHelper.delete((IDataEntityType)db.getDataEntityType(), (Object[])new Object[]{primaryKey});
                        continue;
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{db});
                }
            }
            QFilter userFilter = new QFilter("creator", "=", (Object)userid);
            QFilter fieldFilter = new QFilter("type", "=", this.getModel().getValue("type"));
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgid));
            DynamicObject existDb = QueryServiceHelper.queryOne((String)"gl_myattention", (String)"id", (QFilter[])new QFilter[]{userFilter, fieldFilter, orgFilter});
            if (existDb != null) {
                HashMap<String, Long> map = new HashMap<String, Long>();
                Long pkid = existDb.getLong("id");
                DynamicObject existDbAll = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"gl_myattention");
                DynamicObjectCollection accountColNew = existDbAll.getDynamicObjectCollection("account");
                if (isedit) {
                    accountColNew.addAll((Collection)coll);
                    for (Iterator entryDy : coll) {
                        map.put(String.valueOf(entryDy.getLong("pkid")), entryDy.getLong("fbasedataid_id"));
                    }
                } else {
                    DynamicObjectCollection entryColl = dynObject.getDynamicObjectCollection("account");
                    for (DynamicObject entryDy : entryColl) {
                        accountColNew.add((Object)entryDy);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{existDbAll});
                if (isedit) {
                    DynamicObject existDb3 = QueryServiceHelper.queryOne((String)"gl_myattention", (String)"id", (QFilter[])new QFilter[]{userFilter, fieldFilter, orgFilter});
                    Long pkid3 = existDb3.getLong("id");
                    DynamicObject existDb2 = BusinessDataServiceHelper.loadSingle((Object)pkid3, (String)"gl_myattention");
                    DynamicObjectCollection accountColNew2 = existDb2.getDynamicObjectCollection("account");
                    for (DynamicObject entry2 : accountColNew2) {
                        Long pkid2 = entry2.getLong("pkid");
                        if (map.get(String.valueOf(pkid2)) == null) continue;
                        entry2.set("fbasedataid_id", map.get(String.valueOf(pkid2)));
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{existDb2});
                }
            } else {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObject});
            }
        }
        this.getView().close();
    }

    private boolean validate() {
        IDataModel model = this.getModel();
        DynamicObject creator = (DynamicObject)model.getValue("creator");
        if (creator == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u521b\u5efa\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9000\u51fa\u91cd\u65b0\u8fdb\u5165\u3002", (String)"MyAttentionAccountEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u3002", (String)"MyAttentionAccountEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date createtime = (Date)model.getValue("createtime");
        if (createtime == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u3002", (String)"MyAttentionAccountEdit_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection account = (DynamicObjectCollection)model.getValue("account");
        if (account == null || account.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u79d1\u76ee\u3002", (String)"MyAttentionAccountEdit_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        String type = (String)model.getValue("type");
        if (StringUtils.isBlank((CharSequence)type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u53d6\u6570\u7c7b\u578b\u3002", (String)"MyAttentionAccountEdit_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject cols = this.getAttentionData(creator.getLong("id"), org.getLong("id"), type);
        if (cols != null) {
            Long pkid = cols.getLong("id");
            DynamicObject existDbAll = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"gl_myattention");
            DynamicObjectCollection accountColNew = existDbAll.getDynamicObjectCollection("account");
            ArrayList<Long> accountDbIds = new ArrayList<Long>();
            for (DynamicObject existDbAllEntry : accountColNew) {
                Long existId = existDbAllEntry.getLong("fbasedataid_id");
                accountDbIds.add(existId);
            }
            Iterator iter = account.iterator();
            while (iter.hasNext()) {
                Long accountId = ((DynamicObject)iter.next()).getLong("fbasedataid_id");
                if (!accountDbIds.contains(accountId)) continue;
                iter.remove();
            }
            if (account == null || account.size() == 0) {
                model.setValue("account", null);
                return false;
            }
        }
        return true;
    }

    private DynamicObject getAttentionData(Long creator, Long org, String type) {
        QFilter userFilter = new QFilter("creator", "=", (Object)creator);
        QFilter fieldFilter = new QFilter("type", "=", (Object)type);
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        DynamicObject cols = QueryServiceHelper.queryOne((String)"gl_myattention", (String)"id", (QFilter[])new QFilter[]{userFilter, fieldFilter, orgFilter});
        return cols;
    }
}

