/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.closeperiod.ClosePeriodUtils;
import kd.fi.gl.closing.ClosingErrorCode;
import kd.fi.gl.constant.AccountBook;
import kd.fi.gl.constant.closeperiod.ClosePeriodInfo;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLClosePeriodUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.VoucherNumCheckUtil;

public class PeriodcloseHomePlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String PARAM_APPID = "appid";
    private static final String PARAM_ORG_FUNC = "orgFunId";
    private static final String ORG_ID = "org.id";
    private static final String BTN_CLOSE = "periodclosebtn";
    private static final String BTN_ANTI_CLOSE = "reperiodclosebtn";
    private static final String BTN_CHECK_BREAK_NUMBER = "isconsistent";
    private static final String BTN_BROKEN_NUM_LOG = "brokennumberlogbtn";
    private static final String APP_GL = "gl";
    private static final String APP_FA = "fa";
    private static final String APP_AR = "ar";
    private static final String APP_AP = "ap";
    private static final String PERM_VIEW = "47150e89000000ac";
    private static final String LAB_MSG = "msglabe1";
    private static final String LAB_NUM = "numlabe";
    private static final String LAB_ORG = "orglabe";
    private static final String LAB_FORMNAME = "formnamelabe";
    private static final String HISTORY_USER = "user";
    private static final String HISTORY_APP = "orgtype";
    private static final String BD_CLOSEDPERIODORGS = "bd_closedperiodorgs";
    private static final String CACHE_BOOK_TYPE_NAME = "bookTypeName";
    public static final String FBASEDATAID_ID = "fbasedataid_id";
    public static final String GL_CLOSEDPERIOD = "gl_closedperiod";
    private PageCacheManager cacheManager;
    private OrgBookInfo bookCache;

    private static String getHomeSuffix() {
        if (Lang.get().equals((Object)Lang.zh_CN) || Lang.get().equals((Object)Lang.zh_TW)) {
            return ResManager.loadKDString((String)"\u5bb6", (String)"PeriodcloseHomePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private ClosePeriodInfo getCloseInfo() {
        String cacheVal = this.getPageCache().get("closeInfo");
        if (StringUtils.isNotBlank((CharSequence)cacheVal)) {
            return (ClosePeriodInfo)SerializationUtils.fromJsonString((String)cacheVal, ClosePeriodInfo.class);
        }
        ClosePeriodInfo closeInfo = new ClosePeriodInfo();
        closeInfo.setBizapp(this.getAppId());
        DynamicObject registerInfo = QueryServiceHelper.queryOne((String)"bd_accountbookregister", (String)String.join((CharSequence)",", "formid", "booktypefieldid"), (QFilter[])new QFilter("bizapp", "=", (Object)closeInfo.getBizapp()).toArray());
        if (registerInfo == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"periodcloseorg", "periodedit", "bookscombo"});
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8be5\u9886\u57df\u672a\u6ce8\u518c\u7ed3\u8d26\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u534f\u52a9\u6ce8\u518c\u540e\u518d\u4f7f\u7528\u3002", (String)"PeriodcloseHomePlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0])});
        }
        closeInfo.setTypeFieldName(registerInfo.getString("booktypefieldid"));
        closeInfo.setFormId(registerInfo.getString("formid"));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)closeInfo.getFormId());
        LocaleString orgDisplayName = dataEntityType.getProperty("org").getDisplayName();
        closeInfo.setOrgFieldName(orgDisplayName.getLocaleValue());
        this.getPageCache().put("closeInfo", SerializationUtils.toJsonString((Object)closeInfo));
        return closeInfo;
    }

    private void getAndCacheBookInfo(List<Long> orgIds) {
        ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("closeInfo"), ClosePeriodInfo.class);
        QFBuilder qfBuilder = new QFBuilder();
        if (!Objects.isNull(orgIds)) {
            qfBuilder.add("org", "in", orgIds);
        }
        switch (closeInfo.getBizapp()) {
            case "gl": {
                qfBuilder.add("isbizunit", "=", (Object)Boolean.TRUE);
                qfBuilder.add("isendinit", "=", (Object)Boolean.TRUE);
                List bootTypeIds = AccSysUtil.getBookTypeDataPermission(orgIds);
                if (bootTypeIds == null) break;
                qfBuilder.add("bookstype", "in", (Object)bootTypeIds);
                break;
            }
            case "fa": {
                String faBookStatusKey = "status";
                String faBookStatusValue = "C";
                qfBuilder.add(faBookStatusKey, "in", (Object)faBookStatusValue);
                break;
            }
            case "ar": 
            case "ap": {
                String arBookInitKey = "isfinishinit";
                String arBookInitValue = "1";
                qfBuilder.add(arBookInitKey, "=", (Object)arBookInitValue);
                break;
            }
        }
        DynamicObject[] bookDOs = BusinessDataServiceHelper.load((String)closeInfo.getFormId(), (String)String.join((CharSequence)",", "curperiod", "startperiod", "org", closeInfo.getTypeFieldName(), "periodtype"), (QFilter[])qfBuilder.toArray());
        this.bookCache = new OrgBookInfo();
        if (bookDOs != null && bookDOs.length > 0) {
            for (DynamicObject bookDO : bookDOs) {
                this.bookCache.putOrgBook(bookDO.getLong(ORG_ID), bookDO);
            }
        }
        if (this.bookCache.getAllOrgIds().isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"periodcloseorg", "periodedit", "bookscombo"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u65e0\u6743\u9650\u6216\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u8bf7\u68c0\u67e5\u8d26\u7c3f\u8bbe\u7f6e\u3002", (String)"PeriodcloseHomePlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CLOSE, BTN_ANTI_CLOSE, BTN_CHECK_BREAK_NUMBER, BTN_BROKEN_NUM_LOG});
        MulBasedataEdit mulOrgEdit = (MulBasedataEdit)this.getControl("periodcloseorg");
        if (mulOrgEdit != null) {
            mulOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("periodedit");
        periodEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject period;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (!APP_GL.equals(this.getAppId())) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
            }
            if ((period = (DynamicObject)this.getModel().getValue("periodedit")) != null) {
                showParameter.setSelectedRow(period.getPkValue());
            }
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        this.mulOrgEditBeforeF7Select(e);
    }

    private void mulOrgEditBeforeF7Select(BeforeF7SelectEvent e) {
        String orgFuncId = this.getView().getFormShowParameter().getCustomParam(PARAM_ORG_FUNC).toString();
        FormShowParameter param = e.getFormShowParameter();
        String orgF7ParamKeyFunc = "orgFuncId";
        param.setCustomParam(orgF7ParamKeyFunc, (Object)orgFuncId);
        ListFilterParameter listFilterParameter = ((ListShowParameter)param).getListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("id", "in", this.getAllHasPermOrgId()));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.visiableManage();
        Set<Long> allCLoseableOrgs = this.getAllHasPermOrgId();
        if (allCLoseableOrgs.size() > 0) {
            this.orgManage(Boolean.TRUE);
        }
    }

    private void visiableManage() {
        String appId;
        switch (appId = this.getAppId()) {
            case "gl": {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CHECK_BREAK_NUMBER, BTN_BROKEN_NUM_LOG});
                this.getView().setEnable(Boolean.TRUE, new String[]{"periodedit"});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CHECK_BREAK_NUMBER, BTN_BROKEN_NUM_LOG});
                this.getView().setEnable(Boolean.FALSE, new String[]{"periodedit"});
            }
        }
        Label labOrg = (Label)this.getControl(LAB_ORG);
        Label labMsg = (Label)this.getControl(LAB_MSG);
        labOrg.setText(String.format(ResManager.loadKDString((String)"\u5f85\u7ed3\u8d26\u7684%s", (String)"PeriodcloseHomePlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]), this.getCloseInfo().getOrgFieldName()));
        labMsg.setText(String.format(ResManager.loadKDString((String)"\u76ee\u524d\u9700\u8981\u7ed3\u8d26\u7684%s\u4e3a", (String)"PeriodcloseHomePlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), this.getCloseInfo().getOrgFieldName()));
    }

    public void click(EventObject e) {
        super.click(e);
        Control btn = (Control)e.getSource();
        List<Long> orgIds = this.getOrgIds().stream().map(Long::parseLong).collect(Collectors.toList());
        VoucherNumCheckUtil checkUtil = new VoucherNumCheckUtil(this);
        switch (btn.getKey()) {
            case "periodclosebtn": {
                String msgTemplate;
                DynamicObjectCollection orgDOs = (DynamicObjectCollection)this.getModel().getValue("periodcloseorg");
                String bookTypeId = (String)this.getModel().getValue("bookscombo");
                ClosePeriodInfo closeInfo = this.getCloseInfo();
                DynamicObject periodDO = (DynamicObject)this.getModel().getValue("periodedit");
                if (periodDO == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed3\u8d26\u7684\u671f\u95f4\u3002", (String)"PeriodcloseHomePlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (orgDOs.size() <= 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed3\u8d26\u7684%s", (String)"PeriodcloseHomePlugin_20", (String)"fi-gl-formplugin", (Object[])new Object[0]), closeInfo.getOrgFieldName()));
                    return;
                }
                if (bookTypeId != null && "".equals(bookTypeId.trim())) {
                    String bookTypeName = this.getBookTypeName();
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s", (String)"PeriodcloseHomePlugin_21", (String)"fi-gl-formplugin", (Object[])new Object[0]), bookTypeName));
                    return;
                }
                Optional hasClosePermOrgIdsOptional = ClosePeriodUtils.getHasClosePermOrgIds((ClosePeriodInfo)closeInfo);
                List unableCloseOrgIds = orgDOs.stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList());
                List ableCloseOrgIds = orgDOs.stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList());
                String noClosePermMsg = "";
                if (hasClosePermOrgIdsOptional.isPresent()) {
                    List hasClosePermOrgIds = (List)hasClosePermOrgIdsOptional.get();
                    unableCloseOrgIds.removeAll(hasClosePermOrgIds);
                    if (!unableCloseOrgIds.isEmpty()) {
                        ableCloseOrgIds.removeAll(unableCloseOrgIds);
                        if (ableCloseOrgIds.isEmpty()) {
                            String formId = closeInfo.getBizapp().equals(APP_GL) ? "gl_autocloseperiod" : closeInfo.getFormId();
                            String formName = MetadataServiceHelper.getDataEntityType((String)formId).getDisplayName().getLocaleValue();
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u7ed3\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PeriodcloseHomePlugin_23", (String)"fi-gl-formplugin", (Object[])new Object[]{formName}));
                            return;
                        }
                        msgTemplate = ResManager.loadKDString((String)"%s\u65e0\u201c\u7ed3\u8d26\u201d\u6743\u9650\uff1b", (String)"PeriodcloseHomePlugin_24", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                        noClosePermMsg = orgDOs.stream().filter(org -> unableCloseOrgIds.contains(org.getLong(FBASEDATAID_ID))).map(org -> org.getLocaleString("fbasedataid.name").getLocaleValue()).map(orgName -> String.format(msgTemplate, orgName)).collect(Collectors.joining("\r\n"));
                    }
                }
                String headMsg = ResManager.loadKDString((String)"\u4e0b\u5217\u8d26\u7c3f\u5c06\u8fdb\u884c\u7ed3\u8d26\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PeriodcloseHomePlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                msgTemplate = ResManager.loadKDString((String)"%1$s%2$s\u5c06\u7ed3\u8d26\u5230%3$s\uff1b", (String)"PeriodcloseHomePlugin_14", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                String closePeriodMsg = orgDOs.stream().filter(org -> ableCloseOrgIds.contains(org.getLong(FBASEDATAID_ID))).map(org -> org.getLocaleString("fbasedataid.name").getLocaleValue()).map(orgName -> String.format(msgTemplate, orgName, this.getCacheManager().getBookTypeNameById(bookTypeId), periodDO.getString("name"))).collect(Collectors.joining("\r\n"));
                this.getView().showConfirm(headMsg, closePeriodMsg + "\r\n" + noClosePermMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(BTN_CLOSE));
                break;
            }
            case "reperiodclosebtn": {
                DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("periodcloseorg");
                int size = orgColl.size();
                ArrayList<Long> orgList = new ArrayList<Long>(size);
                if (size <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53cd\u7ed3\u8d26\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PeriodcloseHomePlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject dynamicObject : orgColl) {
                    DynamicObject obj = (DynamicObject)dynamicObject.get(1);
                    orgList.add((Long)obj.getPkValue());
                }
                ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("closeInfo"), ClosePeriodInfo.class);
                FormShowParameter parame = new FormShowParameter();
                parame.setFormId("gl_reperiodclosepopup");
                parame.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btn.getKey());
                parame.setCloseCallBack(closeCallBack);
                DynamicObject coll = (DynamicObject)this.getModel().getValue("periodedit");
                if (coll == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u8d26\u81f3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PeriodcloseHomePlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                parame.setCustomParam("orglist", (Object)SerializationUtils.toJsonString(orgList));
                parame.setCustomParam("entityname", (Object)closeInfo.getFormId());
                parame.setCustomParam("periodtype", coll.getDynamicObject("periodtype").getPkValue());
                parame.setCustomParam(PARAM_APPID, (Object)closeInfo.getBizapp());
                parame.setCustomParam("booktype", this.getModel().getValue("bookscombo"));
                parame.setCustomParam("booktypefield", (Object)closeInfo.getTypeFieldName());
                this.getView().showForm(parame);
                break;
            }
            case "isconsistent": {
                boolean hasPermission = checkUtil.checkQueryPermission(orgIds, true);
                if (!hasPermission) {
                    return;
                }
                new GLClosePeriodUtil().beforeCheckBreakPoint(this);
                break;
            }
            case "brokennumberlogbtn": {
                boolean hasPermission1 = checkUtil.checkQueryPermission(orgIds, true);
                if (!hasPermission1) {
                    return;
                }
                boolean flag = new GLClosePeriodUtil().brokenNumberLogBtnCheck(this);
                if (!flag) break;
                this.showVoucherBPLogForm();
                break;
            }
        }
    }

    private boolean checkQueryPermission() {
        int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)Long.parseLong("0"), (String)APP_GL, (String)"gl_voucherbreakpoint", (String)PERM_VIEW);
        if (permission == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u51ed\u8bc1\u65ad\u53f7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PeriodcloseHomePlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("submit".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.showVoucherBPForm();
            }
        } else if (BTN_CLOSE.equals(callBackId)) {
            if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                this.executeClose();
            }
        } else if (ClosingErrorCode.UNINITIALIZE_CURRENT_ACCOUNT_WARN.getCode().equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            String selectedPeriodIdsJson = this.getPageCache().get("doReverseClosing.selectedPeriodIds");
            List selectedPeriodIds = SerializationUtils.fromJsonStringToList((String)selectedPeriodIdsJson, Long.class);
            ClosePeriodUtils.doReverseClosing((IFormPlugin)this, (IFormView)this.getView(), (List)selectedPeriodIds, (boolean)true, (boolean)false);
        }
    }

    private void showVoucherBPForm() {
        ListShowParameter parame = new ListShowParameter();
        parame.setBillFormId("gl_vouchernoadjust_layout");
        parame.setFormId("gl_vouchernolist");
        parame.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adjustBreakPoint"));
        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long lastPeriod = GLUtil.getPreviousPeriod((Object)this.getModel().getValue("periodedit_id")).getLong("id");
        List<String> orgIds = this.getOrgIds();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orgBookTypePeriodList", this.getPageCache().get("orgBookTypePeriodList"));
        map.put("orgAndBooksForPointList", this.getPageCache().get("orgAndBooksForPointList"));
        parame.setCustomParams(map);
        this.getView().showForm((FormShowParameter)parame);
    }

    private void showVoucherBPLogForm() {
        ListShowParameter parame = new ListShowParameter();
        parame.setBillFormId("gl_voucherbreakpoint");
        parame.setFormId("gl_vouchernolist");
        parame.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "breakPointLog"));
        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long lastPeriod = GLUtil.getPreviousPeriod((Object)this.getModel().getValue("periodedit_id")).getLong("id");
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> orgIds = this.getOrgIds();
        map.put("orgIds", JSON.toJSONString(orgIds));
        map.put("booktypeCombo", this.getModel().getValue("bookscombo"));
        map.put("lastPeriod", String.valueOf(lastPeriod));
        map.put("orgAndBooksForPointList", this.getPageCache().get("orgAndBooksForPointList"));
        map.put("orgBookTypePeriodList", this.getPageCache().get("orgBookTypePeriodList"));
        parame.setCustomParams(map);
        this.getView().showForm((FormShowParameter)parame);
    }

    private List<String> getOrgIds() {
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection orgColl = (DynamicObjectCollection)model.getValue("periodcloseorg");
        List<String> orgIds = orgColl.stream().map(e -> e.getString(2)).collect(Collectors.toList());
        return orgIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel m = this.getModel();
        if ("periodcloseorg".equals(propertyName)) {
            DynamicObjectCollection coll = (DynamicObjectCollection)m.getValue("periodcloseorg");
            int size = coll.size();
            if (size == 0) {
                m.setValue("periodedit", null);
                Label companynum = (Label)this.getControl(LAB_NUM);
                companynum.setText(size + PeriodcloseHomePlugin.getHomeSuffix());
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(size);
            for (DynamicObject dynamicObject : coll) {
                ids.add(dynamicObject.getLong(2));
            }
            this.getAndCacheBookInfo(ids);
            this.orgManage(Boolean.FALSE);
        } else if ("bookscombo".equals(propertyName)) {
            this.periodManage();
        }
    }

    private void bookTypeEditInit() {
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        String typeFieldName = closeInfo.getTypeFieldName();
        if (StringUtils.isNotBlank((CharSequence)typeFieldName)) {
            DynamicObjectCollection orgDOs = (DynamicObjectCollection)this.getModel().getValue("periodcloseorg");
            List<Long> orgIds = orgDOs.stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList());
            ArrayList allBooks = new ArrayList(8);
            orgIds.forEach(orgId -> {
                List<DynamicObject> bookList = this.bookCache.getBooks((long)orgId);
                if (Objects.nonNull(bookList)) {
                    allBooks.addAll(bookList);
                }
            });
            Map<Object, String> allBookTypes = allBooks.stream().collect(Collectors.toMap(x -> x.getDynamicObject(typeFieldName).getPkValue(), x -> x.getDynamicObject(typeFieldName).getString("name"), (oldVal, newVal) -> newVal));
            if (allBookTypes.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bookscombo"});
                this.getView().setVisible(Boolean.FALSE, new String[]{LAB_FORMNAME});
            } else {
                this.getCacheManager().cacheBookTypeId2Name(allBookTypes);
                this.putBookTypeName(EntityMetadataCache.getDataEntityType((String)closeInfo.getFormId()).getProperty(typeFieldName).getDisplayName().getLocaleValue());
                List comboItems = allBookTypes.entrySet().stream().map(x -> {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString((String)x.getValue()));
                    comboItem.setValue(x.getKey().toString());
                    return comboItem;
                }).collect(Collectors.toList());
                ComboEdit comboEdit = (ComboEdit)this.getControl("bookscombo");
                comboEdit.setComboItems(comboItems);
                Long bookTypeId = Long.valueOf(((ComboItem)comboItems.get(0)).getValue());
                if (closeInfo.getBizapp().equals(APP_GL)) {
                    long mainBookTypeId;
                    DynamicObject bookType;
                    if (orgIds.size() == 1) {
                        QFilter orgQF = new QFilter("company", "in", orgIds);
                        QFilter subsysFormNumQF = new QFilter("subsysformnum", "=", (Object)closeInfo.getFormId());
                        DynamicObjectCollection allState = QueryServiceHelper.query((String)"gl_closestate", (String)"closedate, accountbooks", (QFilter[])new QFilter[]{orgQF, subsysFormNumQF}, (String)"closedate desc", (int)1);
                        if (allState.size() > 0) {
                            Long accountBookId = ((DynamicObject)allState.get(0)).getLong("accountbooks");
                            for (DynamicObject accountBook : allBooks) {
                                if (!accountBookId.equals(accountBook.getPkValue())) continue;
                                bookTypeId = (Long)accountBook.getDynamicObject(closeInfo.getTypeFieldName()).getPkValue();
                            }
                        }
                    } else if (orgIds.size() > 1 && (bookType = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("accounttype", "=", (Object)"1")})) != null && allBookTypes.containsKey(mainBookTypeId = bookType.getLong("id"))) {
                        bookTypeId = mainBookTypeId;
                    }
                }
                this.getModel().beginInit();
                this.getModel().setValue("bookscombo", (Object)bookTypeId);
                this.getModel().endInit();
                this.getView().updateView("bookscombo");
                if (comboItems.size() == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bookscombo"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{LAB_FORMNAME});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bookscombo"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{LAB_FORMNAME});
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bookscombo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{LAB_FORMNAME});
        }
    }

    private void putBookTypeName(String bookTypeName) {
        this.getPageCache().put(CACHE_BOOK_TYPE_NAME, bookTypeName);
    }

    private String getBookTypeName() {
        return this.getPageCache().get(CACHE_BOOK_TYPE_NAME);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String periodId;
        Object returnData = e.getReturnData();
        if (BTN_ANTI_CLOSE.equalsIgnoreCase(e.getActionId())) {
            List mulSelectPeriodIds = null;
            if (returnData instanceof Map) {
                Map map = (Map)returnData;
                mulSelectPeriodIds = (List)map.get("periodIds");
            }
            if (Objects.isNull(mulSelectPeriodIds)) {
                return;
            }
            if (mulSelectPeriodIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53cd\u7ed3\u8d26\u7684\u671f\u95f4\u3002", (String)"PeriodcloseHomePlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            ClosePeriodUtils.doReverseClosing((IFormPlugin)this, (IFormView)this.getView(), (List)mulSelectPeriodIds, (boolean)false, (boolean)false);
        } else if (BTN_CLOSE.equals(e.getActionId()) && (periodId = (String)returnData) != null) {
            this.getModel().setValue("periodedit", (Object)periodId);
        }
    }

    private void orgManage(boolean createNewData) {
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        Set<Long> allOrgIds = this.bookCache.getAllOrgIds();
        allOrgIds.remove(0L);
        if (allOrgIds.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"periodcloseorg", "periodedit", "bookscombo"});
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u7684%s\u3002", (String)"PeriodcloseHomePlugin_22", (String)"fi-gl-formplugin", (Object[])new Object[0]), closeInfo.getOrgFieldName()));
            return;
        }
        HashSet<Long> closeOrgIds = new HashSet<Long>();
        if (createNewData) {
            Set<Long> historyCloseOrgs = this.getHistoryCloseOrgs();
            historyCloseOrgs.retainAll(allOrgIds);
            if (!historyCloseOrgs.isEmpty()) {
                closeOrgIds.addAll(historyCloseOrgs);
            } else {
                long defaultOrgId = AccSysUtil.getDefaultOrgId((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
                if (allOrgIds.contains(defaultOrgId)) {
                    closeOrgIds.add(defaultOrgId);
                } else {
                    closeOrgIds.add(allOrgIds.iterator().next());
                }
            }
            this.getModel().setValue("periodcloseorg", (Object)closeOrgIds.toArray());
        } else {
            closeOrgIds.addAll(allOrgIds);
        }
        this.putHistoryCloseOrgs(closeOrgIds);
        Label labNum = (Label)this.getControl(LAB_NUM);
        labNum.setText(String.format("%d%s", closeOrgIds.size(), PeriodcloseHomePlugin.getHomeSuffix()));
        boolean isGL = APP_GL.equals(closeInfo.getBizapp());
        if (isGL) {
            this.initMapForPointList(closeOrgIds.stream().collect(Collectors.toMap(x -> x, x -> this.bookCache.getBooks((long)x))));
        }
        this.bookTypeEditInit();
        this.periodManage();
    }

    private void putHistoryCloseOrgs(Set<Long> orgIds) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(HISTORY_USER, "=", (Object)ContextUtil.getUserId());
        qfBuilder.add(HISTORY_APP, "=", (Object)this.getAppId());
        DeleteServiceHelper.delete((String)BD_CLOSEDPERIODORGS, (QFilter[])qfBuilder.toArray());
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])orgIds.stream().map(x -> {
            DynamicObject historyDO = BusinessDataServiceHelper.newDynamicObject((String)BD_CLOSEDPERIODORGS);
            historyDO.set(HISTORY_USER, (Object)ContextUtil.getUserId());
            historyDO.set("org", x);
            historyDO.set(HISTORY_APP, (Object)this.getAppId());
            return historyDO;
        }).toArray(DynamicObject[]::new)));
    }

    private Set<Long> getHistoryCloseOrgs() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(HISTORY_USER, "=", (Object)ContextUtil.getUserId());
        qfBuilder.add(HISTORY_APP, "=", (Object)this.getAppId());
        return QueryServiceHelper.query((String)BD_CLOSEDPERIODORGS, (String)"org", (QFilter[])qfBuilder.toArray()).stream().map(x -> x.getLong("org")).collect(Collectors.toSet());
    }

    private void initMapForPointList(Map<Long, List<DynamicObject>> map) {
        HashMap mapForPoint = new HashMap();
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            ArrayList list = new ArrayList(16);
            for (DynamicObject dyo : entry.getValue()) {
                HashMap<String, String> mapForList = new HashMap<String, String>();
                mapForList.put("bookNm", dyo.getDynamicObject("bookstype").getString("name"));
                mapForList.put("masterId", dyo.getDynamicObject("bookstype").getString("masterid"));
                mapForList.put("curperiodPkId", null == dyo.getDynamicObject("curperiod") ? "" : dyo.getDynamicObject("curperiod").getPkValue().toString());
                mapForList.put("startperiodPkId", null == dyo.getDynamicObject("startperiod") ? "" : dyo.getDynamicObject("startperiod").getPkValue().toString());
                list.add(mapForList);
                mapForPoint.put(entry.getKey(), list);
            }
        }
        this.getPageCache().put("orgAndBooksForPointList", SerializationUtils.toJsonString(mapForPoint));
    }

    private void periodManage() {
        QFBuilder qfBuilder = new QFBuilder();
        DynamicObjectCollection orgDOs = (DynamicObjectCollection)this.getModel().getValue("periodcloseorg");
        if (!orgDOs.isEmpty()) {
            List orgIds = orgDOs.stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList());
            qfBuilder.add("org", "in", orgIds);
            String bookTypeStr = (String)this.getModel().getValue("bookscombo");
            ClosePeriodInfo closeInfo = this.getCloseInfo();
            if (StringUtils.isNotBlank((CharSequence)closeInfo.getTypeFieldName()) && StringUtils.isNotBlank((CharSequence)bookTypeStr)) {
                qfBuilder.add(closeInfo.getTypeFieldName(), "=", (Object)Long.parseLong(bookTypeStr));
            }
            DynamicObject allBooks = BusinessDataServiceHelper.load((String)closeInfo.getFormId(), (String)String.join((CharSequence)",", "curperiod", "periodtype", "org", "bookstype"), (QFilter[])qfBuilder.toArray());
            boolean gl = APP_GL.equals(this.getAppId());
            HashMap<String, Long> periodNumbers = new HashMap<String, Long>(((DynamicObject[])allBooks).length);
            HashBasedTable bookOrgPeriods = HashBasedTable.create((int)1, (int)orgIds.size());
            if (gl && allBooks != null && ((DynamicObject[])allBooks).length != 0) {
                DynamicObject book = allBooks[0];
                if (orgIds.size() != 1) {
                    bookOrgPeriods = GLUtil.batchGetOpenPeriod(orgIds, (Long)book.getLong(AccountBook.id_((String)"bookstype")));
                } else {
                    bookOrgPeriods.put((Object)book.getLong(AccountBook.id_((String)"bookstype")), (Object)book.getLong(ORG_ID), (Object)GLUtil.getOpenPeriod((long)book.getLong(ORG_ID), (long)book.getLong(AccountBook.id_((String)"bookstype"))));
                }
            }
            for (DynamicObject bookDO : allBooks) {
                DynamicObject periodDO;
                List openPeriods;
                String periodNumber = "";
                DynamicObject curPeriodDO = bookDO.getDynamicObject("curperiod");
                if (!Objects.isNull(curPeriodDO)) {
                    periodNumber = curPeriodDO.getString("number");
                }
                if (gl && !CollectionUtils.isEmpty((Collection)(openPeriods = (List)bookOrgPeriods.get((Object)bookDO.getLong(AccountBook.id_((String)"bookstype")), (Object)bookDO.getLong(ORG_ID)))) && (periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"number", (QFilter[])new QFBuilder("id", "=", openPeriods.get(0)).toArray())) != null) {
                    periodNumber = periodDO.getString("number");
                }
                if (!StringUtils.isNotBlank((CharSequence)periodNumber)) continue;
                periodNumbers.put(periodNumber, bookDO.getLong(AccountBook.id_((String)"periodtype")));
            }
            if (!periodNumbers.isEmpty()) {
                ArrayList nums = new ArrayList(periodNumbers.keySet());
                Collections.sort(nums);
                String maxPeriodNumber = (String)nums.get(nums.size() - 1);
                long periodTypeId = (Long)periodNumbers.get(maxPeriodNumber);
                qfBuilder.clear();
                qfBuilder.add("periodtype", "=", (Object)periodTypeId);
                qfBuilder.add("number", "=", (Object)maxPeriodNumber);
                DynamicObjectCollection periodDOs = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])qfBuilder.toArray(), (String)String.join((CharSequence)",", "periodyear desc", "periodnumber desc"));
                if (periodDOs.isEmpty()) {
                    return;
                }
                DynamicObject maxPeriodDO = (DynamicObject)periodDOs.get(0);
                DynamicObject nextPeriodDO = GLUtil.getNextPeriod((Object)maxPeriodDO.getLong("id"), (boolean)APP_GL.equalsIgnoreCase(this.getAppId()));
                if (nextPeriodDO == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u4e00\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u4e0b\u4e00\u671f\u95f4\u3002", (String)"PeriodcloseHomePlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("periodedit", (Object)maxPeriodDO.getLong("id"));
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_CLOSE});
                } else {
                    this.getModel().setValue("periodedit", nextPeriodDO.get("id"));
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_CLOSE, BTN_ANTI_CLOSE});
                }
                BasedataEdit periodEdit = (BasedataEdit)this.getView().getControl("periodedit");
                periodEdit.setQFilter(new QFilter("periodtype", "=", (Object)periodTypeId));
            }
        }
    }

    private String getAppId() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String appId = (String)parameter.getCustomParam("closePeriodApp");
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = parameter.getAppId();
        }
        return appId == null ? "" : appId;
    }

    private void executeClose() {
        DynamicObjectCollection orgDOs = (DynamicObjectCollection)this.getModel().getValue("periodcloseorg");
        DynamicObject periodDO = (DynamicObject)this.getModel().getValue("periodedit");
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        Optional hasClosePermOrgIdsOptional = ClosePeriodUtils.getHasClosePermOrgIds((ClosePeriodInfo)closeInfo);
        List unableCloseOrgIds = orgDOs.stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList());
        List ableCloseOrgIds = orgDOs.stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList());
        if (hasClosePermOrgIdsOptional.isPresent()) {
            unableCloseOrgIds.removeAll((Collection)hasClosePermOrgIdsOptional.get());
        } else {
            unableCloseOrgIds.clear();
        }
        if (!unableCloseOrgIds.isEmpty()) {
            ableCloseOrgIds.removeAll(unableCloseOrgIds);
        }
        closeInfo.setAwaitPeriodId(periodDO.getPkValue());
        closeInfo.setBooktype(this.getModel().getValue("bookscombo"));
        closeInfo.setOrgs(ableCloseOrgIds);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(GL_CLOSEDPERIOD);
        formShowParameter.setCustomParam("closeInfo", (Object)SerializationUtils.toJsonString((Object)closeInfo));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_CLOSE);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private PageCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new PageCacheManager();
        }
        return this.cacheManager;
    }

    private Set<Long> getAllHasPermOrgId() {
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        String appId = AppMetadataCache.getAppInfo((String)closeInfo.getBizapp()).getId();
        ArrayList hasPermOrgIdList = null;
        HasPermOrgResult viewPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PERM_VIEW);
        if (!viewPermOrgResult.hasAllOrgPerm()) {
            Optional hasClosePermOrgIdsOptional = ClosePeriodUtils.getHasClosePermOrgIds((ClosePeriodInfo)closeInfo);
            List hasClosePermOrgIds = hasClosePermOrgIdsOptional.orElse(null);
            if (!viewPermOrgResult.hasAllOrgPerm() && viewPermOrgResult.getHasPermOrgs().isEmpty() && Objects.nonNull(hasClosePermOrgIds) && hasClosePermOrgIds.isEmpty()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"periodcloseorg", "periodedit", "bookscombo"});
                String fromId = closeInfo.getBizapp().equals(APP_GL) ? "gl_autocloseperiod" : closeInfo.getFormId();
                String message = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u67e5\u8be2\u201d\u548c\u201c\u7ed3\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PeriodcloseHomePlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]), MetadataServiceHelper.getDataEntityType((String)fromId).getDisplayName());
                this.getView().showTipNotification(message);
            }
            if (Objects.nonNull(hasClosePermOrgIds)) {
                HashSet hasPermOrgIdSet = new HashSet(8);
                hasPermOrgIdSet.addAll(viewPermOrgResult.getHasPermOrgs());
                hasPermOrgIdSet.addAll(hasClosePermOrgIds);
                hasPermOrgIdList = new ArrayList(hasPermOrgIdSet);
            }
        }
        this.getAndCacheBookInfo(hasPermOrgIdList);
        return this.bookCache.getAllOrgIds();
    }

    private class PageCacheManager {
        private PageCacheManager() {
        }

        protected void cacheBookTypeId2Name(Map<Object, String> map) {
            PeriodcloseHomePlugin.this.getPageCache().put("bookTypeMap", JSONObject.toJSONString(map));
        }

        protected String getBookTypeNameById(Object id) {
            if (null == id) {
                return "";
            }
            String bookTypeMapStr = PeriodcloseHomePlugin.this.getPageCache().get("bookTypeMap");
            if (null == bookTypeMapStr) {
                throw new KDBizException("book type init failed");
            }
            return JSONObject.parseObject((String)bookTypeMapStr).get((Object)id.toString()).toString();
        }
    }

    private static class OrgBookInfo {
        private transient Map<Long, List<DynamicObject>> orgBookDOs = new HashMap<Long, List<DynamicObject>>(16);

        private OrgBookInfo() {
        }

        public void putOrgBook(long org, DynamicObject book) {
            if (this.orgBookDOs == null) {
                this.orgBookDOs = new HashMap<Long, List<DynamicObject>>();
            }
            if (this.orgBookDOs.get(org) == null) {
                this.orgBookDOs.put(org, new ArrayList<DynamicObject>(Collections.singletonList(book)));
            } else {
                this.orgBookDOs.get(org).add(book);
            }
        }

        public List<DynamicObject> getBooks(long org) {
            return this.orgBookDOs.get(org);
        }

        public List<DynamicObject> getAllBooks() {
            return this.orgBookDOs.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }

        public Set<Long> getAllOrgIds() {
            return this.orgBookDOs.keySet();
        }
    }
}

